/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.csiro.svg.dom.Drawable;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedPreserveAspectRatioImpl;
import org.csiro.svg.dom.SVGAnimatedStringImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGClipPathElementImpl;
import org.csiro.svg.dom.SVGColorProfileElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGGraphic;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGMatrixImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGPreserveAspectRatioImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGSVGElementImpl;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.csiro.svg.parser.SVGParseException;
import org.csiro.svg.parser.SVGParser;
import org.csiro.svg.tools.ConnectionManager;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGImageElement;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGImageElementImpl
extends SVGGraphic
implements SVGImageElement,
Drawable {
    protected SVGAnimatedLength x;
    protected SVGAnimatedLength y;
    protected SVGAnimatedLength width;
    protected SVGAnimatedLength height;
    protected SVGAnimatedString href;
    protected SVGAnimatedPreserveAspectRatio preserveAspectRatio;
    boolean visible = true;
    boolean display = true;
    AffineTransform thisTransform = null;
    Shape clipShape = null;
    Image image = null;
    Image imageWithProfile = null;
    SVGDocumentImpl doc = null;
    float opacity = 1.0f;
    SVGClipPathElementImpl clipPath = null;
    String oldHref = null;

    public SVGImageElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "image");
        super.setAttribute("x", this.getX().getBaseVal().getValueAsString());
        super.setAttribute("y", this.getY().getBaseVal().getValueAsString());
        super.setAttribute("width", this.getWidth().getBaseVal().getValueAsString());
        super.setAttribute("height", this.getHeight().getBaseVal().getValueAsString());
        super.setAttribute("href", this.getHref().getBaseVal());
        super.setAttribute("preserveAspectRatio", ((SVGPreserveAspectRatioImpl)this.getPreserveAspectRatio().getBaseVal()).toString());
    }

    public SVGImageElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "image");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGImageElementImpl sVGImageElementImpl = new SVGImageElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedLengthImpl)this.getX()).getAnimations();
        Vector vector2 = ((SVGAnimatedLengthImpl)this.getY()).getAnimations();
        Vector vector3 = ((SVGAnimatedLengthImpl)this.getWidth()).getAnimations();
        Vector vector4 = ((SVGAnimatedLengthImpl)this.getHeight()).getAnimations();
        Vector vector5 = ((SVGAnimatedStringImpl)this.getHref()).getAnimations();
        Vector vector6 = ((SVGAnimatedTransformListImpl)this.getTransform()).getAnimations();
        Vector vector7 = ((SVGAnimatedPreserveAspectRatioImpl)this.getPreserveAspectRatio()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGImageElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGImageElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGImageElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector4 != null) {
            n = 0;
            while (n < vector4.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector4.elementAt(n);
                sVGImageElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector5 != null) {
            n = 0;
            while (n < vector5.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector5.elementAt(n);
                sVGImageElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector6 != null) {
            n = 0;
            while (n < vector6.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector6.elementAt(n);
                sVGImageElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector7 != null) {
            n = 0;
            while (n < vector7.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector7.elementAt(n);
                sVGImageElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGImageElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGImageElementImpl;
    }

    public SVGAnimatedLength getX() {
        if (this.x == null) {
            this.x = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 0), this);
        }
        return this.x;
    }

    public SVGAnimatedLength getY() {
        if (this.y == null) {
            this.y = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 1), this);
        }
        return this.y;
    }

    public SVGAnimatedLength getWidth() {
        if (this.width == null) {
            this.width = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 0), this);
        }
        return this.width;
    }

    public SVGAnimatedLength getHeight() {
        if (this.height == null) {
            this.height = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 1), this);
        }
        return this.height;
    }

    public String getXlinkType() {
        return this.getAttribute("xlink:type");
    }

    public void setXlinkType(String string) throws DOMException {
        this.setAttribute("xlink:type", string);
    }

    public String getXlinkRole() {
        return this.getAttribute("xlink:role");
    }

    public void setXlinkRole(String string) throws DOMException {
        this.setAttribute("xlink:role", string);
    }

    public String getXlinkArcRole() {
        return this.getAttribute("xlink:arcrole");
    }

    public void setXlinkArcRole(String string) throws DOMException {
        this.setAttribute("xlink:arcrole", string);
    }

    public String getXlinkTitle() {
        return this.getAttribute("xlink:title");
    }

    public void setXlinkTitle(String string) throws DOMException {
        this.setAttribute("xlink:title", string);
    }

    public String getXlinkShow() {
        return this.getAttribute("xlink:show");
    }

    public void setXlinkShow(String string) throws DOMException {
        this.setAttribute("xlink:show", string);
    }

    public String getXlinkActuate() {
        return this.getAttribute("xlink:actuate");
    }

    public void setXlinkActuate(String string) throws DOMException {
        this.setAttribute("xlink:actuate", string);
    }

    public SVGAnimatedString getHref() {
        if (this.href == null) {
            this.href = new SVGAnimatedStringImpl("", this);
        }
        return this.href;
    }

    public SVGAnimatedPreserveAspectRatio getPreserveAspectRatio() {
        if (this.preserveAspectRatio == null) {
            this.preserveAspectRatio = new SVGAnimatedPreserveAspectRatioImpl(new SVGPreserveAspectRatioImpl(), this);
        }
        return this.preserveAspectRatio;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("x")) {
            return this.getX().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("y")) {
            return this.getY().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("width")) {
            return this.getWidth().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("height")) {
            return this.getHeight().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("xlink:href")) {
            return this.getHref().getBaseVal();
        }
        if (string.equalsIgnoreCase("preserveAspectRatio")) {
            return ((SVGPreserveAspectRatioImpl)this.getPreserveAspectRatio().getBaseVal()).toString();
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("x")) {
            attr.setValue(this.getX().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("y")) {
            attr.setValue(this.getY().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("width")) {
            attr.setValue(this.getWidth().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("height")) {
            attr.setValue(this.getHeight().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("xlink:href")) {
            attr.setValue(this.getHref().getBaseVal());
        } else if (string.equalsIgnoreCase("preserveAspectRatio")) {
            attr.setValue(((SVGPreserveAspectRatioImpl)this.getPreserveAspectRatio().getBaseVal()).toString());
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("x")) {
            this.getX().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("y")) {
            this.getY().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("width")) {
            this.getWidth().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("height")) {
            this.getHeight().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("xlink:href")) {
            this.getHref().setBaseVal(string2);
        } else if (string.equalsIgnoreCase("preserveAspectRatio")) {
            short s;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
            String string3 = null;
            String string4 = null;
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                string3 = stringTokenizer.nextToken();
                if (n > 1) {
                    string4 = stringTokenizer.nextToken();
                }
            }
            if (string3 != null) {
                s = SVGPreserveAspectRatioImpl.getAlignConst(string3);
                this.getPreserveAspectRatio().getBaseVal().setAlign(s);
            }
            if (string4 != null) {
                s = SVGPreserveAspectRatioImpl.getMeetOrSliceConst(string4);
                this.getPreserveAspectRatio().getBaseVal().setMeetOrSlice(s);
            }
        }
    }

    public void draw(Graphics2D graphics2D, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        if (bl || this.image == null && this.doc == null) {
            this.refreshData();
            this.visible = this.getVisibility();
            this.display = this.getDisplay();
            this.opacity = this.getOpacity();
            this.clipPath = this.getClippingPath();
            this.clipShape = null;
            if (this.clipPath != null) {
                this.clipShape = this.clipPath.getClippingShape(this);
            }
            this.thisTransform = ((SVGTransformListImpl)this.getTransform().getAnimVal()).getAffineTransform();
            object3 = this.getHref().getAnimVal();
            if (this.oldHref == null || !this.oldHref.equals(object3)) {
                this.image = null;
                this.doc = null;
                if (object3 != null && ((String)object3).length() > 0) {
                    this.oldHref = object3;
                    if (((String)object3).toLowerCase().endsWith(".svg")) {
                        if (!(((String)object3).startsWith("http://") || ((String)object3).startsWith("ftp://") || ((String)object3).startsWith("file:") || (object2 = (SVGDocument)this.getOwnerDocument()) == null || object2.getURL() == null || ((String)(object = object2.getURL())).indexOf(47) == -1 && ((String)object).indexOf(92) == -1)) {
                            int n = ((String)object).lastIndexOf(47);
                            if (n == -1) {
                                n = ((String)object).lastIndexOf(92);
                            }
                            String string = ((String)object).substring(0, n + 1);
                            object3 = string + (String)object3;
                        }
                        try {
                            object2 = new SVGParser();
                            this.doc = ((SVGParser)object2).parseSVG((String)object3);
                            if (this.doc == null) {
                                return;
                            }
                        }
                        catch (SVGParseException sVGParseException) {
                            System.out.println("parse exception while reading: " + (String)object3);
                            System.out.println(sVGParseException.getMessage());
                        }
                    } else {
                        Object object4;
                        object2 = "";
                        object = (SVGDocument)this.getOwnerDocument();
                        if (object != null && object.getURL() != null && (((String)(object4 = object.getURL())).indexOf(47) != -1 || ((String)object4).indexOf(92) != -1)) {
                            int n = ((String)object4).lastIndexOf(47);
                            if (n == -1) {
                                n = ((String)object4).lastIndexOf(92);
                            }
                            object2 = ((String)object4).substring(0, n + 1);
                        }
                        if (!(object3 == null || ((String)object3).startsWith("http://") || ((String)object3).startsWith("ftp://") || ((String)object3).startsWith("file:") || object2 == null || !((String)object2).startsWith("http://") && !((String)object2).startsWith("ftp://"))) {
                            object3 = (String)object2 + (String)object3;
                        }
                        if (object3 != null && (((String)object3).startsWith("http://") || ((String)object3).startsWith("file:") || ((String)object3).startsWith("ftp://"))) {
                            try {
                                object4 = new URL((String)object3);
                                byte[] byArray = ConnectionManager.getInstance().retrieveData((URL)object4);
                                this.image = Toolkit.getDefaultToolkit().createImage(byArray);
                            }
                            catch (MalformedURLException malformedURLException) {
                                System.out.println("Bad URL in image element : " + (String)object3);
                            }
                        } else {
                            this.image = Toolkit.getDefaultToolkit().getImage((String)object2 + (String)object3);
                        }
                        if (this.image != null) {
                            object4 = new MediaTracker(new Canvas());
                            ((MediaTracker)object4).addImage(this.image, 0);
                            try {
                                ((MediaTracker)object4).waitForAll();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        if (this.visible && this.display && this.opacity > 0.0f) {
            object3 = graphics2D.getTransform();
            object2 = graphics2D.getClip();
            object = graphics2D.getComposite();
            graphics2D.transform(this.thisTransform);
            if (this.clipShape != null) {
                graphics2D.clip(this.clipShape);
            }
            if (this.doc != null) {
                SVGSVGElementImpl sVGSVGElementImpl = (SVGSVGElementImpl)this.doc.getRootElement();
                SVGRect sVGRect = sVGSVGElementImpl.getViewport();
                if (this.opacity < 1.0f) {
                    SVGSVGElement sVGSVGElement = this.getOwnerDoc().getRootElement();
                    float f = sVGSVGElement.getCurrentScale();
                    SVGPoint sVGPoint = sVGSVGElement.getCurrentTranslate();
                    if (sVGPoint == null) {
                        sVGPoint = new SVGPointImpl();
                    }
                    SVGRect sVGRect2 = this.getBBox();
                    Rectangle2D.Double double_ = new Rectangle2D.Double(sVGRect2.getX(), sVGRect2.getY(), sVGRect2.getWidth(), sVGRect2.getHeight());
                    AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
                    Shape shape = affineTransform.createTransformedShape(double_);
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    double d = rectangle2D.getWidth() / 5.0;
                    double d2 = rectangle2D.getHeight() / 5.0;
                    rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d2, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d2);
                    int n = (int)(rectangle2D.getWidth() * (double)f);
                    int n2 = (int)(rectangle2D.getHeight() * (double)f);
                    if (n > 0 && n2 > 0) {
                        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
                        Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics2D2.setRenderingHints(renderingHints);
                        if (f != 1.0f) {
                            graphics2D2.scale(f, f);
                        }
                        graphics2D2.translate(-rectangle2D.getX(), -rectangle2D.getY());
                        graphics2D2.transform(affineTransform);
                        float f2 = this.getWidth().getAnimVal().getValue() / sVGRect.getWidth();
                        float f3 = this.getHeight().getAnimVal().getValue() / sVGRect.getHeight();
                        graphics2D2.scale(f2, f3);
                        float f4 = this.getX().getAnimVal().getValue() / f2 - sVGRect.getX();
                        float f5 = this.getY().getAnimVal().getValue() / f3 - sVGRect.getY();
                        graphics2D2.translate(f4, f5);
                        this.doc.draw(graphics2D2);
                        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
                        graphics2D.setComposite(alphaComposite);
                        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY());
                        affineTransform2.scale(1.0f / f, 1.0f / f);
                        try {
                            affineTransform2.preConcatenate(affineTransform.createInverse());
                        }
                        catch (NoninvertibleTransformException noninvertibleTransformException) {
                            // empty catch block
                        }
                        graphics2D.drawImage(bufferedImage, affineTransform2, null);
                        bufferedImage.flush();
                    }
                } else {
                    float f = this.getWidth().getAnimVal().getValue() / sVGRect.getWidth();
                    float f6 = this.getHeight().getAnimVal().getValue() / sVGRect.getHeight();
                    graphics2D.scale(f, f6);
                    float f7 = this.getX().getAnimVal().getValue() / f - sVGRect.getX();
                    float f8 = this.getY().getAnimVal().getValue() / f6 - sVGRect.getY();
                    graphics2D.translate(f7, f8);
                    this.doc.draw(graphics2D);
                }
            } else if (this.image != null) {
                Object object5;
                int n = this.image.getWidth(null);
                int n3 = this.image.getHeight(null);
                float f = this.getWidth().getAnimVal().getValue();
                float f9 = this.getHeight().getAnimVal().getValue();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(this.getX().getAnimVal().getValue(), this.getY().getAnimVal().getValue());
                affineTransform.scale(f / (float)n, f9 / (float)n3);
                if (this.opacity < 1.0f) {
                    object5 = AlphaComposite.getInstance(3, this.opacity);
                    graphics2D.setComposite((Composite)object5);
                }
                if ((object5 = this.getColorProfile()) != null) {
                    if (this.imageWithProfile == null) {
                        System.out.println("Got a profile -- apply it");
                        this.imageWithProfile = ((SVGColorProfileElementImpl)object5).applyProfile(this.image);
                        if (this.imageWithProfile == null) {
                            this.imageWithProfile = this.image;
                            System.out.println("Could not apply profile.");
                            System.out.println("Drawing without profile");
                        } else {
                            System.out.println("Profile Applied");
                            System.out.println("Drawing with profile");
                        }
                    }
                    graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                    graphics2D.drawImage(this.imageWithProfile, affineTransform, null);
                } else {
                    graphics2D.drawImage(this.image, affineTransform, null);
                }
            }
            graphics2D.setTransform((AffineTransform)object3);
            graphics2D.setClip((Shape)object2);
            graphics2D.setComposite((Composite)object);
        }
    }

    public SVGRect getBBox() {
        AffineTransform affineTransform;
        AffineTransform affineTransform2 = ((SVGMatrixImpl)this.getCTM()).getAffineTransform();
        try {
            affineTransform = affineTransform2.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            affineTransform = null;
        }
        float f = ((SVGLengthImpl)this.getX().getAnimVal()).getTransformedLength(affineTransform);
        float f2 = ((SVGLengthImpl)this.getY().getAnimVal()).getTransformedLength(affineTransform);
        float f3 = ((SVGLengthImpl)this.getWidth().getAnimVal()).getTransformedLength(affineTransform);
        float f4 = ((SVGLengthImpl)this.getHeight().getAnimVal()).getTransformedLength(affineTransform);
        SVGRectImpl sVGRectImpl = new SVGRectImpl(f, f2, f3, f4);
        return sVGRectImpl;
    }

    public boolean contains(double d, double d2) {
        SVGRect sVGRect = this.getBBox();
        Rectangle2D.Double double_ = new Rectangle2D.Double(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight());
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape = affineTransform.createTransformedShape(double_);
        return shape.contains(d, d2);
    }

    public double boundingArea() {
        SVGRect sVGRect = this.getBBox();
        Rectangle2D.Double double_ = new Rectangle2D.Double(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight());
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape = affineTransform.createTransformedShape(double_);
        Rectangle2D rectangle2D = shape.getBounds2D();
        return rectangle2D.getWidth() * rectangle2D.getHeight();
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("x")) {
            ((SVGAnimatedValue)((Object)this.getX())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("y")) {
            ((SVGAnimatedValue)((Object)this.getY())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("width")) {
            ((SVGAnimatedValue)((Object)this.getWidth())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("height")) {
            ((SVGAnimatedValue)((Object)this.getHeight())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("xlink:href")) {
            ((SVGAnimatedValue)((Object)this.getHref())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

