/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.csiro.svg.dom.SVGExceptionImpl;
import org.csiro.svg.dom.SVGStylableImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGLengthImpl
implements SVGLength {
    SVGElement ownerElement;
    short lengthDir;
    float valueInSpecifiedUnits;
    short unitType = 1;
    public static final short X_DIRECTION = 0;
    public static final short Y_DIRECTION = 1;
    public static final short NO_DIRECTION = 2;

    public SVGLengthImpl() {
        this.ownerElement = null;
        this.lengthDir = (short)2;
        this.unitType = 1;
        this.setValue(0.0f);
    }

    public SVGLengthImpl(SVGLengthImpl sVGLengthImpl) {
        if (sVGLengthImpl != null) {
            this.setValueAsString(sVGLengthImpl.getValueAsString());
            this.ownerElement = sVGLengthImpl.ownerElement;
            this.lengthDir = sVGLengthImpl.lengthDir;
        } else {
            this.unitType = 1;
            this.setValue(0.0f);
            this.ownerElement = null;
            this.lengthDir = (short)2;
        }
    }

    public SVGLengthImpl(SVGElement sVGElement, short s) {
        this.ownerElement = sVGElement;
        this.lengthDir = s;
        this.unitType = 1;
        this.setValue(0.0f);
    }

    public SVGLengthImpl(SVGLength sVGLength, SVGElement sVGElement, short s) {
        this.ownerElement = sVGElement;
        this.lengthDir = s;
        if (sVGLength != null) {
            this.unitType = sVGLength.getUnitType();
            this.setValue(sVGLength.getValue());
        } else {
            this.unitType = 1;
            this.setValue(0.0f);
        }
    }

    public SVGLengthImpl(float f, SVGElement sVGElement, short s) {
        this.ownerElement = sVGElement;
        this.lengthDir = s;
        this.unitType = 1;
        this.setValue(f);
    }

    public SVGLengthImpl(String string, SVGElement sVGElement, short s) {
        this.ownerElement = sVGElement;
        this.lengthDir = s;
        this.setValueAsString(string);
    }

    public short getUnitType() {
        return this.unitType;
    }

    public float getValue() {
        return this.convertToUserUnits(this.valueInSpecifiedUnits, this.unitType);
    }

    public void setValue(float f) throws DOMException {
        this.valueInSpecifiedUnits = this.convertFromUserUnits(f, this.unitType);
    }

    public float getValueInSpecifiedUnits() {
        return this.valueInSpecifiedUnits;
    }

    public void setValueInSpecifiedUnits(float f) throws DOMException {
        this.valueInSpecifiedUnits = f;
    }

    public String getValueAsString() {
        return String.valueOf(this.valueInSpecifiedUnits) + SVGLengthImpl.getUnitText(this.unitType);
    }

    public void setValueAsString(String string) throws DOMException {
        String string2;
        float f = 1.0f;
        String string3 = string.trim();
        int n = -1;
        int n2 = 0;
        while (n2 < string3.length()) {
            if (!Character.isDigit(string3.charAt(n2)) && string3.charAt(n2) != '.' && string3.charAt(n2) != '-' && string3.charAt(n2) != '+') {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n != -1 && (string3.charAt(n) == 'e' || string3.charAt(n) == 'E')) {
            string2 = string3.substring(n);
            int n3 = -1;
            int n4 = 1;
            while (n4 < string2.length()) {
                if (!Character.isDigit(string2.charAt(n4)) && string2.charAt(n4) != '-' && string2.charAt(n4) != '+') {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
            String string4 = n3 != -1 ? string2.substring(1, n3) : string2.substring(1);
            try {
                f = (float)Math.pow(10.0, Integer.parseInt(string4));
                n = -1;
                string3 = string3.substring(0, n) + string3.substring(n + string4.length() + 1, string3.length());
                int n5 = 0;
                while (n5 < string3.length()) {
                    if (!Character.isDigit(string3.charAt(n5)) && string3.charAt(n5) != '.' && string3.charAt(n5) != '-' && string3.charAt(n5) != '+') {
                        n = n5;
                        break;
                    }
                    ++n5;
                }
            }
            catch (Exception exception) {
                f = 1.0f;
            }
        }
        if (n == -1) {
            this.unitType = 1;
            this.setValue(Float.parseFloat(string3) * f);
        } else {
            string2 = string3.substring(n);
            this.unitType = SVGLengthImpl.getUnitTypeConst(string2);
            this.valueInSpecifiedUnits = Float.parseFloat(string3.substring(0, n)) * f;
        }
    }

    public void newValueSpecifiedUnits(short s, float f) {
        this.checkUnitType(s);
        this.unitType = s;
        this.valueInSpecifiedUnits = f;
    }

    public void convertToSpecifiedUnits(short s) {
        this.checkUnitType(s);
        float f = this.convertToUserUnits(this.valueInSpecifiedUnits, this.unitType);
        this.unitType = s;
        this.valueInSpecifiedUnits = this.convertFromUserUnits(f, s);
    }

    public void setLengthDirection(short s) {
        this.lengthDir = s;
    }

    private void checkUnitType(short s) throws SVGException {
        if (s != 6 && s != 3 && s != 4 && s != 8 && s != 7 && s != 1 && s != 10 && s != 2 && s != 9 && s != 5 && s != 0) {
            throw new SVGExceptionImpl(0, "Invalid unit type for SVGLength");
        }
    }

    private float convertToUserUnits(float f, short s) {
        float f2;
        float f3;
        float f4;
        float f5 = 0.28f;
        SVGSVGElement sVGSVGElement = null;
        if (this.ownerElement != null) {
            sVGSVGElement = this.ownerElement.getOwnerSVGElement();
        }
        if (sVGSVGElement != null) {
            f5 = this.lengthDir == 0 ? sVGSVGElement.getScreenPixelToMillimeterX() : (this.lengthDir == 1 ? sVGSVGElement.getScreenPixelToMillimeterY() : (sVGSVGElement.getScreenPixelToMillimeterX() + sVGSVGElement.getScreenPixelToMillimeterY()) / 2.0f);
        }
        float f6 = 1.0f;
        if (sVGSVGElement != null && sVGSVGElement.getViewBox() != null && sVGSVGElement.getViewport() != null) {
            f4 = sVGSVGElement.getViewBox().getAnimVal().getWidth();
            f3 = sVGSVGElement.getViewBox().getAnimVal().getHeight();
            float f7 = sVGSVGElement.getViewport().getWidth();
            f2 = sVGSVGElement.getViewport().getHeight();
            f6 = this.lengthDir == 0 ? f4 / f7 : (this.lengthDir == 1 ? f3 / f2 : (f4 / f7 + f3 / f2) / 2.0f);
        }
        if (s == 1) {
            return f;
        }
        if (s == 5) {
            return f * f6;
        }
        if (s == 6) {
            return f / f5 * 10.0f * f6;
        }
        if (s == 7) {
            return f / f5 * f6;
        }
        if (s == 8) {
            return (float)((double)(f / f5 * 10.0f * f6) * 2.54);
        }
        if (s == 9) {
            return (float)((double)(f / f5 * 10.0f * f6) * 2.54 / 72.0);
        }
        if (s == 10) {
            return (float)((double)(f / f5 * 10.0f * f6) * 2.54 / 72.0 * 12.0);
        }
        if (s == 2) {
            if (sVGSVGElement != null && sVGSVGElement.getViewBox() != null) {
                f4 = sVGSVGElement.getViewBox().getAnimVal().getWidth();
                f3 = sVGSVGElement.getViewBox().getAnimVal().getHeight();
                if (this.lengthDir == 0) {
                    return (float)((double)f / 100.0 * (double)f4);
                }
                if (this.lengthDir == 1) {
                    return (float)((double)f / 100.0 * (double)f3);
                }
                return (float)((double)f / 100.0 * (double)(f4 + f3) / 2.0);
            }
        } else {
            if (s == 3) {
                if (this.ownerElement != null && this.ownerElement instanceof SVGStylableImpl) {
                    Font font = ((SVGStylableImpl)this.ownerElement).getFont(null);
                    return f * (float)font.getSize();
                }
                return f;
            }
            if (s == 4) {
                if (this.ownerElement != null && this.ownerElement instanceof SVGStylableImpl) {
                    Font font = ((SVGStylableImpl)this.ownerElement).getFont(null);
                    GlyphVector glyphVector = font.createGlyphVector(new FontRenderContext(new AffineTransform(), true, true), "x");
                    Shape shape = glyphVector.getGlyphOutline(0);
                    f2 = (float)shape.getBounds2D().getHeight();
                    return f * f2;
                }
                return f;
            }
        }
        return f;
    }

    private float convertFromUserUnits(float f, short s) {
        float f2 = 0.28f;
        SVGSVGElement sVGSVGElement = null;
        if (this.ownerElement != null) {
            sVGSVGElement = this.ownerElement.getOwnerSVGElement();
        }
        if (sVGSVGElement != null) {
            f2 = this.lengthDir == 0 ? sVGSVGElement.getScreenPixelToMillimeterX() : (this.lengthDir == 1 ? sVGSVGElement.getScreenPixelToMillimeterY() : (sVGSVGElement.getScreenPixelToMillimeterX() + sVGSVGElement.getScreenPixelToMillimeterY()) / 2.0f);
        }
        float f3 = 1.0f;
        if (s == 1) {
            return f;
        }
        if (s == 5) {
            return f / f3;
        }
        if (s == 6) {
            return f / (10.0f * f3) * f2;
        }
        if (s == 7) {
            return f / f3 * f2;
        }
        if (s == 8) {
            return (float)((double)f / ((double)(10.0f * f3) * 2.54) * (double)f2);
        }
        if (s == 9) {
            return (float)((double)f / ((double)(10.0f * f3) * 2.54 / 72.0) * (double)f2);
        }
        if (s == 10) {
            return (float)((double)f / ((double)(10.0f * f3) * 2.54 / 72.0 * 12.0) * (double)f2);
        }
        if (s == 2) {
            if (sVGSVGElement != null) {
                float f4 = sVGSVGElement.getViewBox().getAnimVal().getWidth();
                float f5 = sVGSVGElement.getViewBox().getAnimVal().getHeight();
                if (this.lengthDir == 0) {
                    return (float)((double)(f / f4) * 100.0);
                }
                if (this.lengthDir == 1) {
                    return (float)((double)(f / f5) * 100.0);
                }
                return (float)((double)(f / ((f4 + f5) / 2.0f)) * 100.0);
            }
        } else {
            if (s == 3) {
                if (this.ownerElement != null && this.ownerElement instanceof SVGStylableImpl) {
                    Font font = ((SVGStylableImpl)this.ownerElement).getFont(null);
                    return f / (float)font.getSize();
                }
                return f;
            }
            if (s == 4) {
                if (this.ownerElement != null && this.ownerElement instanceof SVGStylableImpl) {
                    Font font = ((SVGStylableImpl)this.ownerElement).getFont(null);
                    GlyphVector glyphVector = font.createGlyphVector(new FontRenderContext(new AffineTransform(), true, true), "x");
                    Shape shape = glyphVector.getGlyphOutline(0);
                    float f6 = (float)shape.getBounds2D().getHeight();
                    return f / f6;
                }
                return f;
            }
        }
        return f;
    }

    float getTransformedLength(AffineTransform affineTransform) {
        Point2D.Double double_;
        if (this.unitType == 1 || affineTransform == null || affineTransform != null && affineTransform.isIdentity()) {
            return this.getValue();
        }
        Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
        if (this.lengthDir == 0) {
            double_ = new Point2D.Double(this.getValue(), 0.0);
        } else if (this.lengthDir == 1) {
            double_ = new Point2D.Double(0.0, this.getValue());
        } else {
            float f = this.getValue();
            double_ = new Point2D.Double(0.7071068 * (double)f, 0.7071068 * (double)f);
        }
        Point2D.Double double_3 = new Point2D.Double();
        Point2D.Double double_4 = new Point2D.Double();
        affineTransform.transform(double_2, double_3);
        affineTransform.transform(double_, double_4);
        double d = ((Point2D)double_4).getX() - ((Point2D)double_3).getX();
        double d2 = ((Point2D)double_4).getY() - ((Point2D)double_3).getY();
        float f = (float)Math.sqrt(d * d + d2 * d2);
        return f;
    }

    private static String getUnitText(short s) {
        switch (s) {
            case 1: {
                return "";
            }
            case 6: {
                return "cm";
            }
            case 3: {
                return "em";
            }
            case 4: {
                return "ex";
            }
            case 8: {
                return "in";
            }
            case 7: {
                return "mm";
            }
            case 10: {
                return "pc";
            }
            case 2: {
                return "%";
            }
            case 9: {
                return "pt";
            }
            case 5: {
                return "px";
            }
        }
        return "";
    }

    private static short getUnitTypeConst(String string) {
        if (string == null) {
            return 1;
        }
        if (string.equalsIgnoreCase("cm")) {
            return 6;
        }
        if (string.equalsIgnoreCase("em")) {
            return 3;
        }
        if (string.equalsIgnoreCase("ex")) {
            return 4;
        }
        if (string.equalsIgnoreCase("in")) {
            return 8;
        }
        if (string.equalsIgnoreCase("mm")) {
            return 7;
        }
        if (string.equalsIgnoreCase("pc")) {
            return 10;
        }
        if (string.equalsIgnoreCase("%")) {
            return 2;
        }
        if (string.equalsIgnoreCase("pt")) {
            return 9;
        }
        if (string.equalsIgnoreCase("px")) {
            return 5;
        }
        System.out.println("unit type: " + string + ", not a valid svg length unit");
        return 0;
    }
}

