/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.csiro.svg.dom.BasicShape;
import org.csiro.svg.dom.Drawable;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGClipPathElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGGraphic;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGMarkerElementImpl;
import org.csiro.svg.dom.SVGMatrixImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGTexturePaint;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGLineElementImpl
extends SVGGraphic
implements SVGLineElement,
Drawable,
BasicShape {
    protected SVGAnimatedLength x1;
    protected SVGAnimatedLength y1;
    protected SVGAnimatedLength x2;
    protected SVGAnimatedLength y2;
    boolean visible = true;
    boolean display = true;
    float opacity = 1.0f;
    Shape clipShape = null;
    Shape shape = null;
    BasicStroke stroke = null;
    Paint fillPaint = null;
    Paint linePaint = null;
    AffineTransform thisTransform = null;
    SVGMarkerElementImpl startMarker = null;
    SVGMarkerElementImpl endMarker = null;

    public SVGLineElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "line");
        super.setAttribute("x1", this.getX1().getBaseVal().getValueAsString());
        super.setAttribute("y1", this.getY1().getBaseVal().getValueAsString());
        super.setAttribute("x2", this.getX2().getBaseVal().getValueAsString());
        super.setAttribute("y2", this.getY2().getBaseVal().getValueAsString());
    }

    public SVGLineElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "line");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGLineElementImpl sVGLineElementImpl = new SVGLineElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedLengthImpl)this.getX1()).getAnimations();
        Vector vector2 = ((SVGAnimatedLengthImpl)this.getY1()).getAnimations();
        Vector vector3 = ((SVGAnimatedLengthImpl)this.getX2()).getAnimations();
        Vector vector4 = ((SVGAnimatedLengthImpl)this.getY2()).getAnimations();
        Vector vector5 = ((SVGAnimatedTransformListImpl)this.getTransform()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGLineElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGLineElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGLineElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector4 != null) {
            n = 0;
            while (n < vector4.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector4.elementAt(n);
                sVGLineElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector5 != null) {
            n = 0;
            while (n < vector5.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector5.elementAt(n);
                sVGLineElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGLineElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGLineElementImpl;
    }

    public SVGAnimatedLength getX1() {
        if (this.x1 == null) {
            this.x1 = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 0), this);
        }
        return this.x1;
    }

    public SVGAnimatedLength getY1() {
        if (this.y1 == null) {
            this.y1 = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 1), this);
        }
        return this.y1;
    }

    public SVGAnimatedLength getX2() {
        if (this.x2 == null) {
            this.x2 = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 0), this);
        }
        return this.x2;
    }

    public SVGAnimatedLength getY2() {
        if (this.y2 == null) {
            this.y2 = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 1), this);
        }
        return this.y2;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("x1")) {
            return this.getX1().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("y1")) {
            return this.getY1().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("x2")) {
            return this.getX2().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("y2")) {
            return this.getY2().getBaseVal().getValueAsString();
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("x1")) {
            attr.setValue(this.getX1().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("y1")) {
            attr.setValue(this.getY1().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("x2")) {
            attr.setValue(this.getX2().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("y2")) {
            attr.setValue(this.getY2().getBaseVal().getValueAsString());
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("x1")) {
            this.getX1().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("y1")) {
            this.getY1().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("x2")) {
            this.getX2().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("y2")) {
            this.getY2().getBaseVal().setValueAsString(string2);
        }
    }

    private Shape createShape(AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        try {
            affineTransform2 = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            affineTransform2 = null;
        }
        GeneralPath generalPath = new GeneralPath();
        float f = ((SVGLengthImpl)this.getX1().getAnimVal()).getTransformedLength(affineTransform2);
        float f2 = ((SVGLengthImpl)this.getY1().getAnimVal()).getTransformedLength(affineTransform2);
        float f3 = ((SVGLengthImpl)this.getX2().getAnimVal()).getTransformedLength(affineTransform2);
        float f4 = ((SVGLengthImpl)this.getY2().getAnimVal()).getTransformedLength(affineTransform2);
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        return generalPath;
    }

    public void draw(Graphics2D graphics2D, boolean bl) {
        Object object;
        Object object2;
        if (bl || this.shape == null) {
            this.refreshData();
            this.visible = this.getVisibility();
            this.display = this.getDisplay();
            this.opacity = this.getOpacity();
            object2 = this.getClippingPath();
            this.clipShape = null;
            if (object2 != null) {
                this.clipShape = ((SVGClipPathElementImpl)object2).getClippingShape(this);
            }
            this.thisTransform = ((SVGTransformListImpl)this.getTransform().getAnimVal()).getAffineTransform();
            this.shape = this.createShape(((SVGMatrixImpl)this.getCTM()).getAffineTransform());
            this.stroke = this.getStroke();
            this.fillPaint = this.getFillPaint();
            this.linePaint = this.getLinePaint();
            this.startMarker = this.getMarker("marker-start");
            this.endMarker = this.getMarker("marker-end");
            if (this.startMarker == null || this.endMarker == null) {
                object = this.getMarker("marker");
                if (this.startMarker == null) {
                    this.startMarker = object;
                }
                if (this.endMarker == null) {
                    this.endMarker = object;
                }
            }
        } else {
            if (this.fillPaint != null && this.fillPaint instanceof SVGTexturePaint && ((SVGTexturePaint)this.fillPaint).getTextureType() == 2) {
                this.fillPaint = this.getFillPaint();
            }
            if (this.linePaint != null && this.linePaint instanceof SVGTexturePaint && ((SVGTexturePaint)this.linePaint).getTextureType() == 2) {
                this.linePaint = this.getLinePaint();
            }
        }
        if (this.visible && this.display && this.opacity > 0.0f) {
            object2 = graphics2D.getTransform();
            object = graphics2D.getClip();
            graphics2D.transform(this.thisTransform);
            if (this.clipShape != null) {
                graphics2D.clip(this.clipShape);
            }
            if (this.opacity < 1.0f) {
                SVGSVGElement sVGSVGElement = this.getOwnerDoc().getRootElement();
                float f = sVGSVGElement.getCurrentScale();
                SVGPoint sVGPoint = sVGSVGElement.getCurrentTranslate();
                if (sVGPoint == null) {
                    sVGPoint = new SVGPointImpl();
                }
                Shape shape = this.getShape();
                AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
                Shape shape2 = affineTransform.createTransformedShape(shape);
                Rectangle2D rectangle2D = shape2.getBounds2D();
                double d = rectangle2D.getWidth() / 5.0;
                double d2 = rectangle2D.getHeight() / 5.0;
                rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d2, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d2);
                int n = (int)(rectangle2D.getWidth() * (double)f);
                int n2 = (int)(rectangle2D.getHeight() * (double)f);
                if (n > 0 && n2 > 0) {
                    Object object3;
                    BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
                    Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D2.setRenderingHints(renderingHints);
                    if (f != 1.0f) {
                        graphics2D2.scale(f, f);
                    }
                    graphics2D2.translate(-rectangle2D.getX(), -rectangle2D.getY());
                    graphics2D2.transform(affineTransform);
                    this.drawShape(graphics2D2, bl);
                    if (this.highlighted) {
                        graphics2D2.setPaint(Color.yellow);
                        object3 = this.getBBox();
                        graphics2D2.draw(new Rectangle2D.Float(object3.getX(), object3.getY(), object3.getWidth(), object3.getHeight()));
                    }
                    object3 = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
                    graphics2D.setComposite(alphaComposite);
                    AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY());
                    affineTransform2.scale(1.0f / f, 1.0f / f);
                    try {
                        affineTransform2.preConcatenate(affineTransform.createInverse());
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    graphics2D.drawImage(bufferedImage, affineTransform2, null);
                    graphics2D.setComposite((Composite)object3);
                    bufferedImage.flush();
                }
            } else {
                this.drawShape(graphics2D, bl);
                if (this.highlighted) {
                    graphics2D.setPaint(Color.yellow);
                    SVGRect sVGRect = this.getBBox();
                    graphics2D.draw(new Rectangle2D.Float(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight()));
                }
            }
            graphics2D.setTransform((AffineTransform)object2);
            graphics2D.setClip((Shape)object);
        }
    }

    private void drawShape(Graphics2D graphics2D, boolean bl) {
        AffineTransform affineTransform;
        graphics2D.setStroke(this.stroke);
        if (this.fillPaint != null) {
            graphics2D.setPaint(this.fillPaint);
            graphics2D.fill(this.shape);
        }
        if (this.linePaint != null) {
            graphics2D.setPaint(this.linePaint);
            graphics2D.draw(this.shape);
        }
        AffineTransform affineTransform2 = ((SVGMatrixImpl)this.getCTM()).getAffineTransform();
        try {
            affineTransform = affineTransform2.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            affineTransform = null;
        }
        float f = ((SVGLengthImpl)this.getX1().getAnimVal()).getTransformedLength(affineTransform);
        float f2 = ((SVGLengthImpl)this.getY1().getAnimVal()).getTransformedLength(affineTransform);
        float f3 = ((SVGLengthImpl)this.getX2().getAnimVal()).getTransformedLength(affineTransform);
        float f4 = ((SVGLengthImpl)this.getY2().getAnimVal()).getTransformedLength(affineTransform);
        double d = Math.atan2(f4 - f2, f3 - f);
        float f5 = (float)Math.toDegrees(d);
        if (this.startMarker != null) {
            this.startMarker.drawMarker(graphics2D, this, f, f2, f5, this.stroke.getLineWidth(), bl);
        }
        if (this.endMarker != null) {
            this.endMarker.drawMarker(graphics2D, this, f3, f4, f5, this.stroke.getLineWidth(), bl);
        }
    }

    public Shape getShape() {
        if (this.shape == null) {
            AffineTransform affineTransform = ((SVGMatrixImpl)this.getCTM()).getAffineTransform();
            return this.createShape(affineTransform);
        }
        return this.shape;
    }

    public SVGRect getBBox() {
        Shape shape = this.getShape();
        Rectangle2D rectangle2D = shape.getBounds2D();
        SVGRectImpl sVGRectImpl = new SVGRectImpl(rectangle2D);
        return sVGRectImpl;
    }

    public boolean contains(double d, double d2) {
        Shape shape = this.getShape();
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape2 = affineTransform.createTransformedShape(shape);
        double d3 = this.getOwnerDoc().getRootElement().getCurrentScale();
        return shape2.intersects(d - d3, d2 - d3, 2.0 * d3, 2.0 * d3);
    }

    public double boundingArea() {
        Shape shape = this.getShape();
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape2 = affineTransform.createTransformedShape(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        return rectangle2D.getWidth() * rectangle2D.getHeight();
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("x1")) {
            ((SVGAnimatedValue)((Object)this.getX1())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("y1")) {
            ((SVGAnimatedValue)((Object)this.getY1())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("x2")) {
            ((SVGAnimatedValue)((Object)this.getX2())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("y2")) {
            ((SVGAnimatedValue)((Object)this.getY2())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

