/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import org.csiro.svg.dom.SVGAnimatedBooleanImpl;
import org.csiro.svg.dom.SVGAnimatedEnumerationImpl;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedStringImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGGradientElementImpl;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGStopElementImpl;
import org.csiro.svg.dom.SVGTexturePaint;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLinearGradientElement;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGTransformable;

public class SVGLinearGradientElementImpl
extends SVGGradientElementImpl
implements SVGLinearGradientElement {
    protected SVGAnimatedLength x1;
    protected SVGAnimatedLength y1;
    protected SVGAnimatedLength x2;
    protected SVGAnimatedLength y2;

    public SVGLinearGradientElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "linearGradient");
        super.setAttribute("x1", this.getX1().getBaseVal().getValueAsString());
        super.setAttribute("y1", this.getY1().getBaseVal().getValueAsString());
        super.setAttribute("x2", this.getX2().getBaseVal().getValueAsString());
        super.setAttribute("y2", this.getY2().getBaseVal().getValueAsString());
    }

    public SVGLinearGradientElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "linearGradient");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGLinearGradientElementImpl sVGLinearGradientElementImpl = new SVGLinearGradientElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedLengthImpl)this.getX1()).getAnimations();
        Vector vector2 = ((SVGAnimatedLengthImpl)this.getY1()).getAnimations();
        Vector vector3 = ((SVGAnimatedLengthImpl)this.getX2()).getAnimations();
        Vector vector4 = ((SVGAnimatedLengthImpl)this.getY2()).getAnimations();
        Vector vector5 = ((SVGAnimatedTransformListImpl)this.getGradientTransform()).getAnimations();
        Vector vector6 = ((SVGAnimatedEnumerationImpl)this.getGradientUnits()).getAnimations();
        Vector vector7 = ((SVGAnimatedEnumerationImpl)this.getSpreadMethod()).getAnimations();
        Vector vector8 = ((SVGAnimatedBooleanImpl)this.getExternalResourcesRequired()).getAnimations();
        Vector vector9 = ((SVGAnimatedStringImpl)this.getHref()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGLinearGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGLinearGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGLinearGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector4 != null) {
            n = 0;
            while (n < vector4.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector4.elementAt(n);
                sVGLinearGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector5 != null) {
            n = 0;
            while (n < vector5.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector5.elementAt(n);
                sVGLinearGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector6 != null) {
            n = 0;
            while (n < vector6.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector6.elementAt(n);
                sVGLinearGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector7 != null) {
            n = 0;
            while (n < vector7.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector7.elementAt(n);
                sVGLinearGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector8 != null) {
            n = 0;
            while (n < vector8.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector8.elementAt(n);
                sVGLinearGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector9 != null) {
            n = 0;
            while (n < vector9.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector9.elementAt(n);
                sVGLinearGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        return sVGLinearGradientElementImpl;
    }

    public SVGAnimatedLength getX1() {
        if (this.x1 == null) {
            SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
            if (sVGGradientElementImpl != null && sVGGradientElementImpl instanceof SVGLinearGradientElementImpl) {
                return ((SVGLinearGradientElementImpl)sVGGradientElementImpl).getX1();
            }
            this.x1 = new SVGAnimatedLengthImpl(new SVGLengthImpl("0%", (SVGElement)this, 0), this);
        }
        return this.x1;
    }

    public SVGAnimatedLength getY1() {
        if (this.y1 == null) {
            SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
            if (sVGGradientElementImpl != null && sVGGradientElementImpl instanceof SVGLinearGradientElementImpl) {
                return ((SVGLinearGradientElementImpl)sVGGradientElementImpl).getY1();
            }
            this.y1 = new SVGAnimatedLengthImpl(new SVGLengthImpl("0%", (SVGElement)this, 1), this);
        }
        return this.y1;
    }

    public SVGAnimatedLength getX2() {
        if (this.x2 == null) {
            SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
            if (sVGGradientElementImpl != null && sVGGradientElementImpl instanceof SVGLinearGradientElementImpl) {
                return ((SVGLinearGradientElementImpl)sVGGradientElementImpl).getX2();
            }
            this.x2 = new SVGAnimatedLengthImpl(new SVGLengthImpl("100%", (SVGElement)this, 0), this);
        }
        return this.x2;
    }

    public SVGAnimatedLength getY2() {
        if (this.y2 == null) {
            SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
            if (sVGGradientElementImpl != null && sVGGradientElementImpl instanceof SVGLinearGradientElementImpl) {
                return ((SVGLinearGradientElementImpl)sVGGradientElementImpl).getY2();
            }
            this.y2 = new SVGAnimatedLengthImpl(new SVGLengthImpl("0%", (SVGElement)this, 1), this);
        }
        return this.y2;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("x1")) {
            return this.getX1().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("y1")) {
            return this.getY1().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("x2")) {
            return this.getX2().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("y2")) {
            return this.getY2().getBaseVal().getValueAsString();
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("x1")) {
            attr.setValue(this.getX1().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("y1")) {
            attr.setValue(this.getY1().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("x2")) {
            attr.setValue(this.getX2().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("y2")) {
            attr.setValue(this.getY2().getBaseVal().getValueAsString());
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("x1")) {
            this.getX1().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("y1")) {
            this.getY1().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("x2")) {
            this.getX2().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("y2")) {
            this.getY2().getBaseVal().setValueAsString(string2);
        }
    }

    public Paint getPaint(SVGElementImpl sVGElementImpl, float f) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        Object object2;
        float f2;
        float f3;
        float f4;
        float f5;
        Object object3;
        if (this.numStops() == 0 && this.getReferencedGradient() == null) {
            return null;
        }
        int[] nArray = new int[256];
        short s = this.getGradientUnits().getAnimVal();
        short s2 = this.getSpreadMethod().getAnimVal();
        SVGLength sVGLength = this.getX1().getAnimVal();
        SVGLength sVGLength2 = this.getY1().getAnimVal();
        SVGLength sVGLength3 = this.getX2().getAnimVal();
        SVGLength sVGLength4 = this.getY2().getAnimVal();
        int n5 = 0;
        while (n5 < 256) {
            double d = (double)n5 / 255.0;
            object3 = this.getColorAtOffset(d);
            if (f < 1.0f) {
                object3 = new Color(((Color)object3).getRed(), ((Color)object3).getGreen(), ((Color)object3).getBlue(), (int)((float)((Color)object3).getAlpha() * f));
            }
            nArray[255 - n5] = ((Color)object3).getRGB();
            ++n5;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, nArray, 0, true, -1, 0);
        object3 = this.getOwnerSVGElement();
        SVGRect sVGRect = object3.getViewBox().getAnimVal();
        if (sVGRect == null) {
            sVGRect = object3.getViewport();
        }
        SVGRect sVGRect2 = null;
        sVGRect2 = sVGElementImpl instanceof SVGTransformable ? ((SVGTransformable)((Object)sVGElementImpl)).getBBox() : sVGRect;
        float f6 = 1.0f;
        float f7 = 1.0f;
        if (s == 2) {
            f5 = sVGRect2.getX();
            f4 = sVGRect2.getY();
            f3 = sVGRect2.getWidth();
            if (f3 > (f2 = sVGRect2.getHeight())) {
                f7 = f2 / f3;
                f2 = f3;
            } else if (f2 > f3) {
                f6 = f3 / f2;
                f3 = f2;
            }
        } else {
            f5 = sVGRect.getX();
            f4 = sVGRect.getY();
            f3 = sVGRect.getWidth();
            f2 = sVGRect.getHeight();
        }
        double d = sVGLength.getUnitType() == 2 ? (double)((float)((double)f5 + (double)sVGLength.getValueInSpecifiedUnits() / 100.0 * (double)f3)) : (s == 1 ? (double)sVGLength.getValue() : (double)(f5 + sVGLength.getValue() * f3));
        double d2 = sVGLength2.getUnitType() == 2 ? (double)((float)((double)f4 + (double)sVGLength2.getValueInSpecifiedUnits() / 100.0 * (double)f2)) : (s == 1 ? (double)sVGLength2.getValue() : (double)(f4 + sVGLength2.getValue() * f2));
        double d3 = sVGLength3.getUnitType() == 2 ? (double)((float)((double)f5 + (double)sVGLength3.getValueInSpecifiedUnits() / 100.0 * (double)f3)) : (s == 1 ? (double)sVGLength3.getValue() : (double)(f5 + sVGLength3.getValue() * f3));
        double d4 = sVGLength4.getUnitType() == 2 ? (double)((float)((double)f4 + (double)sVGLength4.getValueInSpecifiedUnits() / 100.0 * (double)f2)) : (s == 1 ? (double)sVGLength4.getValue() : (double)(f4 + sVGLength4.getValue() * f2));
        SVGStopElementImpl sVGStopElementImpl = this.getStop(0);
        SVGStopElementImpl sVGStopElementImpl2 = this.getStop(this.numStops() - 1);
        float f8 = sVGStopElementImpl.getOffset().getAnimVal();
        float f9 = sVGStopElementImpl2.getOffset().getAnimVal();
        double d5 = d3 - d;
        double d6 = d4 - d2;
        if (f8 > 0.0f) {
            d += (double)f8 * d5;
            d2 += (double)f8 * d6;
        }
        if (f9 < 1.0f) {
            d3 -= (double)(1.0f - f9) * d5;
            d4 -= (double)(1.0f - f9) * d6;
        }
        AffineTransform affineTransform = ((SVGTransformListImpl)this.getGradientTransform().getAnimVal()).getAffineTransform();
        if (f6 != 1.0f || f7 != 1.0f) {
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(-f5, -f4));
            affineTransform.preConcatenate(AffineTransform.getScaleInstance(f6, f7));
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(f5, f4));
        }
        try {
            object2 = affineTransform.createInverse();
            object = new Rectangle2D.Double(f5, f4, f3, f2);
            Shape shape = ((AffineTransform)object2).createTransformedShape((Shape)object);
            Rectangle2D rectangle2D = shape.getBounds2D();
            n4 = (int)rectangle2D.getMinX();
            n3 = (int)rectangle2D.getMinY();
            n2 = (int)rectangle2D.getMaxX();
            n = (int)rectangle2D.getMaxY();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            n4 = (int)f5;
            n3 = (int)f4;
            n2 = (int)(f5 + f3);
            n = (int)(f4 + f2);
        }
        object2 = new BufferedImage(n2 - n4, n - n3, 13, indexColorModel);
        object = ((BufferedImage)object2).getRaster();
        double d7 = d3 - d;
        double d8 = d4 - d2;
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        int n6 = n4;
        while (n6 < n2) {
            int n7 = n3;
            while (n7 < n) {
                double d10 = (double)n6 - d;
                double d11 = (double)n7 - d2;
                double d12 = (double)n6 - d3;
                double d13 = (double)n7 - d4;
                double d14 = (d10 * d7 + d11 * d8) / d9;
                double d15 = (d12 * -d7 + d13 * -d8) / d9;
                double d16 = d14 / d9;
                double d17 = d15 / d9;
                if (Math.abs(d16) > 2.0 && s2 != 1) {
                    int n8 = (int)(d16 / 2.0);
                    d16 -= (double)(2 * n8);
                }
                if (d17 > 1.0) {
                    if (s2 == 3) {
                        if ((d16 += 1.0) < 0.0) {
                            d16 += 1.0;
                        }
                    } else {
                        d16 = s2 == 2 ? -d16 : 0.0;
                    }
                }
                if (d16 > 1.0) {
                    d16 = s2 == 3 ? (d16 -= 1.0) : (s2 == 2 ? 2.0 - d16 : 1.0);
                }
                if (d16 < 0.0) {
                    d16 = 0.0;
                }
                if (d16 > 1.0) {
                    d16 = 1.0;
                }
                ((WritableRaster)object).setSample(n6 - n4, n7 - n3, 0, 255 - (int)(d16 * 255.0));
                ++n7;
            }
            ++n6;
        }
        SVGTexturePaint sVGTexturePaint = new SVGTexturePaint((BufferedImage)object2, new Rectangle2D.Float(n4, n3, n2 - n4, n - n3), affineTransform, 1);
        return sVGTexturePaint;
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("x1")) {
            ((SVGAnimatedValue)((Object)this.getX1())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("y1")) {
            ((SVGAnimatedValue)((Object)this.getY1())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("x2")) {
            ((SVGAnimatedValue)((Object)this.getX2())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("y2")) {
            ((SVGAnimatedValue)((Object)this.getY2())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

