/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;

public abstract class SVGListImpl {
    protected Vector items = new Vector();

    public int getNumberOfItems() {
        return this.items.size();
    }

    public void clear() throws DOMException {
        this.items = new Vector();
    }

    public Object initialize(Object object) throws DOMException, SVGException {
        this.checkItemType(object);
        this.items = new Vector();
        this.items.add(object);
        return object;
    }

    public Object getItemAt(int n) throws DOMException {
        if (n < 0 || n > this.getNumberOfItems() - 1) {
            throw new DOMException(1, "SVGList.getItem, index out of bounds. Must be between 0 and numberOfItems-1.");
        }
        return this.items.elementAt(n);
    }

    public Object insertItemBefore(Object object, int n) throws DOMException, SVGException {
        this.checkItemType(object);
        if (this.items.contains(object)) {
            this.items.removeElement(object);
        }
        if (n < 0) {
            this.items.insertElementAt(object, 0);
        } else if (n > this.getNumberOfItems() - 1) {
            this.items.add(object);
        } else {
            this.items.insertElementAt(object, n);
        }
        return object;
    }

    public Object replaceItem(Object object, int n) throws DOMException, SVGException {
        this.checkItemType(object);
        if (this.items.contains(object)) {
            this.items.removeElement(object);
        }
        if (n < 0 || n > this.getNumberOfItems() - 1) {
            throw new DOMException(1, "SVGList.replace, index out of bounds. Must be between 0 and numberOfItems-1.");
        }
        this.items.removeElementAt(n);
        this.items.insertElementAt(object, n);
        return object;
    }

    public Object removeItemAt(int n) throws DOMException {
        if (n < 0 || n > this.getNumberOfItems() - 1) {
            throw new DOMException(1, "SVGList.remove, index out of bounds. Must be between 0 and numberOfItems-1.");
        }
        Object e = this.items.elementAt(n);
        this.items.removeElementAt(n);
        return e;
    }

    public Object appendItem(Object object) throws DOMException, SVGException {
        this.checkItemType(object);
        if (this.items.contains(object)) {
            this.items.removeElement(object);
        }
        this.items.add(object);
        return object;
    }

    protected abstract void checkItemType(Object var1) throws SVGException;
}

