/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.Graphics2D;
import java.util.StringTokenizer;
import java.util.Vector;
import org.csiro.svg.dom.Drawable;
import org.csiro.svg.dom.SVGAngleImpl;
import org.csiro.svg.dom.SVGAnimatedAngleImpl;
import org.csiro.svg.dom.SVGAnimatedBooleanImpl;
import org.csiro.svg.dom.SVGAnimatedEnumerationImpl;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedPreserveAspectRatioImpl;
import org.csiro.svg.dom.SVGAnimatedRectImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGGElementImpl;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGPreserveAspectRatioImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGStylableImpl;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGAngle;
import org.w3c.dom.svg.SVGAnimatedAngle;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGMarkerElement;
import org.w3c.dom.svg.SVGTransformList;

public class SVGMarkerElementImpl
extends SVGStylableImpl
implements SVGMarkerElement {
    protected SVGAnimatedLength refX;
    protected SVGAnimatedLength refY;
    protected SVGAnimatedEnumeration markerUnits;
    protected SVGAnimatedLength markerWidth;
    protected SVGAnimatedLength markerHeight;
    protected SVGAnimatedEnumeration orientType;
    protected SVGAnimatedAngle orientAngle;
    protected SVGAnimatedRect viewBox;
    protected SVGAnimatedPreserveAspectRatio preserveAspectRatio;
    protected SVGAnimatedBoolean externalResourcesRequired;
    private static Vector markerUnitStrings;
    private static Vector markerUnitValues;
    private static Vector orientTypeStrings;
    private static Vector orientTypeValues;
    SVGMarkerElementImpl clonedMarker = null;
    String styleText = "";

    public SVGMarkerElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "marker");
        super.setAttribute("refX", this.getRefX().getBaseVal().getValueAsString());
        super.setAttribute("refY", this.getRefY().getBaseVal().getValueAsString());
        super.setAttribute("markerUnits", "strokeWidth");
        super.setAttribute("markerWidth", this.getMarkerWidth().getBaseVal().getValueAsString());
        super.setAttribute("markerHeight", this.getMarkerHeight().getBaseVal().getValueAsString());
        super.setAttribute("orient", "0");
        super.setAttribute("preserveAspectRatio", ((SVGPreserveAspectRatioImpl)this.getPreserveAspectRatio().getBaseVal()).toString());
    }

    public SVGMarkerElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "marker");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGMarkerElementImpl sVGMarkerElementImpl = new SVGMarkerElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedLengthImpl)this.getRefX()).getAnimations();
        Vector vector2 = ((SVGAnimatedLengthImpl)this.getRefY()).getAnimations();
        Vector vector3 = ((SVGAnimatedEnumerationImpl)this.getMarkerUnits()).getAnimations();
        Vector vector4 = ((SVGAnimatedLengthImpl)this.getMarkerWidth()).getAnimations();
        Vector vector5 = ((SVGAnimatedLengthImpl)this.getMarkerHeight()).getAnimations();
        Vector vector6 = ((SVGAnimatedEnumerationImpl)this.getOrientType()).getAnimations();
        Vector vector7 = ((SVGAnimatedAngleImpl)this.getOrientAngle()).getAnimations();
        Vector vector8 = ((SVGAnimatedRectImpl)this.getViewBox()).getAnimations();
        Vector vector9 = ((SVGAnimatedPreserveAspectRatioImpl)this.getPreserveAspectRatio()).getAnimations();
        Vector vector10 = ((SVGAnimatedBooleanImpl)this.getExternalResourcesRequired()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGMarkerElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGMarkerElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGMarkerElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector4 != null) {
            n = 0;
            while (n < vector4.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector4.elementAt(n);
                sVGMarkerElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector5 != null) {
            n = 0;
            while (n < vector5.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector5.elementAt(n);
                sVGMarkerElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector6 != null) {
            n = 0;
            while (n < vector6.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector6.elementAt(n);
                sVGMarkerElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector7 != null) {
            n = 0;
            while (n < vector7.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector7.elementAt(n);
                sVGMarkerElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector8 != null) {
            n = 0;
            while (n < vector8.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector8.elementAt(n);
                sVGMarkerElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector9 != null) {
            n = 0;
            while (n < vector9.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector9.elementAt(n);
                sVGMarkerElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector10 != null) {
            n = 0;
            while (n < vector10.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector10.elementAt(n);
                sVGMarkerElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGMarkerElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGMarkerElementImpl;
    }

    private void initMarkerUnitVectors() {
        if (markerUnitStrings == null) {
            markerUnitStrings = new Vector();
            markerUnitStrings.addElement("userSpaceOnUse");
            markerUnitStrings.addElement("strokeWidth");
        }
        if (markerUnitValues == null) {
            markerUnitValues = new Vector();
            markerUnitValues.addElement(new Short(1));
            markerUnitValues.addElement(new Short(2));
            markerUnitValues.addElement(new Short(0));
        }
    }

    private void initOrientTypeVectors() {
        if (orientTypeStrings == null) {
            orientTypeStrings = new Vector();
            orientTypeStrings.addElement("auto");
        }
        if (orientTypeValues == null) {
            orientTypeValues = new Vector();
            orientTypeValues.addElement(new Short(1));
            orientTypeValues.addElement(new Short(2));
        }
    }

    public SVGAnimatedLength getRefX() {
        if (this.refX == null) {
            this.refX = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 0), this);
        }
        return this.refX;
    }

    public SVGAnimatedLength getRefY() {
        if (this.refY == null) {
            this.refY = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 1), this);
        }
        return this.refY;
    }

    public SVGAnimatedEnumeration getMarkerUnits() {
        if (this.markerUnits == null) {
            if (markerUnitStrings == null) {
                this.initMarkerUnitVectors();
            }
            this.markerUnits = new SVGAnimatedEnumerationImpl(2, this, markerUnitStrings, markerUnitValues);
        }
        return this.markerUnits;
    }

    public SVGAnimatedLength getMarkerWidth() {
        if (this.markerWidth == null) {
            this.markerWidth = new SVGAnimatedLengthImpl(new SVGLengthImpl(3.0f, (SVGElement)this, 0), this);
        }
        return this.markerWidth;
    }

    public SVGAnimatedLength getMarkerHeight() {
        if (this.markerHeight == null) {
            this.markerHeight = new SVGAnimatedLengthImpl(new SVGLengthImpl(3.0f, (SVGElement)this, 1), this);
        }
        return this.markerHeight;
    }

    public SVGAnimatedEnumeration getOrientType() {
        if (this.orientType == null) {
            if (orientTypeStrings == null) {
                this.initOrientTypeVectors();
            }
            this.orientType = new SVGAnimatedEnumerationImpl(2, this, orientTypeStrings, orientTypeValues);
        }
        return this.orientType;
    }

    public SVGAnimatedAngle getOrientAngle() {
        if (this.orientAngle == null) {
            this.orientAngle = new SVGAnimatedAngleImpl(new SVGAngleImpl(), this);
        }
        return this.orientAngle;
    }

    public void setOrientToAuto() {
        this.getOrientType().setBaseVal((short)1);
        ((SVGAnimatedAngleImpl)this.getOrientAngle()).setBaseVal(new SVGAngleImpl());
        super.setAttribute("orient", "auto");
    }

    public void setOrientToAngle(SVGAngle sVGAngle) {
        this.getOrientType().setBaseVal((short)2);
        ((SVGAnimatedAngleImpl)this.getOrientAngle()).setBaseVal(sVGAngle);
        super.setAttribute("orient", sVGAngle.getValueAsString());
    }

    public String getXMLlang() {
        return this.getAttribute("xml:lang");
    }

    public void setXMLlang(String string) {
        if (string != null) {
            super.setAttribute("xml:lang", string);
        } else {
            this.removeAttribute("xml:lang");
        }
    }

    public String getXMLspace() {
        return this.getAttribute("xml:space");
    }

    public void setXMLspace(String string) {
        if (string != null) {
            super.setAttribute("xml:space", string);
        } else {
            this.removeAttribute("xml:space");
        }
    }

    public SVGAnimatedRect getViewBox() {
        if (this.viewBox == null) {
            this.viewBox = new SVGAnimatedRectImpl(new SVGRectImpl(), this);
        }
        return this.viewBox;
    }

    public SVGAnimatedPreserveAspectRatio getPreserveAspectRatio() {
        if (this.preserveAspectRatio == null) {
            this.preserveAspectRatio = new SVGAnimatedPreserveAspectRatioImpl(new SVGPreserveAspectRatioImpl(), this);
        }
        return this.preserveAspectRatio;
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        if (this.externalResourcesRequired == null) {
            this.externalResourcesRequired = new SVGAnimatedBooleanImpl(false, this);
        }
        return this.externalResourcesRequired;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("orient")) {
            if (this.getOrientType().getBaseVal() == 1) {
                return "auto";
            }
            if (this.getOrientType().getBaseVal() == 2) {
                return this.getOrientAngle().getBaseVal().getValueAsString();
            }
            return "";
        }
        if (string.equalsIgnoreCase("markerUnits")) {
            if (this.getMarkerUnits().getBaseVal() == 1) {
                return "userSpaceOnUse";
            }
            return "strokeWidth";
        }
        if (string.equalsIgnoreCase("refX")) {
            return this.getRefX().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("refY")) {
            return this.getRefY().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("markerWidth")) {
            return this.getMarkerWidth().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("markerHeight")) {
            return this.getMarkerHeight().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("viewBox")) {
            if (this.getViewBox().getBaseVal() == null) {
                return "";
            }
            return this.getViewBox().getBaseVal().toString();
        }
        if (string.equalsIgnoreCase("preserveAspectRatio")) {
            return ((SVGPreserveAspectRatioImpl)this.getPreserveAspectRatio().getBaseVal()).toString();
        }
        if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                return "true";
            }
            return "false";
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("orient")) {
            if (this.getOrientType().getBaseVal() == 1) {
                attr.setValue("auto");
            } else if (this.getOrientType().getBaseVal() == 2) {
                attr.setValue(this.getOrientAngle().getBaseVal().getValueAsString());
            }
        } else if (string.equalsIgnoreCase("markerUnits")) {
            if (this.getMarkerUnits().getBaseVal() == 1) {
                attr.setValue("userSpaceOnUse");
            } else {
                attr.setValue("strokeWidth");
            }
        } else if (string.equalsIgnoreCase("refX")) {
            attr.setValue(this.getRefX().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("refY")) {
            attr.setValue(this.getRefY().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("markerWidth")) {
            attr.setValue(this.getMarkerWidth().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("markerHeight")) {
            attr.setValue(this.getMarkerHeight().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("viewBox")) {
            if (this.getViewBox().getBaseVal() == null) {
                attr.setValue("");
            } else {
                attr.setValue(this.getViewBox().getBaseVal().toString());
            }
        } else if (string.equalsIgnoreCase("preserveAspectRatio")) {
            attr.setValue(this.getPreserveAspectRatio().getBaseVal().toString());
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                attr.setValue("true");
            } else {
                attr.setValue("false");
            }
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("orient")) {
            if (string2.equalsIgnoreCase("auto")) {
                this.getOrientType().setBaseVal((short)1);
                this.getOrientAngle().getBaseVal().setValue(0.0f);
            } else {
                this.getOrientType().setBaseVal((short)2);
                this.getOrientAngle().getBaseVal().setValueAsString(string2);
            }
        } else if (string.equalsIgnoreCase("refX")) {
            this.getRefX().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("refY")) {
            this.getRefY().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("markerWidth")) {
            this.getMarkerWidth().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("markerHeight")) {
            this.getMarkerHeight().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("markerUnits")) {
            if (string2.equalsIgnoreCase("strokeWidth")) {
                this.getMarkerUnits().setBaseVal((short)2);
            } else if (string2.equalsIgnoreCase("userSpaceOnUse")) {
                this.getMarkerUnits().setBaseVal((short)1);
            } else {
                System.out.println("bad markerUnits attribute value " + string2 + ", setting to default value 'strokeWidth'");
                this.getMarkerUnits().setBaseVal((short)2);
            }
        } else if (string.equalsIgnoreCase("viewBox")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
            if (stringTokenizer.countTokens() == 4) {
                this.getViewBox().getBaseVal().setX(Float.parseFloat(stringTokenizer.nextToken()));
                this.getViewBox().getBaseVal().setY(Float.parseFloat(stringTokenizer.nextToken()));
                this.getViewBox().getBaseVal().setWidth(Float.parseFloat(stringTokenizer.nextToken()));
                this.getViewBox().getBaseVal().setHeight(Float.parseFloat(stringTokenizer.nextToken()));
            }
        } else if (string.equalsIgnoreCase("preserveAspectRatio")) {
            short s;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
            String string3 = null;
            String string4 = null;
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                string3 = stringTokenizer.nextToken();
                if (n > 1) {
                    string4 = stringTokenizer.nextToken();
                }
            }
            if (string3 != null) {
                s = SVGPreserveAspectRatioImpl.getAlignConst(string3);
                this.getPreserveAspectRatio().getBaseVal().setAlign(s);
            }
            if (string4 != null) {
                s = SVGPreserveAspectRatioImpl.getMeetOrSliceConst(string4);
                this.getPreserveAspectRatio().getBaseVal().setMeetOrSlice(s);
            }
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (string2.equalsIgnoreCase("true")) {
                this.getExternalResourcesRequired().setBaseVal(true);
            } else {
                this.getExternalResourcesRequired().setBaseVal(false);
            }
        }
    }

    public void drawMarker(Graphics2D graphics2D, SVGElementImpl sVGElementImpl, float f, float f2, float f3, float f4, boolean bl) {
        if (bl || this.clonedMarker == null) {
            this.refreshData();
            this.clonedMarker = (SVGMarkerElementImpl)this.cloneElement();
            this.styleText = this.getAttribute("style");
            if (!this.styleText.endsWith(";")) {
                this.styleText = this.styleText + ";";
            }
            if (this.styleText.indexOf("marker-start") == -1 || this.getAttribute("marker-start").length() == 0) {
                this.styleText = this.styleText + "marker-start:none;";
            }
            if (this.styleText.indexOf("marker-mid") == -1 || this.getAttribute("marker-mid").length() == 0) {
                this.styleText = this.styleText + "marker-mid:none;";
            }
            if (this.styleText.indexOf("marker-end") == -1 || this.getAttribute("marker-end").length() == 0) {
                this.styleText = this.styleText + "marker-end:none;";
            }
            if (this.styleText.indexOf("marker:") == -1 || this.getAttribute("marker").length() == 0) {
                this.styleText = this.styleText + "marker:none;";
            }
        }
        if (this.clonedMarker != null) {
            float f5;
            float f6;
            SVGElementImpl sVGElementImpl2 = (SVGElementImpl)this.getParentNode();
            SVGGElementImpl sVGGElementImpl = new SVGGElementImpl(sVGElementImpl2.getOwnerDoc());
            sVGElementImpl2.appendChild(sVGGElementImpl);
            sVGGElementImpl.copyAttributes(this);
            sVGGElementImpl.setAttribute("style", this.styleText);
            sVGGElementImpl.animatedProperties = this.clonedMarker.animatedProperties;
            Vector<Node> vector = new Vector<Node>();
            if (this.clonedMarker.hasChildNodes()) {
                NodeList nodeList = this.clonedMarker.getChildNodes();
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Node node = nodeList.item(n2);
                    if (node instanceof Drawable) {
                        vector.add(node);
                    }
                    ++n2;
                }
            }
            int n = 0;
            while (n < vector.size()) {
                Node node = (Node)vector.elementAt(n);
                this.clonedMarker.removeChild(node);
                sVGGElementImpl.appendChild(node);
                ++n;
            }
            if (this.getOrientType().getAnimVal() == 2) {
                f3 = this.getOrientAngle().getAnimVal().getValue();
            }
            String string = "translate(" + f + "," + f2 + ")rotate(" + f3 + ")";
            if (this.getMarkerUnits().getAnimVal() == 2) {
                string = string + "scale(" + f4 + ")";
            }
            float f7 = this.getMarkerWidth().getAnimVal().getValue();
            float f8 = this.getMarkerHeight().getAnimVal().getValue();
            if (this.clonedMarker.getViewBox().getAnimVal().getWidth() > 0.0f) {
                f6 = this.clonedMarker.getViewBox().getAnimVal().getWidth();
                f5 = this.clonedMarker.getViewBox().getAnimVal().getHeight();
            } else {
                f6 = f7;
                f5 = f8;
            }
            string = string + "scale(" + f7 / f6 + "," + f8 / f5 + ")";
            string = string + "translate(" + this.getRefX().getAnimVal().getValue() * -1.0f + "," + this.getRefY().getAnimVal().getValue() * -1.0f + ")";
            SVGTransformList sVGTransformList = SVGTransformListImpl.createTransformList(string);
            ((SVGAnimatedTransformListImpl)sVGGElementImpl.getTransform()).setBaseVal(sVGTransformList);
            sVGGElementImpl.draw(graphics2D, true);
            int n3 = 0;
            while (n3 < vector.size()) {
                Node node = (Node)vector.elementAt(n3);
                sVGGElementImpl.removeChild(node);
                this.clonedMarker.appendChild(node);
                ++n3;
            }
            sVGElementImpl2.removeChild(sVGGElementImpl);
        }
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("refX")) {
            ((SVGAnimatedValue)((Object)this.getRefX())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("refY")) {
            ((SVGAnimatedValue)((Object)this.getRefY())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("markerWidth")) {
            ((SVGAnimatedValue)((Object)this.getMarkerWidth())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("markerHeight")) {
            ((SVGAnimatedValue)((Object)this.getMarkerHeight())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("markerUnits")) {
            ((SVGAnimatedValue)((Object)this.getMarkerUnits())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("orient")) {
            ((SVGAnimatedValue)((Object)this.getOrientAngle())).addAnimation(sVGAnimationElementImpl);
            ((SVGAnimatedValue)((Object)this.getOrientType())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("viewBox")) {
            ((SVGAnimatedValue)((Object)this.getViewBox())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("preserveAspectRatio")) {
            ((SVGAnimatedValue)((Object)this.getPreserveAspectRatio())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("externalResourcesRequired")) {
            ((SVGAnimatedValue)((Object)this.getExternalResourcesRequired())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

