/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import org.csiro.svg.dom.SVGExceptionImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;

public class SVGMatrixImpl
implements SVGMatrix {
    private AffineTransform transform;

    public SVGMatrixImpl() {
        this.transform = new AffineTransform();
    }

    public SVGMatrixImpl(SVGMatrixImpl sVGMatrixImpl) {
        this.transform = new AffineTransform(sVGMatrixImpl.transform);
    }

    public SVGMatrixImpl(float f, float f2, float f3, float f4, float f5, float f6) {
        this.transform = new AffineTransform(f, f2, f3, f4, f5, f6);
    }

    public AffineTransform getAffineTransform() {
        return this.transform;
    }

    public float getA() {
        return (float)this.transform.getScaleX();
    }

    public void setA(float f) throws DOMException {
        float f2 = this.getB();
        float f3 = this.getC();
        float f4 = this.getD();
        float f5 = this.getE();
        float f6 = this.getF();
        this.transform = new AffineTransform(f, f2, f3, f4, f5, f6);
    }

    public float getB() {
        return (float)this.transform.getShearY();
    }

    public void setB(float f) throws DOMException {
        float f2 = this.getA();
        float f3 = this.getC();
        float f4 = this.getD();
        float f5 = this.getE();
        float f6 = this.getF();
        this.transform = new AffineTransform(f2, f, f3, f4, f5, f6);
    }

    public float getC() {
        return (float)this.transform.getShearX();
    }

    public void setC(float f) throws DOMException {
        float f2 = this.getA();
        float f3 = this.getB();
        float f4 = this.getD();
        float f5 = this.getE();
        float f6 = this.getF();
        this.transform = new AffineTransform(f2, f3, f, f4, f5, f6);
    }

    public float getD() {
        return (float)this.transform.getScaleY();
    }

    public void setD(float f) throws DOMException {
        float f2 = this.getA();
        float f3 = this.getB();
        float f4 = this.getC();
        float f5 = this.getE();
        float f6 = this.getF();
        this.transform = new AffineTransform(f2, f3, f4, f, f5, f6);
    }

    public float getE() {
        return (float)this.transform.getTranslateX();
    }

    public void setE(float f) throws DOMException {
        float f2 = this.getA();
        float f3 = this.getB();
        float f4 = this.getC();
        float f5 = this.getD();
        float f6 = this.getF();
        this.transform = new AffineTransform(f2, f3, f4, f5, f, f6);
    }

    public float getF() {
        return (float)this.transform.getTranslateY();
    }

    public void setF(float f) throws DOMException {
        float f2 = this.getA();
        float f3 = this.getB();
        float f4 = this.getC();
        float f5 = this.getD();
        float f6 = this.getE();
        this.transform = new AffineTransform(f2, f3, f4, f5, f6, f);
    }

    public SVGMatrix multiply(SVGMatrix sVGMatrix) {
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl(this);
        sVGMatrixImpl.transform.concatenate(((SVGMatrixImpl)sVGMatrix).transform);
        return sVGMatrixImpl;
    }

    public SVGMatrix inverse() throws SVGException {
        AffineTransform affineTransform;
        try {
            affineTransform = this.transform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new SVGExceptionImpl(2, "Matrix is not invertable");
        }
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl();
        sVGMatrixImpl.transform = new AffineTransform(affineTransform);
        return sVGMatrixImpl;
    }

    public SVGMatrix translate(float f, float f2) {
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl(this);
        sVGMatrixImpl.transform.translate(f, f2);
        return sVGMatrixImpl;
    }

    public SVGMatrix scale(float f) {
        return this.scaleNonUniform(f, f);
    }

    public SVGMatrix scaleNonUniform(float f, float f2) {
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl(this);
        sVGMatrixImpl.transform.scale(f, f2);
        return sVGMatrixImpl;
    }

    public SVGMatrix rotate(float f) {
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl(this);
        sVGMatrixImpl.transform.rotate(Math.toRadians(f));
        return sVGMatrixImpl;
    }

    public SVGMatrix rotateFromVector(float f, float f2) throws SVGException {
        if (f == 0.0f || f2 == 0.0f) {
            throw new SVGExceptionImpl(1, "SVGMatrixImpl.rotateFromVector: parameter values must not be 0");
        }
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl(this);
        double d = Math.atan(f2 / f);
        sVGMatrixImpl.transform.rotate(d);
        return sVGMatrixImpl;
    }

    public SVGMatrix flipX() {
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl(this);
        sVGMatrixImpl.transform.concatenate(new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        return sVGMatrixImpl;
    }

    public SVGMatrix flipY() {
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl(this);
        sVGMatrixImpl.transform.concatenate(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f));
        return sVGMatrixImpl;
    }

    public SVGMatrix skewX(float f) {
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl(this);
        sVGMatrixImpl.transform.concatenate(new AffineTransform(1.0, 0.0, Math.tan(Math.toRadians(f)), 1.0, 0.0, 0.0));
        return sVGMatrixImpl;
    }

    public SVGMatrix skewY(float f) {
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl(this);
        sVGMatrixImpl.transform.concatenate(new AffineTransform(1.0, Math.tan(Math.toRadians(f)), 0.0, 1.0, 0.0, 0.0));
        return sVGMatrixImpl;
    }
}

