/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.csiro.svg.dom.BasicShape;
import org.csiro.svg.dom.Drawable;
import org.csiro.svg.dom.SVGAnimatedNumberImpl;
import org.csiro.svg.dom.SVGClipPathElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGGraphic;
import org.csiro.svg.dom.SVGMarkerElementImpl;
import org.csiro.svg.dom.SVGMatrixImpl;
import org.csiro.svg.dom.SVGPathSegArcAbsImpl;
import org.csiro.svg.dom.SVGPathSegArcRelImpl;
import org.csiro.svg.dom.SVGPathSegClosePathImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoCubicAbsImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoCubicRelImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoCubicSmoothAbsImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoCubicSmoothRelImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoQuadraticAbsImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoQuadraticRelImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoQuadraticSmoothAbsImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoQuadraticSmoothRelImpl;
import org.csiro.svg.dom.SVGPathSegImpl;
import org.csiro.svg.dom.SVGPathSegLinetoAbsImpl;
import org.csiro.svg.dom.SVGPathSegLinetoHorizontalAbsImpl;
import org.csiro.svg.dom.SVGPathSegLinetoHorizontalRelImpl;
import org.csiro.svg.dom.SVGPathSegLinetoRelImpl;
import org.csiro.svg.dom.SVGPathSegLinetoVerticalAbsImpl;
import org.csiro.svg.dom.SVGPathSegLinetoVerticalRelImpl;
import org.csiro.svg.dom.SVGPathSegListImpl;
import org.csiro.svg.dom.SVGPathSegMovetoAbsImpl;
import org.csiro.svg.dom.SVGPathSegMovetoRelImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGPointListImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGTexturePaint;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedNumber;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegArcRel;
import org.w3c.dom.svg.SVGPathSegClosePath;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothRel;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalRel;
import org.w3c.dom.svg.SVGPathSegLinetoRel;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalRel;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;
import org.w3c.dom.svg.SVGRect;

public class SVGPathElementImpl
extends SVGGraphic
implements SVGPathElement,
Drawable,
BasicShape {
    protected SVGPathSegListImpl pathSegList;
    protected SVGPathSegListImpl animPathSegList;
    protected SVGAnimatedNumber pathLength;
    protected boolean animated;
    float[] segLength = null;
    SVGPoint[] lastControlPoint = null;
    SVGPoint[] startPoint = null;
    boolean visible = true;
    boolean display = true;
    float opacity = 1.0f;
    Shape clipShape = null;
    SVGPointList points = null;
    GeneralPath path = null;
    BasicStroke stroke = null;
    Paint fillPaint = null;
    Paint linePaint = null;
    AffineTransform thisTransform = null;
    SVGMarkerElementImpl startMarker = null;
    SVGMarkerElementImpl midMarker = null;
    SVGMarkerElementImpl endMarker = null;

    public SVGPathElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "path");
    }

    public SVGPathElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "path");
    }

    public SVGElementImpl cloneElement() {
        return new SVGPathElementImpl(this.getOwnerDoc(), this);
    }

    public SVGPathSegList getPathSegList() {
        return this.pathSegList;
    }

    public SVGPathSegList getNormalizedPathSegList() {
        return this.pathSegList;
    }

    public SVGPathSegList getAnimatedPathSegList() {
        return this.animPathSegList;
    }

    public SVGPathSegList getAnimatedNormalizedPathSegList() {
        return this.animPathSegList;
    }

    public SVGAnimatedNumber getPathLength() {
        if (this.pathLength == null) {
            this.pathLength = new SVGAnimatedNumberImpl(0.0f, this);
        }
        return this.pathLength;
    }

    public float getTotalLength() {
        int n = this.animPathSegList.getNumberOfItems();
        float f = 0.0f;
        this.CalculatePathLengths();
        int n2 = 0;
        while (n2 < n) {
            f += this.segLength[n2];
            ++n2;
        }
        return f;
    }

    public SVGPoint getPointAtLength(float f) {
        int n = this.animPathSegList.getNumberOfItems();
        int n2 = 0;
        int n3 = 0;
        this.CalculatePathLengths();
        float f2 = 0.0f;
        int n4 = 0;
        while (n4 < n) {
            if (Math.abs(f2 += this.segLength[n4]) < Math.abs(f)) {
                n2 = n4++;
                continue;
            }
            n3 = n4;
            break;
        }
        SVGPathSeg sVGPathSeg = this.animPathSegList.getItem(n3);
        float f3 = f - (f2 - this.segLength[n3]);
        SVGPoint sVGPoint = n3 > 0 ? ((SVGPathSegImpl)sVGPathSeg).getPointAtLength(f3, this.startPoint[n3], this.lastControlPoint[n3 - 1]) : ((SVGPathSegImpl)sVGPathSeg).getPointAtLength(f3, this.startPoint[n3], null);
        return sVGPoint;
    }

    public int getPathSegAtLength(float f) {
        int n = 0;
        int n2 = 0;
        int n3 = this.animPathSegList.getNumberOfItems();
        float f2 = 0.0f;
        this.CalculatePathLengths();
        int n4 = 0;
        while (n4 < n3) {
            if ((f2 += this.segLength[n4]) < f) {
                n = n4++;
                continue;
            }
            n2 = n4;
            break;
        }
        return n2;
    }

    private void CalculatePathLengths() {
        this.segLength = new float[this.animPathSegList.getNumberOfItems()];
        this.lastControlPoint = new SVGPoint[this.animPathSegList.getNumberOfItems()];
        this.startPoint = new SVGPoint[this.animPathSegList.getNumberOfItems()];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n = this.animPathSegList.getNumberOfItems();
        boolean bl = true;
        SVGPointImpl sVGPointImpl = null;
        int n2 = 0;
        while (n2 < n) {
            float f4;
            SVGPathSeg sVGPathSeg = this.animPathSegList.getItem(n2);
            if (bl) {
                while (!sVGPathSeg.getPathSegTypeAsLetter().equalsIgnoreCase("m") && n2 < n) {
                    System.out.println("Warning: Path (or subpath) data should always begin with a moveTo  command, ignoring \"" + sVGPathSeg.getPathSegTypeAsLetter() + "\" command");
                    sVGPathSeg = this.animPathSegList.getItem(++n2);
                }
                if (sVGPathSeg.getPathSegTypeAsLetter().equalsIgnoreCase("m")) {
                    if (sVGPathSeg.getPathSegType() == 3) {
                        float f5 = ((SVGPathSegMovetoRel)sVGPathSeg).getX();
                        f4 = ((SVGPathSegMovetoRel)sVGPathSeg).getY();
                        sVGPointImpl = new SVGPointImpl(f5 + f, f4 + f2);
                        f += f5;
                        f2 += f4;
                        this.segLength[n2] = 0.0f;
                    } else if (sVGPathSeg.getPathSegType() == 2) {
                        float f6 = ((SVGPathSegMovetoAbs)sVGPathSeg).getX();
                        f4 = ((SVGPathSegMovetoAbs)sVGPathSeg).getY();
                        sVGPointImpl = new SVGPointImpl(f6, f4);
                        f = f6;
                        f2 = f4;
                        this.segLength[n2] = 0.0f;
                    }
                    bl = false;
                }
            } else {
                switch (sVGPathSeg.getPathSegType()) {
                    case 1: {
                        this.lastControlPoint[n2] = null;
                        bl = true;
                        if (sVGPointImpl == null) break;
                        SVGPointImpl sVGPointImpl2 = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegClosePathImpl)sVGPathSeg).getTotalLength(sVGPointImpl, sVGPointImpl2);
                        this.lastControlPoint[n2 - 1] = sVGPointImpl;
                        this.startPoint[n2] = sVGPointImpl2;
                        sVGPointImpl = null;
                        break;
                    }
                    case 2: {
                        float f7 = ((SVGPathSegMovetoAbs)sVGPathSeg).getX();
                        f4 = ((SVGPathSegMovetoAbs)sVGPathSeg).getY();
                        f = f7;
                        f2 = f4;
                        this.lastControlPoint[n2] = null;
                        this.segLength[n2] = 0.0f;
                        break;
                    }
                    case 3: {
                        float f8 = ((SVGPathSegMovetoRel)sVGPathSeg).getX();
                        f4 = ((SVGPathSegMovetoRel)sVGPathSeg).getY();
                        f += f8;
                        f2 += f4;
                        this.lastControlPoint[n2] = null;
                        this.segLength[n2] = 0.0f;
                        break;
                    }
                    case 4: {
                        float f9 = ((SVGPathSegLinetoAbs)sVGPathSeg).getX();
                        f4 = ((SVGPathSegLinetoAbs)sVGPathSeg).getY();
                        this.lastControlPoint[n2] = null;
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegLinetoAbsImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2]);
                        f = f9;
                        f2 = f4;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 5: {
                        float f10 = ((SVGPathSegLinetoRel)sVGPathSeg).getX();
                        f4 = ((SVGPathSegLinetoRel)sVGPathSeg).getY();
                        this.lastControlPoint[n2] = null;
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegLinetoRelImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2]);
                        f += f10;
                        f2 += f4;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 12: {
                        float f11 = ((SVGPathSegLinetoHorizontalAbs)sVGPathSeg).getX();
                        this.lastControlPoint[n2] = null;
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegLinetoHorizontalAbsImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2]);
                        f3 += this.segLength[n2];
                        f = f11;
                        break;
                    }
                    case 13: {
                        float f12 = ((SVGPathSegLinetoHorizontalRel)sVGPathSeg).getX();
                        this.lastControlPoint[n2] = null;
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegLinetoHorizontalRelImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2]);
                        f += f12;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 14: {
                        float f13 = ((SVGPathSegLinetoVerticalAbs)sVGPathSeg).getY();
                        this.lastControlPoint[n2] = null;
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegLinetoVerticalAbsImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2]);
                        f2 = f13;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 15: {
                        float f14 = ((SVGPathSegLinetoVerticalRel)sVGPathSeg).getY();
                        this.lastControlPoint[n2] = null;
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegLinetoVerticalRelImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2]);
                        f2 += f14;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 6: {
                        float f15 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX();
                        f4 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY();
                        float f16 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX2();
                        float f17 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY2();
                        this.lastControlPoint[n2] = new SVGPointImpl(f16, f17);
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegCurvetoCubicAbsImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2]);
                        f = f15;
                        f2 = f4;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 7: {
                        float f18 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX();
                        f4 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY();
                        float f16 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX2();
                        float f17 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY2();
                        this.lastControlPoint[n2] = new SVGPointImpl(f + f16, f2 + f17);
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegCurvetoCubicRelImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2 - 1]);
                        f += f18;
                        f2 += f4;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 16: {
                        float f19 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getX();
                        f4 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getY();
                        float f16 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getX2();
                        float f17 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getY2();
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegCurvetoCubicSmoothAbsImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2 - 1]);
                        this.lastControlPoint[n2] = new SVGPointImpl(f16, f17);
                        f = f19;
                        f2 = f4;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 17: {
                        float f20 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getX();
                        f4 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getY();
                        float f16 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getX2();
                        float f17 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getY2();
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegCurvetoCubicSmoothRelImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2 - 1]);
                        this.lastControlPoint[n2] = new SVGPointImpl(f16 + f, f17 + f2);
                        f += f20;
                        f2 += f4;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 8: {
                        float f21 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getX();
                        f4 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getY();
                        float f16 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getX1();
                        float f17 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getY1();
                        this.lastControlPoint[n2] = new SVGPointImpl(f16, f17);
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegCurvetoQuadraticAbsImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2]);
                        f = f21;
                        f2 = f4;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 9: {
                        float f22 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getX();
                        f4 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getY();
                        float f16 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getX1();
                        float f17 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getY1();
                        this.lastControlPoint[n2] = new SVGPointImpl(f + f16, f2 + f17);
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegCurvetoQuadraticRelImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2]);
                        f += f22;
                        f2 += f4;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 18: {
                        float f23 = ((SVGPathSegCurvetoQuadraticSmoothAbs)sVGPathSeg).getX();
                        f4 = ((SVGPathSegCurvetoQuadraticSmoothAbs)sVGPathSeg).getY();
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegCurvetoQuadraticSmoothAbsImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2 - 1]);
                        SVGPointImpl sVGPointImpl3 = this.lastControlPoint[n2 - 1] == null ? new SVGPointImpl(f, f2) : new SVGPointImpl(this.lastControlPoint[n2 - 1].getX(), this.lastControlPoint[n2 - 1].getY());
                        this.lastControlPoint[n2] = new SVGPointImpl(2.0f * f - sVGPointImpl3.getX(), 2.0f * f2 - sVGPointImpl3.getY());
                        f = f23;
                        f2 = f4;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 19: {
                        float f24 = ((SVGPathSegCurvetoQuadraticSmoothRel)sVGPathSeg).getX();
                        f4 = ((SVGPathSegCurvetoQuadraticSmoothRel)sVGPathSeg).getY();
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegCurvetoQuadraticSmoothRelImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2 - 1]);
                        SVGPointImpl sVGPointImpl3 = this.lastControlPoint[n2 - 1] == null ? new SVGPointImpl(f, f2) : new SVGPointImpl(this.lastControlPoint[n2 - 1].getX(), this.lastControlPoint[n2 - 1].getY());
                        this.lastControlPoint[n2] = new SVGPointImpl(2.0f * f - sVGPointImpl3.getX(), 2.0f * f2 - sVGPointImpl3.getY());
                        f += f24;
                        f2 += f4;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 10: {
                        float f25 = f;
                        f4 = f2;
                        float f16 = ((SVGPathSegArcAbs)sVGPathSeg).getX();
                        float f17 = ((SVGPathSegArcAbs)sVGPathSeg).getY();
                        this.lastControlPoint[n2] = null;
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegArcAbsImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2]);
                        f = f16;
                        f2 = f17;
                        f3 += this.segLength[n2];
                        break;
                    }
                    case 11: {
                        float f26 = f;
                        f4 = f2;
                        float f16 = ((SVGPathSegArcRel)sVGPathSeg).getX();
                        float f17 = ((SVGPathSegArcRel)sVGPathSeg).getY();
                        this.lastControlPoint[n2] = null;
                        this.startPoint[n2] = new SVGPointImpl(f, f2);
                        this.segLength[n2] = ((SVGPathSegArcRelImpl)sVGPathSeg).getTotalLength(this.startPoint[n2], this.lastControlPoint[n2]);
                        f += f16;
                        f2 += f17;
                        f3 += this.segLength[n2];
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    public SVGPathSegClosePath createSVGPathSegClosePath() {
        return new SVGPathSegClosePathImpl();
    }

    public SVGPathSegMovetoAbs createSVGPathSegMovetoAbs(float f, float f2) {
        return new SVGPathSegMovetoAbsImpl(f, f2);
    }

    public SVGPathSegMovetoRel createSVGPathSegMovetoRel(float f, float f2) {
        return new SVGPathSegMovetoRelImpl(f, f2);
    }

    public SVGPathSegLinetoAbs createSVGPathSegLinetoAbs(float f, float f2) {
        return new SVGPathSegLinetoAbsImpl(f, f2);
    }

    public SVGPathSegLinetoRel createSVGPathSegLinetoRel(float f, float f2) {
        return new SVGPathSegLinetoRelImpl(f, f2);
    }

    public SVGPathSegCurvetoCubicAbs createSVGPathSegCurvetoCubicAbs(float f, float f2, float f3, float f4, float f5, float f6) {
        return new SVGPathSegCurvetoCubicAbsImpl(f, f2, f3, f4, f5, f6);
    }

    public SVGPathSegCurvetoCubicRel createSVGPathSegCurvetoCubicRel(float f, float f2, float f3, float f4, float f5, float f6) {
        return new SVGPathSegCurvetoCubicRelImpl(f, f2, f3, f4, f5, f6);
    }

    public SVGPathSegCurvetoQuadraticAbs createSVGPathSegCurvetoQuadraticAbs(float f, float f2, float f3, float f4) {
        return new SVGPathSegCurvetoQuadraticAbsImpl(f, f2, f3, f4);
    }

    public SVGPathSegCurvetoQuadraticRel createSVGPathSegCurvetoQuadraticRel(float f, float f2, float f3, float f4) {
        return new SVGPathSegCurvetoQuadraticRelImpl(f, f2, f3, f4);
    }

    public SVGPathSegArcAbs createSVGPathSegArcAbs(float f, float f2, float f3, float f4, float f5, boolean bl, boolean bl2) {
        return new SVGPathSegArcAbsImpl(f, f2, f3, f4, f5, bl, bl2);
    }

    public SVGPathSegArcRel createSVGPathSegArcRel(float f, float f2, float f3, float f4, float f5, boolean bl, boolean bl2) {
        return new SVGPathSegArcRelImpl(f, f2, f3, f4, f5, bl, bl2);
    }

    public SVGPathSegLinetoHorizontalAbs createSVGPathSegLinetoHorizontalAbs(float f) {
        return new SVGPathSegLinetoHorizontalAbsImpl(f);
    }

    public SVGPathSegLinetoHorizontalRel createSVGPathSegLinetoHorizontalRel(float f) {
        return new SVGPathSegLinetoHorizontalRelImpl(f);
    }

    public SVGPathSegLinetoVerticalAbs createSVGPathSegLinetoVerticalAbs(float f) {
        return new SVGPathSegLinetoVerticalAbsImpl(f);
    }

    public SVGPathSegLinetoVerticalRel createSVGPathSegLinetoVerticalRel(float f) {
        return new SVGPathSegLinetoVerticalRelImpl(f);
    }

    public SVGPathSegCurvetoCubicSmoothAbs createSVGPathSegCurvetoCubicSmoothAbs(float f, float f2, float f3, float f4) {
        return new SVGPathSegCurvetoCubicSmoothAbsImpl(f, f2, f3, f4);
    }

    public SVGPathSegCurvetoCubicSmoothRel createSVGPathSegCurvetoCubicSmoothRel(float f, float f2, float f3, float f4) {
        return new SVGPathSegCurvetoCubicSmoothRelImpl(f, f2, f3, f4);
    }

    public SVGPathSegCurvetoQuadraticSmoothAbs createSVGPathSegCurvetoQuadraticSmoothAbs(float f, float f2) {
        return new SVGPathSegCurvetoQuadraticSmoothAbsImpl(f, f2);
    }

    public SVGPathSegCurvetoQuadraticSmoothRel createSVGPathSegCurvetoQuadraticSmoothRel(float f, float f2) {
        return new SVGPathSegCurvetoQuadraticSmoothRelImpl(f, f2);
    }

    private void constructPathSegList(String string) {
        this.pathSegList = new SVGPathSegListImpl();
        String string2 = "MmLlCcZzSsHhVvQqTtAa";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            while (string2.indexOf(string3) == -1 && stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (string2.indexOf(string3) == -1) continue;
            if (string3.equals("Z") || string3.equals("z")) {
                this.addCommand(string3, null, string);
                continue;
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string4 = stringTokenizer.nextToken();
            this.addCommand(string3, string4, string);
        }
        this.animated = false;
        this.animPathSegList = this.animated ? new SVGPathSegListImpl(this.pathSegList) : this.pathSegList;
    }

    private void addCommand(String string, String string2, String string3) {
        if (string.equals("Z") || string.equals("z")) {
            SVGPathSegClosePathImpl sVGPathSegClosePathImpl = new SVGPathSegClosePathImpl();
            this.pathSegList.appendItem(sVGPathSegClosePathImpl);
        } else if (string.equals("M") || string.equals("m")) {
            this.addMoveTo(string, string2);
        } else if (string.equals("L") || string.equals("l")) {
            this.addLineTo(string, string2);
        } else if (string.equals("C") || string.equals("c")) {
            this.addCurveTo(string, string2);
        } else if (string.equals("S") || string.equals("s")) {
            this.addSmoothCurveTo(string, string2);
        } else if (string.equals("H") || string.equals("h")) {
            this.addHorizontalLineTo(string, string2);
        } else if (string.equals("V") || string.equals("v")) {
            this.addVerticalLineTo(string, string2);
        } else if (string.equals("Q") || string.equals("q")) {
            this.addQuadraticBezierCurveTo(string, string2);
        } else if (string.equals("T") || string.equals("t")) {
            this.addTruetypeQuadraticBezierCurveTo(string, string2);
        } else if (string.equals("A") || string.equals("a")) {
            this.addEllipticArc(string, string2);
        } else {
            System.out.println("Unrecognised path command: '" + string + "' in path: " + string3);
        }
    }

    private String getNextToken(StringTokenizer stringTokenizer, String string, String string2) {
        String string3;
        boolean bl = false;
        try {
            string3 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens() && string.indexOf(string3) != -1) {
                bl = string3.equals("-");
                string3 = stringTokenizer.nextToken();
            }
            if (string.indexOf(string3) != -1) {
                string3 = string2;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            string3 = string2;
        }
        if (bl) {
            string3 = "-" + string3;
        }
        if (string3.endsWith("e") || string3.endsWith("E")) {
            try {
                String string4 = stringTokenizer.nextToken();
                string4 = string4 + stringTokenizer.nextToken();
                string3 = string3 + string4;
            }
            catch (NoSuchElementException noSuchElementException) {
                string3 = string3 + '0';
            }
        }
        return string3;
    }

    private String trimCommas(String string) {
        String string2 = string;
        while (string2.startsWith(",")) {
            string2 = string2.substring(1);
        }
        while (string2.endsWith(",")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private void addMoveTo(String string, String string2) {
        boolean bl = true;
        boolean bl2 = true;
        if (string.equals("m")) {
            bl = false;
        }
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        String string3 = " ,-\n\t\r";
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            if (bl2) {
                if (bl) {
                    this.pathSegList.appendItem(new SVGPathSegMovetoAbsImpl(f, f2));
                } else {
                    this.pathSegList.appendItem(new SVGPathSegMovetoRelImpl(f, f2));
                }
                bl2 = false;
                continue;
            }
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegLinetoAbsImpl(f, f2));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegLinetoRelImpl(f, f2));
        }
    }

    private void addLineTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("l")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegLinetoAbsImpl(f, f2));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegLinetoRelImpl(f, f2));
        }
    }

    private void addCurveTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("c")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f3 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f4 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f5 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f6 = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegCurvetoCubicAbsImpl(f5, f6, f, f2, f3, f4));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegCurvetoCubicRelImpl(f5, f6, f, f2, f3, f4));
        }
    }

    private void addSmoothCurveTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("s")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f3 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f4 = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegCurvetoCubicSmoothAbsImpl(f3, f4, f, f2));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegCurvetoCubicSmoothRelImpl(f3, f4, f, f2));
        }
    }

    private void addHorizontalLineTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("h")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegLinetoHorizontalAbsImpl(f));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegLinetoHorizontalRelImpl(f));
        }
    }

    private void addVerticalLineTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("v")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegLinetoVerticalAbsImpl(f));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegLinetoVerticalRelImpl(f));
        }
    }

    private void addEllipticArc(String string, String string2) {
        boolean bl = true;
        if (string.equals("a")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f3 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            int n = Integer.parseInt(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            int n2 = Integer.parseInt(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f4 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f5 = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegArcAbsImpl(f4, f5, f, f2, f3, n == 1, n2 == 1));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegArcRelImpl(f4, f5, f, f2, f3, n == 1, n2 == 1));
        }
    }

    private void addQuadraticBezierCurveTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("q")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f3 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f4 = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegCurvetoQuadraticAbsImpl(f3, f4, f, f2));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegCurvetoQuadraticRelImpl(f3, f4, f, f2));
        }
    }

    private void addTruetypeQuadraticBezierCurveTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("t")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegCurvetoQuadraticSmoothAbsImpl(f, f2));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegCurvetoQuadraticSmoothRelImpl(f, f2));
        }
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("d")) {
            return this.pathSegList.toString();
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("d")) {
            attr.setValue(this.pathSegList.toString());
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        if (string.equalsIgnoreCase("d")) {
            this.constructPathSegList(string2);
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        String string = attr.getName();
        if (string.equalsIgnoreCase("d")) {
            this.constructPathSegList(attr.getValue());
        }
        return super.setAttributeNode(attr);
    }

    GeneralPath createShape(SVGPointList sVGPointList) {
        GeneralPath generalPath = new GeneralPath();
        float f = 0.0f;
        float f2 = 0.0f;
        Point2D.Float float_ = null;
        int n = this.animPathSegList.getNumberOfItems();
        boolean bl = true;
        SVGPoint sVGPoint = null;
        int n2 = 0;
        while (n2 < n) {
            float f3;
            float f4;
            SVGPathSeg sVGPathSeg = this.animPathSegList.getItem(n2);
            if (bl) {
                while (!sVGPathSeg.getPathSegTypeAsLetter().equalsIgnoreCase("m") && n2 < n) {
                    System.out.println("Warning: Path (or subpath) data should always begin with a moveTo  command, ignoring \"" + sVGPathSeg.getPathSegTypeAsLetter() + "\" command");
                    sVGPathSeg = this.animPathSegList.getItem(++n2);
                }
                if (sVGPathSeg.getPathSegTypeAsLetter().equalsIgnoreCase("m")) {
                    if (sVGPathSeg.getPathSegType() == 3) {
                        f4 = ((SVGPathSegMovetoRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegMovetoRel)sVGPathSeg).getY();
                        generalPath.moveTo(f4 + f, f3 + f2);
                        sVGPoint = new SVGPointImpl(f4 + f, f3 + f2);
                        sVGPointList.appendItem(sVGPoint);
                        f += f4;
                        f2 += f3;
                    } else if (sVGPathSeg.getPathSegType() == 2) {
                        f4 = ((SVGPathSegMovetoAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegMovetoAbs)sVGPathSeg).getY();
                        generalPath.moveTo(f4, f3);
                        sVGPoint = new SVGPointImpl(f4, f3);
                        sVGPointList.appendItem(sVGPoint);
                        f = f4;
                        f2 = f3;
                    }
                    bl = false;
                }
            } else {
                switch (sVGPathSeg.getPathSegType()) {
                    case 1: {
                        generalPath.closePath();
                        float_ = null;
                        bl = true;
                        if (sVGPoint == null) break;
                        sVGPointList.appendItem(sVGPoint);
                        f = sVGPoint.getX();
                        f2 = sVGPoint.getY();
                        sVGPoint = null;
                        break;
                    }
                    case 2: {
                        f4 = ((SVGPathSegMovetoAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegMovetoAbs)sVGPathSeg).getY();
                        generalPath.moveTo(f4, f3);
                        f = f4;
                        f2 = f3;
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 3: {
                        f4 = ((SVGPathSegMovetoRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegMovetoRel)sVGPathSeg).getY();
                        generalPath.moveTo(f4 + f, f3 + f2);
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2 += f3));
                        break;
                    }
                    case 4: {
                        f4 = ((SVGPathSegLinetoAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegLinetoAbs)sVGPathSeg).getY();
                        generalPath.lineTo(f4, f3);
                        f = f4;
                        f2 = f3;
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 5: {
                        f4 = ((SVGPathSegLinetoRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegLinetoRel)sVGPathSeg).getY();
                        generalPath.lineTo(f4 + f, f3 + f2);
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2 += f3));
                        break;
                    }
                    case 12: {
                        f4 = ((SVGPathSegLinetoHorizontalAbs)sVGPathSeg).getX();
                        generalPath.lineTo(f4, f2);
                        f = f4;
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 13: {
                        f4 = ((SVGPathSegLinetoHorizontalRel)sVGPathSeg).getX();
                        generalPath.lineTo(f4 + f, f2);
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2));
                        break;
                    }
                    case 14: {
                        f4 = ((SVGPathSegLinetoVerticalAbs)sVGPathSeg).getY();
                        generalPath.lineTo(f, f4);
                        f2 = f4;
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 15: {
                        f4 = ((SVGPathSegLinetoVerticalRel)sVGPathSeg).getY();
                        generalPath.lineTo(f, f4 + f2);
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2 += f4));
                        break;
                    }
                    case 6: {
                        f4 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY();
                        float f5 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX1();
                        float f6 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY1();
                        float f7 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX2();
                        float f8 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY2();
                        generalPath.curveTo(f5, f6, f7, f8, f4, f3);
                        float_ = new Point2D.Float(f7, f8);
                        f = f4;
                        f2 = f3;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 7: {
                        f4 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY();
                        float f9 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX1();
                        float f6 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY1();
                        float f7 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX2();
                        float f8 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY2();
                        generalPath.curveTo(f + f9, f2 + f6, f + f7, f2 + f8, f + f4, f2 + f3);
                        float_ = new Point2D.Float(f + f7, f2 + f8);
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2 += f3));
                        break;
                    }
                    case 16: {
                        f4 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getY();
                        float f10 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getX2();
                        float f6 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getY2();
                        if (float_ == null) {
                            float_ = new Point2D.Float(f, f2);
                        }
                        generalPath.curveTo(2.0f * f - (float)((Point2D)float_).getX(), 2.0f * f2 - (float)((Point2D)float_).getY(), f10, f6, f4, f3);
                        float_ = new Point2D.Float(f10, f6);
                        f = f4;
                        f2 = f3;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 17: {
                        f4 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getY();
                        float f11 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getX2();
                        float f6 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getY2();
                        if (float_ == null) {
                            float_ = new Point2D.Float(f, f2);
                        }
                        generalPath.curveTo(2.0f * f - (float)((Point2D)float_).getX(), 2.0f * f2 - (float)((Point2D)float_).getY(), f + f11, f2 + f6, f + f4, f2 + f3);
                        float_ = new Point2D.Float(f + f11, f2 + f6);
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2 += f3));
                        break;
                    }
                    case 8: {
                        f4 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getY();
                        float f12 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getX1();
                        float f6 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getY1();
                        generalPath.quadTo(f12, f6, f4, f3);
                        float_ = new Point2D.Float(f12, f6);
                        f = f4;
                        f2 = f3;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 9: {
                        f4 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getY();
                        float f13 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getX1();
                        float f6 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getY1();
                        generalPath.quadTo(f + f13, f2 + f6, f + f4, f2 + f3);
                        float_ = new Point2D.Float(f + f13, f2 + f6);
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2 += f3));
                        break;
                    }
                    case 18: {
                        f4 = ((SVGPathSegCurvetoQuadraticSmoothAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoQuadraticSmoothAbs)sVGPathSeg).getY();
                        if (float_ == null) {
                            float_ = new Point2D.Float(f, f2);
                        }
                        Point2D.Float float_2 = new Point2D.Float(2.0f * f - (float)((Point2D)float_).getX(), 2.0f * f2 - (float)((Point2D)float_).getY());
                        generalPath.quadTo((float)((Point2D)float_2).getX(), (float)((Point2D)float_2).getY(), f4, f3);
                        float_ = float_2;
                        f = f4;
                        f2 = f3;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 19: {
                        f4 = ((SVGPathSegCurvetoQuadraticSmoothRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoQuadraticSmoothRel)sVGPathSeg).getY();
                        if (float_ == null) {
                            float_ = new Point2D.Float(f, f2);
                        }
                        Point2D.Float float_3 = new Point2D.Float(2.0f * f - (float)((Point2D)float_).getX(), 2.0f * f2 - (float)((Point2D)float_).getY());
                        generalPath.quadTo((float)((Point2D)float_3).getX(), (float)((Point2D)float_3).getY(), f + f4, f2 + f3);
                        float_ = float_3;
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2 += f3));
                        break;
                    }
                    case 10: {
                        Shape shape;
                        f4 = f;
                        f3 = f2;
                        float f14 = ((SVGPathSegArcAbs)sVGPathSeg).getX();
                        float f6 = ((SVGPathSegArcAbs)sVGPathSeg).getY();
                        float f7 = Math.abs(((SVGPathSegArcAbs)sVGPathSeg).getR1());
                        float f8 = Math.abs(((SVGPathSegArcAbs)sVGPathSeg).getR2());
                        float f15 = (float)Math.toRadians(((SVGPathSegArcAbs)sVGPathSeg).getAngle());
                        boolean bl2 = ((SVGPathSegArcAbs)sVGPathSeg).getLargeArcFlag();
                        boolean bl3 = ((SVGPathSegArcAbs)sVGPathSeg).getSweepFlag();
                        if (f7 == 0.0f || f8 == 0.0f) {
                            generalPath.lineTo(f14, f6);
                            f = f14;
                            f2 = f6;
                            float_ = null;
                        } else {
                            shape = this.createArc(f4, f3, f14, f6, f7, f8, f15, bl2, bl3);
                            generalPath.append(shape, true);
                            f = f14;
                            f2 = f6;
                            float_ = null;
                        }
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 11: {
                        Shape shape;
                        f4 = f;
                        f3 = f2;
                        float f16 = f + ((SVGPathSegArcRel)sVGPathSeg).getX();
                        float f6 = f2 + ((SVGPathSegArcRel)sVGPathSeg).getY();
                        float f7 = Math.abs(((SVGPathSegArcRel)sVGPathSeg).getR1());
                        float f8 = Math.abs(((SVGPathSegArcRel)sVGPathSeg).getR2());
                        float f15 = (float)Math.toRadians(((SVGPathSegArcRel)sVGPathSeg).getAngle());
                        boolean bl2 = ((SVGPathSegArcRel)sVGPathSeg).getLargeArcFlag();
                        boolean bl3 = ((SVGPathSegArcRel)sVGPathSeg).getSweepFlag();
                        if (f7 == 0.0f || f8 == 0.0f) {
                            generalPath.lineTo(f16, f6);
                            f = f16;
                            f2 = f6;
                            float_ = null;
                        } else {
                            shape = this.createArc(f4, f3, f16, f6, f7, f8, f15, bl2, bl3);
                            generalPath.append(shape, true);
                            f = f16;
                            f2 = f6;
                            float_ = null;
                        }
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                }
            }
            ++n2;
        }
        return generalPath;
    }

    private Shape createArc(float f, float f2, float f3, float f4, float f5, float f6, float f7, boolean bl, boolean bl2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9 = Math.cos(f7);
        double d10 = d9 * (double)(f - f3) / 2.0 + (d8 = Math.sin(f7)) * (double)(f2 - f4) / 2.0;
        double d11 = d10 * d10;
        double d12 = d11 / (d7 = (double)(f5 * f5)) + (d6 = (d5 = -d8 * (double)(f - f3) / 2.0 + d9 * (double)(f2 - f4) / 2.0) * d5) / (d4 = (double)(f6 * f6));
        if (d12 > 1.0) {
            f5 = (float)Math.sqrt(d12) * f5;
            f6 = (float)Math.sqrt(d12) * f6;
            System.out.println("radii not large enough, increasing to: " + f5 + "," + f6);
            d7 = f5 * f5;
            d4 = f6 * f6;
        }
        if ((d3 = (d7 * d4 - d7 * d6 - d4 * d11) / (d7 * d6 + d4 * d11)) < 0.0) {
            d3 = 0.0;
        }
        d3 = Math.sqrt(d3);
        if (bl == bl2) {
            d3 = -d3;
        }
        double d13 = d3 * (double)f5 * d5 / (double)f6;
        double d14 = d3 * -((double)f6 * d10 / (double)f5);
        double d15 = d9 * d13 - d8 * d14 + (double)((f + f3) / 2.0f);
        double d16 = d8 * d13 + d9 * d14 + (double)((f2 + f4) / 2.0f);
        double d17 = 1.0;
        double d18 = 0.0;
        double d19 = (d10 - d13) / (double)f5;
        double d20 = (d5 - d14) / (double)f6;
        double d21 = Math.acos((d17 * d19 + d18 * d20) / (Math.sqrt(d17 * d17 + d18 * d18) * Math.sqrt(d19 * d19 + d20 * d20)));
        if (d17 * d20 - d18 * d19 < 0.0) {
            d21 = -d21;
        }
        d17 = (d10 - d13) / (double)f5;
        d18 = (d5 - d14) / (double)f6;
        d19 = (-d10 - d13) / (double)f5;
        d20 = (-d5 - d14) / (double)f6;
        double d22 = Math.acos((d17 * d19 + d18 * d20) / (Math.sqrt(d17 * d17 + d18 * d18) * Math.sqrt(d19 * d19 + d20 * d20)));
        if (d17 * d20 - d18 * d19 < 0.0) {
            d22 = -d22;
        }
        if ((d2 = Math.abs((d = Math.toDegrees(d22)) / 360.0)) > 1.0) {
            d = d > 0.0 ? (d -= 360.0 * Math.floor(d2)) : (d += 360.0 * Math.floor(d2));
            d22 = Math.toRadians(d);
        }
        if (bl2 && d22 < 0.0) {
            d22 += Math.toRadians(360.0);
        } else if (!bl2 && d22 > 0.0) {
            d22 -= Math.toRadians(360.0);
        }
        Shape shape = new Arc2D.Double(d15 - (double)f5, d16 - (double)f6, f5 * 2.0f, f6 * 2.0f, -Math.toDegrees(d21), -Math.toDegrees(d22), 0);
        shape = AffineTransform.getRotateInstance(f7, d15, d16).createTransformedShape(shape);
        return shape;
    }

    public void draw(Graphics2D graphics2D, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        if (bl || this.path == null) {
            this.refreshData();
            this.visible = this.getVisibility();
            this.display = this.getDisplay();
            this.opacity = this.getOpacity();
            object3 = this.getClippingPath();
            this.clipShape = null;
            if (object3 != null) {
                this.clipShape = ((SVGClipPathElementImpl)object3).getClippingShape(this);
            }
            this.thisTransform = new AffineTransform();
            if (this.transform != null) {
                this.thisTransform = ((SVGTransformListImpl)this.transform.getAnimVal()).getAffineTransform();
            }
            this.points = new SVGPointListImpl();
            this.path = this.createShape(this.points);
            object2 = this.getFillRule();
            if (((String)object2).equalsIgnoreCase("nonzero")) {
                this.path.setWindingRule(1);
            } else {
                this.path.setWindingRule(0);
            }
            this.stroke = this.getStroke();
            this.fillPaint = this.getFillPaint();
            this.linePaint = this.getLinePaint();
            this.startMarker = this.getMarker("marker-start");
            this.midMarker = this.getMarker("marker-mid");
            this.endMarker = this.getMarker("marker-end");
            if (this.startMarker == null || this.midMarker == null || this.endMarker == null) {
                object = this.getMarker("marker");
                if (this.startMarker == null) {
                    this.startMarker = object;
                }
                if (this.midMarker == null) {
                    this.midMarker = object;
                }
                if (this.endMarker == null) {
                    this.endMarker = object;
                }
            }
        } else {
            if (this.fillPaint != null && this.fillPaint instanceof SVGTexturePaint && ((SVGTexturePaint)this.fillPaint).getTextureType() == 2) {
                this.fillPaint = this.getFillPaint();
            }
            if (this.linePaint != null && this.linePaint instanceof SVGTexturePaint && ((SVGTexturePaint)this.linePaint).getTextureType() == 2) {
                this.linePaint = this.getLinePaint();
            }
        }
        if (this.visible && this.display && this.opacity > 0.0f) {
            object3 = graphics2D.getTransform();
            object2 = graphics2D.getClip();
            if (this.thisTransform != null) {
                graphics2D.transform(this.thisTransform);
            }
            if (this.clipShape != null) {
                graphics2D.clip(this.clipShape);
            }
            if (this.opacity < 1.0f) {
                object = this.getOwnerDoc().getRootElement();
                float f = object.getCurrentScale();
                SVGPoint sVGPoint = object.getCurrentTranslate();
                if (sVGPoint == null) {
                    sVGPoint = new SVGPointImpl();
                }
                Shape shape = this.getShape();
                AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
                Shape shape2 = affineTransform.createTransformedShape(shape);
                Rectangle2D rectangle2D = shape2.getBounds2D();
                double d = rectangle2D.getWidth() / 5.0;
                double d2 = rectangle2D.getHeight() / 5.0;
                rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d2, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d2);
                int n = (int)(rectangle2D.getWidth() * (double)f);
                int n2 = (int)(rectangle2D.getHeight() * (double)f);
                if (n > 0 && n2 > 0) {
                    Object object4;
                    BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
                    Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D2.setRenderingHints(renderingHints);
                    if (f != 1.0f) {
                        graphics2D2.scale(f, f);
                    }
                    graphics2D2.translate(-rectangle2D.getX(), -rectangle2D.getY());
                    graphics2D2.transform(affineTransform);
                    this.drawShape(graphics2D2, bl);
                    if (this.highlighted) {
                        graphics2D2.setPaint(Color.yellow);
                        object4 = this.getBBox();
                        graphics2D2.draw(new Rectangle2D.Float(object4.getX(), object4.getY(), object4.getWidth(), object4.getHeight()));
                    }
                    object4 = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
                    graphics2D.setComposite(alphaComposite);
                    AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY());
                    affineTransform2.scale(1.0f / f, 1.0f / f);
                    try {
                        affineTransform2.preConcatenate(affineTransform.createInverse());
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    graphics2D.drawImage(bufferedImage, affineTransform2, null);
                    graphics2D.setComposite((Composite)object4);
                    bufferedImage.flush();
                }
            } else {
                this.drawShape(graphics2D, bl);
                if (this.highlighted) {
                    graphics2D.setPaint(Color.yellow);
                    object = this.getBBox();
                    graphics2D.draw(new Rectangle2D.Float(object.getX(), object.getY(), object.getWidth(), object.getHeight()));
                }
            }
            graphics2D.setTransform((AffineTransform)object3);
            graphics2D.setClip((Shape)object2);
        }
    }

    private void drawShape(Graphics2D graphics2D, boolean bl) {
        SVGPoint sVGPoint;
        float f;
        float f2;
        float f3;
        SVGPoint sVGPoint2;
        graphics2D.setStroke(this.stroke);
        if (this.fillPaint != null) {
            graphics2D.setPaint(this.fillPaint);
            graphics2D.fill(this.path);
        }
        if (this.linePaint != null) {
            graphics2D.setPaint(this.linePaint);
            graphics2D.draw(this.path);
        }
        int n = this.points.getNumberOfItems();
        if (this.startMarker != null && n > 0) {
            sVGPoint2 = this.points.getItem(0);
            f3 = sVGPoint2.getX();
            f2 = sVGPoint2.getY();
            f = 0.0f;
            if (n > 1) {
                sVGPoint = this.points.getItem(1);
                f = SVGPointImpl.getAngleBetweenPoints(sVGPoint2, sVGPoint);
            }
            this.startMarker.drawMarker(graphics2D, this, f3, f2, f, this.stroke.getLineWidth(), bl);
        }
        if (this.midMarker != null) {
            int n2 = 1;
            while (n2 < n - 1) {
                SVGPoint sVGPoint3 = this.points.getItem(n2);
                f2 = sVGPoint3.getX();
                f = sVGPoint3.getY();
                sVGPoint = this.points.getItem(n2 - 1);
                SVGPoint sVGPoint4 = this.points.getItem(n2 + 1);
                float f4 = SVGPointImpl.getAngleBetweenPoints(sVGPoint, sVGPoint3);
                float f5 = SVGPointImpl.getAngleBetweenPoints(sVGPoint3, sVGPoint4);
                float f6 = (f4 + f5) / 2.0f;
                this.midMarker.drawMarker(graphics2D, this, f2, f, f6, this.stroke.getLineWidth(), bl);
                ++n2;
            }
        }
        if (this.endMarker != null && n > 0) {
            sVGPoint2 = this.points.getItem(n - 1);
            f3 = sVGPoint2.getX();
            f2 = sVGPoint2.getY();
            f = 0.0f;
            if (n > 1) {
                sVGPoint = this.points.getItem(n - 2);
                f = SVGPointImpl.getAngleBetweenPoints(sVGPoint, sVGPoint2);
            }
            this.endMarker.drawMarker(graphics2D, this, f3, f2, f, this.stroke.getLineWidth(), bl);
        }
    }

    public Shape getShape() {
        if (this.path == null) {
            return this.createShape(new SVGPointListImpl());
        }
        return this.path;
    }

    public SVGRect getBBox() {
        Shape shape = this.getShape();
        Rectangle2D rectangle2D = shape.getBounds2D();
        SVGRectImpl sVGRectImpl = new SVGRectImpl(rectangle2D);
        return sVGRectImpl;
    }

    public boolean contains(double d, double d2) {
        Shape shape = this.getShape();
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2.contains(d, d2);
    }

    public double boundingArea() {
        Shape shape = this.getShape();
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape2 = affineTransform.createTransformedShape(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        return rectangle2D.getWidth() * rectangle2D.getHeight();
    }
}

