/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import org.csiro.svg.dom.SVGPathSegImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPoint;

public class SVGPathSegArcAbsImpl
extends SVGPathSegImpl
implements SVGPathSegArcAbs {
    protected float x;
    protected float y;
    protected float r1;
    protected float r2;
    protected float angle;
    protected boolean largeArcFlag;
    protected boolean sweepFlag;

    public SVGPathSegArcAbsImpl(float f, float f2, float f3, float f4, float f5, boolean bl, boolean bl2) {
        this.x = f;
        this.y = f2;
        this.r1 = f3;
        this.r2 = f4;
        this.angle = f5;
        this.largeArcFlag = bl;
        this.sweepFlag = bl2;
    }

    public short getPathSegType() {
        return 10;
    }

    public String getPathSegTypeAsLetter() {
        return "A";
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getR1() {
        return this.r1;
    }

    public void setR1(float f) {
        this.r1 = f;
    }

    public float getR2() {
        return this.r2;
    }

    public void setR2(float f) {
        this.r2 = f;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        this.angle = f;
    }

    public boolean getLargeArcFlag() {
        return this.largeArcFlag;
    }

    public void setLargeArcFlag(boolean bl) {
        this.largeArcFlag = bl;
    }

    public boolean getSweepFlag() {
        return this.sweepFlag;
    }

    public void setSweepFlag(boolean bl) {
        this.sweepFlag = bl;
    }

    public String toString() {
        int n = 0;
        if (this.getSweepFlag()) {
            n = 1;
        }
        int n2 = 0;
        if (this.getLargeArcFlag()) {
            n2 = 1;
        }
        return this.getPathSegTypeAsLetter() + " " + this.getR1() + " " + this.getR2() + " " + this.getAngle() + " " + n2 + " " + n + " " + this.getX() + " " + this.getY();
    }

    public float getTotalLength(SVGPoint sVGPoint, SVGPoint sVGPoint2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        float f = sVGPoint.getX();
        float f2 = sVGPoint.getY();
        float f3 = this.x;
        float f4 = this.y;
        double d9 = Math.cos(this.angle);
        double d10 = d9 * (double)(f - f3) / 2.0 + (d8 = Math.sin(this.angle)) * (double)(f2 - f4) / 2.0;
        double d11 = d10 * d10;
        double d12 = d11 / (d7 = (double)(this.r1 * this.r1)) + (d6 = (d5 = -d8 * (double)(f - f3) / 2.0 + d9 * (double)(f2 - f4) / 2.0) * d5) / (d4 = (double)(this.r2 * this.r2));
        if (d12 > 1.0) {
            this.r1 = (float)Math.sqrt(d12) * this.r1;
            this.r2 = (float)Math.sqrt(d12) * this.r2;
            System.out.println("radii not large enough, increasing to: " + this.r1 + "," + this.r2);
            d7 = this.r1 * this.r1;
            d4 = this.r2 * this.r2;
        }
        if ((d3 = (d7 * d4 - d7 * d6 - d4 * d11) / (d7 * d6 + d4 * d11)) < 0.0) {
            d3 = 0.0;
        }
        d3 = Math.sqrt(d3);
        if (this.largeArcFlag == this.sweepFlag) {
            d3 = -d3;
        }
        double d13 = d3 * (double)this.r1 * d5 / (double)this.r2;
        double d14 = d3 * -((double)this.r2 * d10 / (double)this.r1);
        double d15 = d9 * d13 - d8 * d14 + (double)((f + f3) / 2.0f);
        double d16 = d8 * d13 + d9 * d14 + (double)((f2 + f4) / 2.0f);
        double d17 = 1.0;
        double d18 = 0.0;
        double d19 = (d10 - d13) / (double)this.r1;
        double d20 = (d5 - d14) / (double)this.r2;
        double d21 = Math.acos((d17 * d19 + d18 * d20) / (Math.sqrt(d17 * d17 + d18 * d18) * Math.sqrt(d19 * d19 + d20 * d20)));
        if (d17 * d20 - d18 * d19 < 0.0) {
            d21 = -d21;
        }
        d17 = (d10 - d13) / (double)this.r1;
        d18 = (d5 - d14) / (double)this.r2;
        d19 = (-d10 - d13) / (double)this.r1;
        d20 = (-d5 - d14) / (double)this.r2;
        double d22 = Math.acos((d17 * d19 + d18 * d20) / (Math.sqrt(d17 * d17 + d18 * d18) * Math.sqrt(d19 * d19 + d20 * d20)));
        if (d17 * d20 - d18 * d19 < 0.0) {
            d22 = -d22;
        }
        if ((d2 = Math.abs((d = Math.toDegrees(d22)) / 360.0)) > 1.0) {
            d = d > 0.0 ? (d -= 360.0 * Math.floor(d2)) : (d += 360.0 * Math.floor(d2));
            d22 = Math.toRadians(d);
        }
        if (this.sweepFlag && d22 < 0.0) {
            d22 += Math.toRadians(360.0);
        } else if (!this.sweepFlag && d22 > 0.0) {
            d22 -= Math.toRadians(360.0);
        }
        double d23 = (double)(this.r1 + this.r2) * (1.0 + 3.0 * Math.pow((this.r1 - this.r2) / (this.r1 + this.r2), 2.0) / (10.0 + Math.sqrt(3.0 - 4.0 * Math.pow((this.r1 - this.r2) / (this.r1 + this.r2), 2.0))));
        d23 = d22 / 2.0 * d23;
        d23 = Math.abs(d23);
        return (float)d23;
    }

    public SVGPoint getPointAtLength(float f, SVGPoint sVGPoint, SVGPoint sVGPoint2) {
        double d;
        double d2;
        if ((double)Math.abs(f - this.getTotalLength(sVGPoint, sVGPoint2)) < 0.001) {
            return new SVGPointImpl(this.x, this.y);
        }
        float f2 = sVGPoint.getX();
        float f3 = sVGPoint.getY();
        float f4 = this.x;
        float f5 = this.y;
        double d3 = Math.cos(this.angle);
        double d4 = this.r1 * this.r1;
        double d5 = this.r2 * this.r2;
        double d6 = Math.sin(this.angle);
        double d7 = -d6 * (double)(f2 - f4) / 2.0 + d3 * (double)(f3 - f5) / 2.0;
        double d8 = d7 * d7;
        double d9 = (d4 * d5 - d4 * d8 - d5 * (d2 = (d = d3 * (double)(f2 - f4) / 2.0 + d6 * (double)(f3 - f5) / 2.0) * d)) / (d4 * d8 + d5 * d2);
        if (d9 < 0.0) {
            d9 = 0.0;
        }
        d9 = Math.sqrt(d9);
        if (this.largeArcFlag == this.sweepFlag) {
            d9 = -d9;
        }
        double d10 = d9 * (double)this.r1 * d7 / (double)this.r2;
        double d11 = d9 * -((double)this.r2 * d / (double)this.r1);
        double d12 = d3 * d10 - d6 * d11 + (double)((f2 + f4) / 2.0f);
        double d13 = d6 * d10 + d3 * d11 + (double)((f3 + f5) / 2.0f);
        double d14 = 1.0;
        double d15 = 0.0;
        double d16 = (d - d10) / (double)this.r1;
        double d17 = (d7 - d11) / (double)this.r2;
        double d18 = Math.acos((d14 * d16 + d15 * d17) / (Math.sqrt(Math.abs(d14 * d14 + d15 * d15)) * Math.sqrt(Math.abs(d16 * d16 + d17 * d17))));
        if (d14 * d17 - d15 * d16 < 0.0) {
            d18 = -d18;
        }
        double d19 = (double)(2.0f * f / (this.r1 + this.r2)) * (1.0 + 3.0 * Math.pow((this.r1 - this.r2) / (this.r1 + this.r2), 2.0) / (10.0 + Math.sqrt(3.0 - 4.0 * Math.pow((this.r1 - this.r2) / (this.r1 + this.r2), 2.0))));
        double d20 = Math.abs((d19 = Math.toDegrees(d19)) / 360.0);
        if (d20 > 1.0) {
            d19 = d19 > 0.0 ? (d19 -= 360.0 * Math.floor(d20)) : (d19 += 360.0 * Math.floor(d20));
            d19 = Math.toRadians(d19);
        } else {
            d19 = Math.toRadians(d19);
        }
        double d21 = d19 - d18;
        if (this.sweepFlag && d19 < 0.0) {
            d19 += Math.toRadians(360.0);
        } else if (!this.sweepFlag && d19 > 0.0) {
            d19 -= Math.toRadians(360.0);
        }
        d19 = Math.abs(d19);
        double d22 = Math.cos(this.angle) * (double)this.r1 * Math.cos(d18 + d19) - Math.sin(this.angle) * (double)this.r2 * Math.sin(d18 + d19) + d12;
        double d23 = Math.sin(this.angle) * (double)this.r1 * Math.cos(d18 + d19) + Math.cos(this.angle) * (double)this.r2 * Math.sin(d18 + d19) + d13;
        SVGPointImpl sVGPointImpl = new SVGPointImpl((float)d22, (float)d23);
        return sVGPointImpl;
    }
}

