/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import org.csiro.svg.dom.SVGPathSegImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGPointListImpl;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicRel;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;

public class SVGPathSegCurvetoCubicRelImpl
extends SVGPathSegImpl
implements SVGPathSegCurvetoCubicRel {
    protected float x;
    protected float y;
    protected float x1;
    protected float y1;
    protected float x2;
    protected float y2;
    protected int steps = 20;
    protected SVGPointList Points;

    public SVGPathSegCurvetoCubicRelImpl(float f, float f2, float f3, float f4, float f5, float f6) {
        this.x = f;
        this.y = f2;
        this.x1 = f3;
        this.y1 = f4;
        this.x2 = f5;
        this.y2 = f6;
    }

    public short getPathSegType() {
        return 7;
    }

    public String getPathSegTypeAsLetter() {
        return "c";
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getX1() {
        return this.x1;
    }

    public void setX1(float f) {
        this.x1 = f;
    }

    public float getY1() {
        return this.y1;
    }

    public void setY1(float f) {
        this.y1 = f;
    }

    public float getX2() {
        return this.x2;
    }

    public void setX2(float f) {
        this.x2 = f;
    }

    public float getY2() {
        return this.y2;
    }

    public void setY2(float f) {
        this.y2 = f;
    }

    public SVGPointList getPoints() {
        return this.Points;
    }

    public void setPoints(SVGPointList sVGPointList) {
        this.Points = sVGPointList;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setSteps(int n) {
        this.steps = n;
    }

    public String toString() {
        return this.getPathSegTypeAsLetter() + " " + this.getX1() + " " + this.getY1() + " " + this.getX2() + " " + this.getY2() + " " + this.getX() + " " + this.getY();
    }

    public float getTotalLength(SVGPoint sVGPoint, SVGPoint sVGPoint2) {
        this.calculatePoints(sVGPoint);
        SVGPointList sVGPointList = this.getPoints();
        double d = 0.0;
        int n = 1;
        while (n < this.steps) {
            SVGPoint sVGPoint3 = sVGPointList.getItem(n - 1);
            SVGPoint sVGPoint4 = sVGPointList.getItem(n);
            double d2 = Math.pow(sVGPoint3.getX() - sVGPoint4.getX(), 2.0) + Math.pow(sVGPoint3.getY() - sVGPoint4.getY(), 2.0);
            d2 = Math.sqrt(d2);
            d += d2;
            ++n;
        }
        return (float)d;
    }

    public SVGPoint getPointAtLength(float f, SVGPoint sVGPoint, SVGPoint sVGPoint2) {
        this.calculatePoints(sVGPoint);
        SVGPointList sVGPointList = this.getPoints();
        double[] dArray = new double[this.steps];
        double d = 0.0;
        int n = 1;
        while (n < this.steps) {
            SVGPoint sVGPoint3 = sVGPointList.getItem(n - 1);
            SVGPoint sVGPoint4 = sVGPointList.getItem(n);
            dArray[n] = Math.pow(sVGPoint3.getX() - sVGPoint4.getX(), 2.0) + Math.pow(sVGPoint3.getY() - sVGPoint4.getY(), 2.0);
            dArray[n] = Math.sqrt(dArray[n]);
            d += dArray[n];
            ++n;
        }
        double d2 = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        while (n4 < this.steps) {
            if ((d2 += dArray[n4]) < (double)f) {
                n2 = n4++;
                continue;
            }
            n3 = n4;
            break;
        }
        double d3 = ((double)f - (d2 -= dArray[n3])) / dArray[n3];
        SVGPoint sVGPoint5 = sVGPointList.getItem(n2);
        SVGPoint sVGPoint6 = sVGPointList.getItem(n3);
        double d4 = 0.0;
        double d5 = 0.0;
        if (Math.abs(d - (double)f) > 0.001) {
            d4 = d3 * (double)(sVGPoint6.getX() - sVGPoint5.getX()) + (double)sVGPoint5.getX();
            d5 = d3 * (double)(sVGPoint6.getY() - sVGPoint5.getY()) + (double)sVGPoint5.getY();
        } else {
            d4 = this.getX() + sVGPoint.getX();
            d5 = this.getY() + sVGPoint.getY();
        }
        SVGPointImpl sVGPointImpl = new SVGPointImpl((float)d4, (float)d5);
        return sVGPointImpl;
    }

    private void calculatePoints(SVGPoint sVGPoint) {
        SVGPointListImpl sVGPointListImpl = new SVGPointListImpl();
        float f = sVGPoint.getX();
        float f2 = sVGPoint.getY();
        float f3 = this.getX1() + f;
        float f4 = this.getY1() + f2;
        float f5 = this.getX2() + f;
        float f6 = this.getY2() + f2;
        float f7 = this.getX() + f;
        float f8 = this.getY() + f2;
        float f9 = (float)(1.0 / (double)this.steps);
        float f10 = f9 * f9;
        float f11 = f10 * f9;
        float f12 = 3.0f * f9;
        float f13 = 3.0f * f10;
        float f14 = f11;
        float f15 = 6.0f * f10;
        float f16 = 6.0f * f11;
        float f17 = f - f3 * 2.0f + f5;
        float f18 = f2 - f4 * 2.0f + f6;
        float f19 = (f3 - f5) * 3.0f - f + f7;
        float f20 = (f4 - f6) * 3.0f - f2 + f8;
        float f21 = f;
        float f22 = f2;
        float f23 = (f3 - f) * f12 + f17 * f13 + f19 * f14;
        float f24 = (f4 - f2) * f12 + f18 * f13 + f20 * f14;
        float f25 = f17 * f15 + f19 * f16;
        float f26 = f18 * f15 + f20 * f16;
        float f27 = f19 * f16;
        float f28 = f20 * f16;
        sVGPointListImpl.appendItem(sVGPoint);
        int n = 1;
        while (n < this.steps) {
            f23 += f25;
            f25 += f27;
            f26 += f28;
            sVGPointListImpl.appendItem(new SVGPointImpl(f21 += f23, f22 += (f24 += f26)));
            ++n;
        }
        sVGPointListImpl.appendItem(new SVGPointImpl(f7, f8));
        this.setPoints(sVGPointListImpl);
    }
}

