/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import org.csiro.svg.dom.SVGPathSegImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGPointListImpl;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;

public class SVGPathSegCurvetoCubicSmoothAbsImpl
extends SVGPathSegImpl
implements SVGPathSegCurvetoCubicSmoothAbs {
    protected float x;
    protected float y;
    protected float x2;
    protected float y2;
    protected SVGPointList Points;
    protected int steps = 20;

    public SVGPathSegCurvetoCubicSmoothAbsImpl(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.x2 = f3;
        this.y2 = f4;
    }

    public short getPathSegType() {
        return 16;
    }

    public String getPathSegTypeAsLetter() {
        return "S";
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getX2() {
        return this.x2;
    }

    public void setX2(float f) {
        this.x2 = f;
    }

    public float getY2() {
        return this.y2;
    }

    public void setY2(float f) {
        this.y2 = f;
    }

    public SVGPointList getPoints() {
        return this.Points;
    }

    public void setPoints(SVGPointList sVGPointList) {
        this.Points = sVGPointList;
    }

    public String toString() {
        return this.getPathSegTypeAsLetter() + " " + this.getX2() + " " + this.getY2() + " " + this.getX() + " " + this.getY();
    }

    public float getTotalLength(SVGPoint sVGPoint, SVGPoint sVGPoint2) {
        this.calculatePoints(sVGPoint, sVGPoint2);
        SVGPointList sVGPointList = this.getPoints();
        double d = 0.0;
        int n = 1;
        while (n < this.steps) {
            SVGPoint sVGPoint3 = sVGPointList.getItem(n - 1);
            SVGPoint sVGPoint4 = sVGPointList.getItem(n);
            double d2 = Math.pow(sVGPoint3.getX() - sVGPoint4.getX(), 2.0) + Math.pow(sVGPoint3.getY() - sVGPoint4.getY(), 2.0);
            d2 = Math.sqrt(d2);
            d += d2;
            ++n;
        }
        return (float)d;
    }

    public SVGPoint getPointAtLength(float f, SVGPoint sVGPoint, SVGPoint sVGPoint2) {
        this.calculatePoints(sVGPoint, sVGPoint2);
        SVGPointList sVGPointList = this.getPoints();
        double[] dArray = new double[this.steps];
        double d = 0.0;
        int n = 1;
        while (n < this.steps) {
            SVGPoint sVGPoint3 = sVGPointList.getItem(n - 1);
            SVGPoint sVGPoint4 = sVGPointList.getItem(n);
            dArray[n] = Math.pow(sVGPoint3.getX() - sVGPoint4.getX(), 2.0) + Math.pow(sVGPoint3.getY() - sVGPoint4.getY(), 2.0);
            dArray[n] = Math.sqrt(dArray[n]);
            d += dArray[n];
            ++n;
        }
        double d2 = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        while (n4 < this.steps) {
            if ((d2 += dArray[n4]) < (double)f) {
                n2 = n4++;
                continue;
            }
            n3 = n4;
            break;
        }
        double d3 = Math.abs((double)f - (d2 -= dArray[n3])) / dArray[n3];
        SVGPoint sVGPoint5 = sVGPointList.getItem(n3);
        SVGPoint sVGPoint6 = sVGPointList.getItem(n2);
        double d4 = 0.0;
        double d5 = 0.0;
        if (Math.abs((double)f - d) > 0.001) {
            d4 = d3 * (double)(sVGPoint5.getX() - sVGPoint6.getX()) + (double)sVGPoint6.getX();
            d5 = d3 * (double)(sVGPoint5.getY() - sVGPoint6.getY()) + (double)sVGPoint6.getY();
        } else {
            d4 = this.getX();
            d5 = this.getY();
        }
        SVGPointImpl sVGPointImpl = new SVGPointImpl((float)d4, (float)d5);
        return sVGPointImpl;
    }

    private void calculatePoints(SVGPoint sVGPoint, SVGPoint sVGPoint2) {
        SVGPointListImpl sVGPointListImpl = new SVGPointListImpl();
        if (sVGPoint2 == null) {
            sVGPoint2 = new SVGPointImpl(sVGPoint.getX(), sVGPoint.getY());
        }
        float f = 2.0f * sVGPoint.getX() - sVGPoint2.getX();
        float f2 = 2.0f * sVGPoint.getY() - sVGPoint2.getY();
        float f3 = sVGPoint.getX();
        float f4 = sVGPoint.getY();
        float f5 = this.getX2();
        float f6 = this.getY2();
        float f7 = this.getX();
        float f8 = this.getY();
        float f9 = (float)(1.0 / (double)this.steps);
        float f10 = f9 * f9;
        float f11 = f10 * f9;
        float f12 = 3.0f * f9;
        float f13 = 3.0f * f10;
        float f14 = f11;
        float f15 = 6.0f * f10;
        float f16 = 6.0f * f11;
        float f17 = f3 - f * 2.0f + f5;
        float f18 = f4 - f2 * 2.0f + f6;
        float f19 = (f - f5) * 3.0f - f3 + f7;
        float f20 = (f2 - f6) * 3.0f - f4 + f8;
        float f21 = f3;
        float f22 = f4;
        float f23 = (f - f3) * f12 + f17 * f13 + f19 * f14;
        float f24 = (f2 - f4) * f12 + f18 * f13 + f20 * f14;
        float f25 = f17 * f15 + f19 * f16;
        float f26 = f18 * f15 + f20 * f16;
        float f27 = f19 * f16;
        float f28 = f20 * f16;
        sVGPointListImpl.appendItem(sVGPoint);
        int n = 1;
        while (n < this.steps) {
            f23 += f25;
            f25 += f27;
            f26 += f28;
            sVGPointListImpl.appendItem(new SVGPointImpl(f21 += f23, f22 += (f24 += f26)));
            ++n;
        }
        sVGPointListImpl.appendItem(new SVGPointImpl(f7, f8));
        this.setPoints(sVGPointListImpl);
    }
}

