/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import org.csiro.svg.dom.SVGPathSegImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGPointListImpl;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;

public class SVGPathSegCurvetoQuadraticSmoothAbsImpl
extends SVGPathSegImpl
implements SVGPathSegCurvetoQuadraticSmoothAbs {
    protected float x;
    protected float y;
    protected SVGPointList Points;
    protected int steps = 25;

    public SVGPathSegCurvetoQuadraticSmoothAbsImpl(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public short getPathSegType() {
        return 18;
    }

    public String getPathSegTypeAsLetter() {
        return "T";
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public SVGPointList getPoints() {
        return this.Points;
    }

    public void setPoints(SVGPointList sVGPointList) {
        this.Points = sVGPointList;
    }

    public String toString() {
        return this.getPathSegTypeAsLetter() + " " + this.getX() + " " + this.getY();
    }

    public float getTotalLength(SVGPoint sVGPoint, SVGPoint sVGPoint2) {
        this.calculatePoints(sVGPoint, sVGPoint2);
        SVGPointList sVGPointList = this.getPoints();
        double d = 0.0;
        int n = 1;
        while (n < this.steps) {
            SVGPoint sVGPoint3 = sVGPointList.getItem(n - 1);
            SVGPoint sVGPoint4 = sVGPointList.getItem(n);
            double d2 = Math.pow(sVGPoint3.getX() - sVGPoint4.getX(), 2.0) + Math.pow(sVGPoint3.getY() - sVGPoint4.getY(), 2.0);
            d2 = Math.sqrt(d2);
            d += d2;
            ++n;
        }
        return (float)d;
    }

    public SVGPoint getPointAtLength(float f, SVGPoint sVGPoint, SVGPoint sVGPoint2) {
        this.calculatePoints(sVGPoint, sVGPoint2);
        SVGPointList sVGPointList = this.getPoints();
        double[] dArray = new double[this.steps];
        double d = 0.0;
        int n = 1;
        while (n < this.steps) {
            SVGPoint sVGPoint3 = sVGPointList.getItem(n - 1);
            SVGPoint sVGPoint4 = sVGPointList.getItem(n);
            dArray[n] = Math.pow(sVGPoint3.getX() - sVGPoint4.getX(), 2.0) + Math.pow(sVGPoint3.getY() - sVGPoint4.getY(), 2.0);
            dArray[n] = Math.sqrt(dArray[n]);
            d += dArray[n];
            ++n;
        }
        double d2 = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        while (n4 < this.steps) {
            if ((d2 += dArray[n4]) <= (double)f) {
                n2 = n4++;
                continue;
            }
            n3 = n4;
            break;
        }
        double d3 = Math.abs((double)f - (d2 -= dArray[n3])) / dArray[n3];
        SVGPoint sVGPoint5 = sVGPointList.getItem(n3);
        SVGPoint sVGPoint6 = sVGPointList.getItem(n2);
        double d4 = d3 * (double)(sVGPoint5.getX() - sVGPoint6.getX()) + (double)sVGPoint6.getX();
        double d5 = d3 * (double)(sVGPoint5.getY() - sVGPoint6.getY()) + (double)sVGPoint6.getY();
        SVGPointImpl sVGPointImpl = new SVGPointImpl((float)d4, (float)d5);
        return sVGPointImpl;
    }

    private void calculatePoints(SVGPoint sVGPoint, SVGPoint sVGPoint2) {
        if (sVGPoint2 == null) {
            sVGPoint2 = new SVGPointImpl(sVGPoint.getX(), sVGPoint.getY());
        }
        float f = 2.0f * sVGPoint.getX() - sVGPoint2.getX();
        float f2 = 2.0f * sVGPoint.getY() - sVGPoint2.getY();
        float f3 = sVGPoint.getX();
        float f4 = sVGPoint.getY();
        float f5 = this.getX();
        float f6 = this.getY();
        System.out.println("EndPoint " + this.getX() + " " + this.getY() + " start Point " + f3 + " " + f4);
        SVGPointListImpl sVGPointListImpl = new SVGPointListImpl();
        SVGPoint[] sVGPointArray = new SVGPointImpl[this.steps];
        sVGPointArray[0] = new SVGPointImpl(f3, f4);
        sVGPointArray[this.steps - 1] = new SVGPointImpl(f5, f6);
        this.initialize(0, this.steps - 1, f, f2, sVGPointArray);
        int n = 0;
        while (n < this.steps) {
            sVGPointListImpl.appendItem(new SVGPointImpl(sVGPointArray[n].getX(), sVGPointArray[n].getY()));
            ++n;
        }
        this.setPoints(sVGPointListImpl);
    }

    private void initialize(int n, int n2, float f, float f2, SVGPoint[] sVGPointArray) {
        if (n == n2 - 1) {
            return;
        }
        float f3 = sVGPointArray[n].getX();
        float f4 = sVGPointArray[n].getY();
        float f5 = f;
        float f6 = f2;
        float f7 = sVGPointArray[n2].getX();
        float f8 = sVGPointArray[n2].getY();
        float f9 = (float)((double)(f3 + f5) / 2.0);
        float f10 = (float)((double)(f4 + f6) / 2.0);
        float f11 = (float)((double)(f7 + f5) / 2.0);
        float f12 = (float)((double)(f8 + f6) / 2.0);
        f5 = (float)((double)(f9 + f11) / 2.0);
        f6 = (float)((double)(f10 + f12) / 2.0);
        int n3 = n + (n2 - n) / 2;
        sVGPointArray[n3] = new SVGPointImpl(f5, f6);
        this.initialize(n, n3, f9, f10, sVGPointArray);
        this.initialize(n3, n2, f11, f12, sVGPointArray);
    }
}

