/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import java.util.Vector;
import org.csiro.svg.dom.SVGAnimatedBooleanImpl;
import org.csiro.svg.dom.SVGAnimatedEnumerationImpl;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedPreserveAspectRatioImpl;
import org.csiro.svg.dom.SVGAnimatedRectImpl;
import org.csiro.svg.dom.SVGAnimatedStringImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGGElementImpl;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGPreserveAspectRatioImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGSVGElementImpl;
import org.csiro.svg.dom.SVGStringListImpl;
import org.csiro.svg.dom.SVGStylableImpl;
import org.csiro.svg.dom.SVGTexturePaint;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGAnimatedTransformList;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGPatternElement;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGStringList;

public class SVGPatternElementImpl
extends SVGStylableImpl
implements SVGPatternElement {
    protected SVGAnimatedLength x;
    protected SVGAnimatedLength y;
    protected SVGAnimatedLength width;
    protected SVGAnimatedLength height;
    protected SVGAnimatedEnumeration patternUnits;
    protected SVGAnimatedEnumeration patternContentUnits;
    protected SVGAnimatedTransformList patternTransform;
    protected SVGAnimatedRect viewBox;
    protected SVGAnimatedPreserveAspectRatio preserveAspectRatio;
    protected SVGAnimatedString href;
    protected SVGAnimatedBoolean externalResourcesRequired;
    private static Vector patternUnitStrings;
    private static Vector patternUnitValues;
    protected SVGStringListImpl requiredFeatures;
    protected SVGStringListImpl requiredExtensions;
    protected SVGStringListImpl systemLanguage;

    public SVGPatternElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "pattern");
        super.setAttribute("x", this.getX().getBaseVal().getValueAsString());
        super.setAttribute("y", this.getY().getBaseVal().getValueAsString());
        super.setAttribute("width", this.getWidth().getBaseVal().getValueAsString());
        super.setAttribute("height", this.getHeight().getBaseVal().getValueAsString());
        super.setAttribute("patternUnits", "objectBoundingBox");
        super.setAttribute("patternContentUnits", "userSpaceOnUse");
        super.setAttribute("patternTransform", "");
        super.setAttribute("preserveAspectRatio", ((SVGPreserveAspectRatioImpl)this.getPreserveAspectRatio().getBaseVal()).toString());
    }

    public SVGPatternElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "pattern");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGPatternElementImpl sVGPatternElementImpl = new SVGPatternElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedLengthImpl)this.getX()).getAnimations();
        Vector vector2 = ((SVGAnimatedLengthImpl)this.getY()).getAnimations();
        Vector vector3 = ((SVGAnimatedLengthImpl)this.getWidth()).getAnimations();
        Vector vector4 = ((SVGAnimatedLengthImpl)this.getHeight()).getAnimations();
        Vector vector5 = ((SVGAnimatedEnumerationImpl)this.getPatternUnits()).getAnimations();
        Vector vector6 = ((SVGAnimatedEnumerationImpl)this.getPatternContentUnits()).getAnimations();
        Vector vector7 = ((SVGAnimatedTransformListImpl)this.getPatternTransform()).getAnimations();
        Vector vector8 = ((SVGAnimatedRectImpl)this.getViewBox()).getAnimations();
        Vector vector9 = ((SVGAnimatedPreserveAspectRatioImpl)this.getPreserveAspectRatio()).getAnimations();
        Vector vector10 = ((SVGAnimatedBooleanImpl)this.getExternalResourcesRequired()).getAnimations();
        Vector vector11 = ((SVGAnimatedStringImpl)this.getHref()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGPatternElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGPatternElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGPatternElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector4 != null) {
            n = 0;
            while (n < vector4.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector4.elementAt(n);
                sVGPatternElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector5 != null) {
            n = 0;
            while (n < vector5.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector5.elementAt(n);
                sVGPatternElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector6 != null) {
            n = 0;
            while (n < vector6.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector6.elementAt(n);
                sVGPatternElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector7 != null) {
            n = 0;
            while (n < vector7.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector7.elementAt(n);
                sVGPatternElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector8 != null) {
            n = 0;
            while (n < vector8.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector8.elementAt(n);
                sVGPatternElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector9 != null) {
            n = 0;
            while (n < vector9.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector9.elementAt(n);
                sVGPatternElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector10 != null) {
            n = 0;
            while (n < vector10.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector10.elementAt(n);
                sVGPatternElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector11 != null) {
            n = 0;
            while (n < vector11.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector11.elementAt(n);
                sVGPatternElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGPatternElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGPatternElementImpl;
    }

    private void initPatternUnitVectors() {
        if (patternUnitStrings == null) {
            patternUnitStrings = new Vector();
            patternUnitStrings.addElement("userSpaceOnUse");
            patternUnitStrings.addElement("objectBoundingBox");
        }
        if (patternUnitValues == null) {
            patternUnitValues = new Vector();
            patternUnitValues.addElement(new Short(1));
            patternUnitValues.addElement(new Short(2));
            patternUnitValues.addElement(new Short(0));
        }
    }

    public SVGAnimatedLength getX() {
        if (this.x == null) {
            SVGPatternElementImpl sVGPatternElementImpl = this.getReferencedPattern();
            if (sVGPatternElementImpl != null) {
                return sVGPatternElementImpl.getX();
            }
            this.x = new SVGAnimatedLengthImpl(new SVGLengthImpl("0%", (SVGElement)this, 0), this);
        }
        return this.x;
    }

    public SVGAnimatedLength getY() {
        if (this.y == null) {
            SVGPatternElementImpl sVGPatternElementImpl = this.getReferencedPattern();
            if (sVGPatternElementImpl != null) {
                return sVGPatternElementImpl.getY();
            }
            this.y = new SVGAnimatedLengthImpl(new SVGLengthImpl("0%", (SVGElement)this, 1), this);
        }
        return this.y;
    }

    public SVGAnimatedLength getWidth() {
        if (this.width == null) {
            SVGPatternElementImpl sVGPatternElementImpl = this.getReferencedPattern();
            if (sVGPatternElementImpl != null) {
                return sVGPatternElementImpl.getWidth();
            }
            this.width = new SVGAnimatedLengthImpl(new SVGLengthImpl("100%", (SVGElement)this, 0), this);
        }
        return this.width;
    }

    public SVGAnimatedLength getHeight() {
        if (this.height == null) {
            SVGPatternElementImpl sVGPatternElementImpl = this.getReferencedPattern();
            if (sVGPatternElementImpl != null) {
                return sVGPatternElementImpl.getHeight();
            }
            this.height = new SVGAnimatedLengthImpl(new SVGLengthImpl("100%", (SVGElement)this, 1), this);
        }
        return this.height;
    }

    public SVGAnimatedEnumeration getPatternUnits() {
        if (this.patternUnits == null) {
            SVGPatternElementImpl sVGPatternElementImpl = this.getReferencedPattern();
            if (sVGPatternElementImpl != null) {
                return sVGPatternElementImpl.getPatternUnits();
            }
            if (patternUnitStrings == null) {
                this.initPatternUnitVectors();
            }
            this.patternUnits = new SVGAnimatedEnumerationImpl(2, this, patternUnitStrings, patternUnitValues);
        }
        return this.patternUnits;
    }

    public SVGAnimatedEnumeration getPatternContentUnits() {
        if (this.patternContentUnits == null) {
            SVGPatternElementImpl sVGPatternElementImpl = this.getReferencedPattern();
            if (sVGPatternElementImpl != null) {
                return sVGPatternElementImpl.getPatternContentUnits();
            }
            if (patternUnitStrings == null) {
                this.initPatternUnitVectors();
            }
            this.patternContentUnits = new SVGAnimatedEnumerationImpl(1, this, patternUnitStrings, patternUnitValues);
        }
        return this.patternContentUnits;
    }

    public SVGAnimatedTransformList getPatternTransform() {
        if (this.patternTransform == null) {
            SVGPatternElementImpl sVGPatternElementImpl = this.getReferencedPattern();
            if (sVGPatternElementImpl != null) {
                return sVGPatternElementImpl.getPatternTransform();
            }
            this.patternTransform = new SVGAnimatedTransformListImpl(new SVGTransformListImpl(), this);
        }
        return this.patternTransform;
    }

    public SVGAnimatedRect getViewBox() {
        if (this.viewBox == null) {
            this.viewBox = new SVGAnimatedRectImpl(new SVGRectImpl(), this);
        }
        return this.viewBox;
    }

    public SVGAnimatedPreserveAspectRatio getPreserveAspectRatio() {
        if (this.preserveAspectRatio == null) {
            this.preserveAspectRatio = new SVGAnimatedPreserveAspectRatioImpl(new SVGPreserveAspectRatioImpl(), this);
        }
        return this.preserveAspectRatio;
    }

    public String getXMLlang() {
        return this.getAttribute("xml:lang");
    }

    public void setXMLlang(String string) {
        if (string != null) {
            super.setAttribute("xml:lang", string);
        } else {
            this.removeAttribute("xml:lang");
        }
    }

    public String getXMLspace() {
        return this.getAttribute("xml:space");
    }

    public void setXMLspace(String string) {
        if (string != null) {
            super.setAttribute("xml:space", string);
        } else {
            this.removeAttribute("xml:space");
        }
    }

    public String getXlinkType() {
        return this.getAttribute("xlink:type");
    }

    public void setXlinkType(String string) throws DOMException {
        this.setAttribute("xlink:type", string);
    }

    public String getXlinkRole() {
        return this.getAttribute("xlink:role");
    }

    public void setXlinkRole(String string) throws DOMException {
        this.setAttribute("xlink:role", string);
    }

    public String getXlinkArcRole() {
        return this.getAttribute("xlink:arcrole");
    }

    public void setXlinkArcRole(String string) throws DOMException {
        this.setAttribute("xlink:arcrole", string);
    }

    public String getXlinkTitle() {
        return this.getAttribute("xlink:title");
    }

    public void setXlinkTitle(String string) throws DOMException {
        this.setAttribute("xlink:title", string);
    }

    public String getXlinkShow() {
        return this.getAttribute("xlink:show");
    }

    public void setXlinkShow(String string) throws DOMException {
        this.setAttribute("xlink:show", string);
    }

    public String getXlinkActuate() {
        return this.getAttribute("xlink:actuate");
    }

    public void setXlinkActuate(String string) throws DOMException {
        this.setAttribute("xlink:actuate", string);
    }

    public SVGAnimatedString getHref() {
        if (this.href == null) {
            this.href = new SVGAnimatedStringImpl("", this);
        }
        return this.href;
    }

    public SVGStringList getRequiredFeatures() {
        return this.requiredFeatures;
    }

    public SVGStringList getRequiredExtensions() {
        return this.requiredExtensions;
    }

    public SVGStringList getSystemLanguage() {
        return this.systemLanguage;
    }

    public boolean hasExtension(String string) {
        return string.equalsIgnoreCase("svg");
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        if (this.externalResourcesRequired == null) {
            this.externalResourcesRequired = new SVGAnimatedBooleanImpl(false, this);
        }
        return this.externalResourcesRequired;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("x")) {
            return this.getX().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("y")) {
            return this.getY().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("width")) {
            return this.getWidth().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("height")) {
            return this.getHeight().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("viewBox")) {
            if (this.getViewBox().getBaseVal() == null) {
                return "";
            }
            return this.getViewBox().getBaseVal().toString();
        }
        if (string.equalsIgnoreCase("preserveAspectRatio")) {
            return ((SVGPreserveAspectRatioImpl)this.getPreserveAspectRatio().getBaseVal()).toString();
        }
        if (string.equalsIgnoreCase("patternUnits")) {
            if (this.getPatternUnits().getBaseVal() == 2) {
                return "objectBoundingBox";
            }
            return "userSpaceOnUse";
        }
        if (string.equalsIgnoreCase("patternContentUnits")) {
            if (this.getPatternContentUnits().getBaseVal() == 2) {
                return "objectBoundingBox";
            }
            return "userSpaceOnUse";
        }
        if (string.equalsIgnoreCase("xlink:href")) {
            return this.getHref().getBaseVal();
        }
        if (string.equalsIgnoreCase("patternTransform")) {
            return this.getPatternTransform().getBaseVal().toString();
        }
        if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                return "true";
            }
            return "false";
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("x")) {
            attr.setValue(this.getX().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("y")) {
            attr.setValue(this.getY().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("width")) {
            attr.setValue(this.getWidth().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("height")) {
            attr.setValue(this.getHeight().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("viewBox")) {
            if (this.getViewBox().getBaseVal() == null) {
                attr.setValue("");
            } else {
                attr.setValue(this.getViewBox().getBaseVal().toString());
            }
        } else if (string.equalsIgnoreCase("preserveAspectRatio")) {
            attr.setValue(((SVGPreserveAspectRatioImpl)this.getPreserveAspectRatio().getBaseVal()).toString());
        } else if (string.equalsIgnoreCase("patternUnits")) {
            if (this.getPatternUnits().getBaseVal() == 2) {
                attr.setValue("objectBoundingBox");
            } else {
                attr.setValue("userSpaceOnUse");
            }
        } else if (string.equalsIgnoreCase("patternContentUnits")) {
            if (this.getPatternContentUnits().getBaseVal() == 2) {
                attr.setValue("objectBoundingBox");
            } else {
                attr.setValue("userSpaceOnUse");
            }
        } else if (string.equalsIgnoreCase("xlink:href")) {
            attr.setValue(this.getHref().getBaseVal());
        } else if (string.equalsIgnoreCase("patternTransform")) {
            attr.setValue(this.patternTransform.getBaseVal().toString());
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                attr.setValue("true");
            } else {
                attr.setValue("false");
            }
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("x")) {
            this.getX().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("y")) {
            this.getY().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("width")) {
            this.getWidth().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("height")) {
            this.getHeight().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("viewBox")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
            if (stringTokenizer.countTokens() == 4) {
                this.getViewBox().getBaseVal().setX(Float.parseFloat(stringTokenizer.nextToken()));
                this.getViewBox().getBaseVal().setY(Float.parseFloat(stringTokenizer.nextToken()));
                this.getViewBox().getBaseVal().setWidth(Float.parseFloat(stringTokenizer.nextToken()));
                this.getViewBox().getBaseVal().setHeight(Float.parseFloat(stringTokenizer.nextToken()));
            }
        } else if (string.equalsIgnoreCase("preserveAspectRatio")) {
            short s;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
            String string3 = null;
            String string4 = null;
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                string3 = stringTokenizer.nextToken();
                if (n > 1) {
                    string4 = stringTokenizer.nextToken();
                }
            }
            if (string3 != null) {
                s = SVGPreserveAspectRatioImpl.getAlignConst(string3);
                this.getPreserveAspectRatio().getBaseVal().setAlign(s);
            }
            if (string4 != null) {
                s = SVGPreserveAspectRatioImpl.getMeetOrSliceConst(string4);
                this.getPreserveAspectRatio().getBaseVal().setMeetOrSlice(s);
            }
        } else if (string.equalsIgnoreCase("patternUnits")) {
            if (string2.equalsIgnoreCase("userSpaceOnUse")) {
                this.getPatternUnits().setBaseVal((short)1);
            } else if (string2.equalsIgnoreCase("objectBoundingBox")) {
                this.getPatternUnits().setBaseVal((short)2);
            } else {
                System.out.println("invalid value '" + string2 + "' for patternUnits attribute, setting to default 'objectBoundingBox'");
                this.getPatternUnits().setBaseVal((short)2);
            }
        } else if (string.equalsIgnoreCase("patternContentUnits")) {
            if (string2.equalsIgnoreCase("userSpaceOnUse")) {
                this.getPatternContentUnits().setBaseVal((short)1);
            } else if (string2.equalsIgnoreCase("objectBoundingBox")) {
                this.getPatternContentUnits().setBaseVal((short)2);
            } else {
                System.out.println("invalid value '" + string2 + "' for patternContentUnits attribute, setting to default 'userSpaceOnUse'");
                this.getPatternContentUnits().setBaseVal((short)1);
            }
        } else if (string.equalsIgnoreCase("xlink:href")) {
            this.getHref().setBaseVal(string2);
        } else if (string.equalsIgnoreCase("patternTransform")) {
            ((SVGAnimatedTransformListImpl)this.getPatternTransform()).setBaseVal(SVGTransformListImpl.createTransformList(string2));
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (string2.equalsIgnoreCase("true")) {
                this.getExternalResourcesRequired().setBaseVal(true);
            } else {
                this.getExternalResourcesRequired().setBaseVal(false);
            }
        }
    }

    public Paint getPaint(SVGElementImpl sVGElementImpl, float f) {
        Object object;
        Node node;
        Object object2;
        float f2;
        float f3;
        float f4;
        float f5;
        short s = this.getPatternUnits().getAnimVal();
        short s2 = this.getPatternContentUnits().getAnimVal();
        SVGLength sVGLength = this.getX().getAnimVal();
        SVGLength sVGLength2 = this.getY().getAnimVal();
        SVGLength sVGLength3 = this.getWidth().getAnimVal();
        SVGLength sVGLength4 = this.getHeight().getAnimVal();
        SVGSVGElement sVGSVGElement = this.getOwnerSVGElement();
        SVGRect sVGRect = sVGSVGElement.getViewBox().getAnimVal();
        if (sVGRect == null) {
            sVGRect = sVGSVGElement.getViewport();
        }
        SVGRect sVGRect2 = null;
        sVGRect2 = sVGElementImpl instanceof SVGLocatable ? ((SVGLocatable)((Object)sVGElementImpl)).getBBox() : sVGRect;
        float f6 = 1.0f;
        float f7 = 1.0f;
        if (s == 2) {
            f5 = sVGRect2.getX();
            f4 = sVGRect2.getY();
            f3 = sVGRect2.getWidth();
            f2 = sVGRect2.getHeight();
        } else {
            f5 = sVGRect.getX();
            f4 = sVGRect.getY();
            f3 = sVGRect.getWidth();
            f2 = sVGRect.getHeight();
        }
        if (s2 == 2) {
            if (sVGRect2.getWidth() > sVGRect2.getHeight()) {
                f7 = sVGRect2.getHeight() / sVGRect2.getWidth();
                f2 = sVGRect2.getWidth();
            } else if (sVGRect2.getHeight() > sVGRect2.getWidth()) {
                f6 = sVGRect2.getWidth() / sVGRect2.getHeight();
                f3 = sVGRect2.getHeight();
            }
        }
        float f8 = sVGLength.getUnitType() == 2 ? (float)((double)f5 + (double)sVGLength.getValueInSpecifiedUnits() / 100.0 * (double)f3) : (s == 1 ? sVGLength.getValue() : f5 + sVGLength.getValue() * f3);
        float f9 = sVGLength2.getUnitType() == 2 ? (float)((double)f4 + (double)sVGLength2.getValueInSpecifiedUnits() / 100.0 * (double)f2) : (s == 1 ? sVGLength2.getValue() : f4 + sVGLength2.getValue() * f2);
        float f10 = sVGLength3.getUnitType() == 2 ? (float)((double)sVGLength3.getValueInSpecifiedUnits() / 100.0 * (double)f3) : (s == 1 ? sVGLength3.getValue() : sVGLength3.getValue() * f3);
        float f11 = sVGLength4.getUnitType() == 2 ? (float)((double)sVGLength4.getValueInSpecifiedUnits() / 100.0 * (double)f2) : (s == 1 ? sVGLength4.getValue() : sVGLength4.getValue() * f2);
        AffineTransform affineTransform = ((SVGTransformListImpl)this.getPatternTransform().getAnimVal()).getAffineTransform();
        if ((f6 != 1.0f || f7 != 1.0f) && s != 1) {
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(-f8, -f9));
            affineTransform.preConcatenate(AffineTransform.getScaleInstance(f6, f7));
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(f8, f9));
        }
        SVGSVGElement sVGSVGElement2 = this.getOwnerDoc().getRootElement();
        float f12 = 1.0f;
        if (sVGSVGElement2 != null) {
            f12 = sVGSVGElement2.getCurrentScale();
        }
        int n = (int)(f10 * f12);
        int n2 = (int)(f11 * f12);
        if (n > 500 || n2 > 500) {
            float f13 = (float)n / 500.0f;
            float f14 = (float)n2 / 500.0f;
            if (f13 > f14) {
                n = (int)((float)n / f13);
                n2 = (int)((float)n2 / f13);
            } else {
                n = (int)((float)n / f14);
                n2 = (int)((float)n2 / f14);
            }
        }
        if (n == 0 || n2 == 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHints(renderingHints);
        boolean bl = false;
        if (this.hasChildNodes()) {
            object2 = this.getChildNodes();
            int n3 = object2.getLength();
            int n4 = 0;
            while (n4 < n3) {
                node = object2.item(n4);
                if (node instanceof SVGElementImpl) {
                    bl = true;
                    break;
                }
                ++n4;
            }
        }
        object2 = this.getReferencedPattern();
        SVGPatternElementImpl sVGPatternElementImpl = bl || object2 == null ? (SVGPatternElementImpl)this.cloneElement() : (SVGPatternElementImpl)((SVGPatternElementImpl)object2).cloneElement();
        SVGSVGElementImpl sVGSVGElementImpl = new SVGSVGElementImpl(this.getOwnerDoc());
        ((SVGAnimatedLengthImpl)sVGSVGElementImpl.getX()).setBaseVal(new SVGLengthImpl(0.0f, (SVGElement)sVGSVGElementImpl, 0));
        ((SVGAnimatedLengthImpl)sVGSVGElementImpl.getY()).setBaseVal(new SVGLengthImpl(0.0f, (SVGElement)sVGSVGElementImpl, 1));
        ((SVGAnimatedLengthImpl)sVGSVGElementImpl.getWidth()).setBaseVal(new SVGLengthImpl(n, (SVGElement)sVGSVGElementImpl, 0));
        ((SVGAnimatedLengthImpl)sVGSVGElementImpl.getHeight()).setBaseVal(new SVGLengthImpl(n2, (SVGElement)sVGSVGElementImpl, 1));
        ((SVGAnimatedPreserveAspectRatioImpl)sVGSVGElementImpl.getPreserveAspectRatio()).setBaseVal(this.getPreserveAspectRatio().getAnimVal());
        if (this.getViewBox().getBaseVal().getWidth() > 0.0f) {
            sVGSVGElementImpl.setAttribute("viewBox", ((SVGRectImpl)this.getViewBox().getBaseVal()).toString());
        } else if (s2 == 2) {
            sVGSVGElementImpl.setAttribute("viewBox", "0,0," + f10 / sVGRect2.getWidth() * f6 + "," + f11 / sVGRect2.getHeight() * f7);
        } else {
            sVGSVGElementImpl.setAttribute("viewBox", "0,0," + f10 + "," + f11);
        }
        node = new SVGGElementImpl(this.getOwnerDoc());
        Vector<Node> vector = new Vector<Node>();
        if (sVGPatternElementImpl.hasChildNodes()) {
            NodeList nodeList = sVGPatternElementImpl.getChildNodes();
            int n5 = nodeList.getLength();
            int n6 = 0;
            while (n6 < n5) {
                object = nodeList.item(n6);
                if (object instanceof SVGElementImpl) {
                    vector.add((Node)object);
                }
                ++n6;
            }
        }
        int n7 = 0;
        while (n7 < vector.size()) {
            SVGElementImpl sVGElementImpl2 = (SVGElementImpl)vector.elementAt(n7);
            node.appendChild(sVGElementImpl2);
            ++n7;
        }
        sVGSVGElementImpl.appendChild(node);
        if ((f6 != 1.0f || f7 != 1.0f) && s2 == 2 && s == 1 && this.getViewBox().getBaseVal().getWidth() == 0.0f) {
            node.setAttribute("transform", "scale(" + f6 + "," + f7 + ")");
        }
        sVGSVGElementImpl.draw(graphics2D, true);
        if (f < 1.0f) {
            BufferedImage bufferedImage2 = new BufferedImage(n, n2, 6);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage2.getGraphics();
            object = AlphaComposite.getInstance(3, f);
            graphics2D2.setComposite((Composite)object);
            graphics2D2.drawImage(bufferedImage, new AffineTransform(), null);
            bufferedImage = bufferedImage2;
        }
        SVGTexturePaint sVGTexturePaint = new SVGTexturePaint(bufferedImage, new Rectangle2D.Float(f8, f9, f10, f11), affineTransform, 2);
        return sVGTexturePaint;
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("x")) {
            ((SVGAnimatedValue)((Object)this.getX())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("y")) {
            ((SVGAnimatedValue)((Object)this.getY())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("width")) {
            ((SVGAnimatedValue)((Object)this.getWidth())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("height")) {
            ((SVGAnimatedValue)((Object)this.getHeight())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("patternUnits")) {
            ((SVGAnimatedValue)((Object)this.getPatternUnits())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("patternTransform")) {
            ((SVGAnimatedValue)((Object)this.getPatternTransform())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("viewBox")) {
            ((SVGAnimatedValue)((Object)this.getViewBox())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("preserveAspectRatio")) {
            ((SVGAnimatedValue)((Object)this.getPreserveAspectRatio())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("href")) {
            ((SVGAnimatedValue)((Object)this.getHref())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("externalResourcesRequired")) {
            ((SVGAnimatedValue)((Object)this.getExternalResourcesRequired())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }

    protected SVGPatternElementImpl getReferencedPattern() {
        String string = this.getHref().getAnimVal();
        if (string.length() > 0 && string.indexOf(35) != -1) {
            int n = string.indexOf(35);
            String string2 = string.substring(n + 1, string.length());
            Element element = this.getOwnerDoc().getElementById(string2);
            if (element != null && element instanceof SVGPatternElementImpl) {
                return (SVGPatternElementImpl)element;
            }
        }
        return null;
    }
}

