/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.csiro.svg.dom.BasicShape;
import org.csiro.svg.dom.Drawable;
import org.csiro.svg.dom.SVGAnimatedNumberListImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGClipPathElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGGraphic;
import org.csiro.svg.dom.SVGMarkerElementImpl;
import org.csiro.svg.dom.SVGMatrixImpl;
import org.csiro.svg.dom.SVGNumberListImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGPointListImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGTexturePaint;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGPolylineElementImpl
extends SVGGraphic
implements SVGPolylineElement,
Drawable,
BasicShape {
    private SVGAnimatedNumberListImpl animatedPointList;
    boolean visible = true;
    boolean display = true;
    float opacity = 1.0f;
    Shape clipShape = null;
    GeneralPath polyline = null;
    BasicStroke stroke = null;
    Paint fillPaint = null;
    Paint linePaint = null;
    AffineTransform thisTransform = null;
    SVGMarkerElementImpl startMarker = null;
    SVGMarkerElementImpl midMarker = null;
    SVGMarkerElementImpl endMarker = null;
    SVGClipPathElementImpl clipPath = null;

    public SVGPolylineElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "polyline");
        super.setAttribute("points", "");
    }

    public SVGPolylineElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "polyline");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGPolylineElementImpl sVGPolylineElementImpl = new SVGPolylineElementImpl(this.getOwnerDoc(), this);
        Vector vector = this.getAnimatedPointList().getAnimations();
        Vector vector2 = ((SVGAnimatedTransformListImpl)this.getTransform()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGPolylineElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGPolylineElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGPolylineElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGPolylineElementImpl;
    }

    private SVGAnimatedNumberListImpl getAnimatedPointList() {
        if (this.animatedPointList == null) {
            this.animatedPointList = new SVGAnimatedNumberListImpl(new SVGNumberListImpl(), this);
        }
        return this.animatedPointList;
    }

    public SVGPointList getPoints() {
        return this.constructPointList(((SVGNumberListImpl)this.getAnimatedPointList().getBaseVal()).toString());
    }

    public SVGPointList getAnimatedPoints() {
        return this.constructPointList(((SVGNumberListImpl)this.getAnimatedPointList().getAnimVal()).toString());
    }

    private SVGPointList constructPointList(String string) {
        SVGPointListImpl sVGPointListImpl = new SVGPointListImpl();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,", false);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                float f = Float.parseFloat(stringTokenizer.nextToken());
                float f2 = Float.parseFloat(stringTokenizer.nextToken());
                SVGPointImpl sVGPointImpl = new SVGPointImpl(f, f2);
                sVGPointListImpl.appendItem(sVGPointImpl);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return sVGPointListImpl;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("points")) {
            return this.getPoints().toString();
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("points")) {
            attr.setValue(this.getPoints().toString());
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        if (string.equalsIgnoreCase("points")) {
            this.getAnimatedPointList().setBaseVal(new SVGNumberListImpl(string2));
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        String string = attr.getName();
        String string2 = attr.getValue();
        if (string.equalsIgnoreCase("points")) {
            this.getAnimatedPointList().setBaseVal(new SVGNumberListImpl(string2));
        }
        return super.setAttributeNode(attr);
    }

    private GeneralPath createShape() {
        GeneralPath generalPath = new GeneralPath();
        SVGPointList sVGPointList = this.getAnimatedPoints();
        int n = sVGPointList.getNumberOfItems();
        int n2 = 0;
        while (n2 < n) {
            SVGPoint sVGPoint = sVGPointList.getItem(n2);
            float f = sVGPoint.getX();
            float f2 = sVGPoint.getY();
            if (n2 == 0) {
                generalPath.moveTo(f, f2);
            } else {
                generalPath.lineTo(f, f2);
            }
            ++n2;
        }
        return generalPath;
    }

    public void draw(Graphics2D graphics2D, boolean bl) {
        Object object;
        Object object2;
        if (bl || this.polyline == null) {
            this.refreshData();
            this.visible = this.getVisibility();
            this.opacity = this.getOpacity();
            this.display = this.getDisplay();
            this.clipPath = this.getClippingPath();
            this.clipShape = null;
            if (this.clipPath != null) {
                this.clipShape = this.clipPath.getClippingShape(this);
            }
            this.thisTransform = new AffineTransform();
            if (this.transform != null) {
                this.thisTransform = ((SVGTransformListImpl)this.transform.getAnimVal()).getAffineTransform();
            }
            this.polyline = this.createShape();
            object2 = this.getFillRule();
            if (((String)object2).equalsIgnoreCase("nonzero")) {
                this.polyline.setWindingRule(1);
            } else {
                this.polyline.setWindingRule(0);
            }
            this.stroke = this.getStroke();
            this.fillPaint = this.getFillPaint();
            this.linePaint = this.getLinePaint();
            this.startMarker = this.getMarker("marker-start");
            this.midMarker = this.getMarker("marker-mid");
            this.endMarker = this.getMarker("marker-end");
            if (this.startMarker == null || this.midMarker == null || this.endMarker == null) {
                object = this.getMarker("marker");
                if (this.startMarker == null) {
                    this.startMarker = object;
                }
                if (this.midMarker == null) {
                    this.midMarker = object;
                }
                if (this.endMarker == null) {
                    this.endMarker = object;
                }
            }
        } else {
            if (this.fillPaint != null && this.fillPaint instanceof SVGTexturePaint && ((SVGTexturePaint)this.fillPaint).getTextureType() == 2) {
                this.fillPaint = this.getFillPaint();
            }
            if (this.linePaint != null && this.linePaint instanceof SVGTexturePaint && ((SVGTexturePaint)this.linePaint).getTextureType() == 2) {
                this.linePaint = this.getLinePaint();
            }
        }
        if (this.visible && this.display && this.opacity > 0.0f) {
            object2 = graphics2D.getTransform();
            object = graphics2D.getClip();
            if (this.thisTransform != null) {
                graphics2D.transform(this.thisTransform);
            }
            if (this.clipShape != null) {
                graphics2D.clip(this.clipShape);
            }
            if (this.opacity < 1.0f) {
                SVGSVGElement sVGSVGElement = this.getOwnerDoc().getRootElement();
                float f = sVGSVGElement.getCurrentScale();
                SVGPoint sVGPoint = sVGSVGElement.getCurrentTranslate();
                if (sVGPoint == null) {
                    sVGPoint = new SVGPointImpl();
                }
                Shape shape = this.getShape();
                AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
                Shape shape2 = affineTransform.createTransformedShape(shape);
                Rectangle2D rectangle2D = shape2.getBounds2D();
                double d = rectangle2D.getWidth() / 5.0;
                double d2 = rectangle2D.getHeight() / 5.0;
                rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d2, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d2);
                int n = (int)(rectangle2D.getWidth() * (double)f);
                int n2 = (int)(rectangle2D.getHeight() * (double)f);
                if (n > 0 && n2 > 0) {
                    Object object3;
                    BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
                    Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D2.setRenderingHints(renderingHints);
                    if (f != 1.0f) {
                        graphics2D2.scale(f, f);
                    }
                    graphics2D2.translate(-rectangle2D.getX(), -rectangle2D.getY());
                    graphics2D2.transform(affineTransform);
                    this.drawShape(graphics2D2, bl);
                    if (this.highlighted) {
                        graphics2D2.setPaint(Color.yellow);
                        object3 = this.getBBox();
                        graphics2D2.draw(new Rectangle2D.Float(object3.getX(), object3.getY(), object3.getWidth(), object3.getHeight()));
                    }
                    object3 = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
                    graphics2D.setComposite(alphaComposite);
                    AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY());
                    affineTransform2.scale(1.0f / f, 1.0f / f);
                    try {
                        affineTransform2.preConcatenate(affineTransform.createInverse());
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    graphics2D.drawImage(bufferedImage, affineTransform2, null);
                    graphics2D.setComposite((Composite)object3);
                    bufferedImage.flush();
                }
            } else {
                this.drawShape(graphics2D, bl);
                if (this.highlighted) {
                    graphics2D.setPaint(Color.yellow);
                    SVGRect sVGRect = this.getBBox();
                    graphics2D.draw(new Rectangle2D.Float(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight()));
                }
            }
            graphics2D.setTransform((AffineTransform)object2);
            graphics2D.setClip((Shape)object);
        }
    }

    private void drawShape(Graphics2D graphics2D, boolean bl) {
        SVGPoint sVGPoint;
        float f;
        float f2;
        float f3;
        SVGPoint sVGPoint2;
        graphics2D.setStroke(this.stroke);
        if (this.fillPaint != null) {
            graphics2D.setPaint(this.fillPaint);
            graphics2D.fill(this.polyline);
        }
        if (this.linePaint != null) {
            graphics2D.setPaint(this.linePaint);
            graphics2D.draw(this.polyline);
        }
        SVGPointList sVGPointList = this.getAnimatedPoints();
        int n = sVGPointList.getNumberOfItems();
        if (this.startMarker != null && n > 0) {
            sVGPoint2 = sVGPointList.getItem(0);
            f3 = sVGPoint2.getX();
            f2 = sVGPoint2.getY();
            f = 0.0f;
            if (n > 1) {
                sVGPoint = sVGPointList.getItem(1);
                f = SVGPointImpl.getAngleBetweenPoints(sVGPoint2, sVGPoint);
            }
            this.startMarker.drawMarker(graphics2D, this, f3, f2, f, this.stroke.getLineWidth(), bl);
        }
        if (this.midMarker != null) {
            int n2 = 1;
            while (n2 < n - 1) {
                SVGPoint sVGPoint3 = sVGPointList.getItem(n2);
                f2 = sVGPoint3.getX();
                f = sVGPoint3.getY();
                sVGPoint = sVGPointList.getItem(n2 - 1);
                SVGPoint sVGPoint4 = sVGPointList.getItem(n2 + 1);
                float f4 = SVGPointImpl.getAngleBetweenPoints(sVGPoint, sVGPoint3);
                float f5 = SVGPointImpl.getAngleBetweenPoints(sVGPoint3, sVGPoint4);
                float f6 = (f4 + f5) / 2.0f;
                this.midMarker.drawMarker(graphics2D, this, f2, f, f6, this.stroke.getLineWidth(), bl);
                ++n2;
            }
        }
        if (this.endMarker != null && n > 0) {
            sVGPoint2 = sVGPointList.getItem(n - 1);
            f3 = sVGPoint2.getX();
            f2 = sVGPoint2.getY();
            f = 0.0f;
            if (n > 1) {
                sVGPoint = sVGPointList.getItem(n - 2);
                f = SVGPointImpl.getAngleBetweenPoints(sVGPoint, sVGPoint2);
            }
            this.endMarker.drawMarker(graphics2D, this, f3, f2, f, this.stroke.getLineWidth(), bl);
        }
    }

    public Shape getShape() {
        if (this.polyline == null) {
            return this.createShape();
        }
        return this.polyline;
    }

    public SVGRect getBBox() {
        Shape shape = this.getShape();
        Rectangle2D rectangle2D = shape.getBounds2D();
        SVGRectImpl sVGRectImpl = new SVGRectImpl(rectangle2D);
        return sVGRectImpl;
    }

    public boolean contains(double d, double d2) {
        Shape shape = this.getShape();
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape2 = affineTransform.createTransformedShape(shape);
        double d3 = this.getOwnerDoc().getRootElement().getCurrentScale();
        return shape2.intersects(d - d3, d2 - d3, 2.0 * d3, 2.0 * d3);
    }

    public double boundingArea() {
        Shape shape = this.getShape();
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape2 = affineTransform.createTransformedShape(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        return rectangle2D.getWidth() * rectangle2D.getHeight();
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("points")) {
            this.getAnimatedPointList().addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

