/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import org.csiro.svg.dom.SVGAnimatedBooleanImpl;
import org.csiro.svg.dom.SVGAnimatedEnumerationImpl;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedStringImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGGradientElementImpl;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGTexturePaint;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGRadialGradientElement;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGTransformable;

public class SVGRadialGradientElementImpl
extends SVGGradientElementImpl
implements SVGRadialGradientElement {
    protected SVGAnimatedLength cx;
    protected SVGAnimatedLength cy;
    protected SVGAnimatedLength r;
    protected SVGAnimatedLength fx;
    protected SVGAnimatedLength fy;

    public SVGRadialGradientElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "radialGradient");
        super.setAttribute("cx", this.getCx().getBaseVal().getValueAsString());
        super.setAttribute("cy", this.getCy().getBaseVal().getValueAsString());
        super.setAttribute("r", this.getR().getBaseVal().getValueAsString());
        super.setAttribute("fx", this.getFx().getBaseVal().getValueAsString());
        super.setAttribute("fy", this.getFy().getBaseVal().getValueAsString());
    }

    public SVGRadialGradientElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "radialGradient");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGRadialGradientElementImpl sVGRadialGradientElementImpl = new SVGRadialGradientElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedLengthImpl)this.getCx()).getAnimations();
        Vector vector2 = ((SVGAnimatedLengthImpl)this.getCy()).getAnimations();
        Vector vector3 = ((SVGAnimatedLengthImpl)this.getR()).getAnimations();
        Vector vector4 = ((SVGAnimatedLengthImpl)this.getFx()).getAnimations();
        Vector vector5 = ((SVGAnimatedLengthImpl)this.getFy()).getAnimations();
        Vector vector6 = ((SVGAnimatedTransformListImpl)this.getGradientTransform()).getAnimations();
        Vector vector7 = ((SVGAnimatedEnumerationImpl)this.getGradientUnits()).getAnimations();
        Vector vector8 = ((SVGAnimatedEnumerationImpl)this.getSpreadMethod()).getAnimations();
        Vector vector9 = ((SVGAnimatedBooleanImpl)this.getExternalResourcesRequired()).getAnimations();
        Vector vector10 = ((SVGAnimatedStringImpl)this.getHref()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGRadialGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGRadialGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGRadialGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector4 != null) {
            n = 0;
            while (n < vector4.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector4.elementAt(n);
                sVGRadialGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector5 != null) {
            n = 0;
            while (n < vector5.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector5.elementAt(n);
                sVGRadialGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector6 != null) {
            n = 0;
            while (n < vector6.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector6.elementAt(n);
                sVGRadialGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector7 != null) {
            n = 0;
            while (n < vector7.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector7.elementAt(n);
                sVGRadialGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector8 != null) {
            n = 0;
            while (n < vector8.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector8.elementAt(n);
                sVGRadialGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector9 != null) {
            n = 0;
            while (n < vector9.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector9.elementAt(n);
                sVGRadialGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector10 != null) {
            n = 0;
            while (n < vector10.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector10.elementAt(n);
                sVGRadialGradientElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        return sVGRadialGradientElementImpl;
    }

    public SVGAnimatedLength getCx() {
        if (this.cx == null) {
            SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
            if (sVGGradientElementImpl != null && sVGGradientElementImpl instanceof SVGRadialGradientElementImpl) {
                return ((SVGRadialGradientElementImpl)sVGGradientElementImpl).getCx();
            }
            this.cx = new SVGAnimatedLengthImpl(new SVGLengthImpl("50%", (SVGElement)this, 0), this);
        }
        return this.cx;
    }

    public SVGAnimatedLength getCy() {
        if (this.cy == null) {
            SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
            if (sVGGradientElementImpl != null && sVGGradientElementImpl instanceof SVGRadialGradientElementImpl) {
                return ((SVGRadialGradientElementImpl)sVGGradientElementImpl).getCy();
            }
            this.cy = new SVGAnimatedLengthImpl(new SVGLengthImpl("50%", (SVGElement)this, 1), this);
        }
        return this.cy;
    }

    public SVGAnimatedLength getR() {
        if (this.r == null) {
            SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
            if (sVGGradientElementImpl != null && sVGGradientElementImpl instanceof SVGRadialGradientElementImpl) {
                return ((SVGRadialGradientElementImpl)sVGGradientElementImpl).getR();
            }
            this.r = new SVGAnimatedLengthImpl(new SVGLengthImpl("50%", (SVGElement)this, 2), this);
        }
        return this.r;
    }

    public SVGAnimatedLength getFx() {
        if (this.fx == null) {
            SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
            if (sVGGradientElementImpl != null && sVGGradientElementImpl instanceof SVGRadialGradientElementImpl) {
                return ((SVGRadialGradientElementImpl)sVGGradientElementImpl).getFx();
            }
            this.fx = new SVGAnimatedLengthImpl(new SVGLengthImpl(this.getCx().getBaseVal().getValueAsString(), (SVGElement)this, 0), this);
        }
        return this.fx;
    }

    public SVGAnimatedLength getFy() {
        if (this.fy == null) {
            SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
            if (sVGGradientElementImpl != null && sVGGradientElementImpl instanceof SVGRadialGradientElementImpl) {
                return ((SVGRadialGradientElementImpl)sVGGradientElementImpl).getFx();
            }
            this.fy = new SVGAnimatedLengthImpl(new SVGLengthImpl(this.getCy().getBaseVal().getValueAsString(), (SVGElement)this, 1), this);
        }
        return this.fy;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("cx")) {
            return this.getCx().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("cy")) {
            return this.getCy().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("r")) {
            return this.getR().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("fx")) {
            return this.getFx().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("fy")) {
            return this.getFy().getBaseVal().getValueAsString();
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("cx")) {
            attr.setValue(this.getCx().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("cy")) {
            attr.setValue(this.getCy().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("r")) {
            attr.setValue(this.getR().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("fx")) {
            attr.setValue(this.getFx().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("fy")) {
            attr.setValue(this.getFy().getBaseVal().getValueAsString());
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("cx")) {
            this.getCx().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("cy")) {
            this.getCy().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("r")) {
            this.getR().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("fx")) {
            this.getFx().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("fy")) {
            this.getFy().getBaseVal().setValueAsString(string2);
        }
    }

    public Paint getPaint(SVGElementImpl sVGElementImpl, float f) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        Object object2;
        float f2;
        float f3;
        float f4;
        float f5;
        Object object3;
        if (this.numStops() == 0 && this.getReferencedGradient() == null) {
            return null;
        }
        int[] nArray = new int[256];
        short s = this.getGradientUnits().getAnimVal();
        short s2 = this.getSpreadMethod().getAnimVal();
        SVGLength sVGLength = this.getCx().getAnimVal();
        SVGLength sVGLength2 = this.getCy().getAnimVal();
        SVGLength sVGLength3 = this.getR().getAnimVal();
        SVGLength sVGLength4 = this.getFx().getAnimVal();
        SVGLength sVGLength5 = this.getFy().getAnimVal();
        int n5 = 0;
        while (n5 < 256) {
            double d = (double)n5 / 255.0;
            object3 = this.getColorAtOffset(d);
            if (f < 1.0f) {
                object3 = new Color(((Color)object3).getRed(), ((Color)object3).getGreen(), ((Color)object3).getBlue(), (int)((float)((Color)object3).getAlpha() * f));
            }
            nArray[255 - n5] = ((Color)object3).getRGB();
            ++n5;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, nArray, 0, true, -1, 0);
        object3 = s == 1 ? sVGElementImpl.getOwnerSVGElement() : this.getOwnerSVGElement();
        SVGRect sVGRect = object3.getViewBox().getAnimVal();
        if (sVGRect == null) {
            sVGRect = object3.getViewport();
        }
        SVGRect sVGRect2 = null;
        sVGRect2 = sVGElementImpl instanceof SVGTransformable ? ((SVGTransformable)((Object)sVGElementImpl)).getBBox() : sVGRect;
        float f6 = 1.0f;
        float f7 = 1.0f;
        if (s == 2) {
            f5 = sVGRect2.getX();
            f4 = sVGRect2.getY();
            f3 = sVGRect2.getWidth();
            if (f3 > (f2 = sVGRect2.getHeight())) {
                f7 = f2 / f3;
                f2 = f3;
            } else if (f2 > f3) {
                f6 = f3 / f2;
                f3 = f2;
            }
        } else {
            f5 = sVGRect.getX();
            f4 = sVGRect.getY();
            f3 = sVGRect.getWidth();
            f2 = sVGRect.getHeight();
        }
        double d = sVGLength.getUnitType() == 2 ? (double)f5 + (double)sVGLength.getValueInSpecifiedUnits() / 100.0 * (double)f3 : (s == 1 ? (double)sVGLength.getValue() : (double)(f5 + sVGLength.getValue() * f3));
        double d2 = sVGLength2.getUnitType() == 2 ? (double)f4 + (double)sVGLength2.getValueInSpecifiedUnits() / 100.0 * (double)f2 : (s == 1 ? (double)sVGLength2.getValue() : (double)(f4 + sVGLength2.getValue() * f2));
        double d3 = sVGLength4.getUnitType() == 2 ? (double)f5 + (double)sVGLength4.getValueInSpecifiedUnits() / 100.0 * (double)f3 : (s == 1 ? (double)sVGLength4.getValue() : (double)(f5 + sVGLength4.getValue() * f3));
        double d4 = sVGLength5.getUnitType() == 2 ? (double)f4 + (double)sVGLength5.getValueInSpecifiedUnits() / 100.0 * (double)f2 : (s == 1 ? (double)sVGLength5.getValue() : (double)(f4 + sVGLength5.getValue() * f2));
        double d5 = sVGLength3.getUnitType() == 2 ? ((double)sVGLength3.getValueInSpecifiedUnits() / 100.0 * (double)f3 + (double)sVGLength3.getValueInSpecifiedUnits() / 100.0 * (double)f2) / 2.0 : (s == 1 ? (double)sVGLength3.getValue() : (double)(sVGLength3.getValue() * f3 + sVGLength3.getValue() * f2) / 2.0);
        double d6 = Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        AffineTransform affineTransform = ((SVGTransformListImpl)this.getGradientTransform().getAnimVal()).getAffineTransform();
        if (f6 != 1.0f || f7 != 1.0f) {
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(-f5, -f4));
            affineTransform.preConcatenate(AffineTransform.getScaleInstance(f6, f7));
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(f5, f4));
        }
        try {
            object2 = affineTransform.createInverse();
            object = new Rectangle2D.Double(f5, f4, f3, f2);
            Shape shape = ((AffineTransform)object2).createTransformedShape((Shape)object);
            Rectangle2D rectangle2D = shape.getBounds2D();
            n4 = (int)rectangle2D.getMinX();
            n3 = (int)rectangle2D.getMinY();
            n2 = (int)rectangle2D.getMaxX();
            n = (int)rectangle2D.getMaxY();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            n4 = (int)f5;
            n3 = (int)f4;
            n2 = (int)(f5 + f3);
            n = (int)(f4 + f2);
        }
        object2 = new BufferedImage(n2 - n4 + 1, n - n3 + 1, 13, indexColorModel);
        object = ((BufferedImage)object2).getRaster();
        double d7 = d - d3;
        double d8 = d2 - d4;
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        if (d9 > d5) {
            System.out.println("Radial Gradient focal point outside circle!! ");
            return null;
        }
        if (d9 < 1.0E-10) {
            int n6 = n4;
            while (n6 <= n2) {
                int n7 = n3;
                while (n7 <= n) {
                    double d10 = (double)n6 - d3;
                    double d11 = (double)n7 - d4;
                    double d12 = Math.sqrt(d10 * d10 + d11 * d11);
                    double d13 = d12 / d5;
                    if (Math.abs(d13) > 2.0 && s2 != 1) {
                        int n8 = (int)(d13 / 2.0);
                        d13 -= (double)(2 * n8);
                    }
                    if (d13 > 1.0) {
                        d13 = s2 == 3 ? (d13 -= 1.0) : (s2 == 2 ? 2.0 - d13 : 1.0);
                    }
                    if (d13 < 0.0) {
                        d13 = 0.0;
                    }
                    if (d13 > 1.0) {
                        d13 = 1.0;
                    }
                    ((WritableRaster)object).setSample(n6 - n4, n7 - n3, 0, 255 - (int)(d13 * 255.0));
                    ++n7;
                }
                ++n6;
            }
        } else {
            int n9;
            int n10;
            double[] dArray = new double[2 * (n2 - n4 + 1) + (n - n3 + 1)];
            int n11 = (int)d3;
            int n12 = 0;
            double[] dArray2 = new double[2 * (n2 - n4 + 1) + (n - n3 + 1)];
            int n13 = Math.min(Math.max(n11, n4), n2);
            int n14 = n13 + 1;
            while (n14 <= n2) {
                this.findBoundaryDistance(n14, n3, dArray, dArray2, n12++, d, d2, d3, d4, d5, d6);
                ++n14;
            }
            if (n13 < n2) {
                n10 = n3;
                while (n10 <= n) {
                    this.findBoundaryDistance(n2, n10, dArray, dArray2, n12++, d, d2, d3, d4, d5, d6);
                    ++n10;
                }
            }
            n10 = n2;
            while (n10 >= n13 + 1) {
                this.findBoundaryDistance(n10, n, dArray, dArray2, n12++, d, d2, d3, d4, d5, d6);
                --n10;
            }
            int n15 = n2;
            int n16 = n3;
            int n17 = n;
            this.scanBlock(new Point(n4, n3), new Rectangle(n13, n16, n15 - n13, n17 - n16), dArray, dArray2, n12 - 1, (WritableRaster)object, d, d2, d3, d4, d5, d6, s2);
            n12 = 0;
            int n18 = n13 - 1;
            while (n18 >= n4) {
                this.findBoundaryDistance(n18, n - 1, dArray, dArray2, n12++, d, d2, d3, d4, d5, d6);
                --n18;
            }
            if (n13 > n4) {
                n9 = n;
                while (n9 >= n3) {
                    this.findBoundaryDistance(n4, n9, dArray, dArray2, n12++, d, d2, d3, d4, d5, d6);
                    --n9;
                }
            }
            n9 = n4;
            while (n9 < n13) {
                this.findBoundaryDistance(n9, n3, dArray, dArray2, n12++, d, d2, d3, d4, d5, d6);
                ++n9;
            }
            int n19 = n4;
            this.scanBlock(new Point(n4, n3), new Rectangle(n19, n16, n13 - n19, n17 - n16), dArray, dArray2, n12 - 1, (WritableRaster)object, d, d2, d3, d4, d5, d6, s2);
            if (n13 >= n4 && n13 <= n2) {
                double d14;
                double d15 = Math.sqrt(d5 * d5 - (d3 - d) * (d3 - d));
                int n20 = (int)d4;
                double d16 = d15 + d4 - d2;
                int n21 = n3;
                while (n21 <= n20) {
                    d14 = (double)(n20 - n21) / d16;
                    double d17 = this.getColorPercentage(d14, s2);
                    ((WritableRaster)object).setSample(n13 - n4, n21 - n3, 0, 255 - (int)(d17 * 255.0));
                    ++n21;
                }
                d16 = d15 + d2 - d4;
                int n22 = n20 + 1;
                while (n22 <= n) {
                    d14 = (double)(n22 - n20) / d16;
                    double d18 = this.getColorPercentage(d14, s2);
                    ((WritableRaster)object).setSample(n13 - n4, n22 - n3, 0, 255 - (int)(d18 * 255.0));
                    ++n22;
                }
            }
        }
        SVGTexturePaint sVGTexturePaint = new SVGTexturePaint((BufferedImage)object2, new Rectangle2D.Float(n4, n3, n2 - n4 + 1, n - n3 + 1), affineTransform, 0);
        return sVGTexturePaint;
    }

    double getColorPercentage(double d, short s) {
        double d2 = d;
        if (Math.abs(d2) > 2.0 && s != 1) {
            int n = (int)(d2 / 2.0);
            d2 -= (double)(2 * n);
        }
        if (d2 > 1.0) {
            d2 = s == 3 ? (d2 -= 1.0) : (s == 2 ? 2.0 - d2 : 1.0);
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        return d2;
    }

    public void findBoundaryDistance(int n, int n2, double[] dArray, double[] dArray2, int n3, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d - d3;
        double d8 = (double)n - d3;
        double d9 = d2 - d4;
        double d10 = (double)n2 - d4;
        double d11 = Math.sqrt(d8 * d8 + d10 * d10);
        double d12 = (d7 * d8 + d9 * d10) / (d6 * d11);
        if (d12 > 1.0) {
            d12 = 1.0;
        }
        if (d12 < -1.0) {
            d12 = -1.0;
        }
        double d13 = d6 * d12;
        double d14 = Math.sqrt(d5 * d5 - d6 * d6 + d13 * d13);
        dArray[n3] = d14 + d13;
        dArray2[n3] = d10 / d8;
    }

    public void scanBlock(Point point, Rectangle rectangle, double[] dArray, double[] dArray2, int n, WritableRaster writableRaster, double d, double d2, double d3, double d4, double d5, double d6, short s) {
        int n2;
        int n3;
        int n4 = rectangle.x;
        int n5 = rectangle.x + rectangle.width;
        int n6 = rectangle.y;
        int n7 = rectangle.y + rectangle.height;
        if (n5 <= (int)d3) {
            n3 = n7 - 1;
            n2 = -1;
        } else {
            n3 = n6;
            n2 = 1;
        }
        int n8 = n5 - 1;
        while (n8 >= n4) {
            int n9 = 0;
            int n10 = n3;
            while (n10 != n3 + n2 * rectangle.height) {
                double d7 = (double)n8 - d3;
                double d8 = (double)n10 - d4;
                double d9 = d8 / d7;
                double d10 = Math.sqrt(d7 * d7 + d8 * d8);
                while (n9 < n && dArray2[n9] < d9) {
                    ++n9;
                }
                double d11 = d10 / dArray[n9];
                double d12 = this.getColorPercentage(d11, s);
                writableRaster.setSample(n8 - point.x, n10 - point.y, 0, 255 - (int)(d12 * 255.0));
                n10 += n2;
            }
            --n8;
        }
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("cx")) {
            ((SVGAnimatedValue)((Object)this.getCx())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("cy")) {
            ((SVGAnimatedValue)((Object)this.getCy())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("r")) {
            ((SVGAnimatedValue)((Object)this.getR())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("fx")) {
            ((SVGAnimatedValue)((Object)this.getFx())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("fy")) {
            ((SVGAnimatedValue)((Object)this.getFy())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

