/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.csiro.svg.dom.BasicShape;
import org.csiro.svg.dom.Drawable;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGClipPathElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGGraphic;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGMatrixImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGTexturePaint;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGRectElement;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGRectElementImpl
extends SVGGraphic
implements SVGRectElement,
Drawable,
BasicShape {
    protected SVGAnimatedLength x;
    protected SVGAnimatedLength y;
    protected SVGAnimatedLength width;
    protected SVGAnimatedLength height;
    protected SVGAnimatedLength rx;
    protected SVGAnimatedLength ry;
    boolean visible = true;
    boolean display = true;
    float opacity = 1.0f;
    Shape clipShape = null;
    Shape shape = null;
    BasicStroke stroke = null;
    Paint fillPaint = null;
    Paint linePaint = null;
    AffineTransform thisTransform = null;
    SVGClipPathElementImpl clipPath = null;

    public SVGRectElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "rect");
        super.setAttribute("x", this.getX().getBaseVal().getValueAsString());
        super.setAttribute("y", this.getY().getBaseVal().getValueAsString());
        super.setAttribute("width", this.getWidth().getBaseVal().getValueAsString());
        super.setAttribute("height", this.getHeight().getBaseVal().getValueAsString());
        super.setAttribute("rx", this.getRx().getBaseVal().getValueAsString());
        super.setAttribute("ry", this.getRy().getBaseVal().getValueAsString());
    }

    public SVGRectElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "rect");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGRectElementImpl sVGRectElementImpl = new SVGRectElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedLengthImpl)this.getX()).getAnimations();
        Vector vector2 = ((SVGAnimatedLengthImpl)this.getY()).getAnimations();
        Vector vector3 = ((SVGAnimatedLengthImpl)this.getWidth()).getAnimations();
        Vector vector4 = ((SVGAnimatedLengthImpl)this.getHeight()).getAnimations();
        Vector vector5 = ((SVGAnimatedLengthImpl)this.getRx()).getAnimations();
        Vector vector6 = ((SVGAnimatedLengthImpl)this.getRy()).getAnimations();
        Vector vector7 = ((SVGAnimatedTransformListImpl)this.getTransform()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGRectElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGRectElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGRectElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector4 != null) {
            n = 0;
            while (n < vector4.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector4.elementAt(n);
                sVGRectElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector5 != null) {
            n = 0;
            while (n < vector5.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector5.elementAt(n);
                sVGRectElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector6 != null) {
            n = 0;
            while (n < vector6.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector6.elementAt(n);
                sVGRectElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector7 != null) {
            n = 0;
            while (n < vector7.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector7.elementAt(n);
                sVGRectElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGRectElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGRectElementImpl;
    }

    public SVGAnimatedLength getX() {
        if (this.x == null) {
            this.x = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 0), this);
        }
        return this.x;
    }

    public SVGAnimatedLength getY() {
        if (this.y == null) {
            this.y = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 1), this);
        }
        return this.y;
    }

    public SVGAnimatedLength getWidth() {
        if (this.width == null) {
            this.width = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 0), this);
        }
        return this.width;
    }

    public SVGAnimatedLength getHeight() {
        if (this.height == null) {
            this.height = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 1), this);
        }
        return this.height;
    }

    public SVGAnimatedLength getRx() {
        if (this.rx == null) {
            this.rx = this.ry == null ? new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 0), this) : new SVGAnimatedLengthImpl(new SVGLengthImpl(this.ry.getBaseVal().getValueAsString(), (SVGElement)this, 0), this);
        }
        return this.rx;
    }

    public SVGAnimatedLength getRy() {
        if (this.ry == null) {
            this.ry = this.rx == null ? new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 0), this) : new SVGAnimatedLengthImpl(new SVGLengthImpl(this.rx.getBaseVal().getValueAsString(), (SVGElement)this, 1), this);
        }
        return this.ry;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("x")) {
            return this.getX().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("y")) {
            return this.getY().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("width")) {
            return this.getWidth().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("height")) {
            return this.getHeight().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("rx")) {
            return this.getRx().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("ry")) {
            return this.getRy().getBaseVal().getValueAsString();
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("x")) {
            attr.setValue(this.getX().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("y")) {
            attr.setValue(this.getY().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("width")) {
            attr.setValue(this.getWidth().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("height")) {
            attr.setValue(this.getHeight().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("rx")) {
            attr.setValue(this.getRx().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("ry")) {
            attr.setValue(this.getRy().getBaseVal().getValueAsString());
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("x")) {
            this.getX().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("y")) {
            this.getY().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("width")) {
            this.getWidth().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("height")) {
            this.getHeight().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("rx")) {
            this.getRx().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("ry")) {
            this.getRy().getBaseVal().setValueAsString(string2);
        }
    }

    private Shape createShape(AffineTransform affineTransform) {
        RectangularShape rectangularShape;
        AffineTransform affineTransform2;
        try {
            affineTransform2 = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            affineTransform2 = null;
        }
        float f = ((SVGLengthImpl)this.getX().getAnimVal()).getTransformedLength(affineTransform2);
        float f2 = ((SVGLengthImpl)this.getY().getAnimVal()).getTransformedLength(affineTransform2);
        float f3 = ((SVGLengthImpl)this.getRx().getAnimVal()).getTransformedLength(affineTransform2);
        float f4 = ((SVGLengthImpl)this.getRy().getAnimVal()).getTransformedLength(affineTransform2);
        float f5 = ((SVGLengthImpl)this.getWidth().getAnimVal()).getTransformedLength(affineTransform2);
        float f6 = ((SVGLengthImpl)this.getHeight().getAnimVal()).getTransformedLength(affineTransform2);
        if (f3 > 0.0f || f4 > 0.0f) {
            if (f3 > 0.0f && f4 == 0.0f) {
                f4 = f3;
            } else if (f3 == 0.0f && f4 > 0.0f) {
                f3 = f4;
            }
            rectangularShape = new RoundRectangle2D.Float(f, f2, f5, f6, f3 * 2.0f, f4 * 2.0f);
        } else {
            rectangularShape = new Rectangle2D.Float(f, f2, f5, f6);
        }
        return rectangularShape;
    }

    public void draw(Graphics2D graphics2D, boolean bl) {
        if (bl || this.shape == null) {
            this.refreshData();
            this.visible = this.getVisibility();
            this.opacity = this.getOpacity();
            this.display = this.getDisplay();
            this.clipPath = this.getClippingPath();
            this.clipShape = null;
            if (this.clipPath != null) {
                this.clipShape = this.clipPath.getClippingShape(this);
            }
            this.thisTransform = ((SVGTransformListImpl)this.getTransform().getAnimVal()).getAffineTransform();
            this.shape = this.createShape(((SVGMatrixImpl)this.getCTM()).getAffineTransform());
            this.stroke = this.getStroke();
            this.fillPaint = this.getFillPaint();
            this.linePaint = this.getLinePaint();
        } else {
            if (this.fillPaint != null && this.fillPaint instanceof SVGTexturePaint && ((SVGTexturePaint)this.fillPaint).getTextureType() == 2) {
                this.fillPaint = this.getFillPaint();
            }
            if (this.linePaint != null && this.linePaint instanceof SVGTexturePaint && ((SVGTexturePaint)this.linePaint).getTextureType() == 2) {
                this.linePaint = this.getLinePaint();
            }
        }
        if (this.visible && this.display && this.opacity > 0.0f) {
            AffineTransform affineTransform = graphics2D.getTransform();
            Shape shape = graphics2D.getClip();
            graphics2D.transform(this.thisTransform);
            if (this.clipShape != null) {
                graphics2D.clip(this.clipShape);
            }
            if (this.opacity < 1.0f) {
                SVGSVGElement sVGSVGElement = this.getOwnerDoc().getRootElement();
                float f = sVGSVGElement.getCurrentScale();
                SVGPoint sVGPoint = sVGSVGElement.getCurrentTranslate();
                if (sVGPoint == null) {
                    sVGPoint = new SVGPointImpl();
                }
                Shape shape2 = this.getShape();
                AffineTransform affineTransform2 = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
                Shape shape3 = affineTransform2.createTransformedShape(shape2);
                Rectangle2D rectangle2D = shape3.getBounds2D();
                double d = rectangle2D.getWidth() / 5.0;
                double d2 = rectangle2D.getHeight() / 5.0;
                rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d2, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d2);
                int n = (int)(rectangle2D.getWidth() * (double)f);
                int n2 = (int)(rectangle2D.getHeight() * (double)f);
                if (n > 0 && n2 > 0) {
                    Object object;
                    BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
                    Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D2.setRenderingHints(renderingHints);
                    if (f != 1.0f) {
                        graphics2D2.scale(f, f);
                    }
                    graphics2D2.translate(-rectangle2D.getX(), -rectangle2D.getY());
                    graphics2D2.transform(affineTransform2);
                    graphics2D2.setStroke(this.stroke);
                    if (this.fillPaint != null) {
                        graphics2D2.setPaint(this.fillPaint);
                        graphics2D2.fill(shape2);
                    }
                    if (this.linePaint != null) {
                        graphics2D2.setPaint(this.linePaint);
                        graphics2D2.draw(shape2);
                    }
                    if (this.highlighted) {
                        graphics2D2.setPaint(Color.yellow);
                        object = this.getBBox();
                        graphics2D2.draw(new Rectangle2D.Float(object.getX(), object.getY(), object.getWidth(), object.getHeight()));
                    }
                    object = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
                    graphics2D.setComposite(alphaComposite);
                    AffineTransform affineTransform3 = AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY());
                    affineTransform3.scale(1.0f / f, 1.0f / f);
                    try {
                        affineTransform3.preConcatenate(affineTransform2.createInverse());
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    graphics2D.drawImage(bufferedImage, affineTransform3, null);
                    graphics2D.setComposite((Composite)object);
                    bufferedImage.flush();
                }
            } else {
                graphics2D.setStroke(this.stroke);
                if (this.fillPaint != null) {
                    graphics2D.setPaint(this.fillPaint);
                    graphics2D.fill(this.shape);
                }
                if (this.linePaint != null) {
                    graphics2D.setPaint(this.linePaint);
                    graphics2D.draw(this.shape);
                }
                if (this.highlighted) {
                    graphics2D.setPaint(Color.yellow);
                    SVGRect sVGRect = this.getBBox();
                    graphics2D.draw(new Rectangle2D.Float(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight()));
                }
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
        }
    }

    public Shape getShape() {
        if (this.shape == null) {
            AffineTransform affineTransform = ((SVGMatrixImpl)this.getCTM()).getAffineTransform();
            return this.createShape(affineTransform);
        }
        return this.shape;
    }

    public SVGRect getBBox() {
        Shape shape = this.getShape();
        Rectangle2D rectangle2D = shape.getBounds2D();
        SVGRectImpl sVGRectImpl = new SVGRectImpl(rectangle2D);
        return sVGRectImpl;
    }

    public boolean contains(double d, double d2) {
        Shape shape = this.getShape();
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2.contains(d, d2);
    }

    public double boundingArea() {
        Shape shape = this.getShape();
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape2 = affineTransform.createTransformedShape(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        return rectangle2D.getWidth() * rectangle2D.getHeight();
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("x")) {
            ((SVGAnimatedValue)((Object)this.getX())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("y")) {
            ((SVGAnimatedValue)((Object)this.getY())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("width")) {
            ((SVGAnimatedValue)((Object)this.getWidth())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("height")) {
            ((SVGAnimatedValue)((Object)this.getHeight())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("rx")) {
            ((SVGAnimatedValue)((Object)this.getRx())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("ry")) {
            ((SVGAnimatedValue)((Object)this.getRy())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

