/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.csiro.svg.dom.BasicShape;
import org.csiro.svg.dom.Drawable;
import org.csiro.svg.dom.SVGAElementImpl;
import org.csiro.svg.dom.SVGAngleImpl;
import org.csiro.svg.dom.SVGAnimatedBooleanImpl;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedPreserveAspectRatioImpl;
import org.csiro.svg.dom.SVGAnimatedRectImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGClipPathElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGGElementImpl;
import org.csiro.svg.dom.SVGImageElementImpl;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGLocatableImpl;
import org.csiro.svg.dom.SVGMatrixImpl;
import org.csiro.svg.dom.SVGNumberImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGPreserveAspectRatioImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGStringListImpl;
import org.csiro.svg.dom.SVGTransformImpl;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.csiro.svg.dom.SVGUseElementImpl;
import org.csiro.svg.dom.events.EventFactory;
import org.csiro.svg.dom.events.ScriptEventListener;
import org.csiro.svg.viewer.Canvas;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.svg.SVGAngle;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGImageElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGStringList;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformable;
import org.w3c.dom.svg.SVGUseElement;
import org.w3c.dom.svg.SVGViewSpec;
import org.w3c.dom.views.DocumentView;

public class SVGSVGElementImpl
extends SVGLocatableImpl
implements SVGSVGElement,
Drawable {
    protected SVGAnimatedLength x;
    protected SVGAnimatedLength y;
    protected SVGAnimatedLength width;
    protected SVGAnimatedLength height;
    protected SVGAnimatedRect viewBox;
    protected SVGAnimatedPreserveAspectRatio preserveAspectRatio;
    protected SVGAnimatedBoolean externalResourcesRequired;
    protected SVGRect viewport;
    protected boolean useCurrentView = false;
    protected SVGViewSpec currentView;
    protected float currentScale = 1.0f;
    protected SVGPoint currentTranslate = new SVGPointImpl();
    protected boolean animationsPaused;
    AffineTransform viewboxToViewportTransform;
    protected boolean changed = true;
    private float pauseTime;
    private float offsetTime = 0.0f;
    NodeList styles = null;
    int numStyles = 0;
    protected SVGStringListImpl requiredFeatures;
    protected SVGStringListImpl requiredExtensions;
    protected SVGStringListImpl systemLanguage;
    Hashtable eventListeners;

    public SVGSVGElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "svg");
        super.setAttribute("x", "0");
        super.setAttribute("y", "0");
        super.setAttribute("width", "600");
        super.setAttribute("height", "600");
        super.setAttribute("preserveAspectRatio", ((SVGPreserveAspectRatioImpl)this.getPreserveAspectRatio().getBaseVal()).toString());
        this.viewport = new SVGRectImpl();
        this.viewport.setWidth(this.getWidth().getBaseVal().getValue());
        this.viewport.setHeight(this.getHeight().getBaseVal().getValue());
        SVGRectImpl sVGRectImpl = new SVGRectImpl();
        sVGRectImpl.setWidth(this.getWidth().getBaseVal().getValue());
        sVGRectImpl.setHeight(this.getHeight().getBaseVal().getValue());
        ((SVGAnimatedRectImpl)this.getViewBox()).setBaseVal(sVGRectImpl);
        this.recalculateViewboxToViewportTransform(-1.0, -1.0);
    }

    public SVGSVGElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "svg");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGSVGElementImpl sVGSVGElementImpl = new SVGSVGElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedLengthImpl)this.getX()).getAnimations();
        Vector vector2 = ((SVGAnimatedLengthImpl)this.getY()).getAnimations();
        Vector vector3 = ((SVGAnimatedLengthImpl)this.getWidth()).getAnimations();
        Vector vector4 = ((SVGAnimatedLengthImpl)this.getHeight()).getAnimations();
        Vector vector5 = ((SVGAnimatedRectImpl)this.getViewBox()).getAnimations();
        Vector vector6 = ((SVGAnimatedPreserveAspectRatioImpl)this.getPreserveAspectRatio()).getAnimations();
        Vector vector7 = ((SVGAnimatedBooleanImpl)this.getExternalResourcesRequired()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGSVGElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGSVGElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGSVGElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector4 != null) {
            n = 0;
            while (n < vector4.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector4.elementAt(n);
                sVGSVGElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector5 != null) {
            n = 0;
            while (n < vector5.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector5.elementAt(n);
                sVGSVGElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector6 != null) {
            n = 0;
            while (n < vector6.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector6.elementAt(n);
                sVGSVGElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector7 != null) {
            n = 0;
            while (n < vector7.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector7.elementAt(n);
                sVGSVGElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGSVGElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGSVGElementImpl;
    }

    public AffineTransform getViewboxToViewportTransform() {
        return this.viewboxToViewportTransform;
    }

    private void recalculateViewboxToViewportTransform(double d, double d2) {
        short s = this.getWidth().getBaseVal().getUnitType();
        this.getWidth().getBaseVal();
        if (s == 2) {
            float f;
            if (d > 0.0) {
                f = (float)(d * 0.01 * (double)this.getWidth().getBaseVal().getValue());
                this.getViewport().setWidth(f);
            }
            if (d2 > 0.0) {
                f = (float)(d2 * 0.01 * (double)this.getHeight().getBaseVal().getValue());
                this.getViewport().setHeight(f);
            }
        }
        this.viewboxToViewportTransform = new AffineTransform();
        short s2 = this.getPreserveAspectRatio().getAnimVal().getAlign();
        short s3 = this.getPreserveAspectRatio().getAnimVal().getMeetOrSlice();
        float f = this.getViewport().getWidth() / this.getViewBox().getAnimVal().getWidth();
        float f2 = this.getViewport().getHeight() / this.getViewBox().getAnimVal().getHeight();
        if (s2 == 1) {
            this.viewboxToViewportTransform.scale(f, f2);
            float f3 = -this.getViewBox().getAnimVal().getX();
            float f4 = -this.getViewBox().getAnimVal().getY();
            this.viewboxToViewportTransform.translate(f3, f4);
        } else {
            float f5;
            float f6;
            float f7 = s3 == 1 ? Math.min(f, f2) : Math.max(f, f2);
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = this.getViewport().getWidth();
            float f11 = this.getViewport().getHeight();
            float f12 = this.getViewBox().getAnimVal().getX();
            float f13 = this.getViewBox().getAnimVal().getY();
            float f14 = this.getViewBox().getAnimVal().getWidth();
            float f15 = this.getViewBox().getAnimVal().getHeight();
            if (s3 == 1) {
                if (f2 < f) {
                    f6 = f9 / f7 - f13;
                    f5 = s2 == 2 || s2 == 5 || s2 == 8 ? f8 / f7 - f12 : (s2 == 3 || s2 == 6 || s2 == 9 ? (f8 + f10 / 2.0f) / f7 - (f12 + f14 / 2.0f) : f8 + f10 / f7 - (f12 + f14));
                } else {
                    f5 = f8 / f7 - f12;
                    f6 = s2 == 2 || s2 == 3 || s2 == 4 ? f9 / f7 - f13 : (s2 == 5 || s2 == 6 || s2 == 7 ? (f9 + f11 / 2.0f) / f7 - (f13 + f15 / 2.0f) : (f9 + f11) / f7 - (f13 + f15));
                }
            } else if (f2 > f) {
                f6 = f9 / f7 - f13;
                f5 = s2 == 2 || s2 == 5 || s2 == 8 ? f8 / f7 - f12 : (s2 == 3 || s2 == 6 || s2 == 9 ? (f8 + f10 / 2.0f) / f7 - (f12 + f14 / 2.0f) : (f8 + f10) / f7 - (f12 + f14));
            } else {
                f5 = f8 - f12 * f7;
                f6 = s2 == 2 || s2 == 3 || s2 == 4 ? f9 / f7 - f13 : (s2 == 5 || s2 == 6 || s2 == 7 ? (f9 + f11 / 2.0f) / f7 - (f13 + f15 / 2.0f) : (f9 + f11) / f7 - (f13 + f15));
            }
            this.viewboxToViewportTransform.scale(f7, f7);
            this.viewboxToViewportTransform.translate(f5, f6);
        }
    }

    public SVGAnimatedLength getX() {
        if (this.x == null) {
            this.x = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 0), this);
        }
        return this.x;
    }

    public SVGAnimatedLength getY() {
        if (this.y == null) {
            this.y = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 1), this);
        }
        return this.y;
    }

    public SVGAnimatedLength getWidth() {
        if (this.width == null) {
            this.width = this.getParentNode() == this.ownerDoc && this.ownerDoc.getDefaultView() != null ? new SVGAnimatedLengthImpl(new SVGLengthImpl(((Canvas)this.ownerDoc.getDefaultView()).getWidth(), (SVGElement)this, 0), this) : new SVGAnimatedLengthImpl(new SVGLengthImpl("100%", (SVGElement)this, 0), this);
        }
        return this.width;
    }

    public SVGAnimatedLength getHeight() {
        if (this.height == null) {
            this.height = this.getParentNode() == this.ownerDoc && this.ownerDoc.getDefaultView() != null ? new SVGAnimatedLengthImpl(new SVGLengthImpl(((Canvas)this.ownerDoc.getDefaultView()).getHeight(), (SVGElement)this, 1), this) : new SVGAnimatedLengthImpl(new SVGLengthImpl("100%", (SVGElement)this, 1), this);
        }
        return this.height;
    }

    public String getContentScriptType() {
        return this.getAttribute("contentScriptType");
    }

    public void setContentScriptType(String string) throws DOMException {
        this.setAttribute("contentScriptType", string);
    }

    public String getContentStyleType() {
        return this.getAttribute("contentStyleType");
    }

    public void setContentStyleType(String string) throws DOMException {
        this.setAttribute("contentStyleType", string);
    }

    public SVGRect getViewport() {
        if (this.viewport == null) {
            this.viewport = new SVGRectImpl();
            this.viewport.setX(this.getX().getBaseVal().getValue());
            this.viewport.setY(this.getY().getBaseVal().getValue());
            this.viewport.setWidth(this.getWidth().getBaseVal().getValue());
            this.viewport.setHeight(this.getHeight().getBaseVal().getValue());
        }
        return this.viewport;
    }

    public float getPixelUnitToMillimeterX() {
        return 0.28f;
    }

    public float getPixelUnitToMillimeterY() {
        return 0.28f;
    }

    public float getScreenPixelToMillimeterX() {
        return 0.28f;
    }

    public float getScreenPixelToMillimeterY() {
        return 0.28f;
    }

    public boolean getUseCurrentView() {
        return this.useCurrentView;
    }

    public void setUseCurrentView(boolean bl) throws DOMException {
        this.useCurrentView = bl;
    }

    public SVGViewSpec getCurrentView() {
        return this.currentView;
    }

    public float getCurrentScale() {
        return this.currentScale;
    }

    public void setCurrentScale(float f) throws DOMException {
        this.currentScale = f;
        this.changed = true;
    }

    public SVGPoint getCurrentTranslate() {
        return this.currentTranslate;
    }

    public void setCurrentTranslate(SVGPoint sVGPoint) throws DOMException {
        this.currentTranslate = sVGPoint;
        this.changed = true;
    }

    public int suspendRedraw(int n) {
        int n2 = 1;
        return n2;
    }

    public void unsuspendRedraw(int n) throws DOMException {
    }

    public void unsuspendRedrawAll() {
    }

    public void forceRedraw() {
    }

    public void pauseAnimations() {
        this.pauseTime = this.getCurrentTime();
        this.animationsPaused = true;
    }

    public void unpauseAnimations() {
        if (this.animationsPaused) {
            this.setCurrentTime(this.pauseTime);
        }
        this.animationsPaused = false;
    }

    public boolean animationsPaused() {
        return this.animationsPaused;
    }

    public float getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        double d = (double)calendar.getTime().getTime() / 1000.0;
        double d2 = this.getOwnerDoc().getBeginTime();
        return (float)(d - this.getOwnerDoc().getBeginTime() + (double)this.offsetTime);
    }

    public void setCurrentTime(float f) {
        Calendar calendar = Calendar.getInstance();
        float f2 = (float)((double)calendar.getTime().getTime() / 1000.0);
        this.offsetTime = f - f2;
    }

    public NodeList getIntersectionList(SVGRect sVGRect, SVGElement sVGElement) {
        return null;
    }

    public NodeList getEnclosureList(SVGRect sVGRect, SVGElement sVGElement) {
        return null;
    }

    public boolean checkIntersection(SVGElement sVGElement, SVGRect sVGRect) {
        return false;
    }

    public boolean checkEnclosure(SVGElement sVGElement, SVGRect sVGRect) {
        return false;
    }

    public void deselectAll() {
    }

    public SVGLength createSVGLength() {
        return new SVGLengthImpl();
    }

    public SVGAngle createSVGAngle() {
        return new SVGAngleImpl();
    }

    public SVGPoint createSVGPoint() {
        return new SVGPointImpl();
    }

    public SVGMatrix createSVGMatrix() {
        return new SVGMatrixImpl();
    }

    public SVGNumber createSVGNumber() {
        return new SVGNumberImpl();
    }

    public SVGRect createSVGRect() {
        return new SVGRectImpl();
    }

    public String createSVGString() {
        return new String();
    }

    public SVGTransform createSVGTransform() {
        return new SVGTransformImpl();
    }

    public SVGTransform createSVGTransformFromMatrix(SVGMatrix sVGMatrix) {
        SVGTransformImpl sVGTransformImpl = new SVGTransformImpl();
        sVGTransformImpl.setMatrix(sVGMatrix);
        return sVGTransformImpl;
    }

    public Element getElementById(String string) {
        if (this.getAttribute("id").equals(string)) {
            return this;
        }
        return this.getChildWithId(this, string);
    }

    private Element getChildWithId(Element element, String string) {
        if (!element.hasChildNodes()) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                if (element2.getAttribute("id").equals(string)) {
                    return element2;
                }
                Element element3 = this.getChildWithId(element2, string);
                if (element3 != null) {
                    return element3;
                }
            }
            ++n2;
        }
        return null;
    }

    public NodeList getStyleElements() {
        if (this.styles == null) {
            this.styles = this.getElementsByTagName("style");
        }
        return this.styles;
    }

    public int getNumStyleElements() {
        if (this.styles == null) {
            this.styles = this.getElementsByTagName("style");
            this.numStyles = this.styles.getLength();
        }
        return this.numStyles;
    }

    public short getZoomAndPan() {
        String string = this.getAttribute("zoomAndPan");
        if (string.equals("disable")) {
            return 1;
        }
        if (string.equals("magnify")) {
            return 2;
        }
        return 2;
    }

    public void setZoomAndPan(short s) {
        if (s == 1) {
            this.setAttribute("zoomAndPan", "disable");
        } else if (s == 2) {
            this.setAttribute("zoomAndPan", "magnify");
        } else {
            System.out.println("bad zoomAndPan value: " + s + ", setting to default value 'magnify'");
            this.setAttribute("zoomAndPan", "magnify");
        }
    }

    public String getXMLlang() {
        return this.getAttribute("xml:lang");
    }

    public void setXMLlang(String string) {
        if (string != null) {
            super.setAttribute("xml:lang", string);
        } else {
            this.removeAttribute("xml:lang");
        }
    }

    public String getXMLspace() {
        return this.getAttribute("xml:space");
    }

    public void setXMLspace(String string) {
        if (string != null) {
            super.setAttribute("xml:space", string);
        } else {
            this.removeAttribute("xml:space");
        }
    }

    public SVGStringList getRequiredFeatures() {
        return this.requiredFeatures;
    }

    public SVGStringList getRequiredExtensions() {
        return this.requiredExtensions;
    }

    public SVGStringList getSystemLanguage() {
        return this.systemLanguage;
    }

    public boolean hasExtension(String string) {
        return string.equalsIgnoreCase("svg");
    }

    public SVGAnimatedRect getViewBox() {
        if (this.viewBox == null) {
            this.viewBox = new SVGAnimatedRectImpl(new SVGRectImpl(0.0f, 0.0f, this.getWidth().getBaseVal().getValue(), this.getHeight().getBaseVal().getValue()), this);
        }
        return this.viewBox;
    }

    public SVGAnimatedPreserveAspectRatio getPreserveAspectRatio() {
        if (this.preserveAspectRatio == null) {
            this.preserveAspectRatio = new SVGAnimatedPreserveAspectRatioImpl(new SVGPreserveAspectRatioImpl(), this);
        }
        return this.preserveAspectRatio;
    }

    public Event createEvent(String string) throws DOMException {
        return EventFactory.createEvent(string);
    }

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        if (this.eventListeners == null) {
            this.eventListeners = new Hashtable();
        }
        Vector vector = this.eventListeners.containsKey(string) ? (Vector)this.eventListeners.get(string) : new Vector();
        vector.add(eventListener);
        this.eventListeners.put(string, vector);
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        Vector vector;
        if (this.eventListeners == null) {
            return;
        }
        if (this.eventListeners.containsKey(string) && (vector = (Vector)this.eventListeners.get(string)).contains(eventListener)) {
            vector.remove(eventListener);
            if (vector.isEmpty()) {
                this.eventListeners.remove(string);
            } else {
                this.eventListeners.put(string, vector);
            }
        }
    }

    public boolean dispatchEvent(Event event) throws EventException {
        if (this.eventListeners == null) {
            return true;
        }
        if (!this.eventListeners.containsKey(event.getType())) {
            return true;
        }
        Vector vector = (Vector)this.eventListeners.get(event.getType());
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            EventListener eventListener = (EventListener)vector.elementAt(n2);
            eventListener.handleEvent(event);
            ++n2;
        }
        return true;
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        if (this.externalResourcesRequired == null) {
            this.externalResourcesRequired = new SVGAnimatedBooleanImpl(false, this);
        }
        return this.externalResourcesRequired;
    }

    public CSSStyleDeclaration getComputedStyle(Element element, String string) {
        return null;
    }

    public DocumentView getDocument() {
        return this.ownerDoc;
    }

    public CSSStyleDeclaration getOverrideStyle(Element element, String string) {
        return null;
    }

    public StyleSheetList getStyleSheets() {
        return null;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("x")) {
            return this.getX().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("y")) {
            return this.getY().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("width")) {
            return this.getWidth().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("height")) {
            return this.getHeight().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("viewBox")) {
            return ((SVGRectImpl)this.getViewBox().getBaseVal()).toString();
        }
        if (string.equalsIgnoreCase("preserveAspectRatio")) {
            return ((SVGPreserveAspectRatioImpl)this.getPreserveAspectRatio().getBaseVal()).toString();
        }
        if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                return "true";
            }
            return "false";
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("x")) {
            attr.setValue(this.getX().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("y")) {
            attr.setValue(this.getY().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("width")) {
            attr.setValue(this.getWidth().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("height")) {
            attr.setValue(this.getHeight().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("viewBox")) {
            attr.setValue(((SVGRectImpl)this.getViewBox().getBaseVal()).toString());
        } else if (string.equalsIgnoreCase("preserveAspectRatio")) {
            attr.setValue(((SVGPreserveAspectRatioImpl)this.getPreserveAspectRatio().getBaseVal()).toString());
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                attr.setValue("true");
            } else {
                attr.setValue("false");
            }
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("x")) {
            this.getX().getBaseVal().setValueAsString(string2);
            this.getViewport().setX(this.getX().getBaseVal().getValue());
        } else if (string.equalsIgnoreCase("y")) {
            this.getY().getBaseVal().setValueAsString(string2);
            this.getViewport().setY(this.getY().getBaseVal().getValue());
        } else if (string.equalsIgnoreCase("width")) {
            this.getWidth().getBaseVal().setValueAsString(string2);
            this.getViewport().setWidth(this.width.getBaseVal().getValue());
            if (super.getAttribute("viewBox").length() == 0) {
                this.getViewBox().getBaseVal().setWidth(this.getWidth().getBaseVal().getValue());
            }
        } else if (string.equalsIgnoreCase("height")) {
            this.getHeight().getBaseVal().setValueAsString(string2);
            this.getViewport().setHeight(this.height.getBaseVal().getValue());
            if (super.getAttribute("viewBox").length() == 0) {
                this.getViewBox().getBaseVal().setHeight(this.getHeight().getBaseVal().getValue());
            }
        } else if (string.equalsIgnoreCase("viewBox")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
            if (stringTokenizer.countTokens() == 4) {
                this.getViewBox().getBaseVal().setX(Float.parseFloat(stringTokenizer.nextToken()));
                this.getViewBox().getBaseVal().setY(Float.parseFloat(stringTokenizer.nextToken()));
                this.getViewBox().getBaseVal().setWidth(Float.parseFloat(stringTokenizer.nextToken()));
                this.getViewBox().getBaseVal().setHeight(Float.parseFloat(stringTokenizer.nextToken()));
            }
        } else if (string.equalsIgnoreCase("preserveAspectRatio")) {
            short s;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
            String string3 = null;
            String string4 = null;
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                string3 = stringTokenizer.nextToken();
                if (n > 1) {
                    string4 = stringTokenizer.nextToken();
                }
            }
            if (string3 != null) {
                s = SVGPreserveAspectRatioImpl.getAlignConst(string3);
                this.getPreserveAspectRatio().getBaseVal().setAlign(s);
            }
            if (string4 != null) {
                s = SVGPreserveAspectRatioImpl.getMeetOrSliceConst(string4);
                this.getPreserveAspectRatio().getBaseVal().setMeetOrSlice(s);
            }
        } else if (string.equalsIgnoreCase("onfocusin") || string.equalsIgnoreCase("onfocusout") || string.equalsIgnoreCase("onactivate") || string.equalsIgnoreCase("onclick") || string.equalsIgnoreCase("onmousedown") || string.equalsIgnoreCase("onmouseup") || string.equalsIgnoreCase("onmouseover") || string.equalsIgnoreCase("onmousemove") || string.equalsIgnoreCase("onmouseout") || string.equalsIgnoreCase("onload")) {
            ScriptEventListener scriptEventListener = new ScriptEventListener(this.getOwnerDoc(), string2);
            this.addEventListener(string, scriptEventListener, true);
        } else if (string.equalsIgnoreCase("onunload") || string.equalsIgnoreCase("onabort") || string.equalsIgnoreCase("onerror") || string.equalsIgnoreCase("onresize") || string.equalsIgnoreCase("onscroll") || string.equalsIgnoreCase("onzoom")) {
            ScriptEventListener scriptEventListener = new ScriptEventListener(this.getOwnerDoc(), string2);
            this.addEventListener(string, scriptEventListener, true);
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (string2.equalsIgnoreCase("true")) {
                this.getExternalResourcesRequired().setBaseVal(true);
            } else {
                this.getExternalResourcesRequired().setBaseVal(false);
            }
        }
    }

    public void draw(Graphics2D graphics2D, boolean bl) {
        if (bl || this.viewBox == null || this.viewport == null) {
            this.viewport = null;
            if (super.getAttribute("viewBox").length() == 0) {
                this.viewBox = null;
            }
            if (graphics2D.getClipBounds() == null) {
                this.recalculateViewboxToViewportTransform(-1.0, -1.0);
            } else {
                this.recalculateViewboxToViewportTransform(graphics2D.getClipBounds().getWidth(), graphics2D.getClipBounds().getHeight());
            }
            this.styles = null;
            this.refreshData();
        }
        boolean bl2 = this.getDisplay();
        float f = this.getOpacity();
        if (bl2 && f > 0.0f) {
            Object object;
            Object object2;
            AffineTransform affineTransform = graphics2D.getTransform();
            Shape shape = graphics2D.getClip();
            if (this.currentScale == 1.0f) {
                this.currentScale = 1.000001f;
            }
            graphics2D.scale(this.currentScale, this.currentScale);
            if (this.currentTranslate != null) {
                graphics2D.translate(this.currentTranslate.getX(), this.currentTranslate.getY());
            }
            if (this.getOwnerDoc().getRootElement() == this || this.getStyle() == null || !this.getStyle().getPropertyValue("overflow").equals("visible")) {
                object2 = new Rectangle2D.Float(this.viewport.getX(), this.viewport.getY(), this.viewport.getWidth(), this.viewport.getHeight());
                graphics2D.setClip((Shape)object2);
            }
            graphics2D.translate(this.viewport.getX(), this.viewport.getY());
            if (this.viewboxToViewportTransform != null) {
                graphics2D.transform(this.viewboxToViewportTransform);
            }
            if ((object2 = this.getClippingPath()) != null && (object = ((SVGClipPathElementImpl)object2).getClippingShape(this)) != null) {
                graphics2D.clip((Shape)object);
            }
            if (f < 1.0f) {
                object = this.getOwnerDoc().getRootElement();
                float f2 = object.getCurrentScale();
                SVGPoint sVGPoint = object.getCurrentTranslate();
                if (sVGPoint == null) {
                    sVGPoint = new SVGPointImpl();
                }
                Shape shape2 = this.getCompositeShape();
                AffineTransform affineTransform2 = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
                Shape shape3 = affineTransform2.createTransformedShape(shape2);
                Rectangle2D rectangle2D = shape3.getBounds2D();
                double d = rectangle2D.getWidth() / 5.0;
                double d2 = rectangle2D.getHeight() / 5.0;
                rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d2, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d2);
                int n = (int)(rectangle2D.getWidth() * (double)f2);
                int n2 = (int)(rectangle2D.getHeight() * (double)f2);
                if (n > 0 && n2 > 0) {
                    BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
                    Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D2.setRenderingHints(renderingHints);
                    if (f2 != 1.0f) {
                        graphics2D2.scale(f2, f2);
                    }
                    graphics2D2.translate(-rectangle2D.getX(), -rectangle2D.getY());
                    graphics2D2.transform(affineTransform2);
                    this.drawChildren(graphics2D2, bl);
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
                    graphics2D.setComposite(alphaComposite);
                    AffineTransform affineTransform3 = AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY());
                    affineTransform3.scale(1.0f / f2, 1.0f / f2);
                    try {
                        affineTransform3.preConcatenate(affineTransform2.createInverse());
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    graphics2D.drawImage(bufferedImage, affineTransform3, null);
                    graphics2D.setComposite(composite);
                    bufferedImage.flush();
                }
            } else {
                this.drawChildren(graphics2D, bl);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
        }
    }

    private void drawChildren(Graphics2D graphics2D, boolean bl) {
        int n;
        Vector<Node> vector = new Vector<Node>();
        if (this.hasChildNodes()) {
            NodeList nodeList = this.getChildNodes();
            n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node instanceof Drawable) {
                    vector.add(node);
                }
                ++n2;
            }
        }
        int n3 = vector.size();
        n = 0;
        while (n < n3) {
            Drawable drawable = (Drawable)vector.elementAt(n);
            drawable.draw(graphics2D, bl);
            ++n;
        }
    }

    Shape getCompositeShape() {
        GeneralPath generalPath = new GeneralPath();
        if (this.hasChildNodes()) {
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                AffineTransform affineTransform;
                Object object;
                Node node = nodeList.item(n2);
                Shape shape = null;
                if (node instanceof BasicShape) {
                    shape = ((BasicShape)((Object)node)).getShape();
                } else if (node instanceof SVGGElementImpl) {
                    shape = ((SVGGElementImpl)node).getCompositeShape();
                } else if (node instanceof SVGAElementImpl) {
                    shape = ((SVGAElementImpl)node).getCompositeShape();
                } else if (node instanceof SVGImageElementImpl) {
                    object = ((SVGImageElement)node).getBBox();
                    shape = new Rectangle2D.Float(object.getX(), object.getY(), object.getWidth(), object.getHeight());
                } else if (node instanceof SVGUseElementImpl) {
                    object = ((SVGUseElement)node).getBBox();
                    shape = new Rectangle2D.Float(object.getX(), object.getY(), object.getWidth(), object.getHeight());
                } else if (node instanceof SVGSVGElementImpl) {
                    AffineTransform affineTransform2;
                    object = (SVGSVGElement)node;
                    affineTransform = AffineTransform.getTranslateInstance(this.viewport.getX(), this.viewport.getY());
                    if (this.viewboxToViewportTransform != null) {
                        affineTransform.concatenate(this.viewboxToViewportTransform);
                    }
                    try {
                        affineTransform2 = affineTransform.createInverse();
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        affineTransform2 = null;
                    }
                    float f = ((SVGLengthImpl)((Object)object.getX())).getTransformedLength(affineTransform2);
                    float f2 = ((SVGLengthImpl)((Object)object.getY())).getTransformedLength(affineTransform2);
                    float f3 = ((SVGLengthImpl)((Object)object.getWidth())).getTransformedLength(affineTransform2);
                    float f4 = ((SVGLengthImpl)((Object)object.getHeight())).getTransformedLength(affineTransform2);
                    shape = new Rectangle2D.Float(f, f2, f3, f4);
                }
                if (node instanceof SVGTransformable && (object = ((SVGTransformable)((Object)node)).getTransform()) != null) {
                    affineTransform = ((SVGTransformListImpl)object.getAnimVal()).getAffineTransform();
                    shape = affineTransform.createTransformedShape(shape);
                }
                if (shape != null) {
                    generalPath.append(shape, false);
                }
                ++n2;
            }
        }
        return generalPath;
    }

    public Vector getElementsThatContain(double d, double d2) {
        Vector<Node> vector = new Vector<Node>();
        if (this.hasChildNodes()) {
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node instanceof BasicShape && node instanceof Drawable) {
                    boolean bl = ((Drawable)((Object)node)).contains(d, d2);
                    if (bl) {
                        vector.addElement(node);
                    }
                } else if (node instanceof SVGImageElementImpl) {
                    boolean bl = ((SVGImageElementImpl)node).contains(d, d2);
                    if (bl) {
                        vector.addElement(node);
                    }
                } else if (node instanceof SVGUseElementImpl) {
                    boolean bl = ((SVGUseElementImpl)node).contains(d, d2);
                    if (bl) {
                        vector.addElement(node);
                    }
                } else if (node instanceof SVGSVGElementImpl) {
                    Vector vector2 = ((SVGSVGElementImpl)node).getElementsThatContain(d, d2);
                    vector.addAll(vector2);
                } else if (node instanceof SVGGElementImpl) {
                    Vector vector3 = ((SVGGElementImpl)node).getElementsThatContain(d, d2);
                    vector.addAll(vector3);
                } else if (node instanceof SVGAElementImpl) {
                    Vector vector4 = ((SVGAElementImpl)node).getElementsThatContain(d, d2);
                    vector.addAll(vector4);
                }
                ++n2;
            }
        }
        if (vector.size() > 0) {
            vector.insertElementAt(this, 0);
        }
        return vector;
    }

    public boolean contains(double d, double d2) {
        if (this.hasChildNodes()) {
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                boolean bl;
                Node node = nodeList.item(n2);
                if (node instanceof Drawable && (bl = ((Drawable)((Object)node)).contains(d, d2))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public SVGRect getBBox() {
        Shape shape = this.getCompositeShape();
        Rectangle2D rectangle2D = shape.getBounds2D();
        SVGRectImpl sVGRectImpl = new SVGRectImpl(rectangle2D);
        return sVGRectImpl;
    }

    public double boundingArea() {
        Shape shape = this.getCompositeShape();
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape2 = affineTransform.createTransformedShape(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        return rectangle2D.getWidth() * rectangle2D.getHeight();
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("x")) {
            ((SVGAnimatedValue)((Object)this.getX())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("y")) {
            ((SVGAnimatedValue)((Object)this.getY())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("width")) {
            ((SVGAnimatedValue)((Object)this.getWidth())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("height")) {
            ((SVGAnimatedValue)((Object)this.getHeight())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("viewBox")) {
            ((SVGAnimatedValue)((Object)this.getViewBox())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("preserveAspectRatio")) {
            ((SVGAnimatedValue)((Object)this.getPreserveAspectRatio())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("externalResourcesRequired")) {
            ((SVGAnimatedValue)((Object)this.getExternalResourcesRequired())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

