/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.Color;
import java.util.Vector;
import org.csiro.svg.dom.SVGAnimatedNumberImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGStylableImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedNumber;
import org.w3c.dom.svg.SVGStopElement;

public class SVGStopElementImpl
extends SVGStylableImpl
implements SVGStopElement {
    protected SVGAnimatedNumber offset;
    protected Color color = null;

    public SVGStopElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "stop");
        super.setAttribute("offset", "0");
        super.setAttribute("stop-color", "black");
    }

    public SVGStopElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "stop");
    }

    public SVGElementImpl cloneElement() {
        SVGStopElementImpl sVGStopElementImpl = new SVGStopElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedNumberImpl)this.getOffset()).getAnimations();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                SVGAnimationElementImpl sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGStopElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGStopElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGStopElementImpl;
    }

    public SVGAnimatedNumber getOffset() {
        if (this.offset == null) {
            this.offset = new SVGAnimatedNumberImpl(0.0f, this);
        }
        return this.offset;
    }

    public Color getColor() {
        if (this.color == null) {
            this.color = this.getStopColor();
        }
        return this.color;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("offset")) {
            return String.valueOf(this.getOffset().getBaseVal());
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("offset")) {
            attr.setValue(String.valueOf(this.getOffset().getBaseVal()));
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("offset")) {
            if (string2.indexOf("%") != -1) {
                int n = string2.indexOf("%");
                this.getOffset().setBaseVal(Float.parseFloat(string2.substring(0, n)) / 100.0f);
            } else {
                this.getOffset().setBaseVal(Float.parseFloat(string2));
            }
            if (this.getOffset().getBaseVal() < 0.0f) {
                this.getOffset().setBaseVal(0.0f);
            } else if (this.getOffset().getBaseVal() > 1.0f) {
                this.getOffset().setBaseVal(1.0f);
            }
        }
        this.color = null;
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("offset")) {
            ((SVGAnimatedValue)((Object)this.getOffset())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

