/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import com.steadystate.css.parser.CSSOMParser;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.ImageIcon;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedLengthListImpl;
import org.csiro.svg.dom.SVGAnimatedNumberImpl;
import org.csiro.svg.dom.SVGAnimatedStringImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGClipPathElementImpl;
import org.csiro.svg.dom.SVGColorDecoder;
import org.csiro.svg.dom.SVGColorProfileElementImpl;
import org.csiro.svg.dom.SVGCursorElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGFilterElementImpl;
import org.csiro.svg.dom.SVGFontElementImpl;
import org.csiro.svg.dom.SVGGradientElementImpl;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGLengthListImpl;
import org.csiro.svg.dom.SVGMarkerElementImpl;
import org.csiro.svg.dom.SVGPatternElementImpl;
import org.csiro.svg.dom.SVGSVGElementImpl;
import org.csiro.svg.dom.SVGStyleElementImpl;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedLengthList;
import org.w3c.dom.svg.SVGAnimatedNumber;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGStylable;

public abstract class SVGStylableImpl
extends SVGElementImpl
implements SVGStylable {
    protected CSSStyleDeclaration style;
    protected Hashtable presentationAtts;
    protected SVGAnimatedString className;
    Hashtable animatedProperties;
    protected boolean highlighted = false;
    private CSSStyleDeclaration cssStyle;
    private boolean cssStyleSet = false;
    static Cursor crossHairCursor = new Cursor(1);
    static Cursor defaultCursor;
    static Cursor pointerCursor;
    static Cursor moveCursor;
    static Cursor eResizeCursor;
    static Cursor neResizeCursor;
    static Cursor nwResizeCursor;
    static Cursor nResizeCursor;
    static Cursor seResizeCursor;
    static Cursor swResizeCursor;
    static Cursor sResizeCursor;
    static Cursor wResizeCursor;
    static Cursor textCursor;
    static Cursor waitCursor;
    static Cursor helpCursor;
    private static SVGColorDecoder colorDecoder;

    public SVGStylableImpl(SVGDocumentImpl sVGDocumentImpl, Element element, String string) {
        super(sVGDocumentImpl, element, string);
    }

    public SVGStylableImpl(SVGDocumentImpl sVGDocumentImpl, String string) {
        super(sVGDocumentImpl, string);
    }

    protected SVGStylableImpl(SVGDocumentImpl sVGDocumentImpl, String string, String string2) {
        super(sVGDocumentImpl, string, string2);
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public SVGAnimatedString getClassName() {
        if (this.className == null) {
            this.className = new SVGAnimatedStringImpl("", this);
        }
        return this.className;
    }

    public CSSStyleDeclaration getStyle() {
        return this.style;
    }

    protected void refreshData() {
        this.cssStyleSet = false;
    }

    public CSSStyleDeclaration getCSSStyle() {
        if (this.cssStyleSet) {
            return this.cssStyle;
        }
        this.cssStyleSet = true;
        String string = this.getClassName().getAnimVal();
        int n = ((SVGSVGElementImpl)this.getOwnerDoc().getRootElement()).getNumStyleElements();
        if (n > 0) {
            NodeList nodeList = ((SVGSVGElementImpl)this.getOwnerDoc().getRootElement()).getStyleElements();
            int n2 = 0;
            while (n2 < n) {
                SVGStyleElementImpl sVGStyleElementImpl = (SVGStyleElementImpl)nodeList.item(n2);
                CSSStyleDeclaration cSSStyleDeclaration = sVGStyleElementImpl.getStyle(this);
                if (cSSStyleDeclaration != null) {
                    if (this.style == null) {
                        this.cssStyle = cSSStyleDeclaration;
                        return cSSStyleDeclaration;
                    }
                    String string2 = this.style.getCssText();
                    string2 = string2.substring(1, string2.length() - 1);
                    String string3 = cSSStyleDeclaration.getCssText();
                    string3 = string3.substring(1, string3.length() - 1);
                    CSSOMParser cSSOMParser = new CSSOMParser();
                    try {
                        this.cssStyle = cSSOMParser.parseStyleDeclaration(new InputSource((Reader)new StringReader("{" + string2 + " ; " + string3 + "}")));
                        return this.cssStyle;
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException.getMessage());
                        return null;
                    }
                }
                ++n2;
            }
        }
        this.cssStyle = this.style;
        return this.cssStyle;
    }

    public CSSValue getPresentationAttribute(String string) {
        CSSValue cSSValue;
        if (this.presentationAtts == null) {
            this.presentationAtts = new Hashtable();
        }
        if ((cSSValue = (CSSValue)this.presentationAtts.get(string)) != null) {
            return cSSValue;
        }
        String string2 = this.getAttribute(string);
        if (string2.length() == 0) {
            return null;
        }
        CSSOMParser cSSOMParser = new CSSOMParser();
        try {
            CSSValue cSSValue2 = cSSOMParser.parsePropertyValue(new InputSource((Reader)new StringReader(string2)));
            this.presentationAtts.put(string, cSSValue2);
            return cSSValue2;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return null;
        }
    }

    private void setStyle(String string) {
        CSSOMParser cSSOMParser = new CSSOMParser();
        try {
            this.style = cSSOMParser.parseStyleDeclaration(new InputSource((Reader)new StringReader("{" + string + "}")));
        }
        catch (IOException iOException) {
            this.style = null;
            System.out.println(iOException.getMessage());
        }
        this.cssStyleSet = false;
    }

    public String getAttribute(String string) {
        if (this.presentationAtts != null && this.presentationAtts.containsKey(string)) {
            return ((CSSValue)this.presentationAtts.get(string)).getCssText();
        }
        if (string.equalsIgnoreCase("style")) {
            if (this.style != null) {
                String string2 = this.style.getCssText();
                return string2.substring(1, string2.length() - 1);
            }
            return "";
        }
        if (string.equalsIgnoreCase("class")) {
            return this.getClassName().getBaseVal();
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (this.presentationAtts != null && this.presentationAtts.containsKey(string)) {
            attr.setValue(((CSSValue)this.presentationAtts.get(string)).getCssText());
        } else if (string.equalsIgnoreCase("style")) {
            if (this.style != null) {
                String string2 = this.style.getCssText();
                attr.setValue(string2.substring(1, string2.length() - 1));
            }
        } else if (string.equalsIgnoreCase("class")) {
            attr.setValue(this.getClassName().getBaseVal());
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        if (this.presentationAtts != null && this.presentationAtts.containsKey(string)) {
            ((CSSValue)this.presentationAtts.get(string)).setCssText(string2);
        } else if (string.equalsIgnoreCase("style")) {
            this.setStyle(string2);
            this.cssStyleSet = false;
        } else if (string.equalsIgnoreCase("class")) {
            this.className = new SVGAnimatedStringImpl(string2, this);
            this.cssStyleSet = false;
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        String string = attr.getName();
        String string2 = attr.getValue();
        if (this.presentationAtts != null && this.presentationAtts.containsKey(string)) {
            ((CSSValue)this.presentationAtts.get(string)).setCssText(attr.getValue());
        } else if (string.equalsIgnoreCase("style")) {
            this.setStyle(string2);
            this.cssStyleSet = false;
        } else if (string.equalsIgnoreCase("class")) {
            this.className = new SVGAnimatedStringImpl(string2, this);
            this.cssStyleSet = false;
        }
        return super.setAttributeNode(attr);
    }

    protected CSSValue getProperty(String string, boolean bl) {
        if (this.animatedProperties != null && this.animatedProperties.containsKey(string)) {
            SVGAnimatedValue sVGAnimatedValue = (SVGAnimatedValue)this.animatedProperties.get(string);
            String string2 = "";
            if (sVGAnimatedValue instanceof SVGAnimatedString) {
                string2 = ((SVGAnimatedString)((Object)sVGAnimatedValue)).getAnimVal();
            } else if (sVGAnimatedValue instanceof SVGAnimatedNumber) {
                string2 = "" + ((SVGAnimatedNumber)((Object)sVGAnimatedValue)).getAnimVal();
            } else if (sVGAnimatedValue instanceof SVGAnimatedLengthImpl) {
                string2 = ((SVGAnimatedLength)((Object)sVGAnimatedValue)).getAnimVal().getValueAsString();
            } else if (sVGAnimatedValue instanceof SVGAnimatedLengthListImpl) {
                string2 = ((SVGAnimatedLengthList)((Object)sVGAnimatedValue)).getAnimVal().toString();
            } else {
                System.out.println("getProperty: animated value type not recognised");
                return null;
            }
            CSSOMParser cSSOMParser = new CSSOMParser();
            try {
                return cSSOMParser.parsePropertyValue(new InputSource((Reader)new StringReader(string2)));
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                return null;
            }
        }
        CSSStyleDeclaration cSSStyleDeclaration = this.getCSSStyle();
        CSSValue cSSValue = null;
        String string3 = "";
        if (cSSStyleDeclaration != null) {
            cSSValue = cSSStyleDeclaration.getPropertyCSSValue(string);
            string3 = cSSStyleDeclaration.getPropertyValue(string);
        }
        if (cSSValue == null) {
            cSSValue = this.getPresentationAttribute(string);
            string3 = this.getAttribute(string);
        }
        if ((cSSValue == null && bl || string3.equals("inherit")) && this.getParentNode() != null && this.getParentNode() instanceof SVGStylableImpl) {
            SVGStylableImpl sVGStylableImpl = (SVGStylableImpl)this.getParentNode();
            cSSValue = sVGStylableImpl.getProperty(string, bl);
        }
        return cSSValue;
    }

    public BasicStroke getStroke() {
        SVGLengthImpl sVGLengthImpl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        float f = 1.0f;
        int n = 0;
        int n2 = 0;
        float f2 = 4.0f;
        float[] fArray = null;
        float f3 = 0.0f;
        CSSValue cSSValue = this.getProperty("stroke-width", true);
        if (cSSValue != null) {
            object6 = new SVGLengthImpl(cSSValue.getCssText(), (SVGElement)this, 2);
            f = object6.getValue();
        }
        if ((object6 = this.getProperty("stroke-linecap", true)) != null) {
            object5 = object6.getCssText();
            if (((String)object5).equals("butt")) {
                n = 0;
            } else if (((String)object5).equals("round")) {
                n = 1;
            } else if (((String)object5).equals("square")) {
                n = 2;
            } else {
                System.out.println("Bad stroke-linecap property: " + (String)object5);
            }
        }
        if ((object5 = this.getProperty("stroke-linejoin", true)) != null) {
            object4 = object5.getCssText();
            if (((String)object4).equals("miter")) {
                n2 = 0;
            } else if (((String)object4).equals("round")) {
                n2 = 1;
            } else if (((String)object4).equals("bevel")) {
                n2 = 2;
            } else {
                System.out.println("Bad stroke-linejoin property: " + (String)object4);
            }
        }
        if ((object4 = this.getProperty("stroke-miterlimit", true)) != null) {
            object3 = object4.getCssText();
            try {
                f2 = Float.parseFloat((String)object3);
                if (f2 < 1.0f) {
                    System.out.println("Bad stroke-miterlimit property: " + (String)object3 + ", must be >= 1");
                    f2 = 4.0f;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("cannot decode stroke-miterlimit: " + (String)object3);
                f2 = 4.0f;
            }
        }
        if ((object3 = this.getProperty("stroke-dasharray", true)) != null) {
            object2 = object3.getCssText();
            if (object3.getCssValueType() == 2) {
                object = (CSSValueList)object3;
                int n3 = object.getLength();
                if (n3 > 0) {
                    fArray = new float[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        CSSValue cSSValue2 = object.item(n4);
                        SVGLengthImpl sVGLengthImpl2 = new SVGLengthImpl(cSSValue2.getCssText(), (SVGElement)this, 2);
                        fArray[n4] = sVGLengthImpl2.getValue();
                        if (fArray[n4] < 0.0f) {
                            System.out.println("cannot have negative numbers in a stroke-dasharray: " + (String)object2);
                            System.out.println("setting negative number to 0");
                            fArray[n4] = 0.0f;
                        }
                        ++n4;
                    }
                    float f4 = 0.0f;
                    int n5 = 0;
                    while (n5 < n3) {
                        f4 += fArray[n5];
                        ++n5;
                    }
                    if (f4 == 0.0f) {
                        fArray = null;
                    }
                }
            } else if (!((String)object2).equals("none")) {
                System.out.println("cannot decode stroke-dasharray: " + (String)object2);
            }
        }
        if ((object2 = this.getProperty("stroke-dashoffset", true)) != null && (f3 = (sVGLengthImpl = new SVGLengthImpl((String)(object = object2.getCssText()), (SVGElement)this, 2)).getValue()) < 0.0f) {
            System.out.println("Bad stroke-dashoffset property: " + (String)object + ", must be >= 0");
            f3 = 0.0f;
        }
        object = new BasicStroke(f, n, n2, f2, fArray, f3);
        return object;
    }

    public Paint getLinePaint() {
        Object object;
        Paint paint = null;
        float f = 1.0f;
        CSSValue cSSValue = this.getProperty("stroke-opacity", true);
        if (cSSValue != null) {
            object = cSSValue.getCssText();
            try {
                f = Float.parseFloat((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("cannot decode stroke-opacity: " + (String)object);
                f = 1.0f;
            }
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if ((object = this.getProperty("stroke", true)) == null) {
            object = this.getProperty("color", true);
        }
        if (object != null) {
            String string = object.getCssText();
            if (string.equals("currentColor")) {
                CSSValue cSSValue2 = this.getProperty("color", true);
                if (cSSValue2 != null) {
                    String string2 = cSSValue2.getCssText();
                    if (cSSValue2.getCssValueType() == 1) {
                        if (((CSSPrimitiveValue)cSSValue2).getPrimitiveType() == 25) {
                            RGBColor rGBColor = ((CSSPrimitiveValue)cSSValue2).getRGBColorValue();
                            float f2 = rGBColor.getRed().getFloatValue(rGBColor.getRed().getPrimitiveType());
                            float f3 = rGBColor.getGreen().getFloatValue(rGBColor.getGreen().getPrimitiveType());
                            float f4 = rGBColor.getBlue().getFloatValue(rGBColor.getBlue().getPrimitiveType());
                            if (rGBColor.getRed().getPrimitiveType() == 2) {
                                f2 = f2 / 100.0f * 255.0f;
                            }
                            if (rGBColor.getGreen().getPrimitiveType() == 2) {
                                f3 = f3 / 100.0f * 255.0f;
                            }
                            if (rGBColor.getBlue().getPrimitiveType() == 2) {
                                f4 = f4 / 100.0f * 255.0f;
                            }
                            if (f2 > 255.0f) {
                                f2 = 255.0f;
                            }
                            if (f2 < 0.0f) {
                                f2 = 0.0f;
                            }
                            if (f3 > 255.0f) {
                                f3 = 255.0f;
                            }
                            if (f3 < 0.0f) {
                                f3 = 0.0f;
                            }
                            if (f4 > 255.0f) {
                                f4 = 255.0f;
                            }
                            if (f4 < 0.0f) {
                                f4 = 0.0f;
                            }
                            paint = new Color((int)f2, (int)f3, (int)f4);
                        } else {
                            paint = SVGStylableImpl.getColor(string2);
                        }
                    }
                }
            } else if (string.toLowerCase().indexOf("url") != -1) {
                int n = string.indexOf(35);
                if (n != -1) {
                    String string3 = string.substring(n + 1, string.length() - 1);
                    Element element = this.getOwnerDoc().getElementById(string3);
                    if (element != null && (element instanceof SVGGradientElementImpl || element instanceof SVGPatternElementImpl)) {
                        paint = element instanceof SVGGradientElementImpl ? ((SVGGradientElementImpl)element).getPaint(this, f) : ((SVGPatternElementImpl)element).getPaint(this, f);
                    }
                }
            } else if (object.getCssValueType() == 1 && !string.equalsIgnoreCase("none")) {
                if (((CSSPrimitiveValue)object).getPrimitiveType() == 25) {
                    RGBColor rGBColor = ((CSSPrimitiveValue)object).getRGBColorValue();
                    float f5 = rGBColor.getRed().getFloatValue(rGBColor.getRed().getPrimitiveType());
                    float f6 = rGBColor.getGreen().getFloatValue(rGBColor.getGreen().getPrimitiveType());
                    float f7 = rGBColor.getBlue().getFloatValue(rGBColor.getBlue().getPrimitiveType());
                    if (rGBColor.getRed().getPrimitiveType() == 2) {
                        f5 = f5 / 100.0f * 255.0f;
                    }
                    if (rGBColor.getGreen().getPrimitiveType() == 2) {
                        f6 = f6 / 100.0f * 255.0f;
                    }
                    if (rGBColor.getBlue().getPrimitiveType() == 2) {
                        f7 = f7 / 100.0f * 255.0f;
                    }
                    if (f5 > 255.0f) {
                        f5 = 255.0f;
                    }
                    if (f5 < 0.0f) {
                        f5 = 0.0f;
                    }
                    if (f6 > 255.0f) {
                        f6 = 255.0f;
                    }
                    if (f6 < 0.0f) {
                        f6 = 0.0f;
                    }
                    if (f7 > 255.0f) {
                        f7 = 255.0f;
                    }
                    if (f7 < 0.0f) {
                        f7 = 0.0f;
                    }
                    paint = new Color((int)f5, (int)f6, (int)f7);
                } else {
                    paint = SVGStylableImpl.getColor(string);
                }
            }
        }
        if (paint != null && paint instanceof Color) {
            paint = new Color(((Color)paint).getRed(), ((Color)paint).getGreen(), ((Color)paint).getBlue(), (int)(f * 255.0f));
        }
        return paint;
    }

    public Paint getFillPaint() {
        Object object;
        Paint paint = null;
        float f = 1.0f;
        CSSValue cSSValue = this.getProperty("fill-opacity", true);
        if (cSSValue != null) {
            object = cSSValue.getCssText();
            try {
                f = Float.parseFloat((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("cannot decode fill-opacity: " + (String)object);
                f = 1.0f;
            }
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if ((object = this.getProperty("fill", true)) == null) {
            object = this.getProperty("color", true);
        }
        if (object != null) {
            String string = object.getCssText();
            if (string.equals("currentColor")) {
                CSSValue cSSValue2 = this.getProperty("color", true);
                if (cSSValue2 != null) {
                    String string2 = cSSValue2.getCssText();
                    if (cSSValue2.getCssValueType() == 1) {
                        if (((CSSPrimitiveValue)cSSValue2).getPrimitiveType() == 25) {
                            RGBColor rGBColor = ((CSSPrimitiveValue)cSSValue2).getRGBColorValue();
                            float f2 = rGBColor.getRed().getFloatValue(rGBColor.getRed().getPrimitiveType());
                            float f3 = rGBColor.getGreen().getFloatValue(rGBColor.getGreen().getPrimitiveType());
                            float f4 = rGBColor.getBlue().getFloatValue(rGBColor.getBlue().getPrimitiveType());
                            if (rGBColor.getRed().getPrimitiveType() == 2) {
                                f2 = f2 / 100.0f * 255.0f;
                            }
                            if (rGBColor.getGreen().getPrimitiveType() == 2) {
                                f3 = f3 / 100.0f * 255.0f;
                            }
                            if (rGBColor.getBlue().getPrimitiveType() == 2) {
                                f4 = f4 / 100.0f * 255.0f;
                            }
                            if (f2 > 255.0f) {
                                f2 = 255.0f;
                            }
                            if (f2 < 0.0f) {
                                f2 = 0.0f;
                            }
                            if (f3 > 255.0f) {
                                f3 = 255.0f;
                            }
                            if (f3 < 0.0f) {
                                f3 = 0.0f;
                            }
                            if (f4 > 255.0f) {
                                f4 = 255.0f;
                            }
                            if (f4 < 0.0f) {
                                f4 = 0.0f;
                            }
                            paint = new Color((int)f2, (int)f3, (int)f4);
                        } else {
                            paint = SVGStylableImpl.getColor(string2);
                        }
                    }
                }
            } else if (string.toLowerCase().indexOf("url") != -1) {
                int n = string.indexOf(35);
                if (n != -1) {
                    String string3 = string.substring(n + 1, string.length() - 1);
                    Element element = this.getOwnerDoc().getElementById(string3);
                    if (element != null && (element instanceof SVGGradientElementImpl || element instanceof SVGPatternElementImpl)) {
                        paint = element instanceof SVGGradientElementImpl ? ((SVGGradientElementImpl)element).getPaint(this, f) : ((SVGPatternElementImpl)element).getPaint(this, f);
                    }
                }
            } else if (object.getCssValueType() == 1 && !string.equalsIgnoreCase("none")) {
                if (((CSSPrimitiveValue)object).getPrimitiveType() == 25) {
                    RGBColor rGBColor = ((CSSPrimitiveValue)object).getRGBColorValue();
                    float f5 = rGBColor.getRed().getFloatValue(rGBColor.getRed().getPrimitiveType());
                    float f6 = rGBColor.getGreen().getFloatValue(rGBColor.getGreen().getPrimitiveType());
                    float f7 = rGBColor.getBlue().getFloatValue(rGBColor.getBlue().getPrimitiveType());
                    if (rGBColor.getRed().getPrimitiveType() == 2) {
                        f5 = f5 / 100.0f * 255.0f;
                    }
                    if (rGBColor.getGreen().getPrimitiveType() == 2) {
                        f6 = f6 / 100.0f * 255.0f;
                    }
                    if (rGBColor.getBlue().getPrimitiveType() == 2) {
                        f7 = f7 / 100.0f * 255.0f;
                    }
                    if (f5 > 255.0f) {
                        f5 = 255.0f;
                    }
                    if (f5 < 0.0f) {
                        f5 = 0.0f;
                    }
                    if (f6 > 255.0f) {
                        f6 = 255.0f;
                    }
                    if (f6 < 0.0f) {
                        f6 = 0.0f;
                    }
                    if (f7 > 255.0f) {
                        f7 = 255.0f;
                    }
                    if (f7 < 0.0f) {
                        f7 = 0.0f;
                    }
                    paint = new Color((int)f5, (int)f6, (int)f7);
                } else {
                    paint = SVGStylableImpl.getColor(string);
                }
            }
        } else {
            paint = Color.black;
        }
        if (paint != null && paint instanceof Color) {
            paint = new Color(paint.getRed(), paint.getGreen(), paint.getBlue(), (int)(f * 255.0f));
        }
        return paint;
    }

    public Font getFont(AffineTransform affineTransform) {
        CSSValue cSSValue;
        CSSValue cSSValue2;
        CSSValue cSSValue3;
        String string;
        CSSValue cSSValue4;
        Object object;
        Object object2;
        Float f = new Float(10.0f);
        String string2 = "Default";
        Float f2 = TextAttribute.POSTURE_REGULAR;
        Float f3 = TextAttribute.WEIGHT_REGULAR;
        Float f4 = TextAttribute.WIDTH_REGULAR;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        CSSValue cSSValue5 = this.getProperty("font-size", true);
        if (cSSValue5 != null) {
            object2 = new SVGLengthImpl(cSSValue5.getCssText(), (SVGElement)this, 1);
            float f5 = ((SVGLengthImpl)object2).getTransformedLength(affineTransform);
            object2 = new SVGLengthImpl(f5, (SVGElement)this, 1);
            ((SVGLengthImpl)object2).convertToSpecifiedUnits((short)9);
            f = new Float(((SVGLengthImpl)object2).getValueInSpecifiedUnits());
        }
        if ((object2 = this.getProperty("font-family", true)) != null) {
            int n;
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            if (object2.getCssValueType() == 1) {
                string2 = object2.getCssText();
                string2 = string2.replace('\"', ' ');
                if ((string2 = string2.trim()).equalsIgnoreCase("Courier")) {
                    string2 = "Courier New";
                } else if (string2.indexOf("Times") != -1 && string2.indexOf("Roman") != -1) {
                    string2 = "Times New Roman";
                }
                boolean bl4 = false;
                n = 0;
                while (n < stringArray.length) {
                    if (string2.equalsIgnoreCase(stringArray[n])) {
                        bl4 = true;
                        break;
                    }
                    ++n;
                }
                if (!bl4) {
                    string2 = "Default";
                }
            } else if (object2.getCssValueType() == 2) {
                CSSValueList cSSValueList = (CSSValueList)object2;
                n = cSSValueList.getLength();
                String string3 = "";
                if (n > 0) {
                    int n2 = 0;
                    while (n2 < n) {
                        object = cSSValueList.item(n2);
                        string3 = object.getCssText();
                        string3 = string3.replace('\"', ' ');
                        if ((string3 = string3.trim()).equalsIgnoreCase("Courier")) {
                            string3 = "Courier New";
                        } else if (string3.indexOf("Times") != -1 && string3.indexOf("Roman") != -1) {
                            string3 = "Times New Roman";
                        }
                        boolean bl5 = false;
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            if (string3.equalsIgnoreCase(stringArray[n3])) {
                                bl5 = true;
                                break;
                            }
                            ++n3;
                        }
                        if (bl5) break;
                        string3 = "";
                        ++n2;
                    }
                }
                if (string3.length() > 0) {
                    string2 = string3;
                }
            }
        }
        if ((cSSValue4 = this.getProperty("font-style", true)) != null && ((string = cSSValue4.getCssText()).equalsIgnoreCase("italic") || string.equalsIgnoreCase("oblique"))) {
            f2 = TextAttribute.POSTURE_OBLIQUE;
        }
        if ((cSSValue3 = this.getProperty("font-weight", true)) != null) {
            String string4 = cSSValue3.getCssText();
            if (string4.equalsIgnoreCase("bold")) {
                f3 = TextAttribute.WEIGHT_BOLD;
            } else if (!string4.equals("normal") && !string4.equals("all")) {
                int n = Integer.parseInt(string4);
                switch (n) {
                    case 100: {
                        f3 = TextAttribute.WEIGHT_EXTRA_LIGHT;
                        break;
                    }
                    case 200: {
                        f3 = TextAttribute.WEIGHT_LIGHT;
                        break;
                    }
                    case 300: {
                        f3 = TextAttribute.WEIGHT_REGULAR;
                        break;
                    }
                    case 400: {
                        f3 = TextAttribute.WEIGHT_SEMIBOLD;
                        break;
                    }
                    case 500: {
                        f3 = TextAttribute.WEIGHT_MEDIUM;
                        break;
                    }
                    case 600: {
                        f3 = TextAttribute.WEIGHT_DEMIBOLD;
                        break;
                    }
                    case 700: {
                        f3 = TextAttribute.WEIGHT_BOLD;
                        break;
                    }
                    case 800: {
                        f3 = TextAttribute.WEIGHT_EXTRABOLD;
                        break;
                    }
                    case 900: {
                        f3 = TextAttribute.WEIGHT_ULTRABOLD;
                    }
                }
            }
        }
        if (f3.floatValue() > TextAttribute.WEIGHT_BOLD.floatValue()) {
            f3 = TextAttribute.WEIGHT_BOLD;
        }
        if ((cSSValue2 = this.getProperty("font-stretch", true)) != null) {
            String string5 = cSSValue2.getCssText();
            if (string5.equalsIgnoreCase("ultra-condensed")) {
                f4 = new Float(0.5);
            } else if (string5.equalsIgnoreCase("extra-condensed")) {
                f4 = new Float(0.625);
            } else if (string5.equalsIgnoreCase("condensed")) {
                f4 = new Float(0.75);
            } else if (string5.equalsIgnoreCase("semi-condensed")) {
                f4 = new Float(0.875);
            } else if (string5.equalsIgnoreCase("semi-expanded")) {
                f4 = new Float(1.125);
            } else if (string5.equalsIgnoreCase("expanded")) {
                f4 = new Float(1.25);
            } else if (string5.equalsIgnoreCase("extra-expanded")) {
                f4 = new Float(1.375);
            } else if (string5.equalsIgnoreCase("ultra-expanded")) {
                f4 = new Float(1.5);
            }
        }
        if ((cSSValue = this.getProperty("text-decoration", true)) != null) {
            String string6 = cSSValue.getCssText();
            if (string6.equalsIgnoreCase("underline")) {
                bl = true;
            } else if (string6.equalsIgnoreCase("overline")) {
                bl3 = true;
            } else if (string6.equalsIgnoreCase("line-through")) {
                bl2 = true;
            }
        }
        Font font = new Font("Serif", 0, 1);
        object = font.getAttributes();
        object.put(TextAttribute.FAMILY, string2);
        object.put(TextAttribute.POSTURE, f2);
        f = new Float((float)((double)f.floatValue() * 1.26));
        object.put(TextAttribute.SIZE, f);
        object.put(TextAttribute.WEIGHT, f3);
        object.put(TextAttribute.WIDTH, f4);
        if (bl) {
            object.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (bl3) {
            // empty if block
        }
        if (bl2) {
            object.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        font = new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)object);
        return font;
    }

    public SVGFontElementImpl getFontElement() {
        block22: {
            String string;
            String string2;
            CSSValue cSSValue;
            block23: {
                cSSValue = this.getProperty("font-family", true);
                CSSValue cSSValue2 = this.getProperty("font-style", true);
                CSSValue cSSValue3 = this.getProperty("font-weight", true);
                string2 = "normal";
                string = "normal";
                if (cSSValue2 != null) {
                    string2 = cSSValue2.getCssText();
                }
                if (cSSValue3 != null) {
                    string = cSSValue3.getCssText();
                }
                if (cSSValue == null) break block22;
                if (cSSValue.getCssValueType() != 1) break block23;
                String string3 = cSSValue.getCssText();
                if (string3.startsWith("\"")) {
                    string3 = string3.substring(1);
                }
                if (string3.endsWith("\"")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                NodeList nodeList = this.getOwnerDoc().getElementsByTagName("font");
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    SVGFontElementImpl sVGFontElementImpl = (SVGFontElementImpl)nodeList.item(n2);
                    if (sVGFontElementImpl.getFamilyName().equalsIgnoreCase(string3) && sVGFontElementImpl.getFontStyle().equalsIgnoreCase(string2)) {
                        if (sVGFontElementImpl.getFontWeight().equalsIgnoreCase(string)) {
                            return sVGFontElementImpl;
                        }
                        if (string.equalsIgnoreCase("normal")) {
                            string = "400";
                        } else if (string.equalsIgnoreCase("bold")) {
                            string = "700";
                        }
                        if (sVGFontElementImpl.getFontWeight().equalsIgnoreCase(string)) {
                            return sVGFontElementImpl;
                        }
                    }
                    ++n2;
                }
                break block22;
            }
            if (cSSValue.getCssValueType() != 2) break block22;
            CSSValueList cSSValueList = (CSSValueList)cSSValue;
            int n = cSSValueList.getLength();
            NodeList nodeList = this.getOwnerDoc().getElementsByTagName("font");
            if (n > 0) {
                int n3 = 0;
                while (n3 < n) {
                    CSSValue cSSValue4 = cSSValueList.item(n3);
                    String string4 = cSSValue4.getCssText();
                    if (string4.startsWith("\"")) {
                        string4 = string4.substring(1);
                    }
                    if (string4.endsWith("\"")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    int n4 = nodeList.getLength();
                    int n5 = 0;
                    while (n5 < n4) {
                        SVGFontElementImpl sVGFontElementImpl = (SVGFontElementImpl)nodeList.item(n5);
                        if (sVGFontElementImpl.getFamilyName().equalsIgnoreCase(string4) && sVGFontElementImpl.getFontStyle().equalsIgnoreCase(string2)) {
                            if (sVGFontElementImpl.getFontWeight().equalsIgnoreCase(string)) {
                                return sVGFontElementImpl;
                            }
                            if (string.equalsIgnoreCase("normal")) {
                                string = "400";
                            } else if (string.equalsIgnoreCase("bold")) {
                                string = "700";
                            }
                            if (sVGFontElementImpl.getFontWeight().equalsIgnoreCase(string)) {
                                return sVGFontElementImpl;
                            }
                        }
                        ++n5;
                    }
                    ++n3;
                }
            }
        }
        return null;
    }

    public float getFontSize(AffineTransform affineTransform) {
        CSSValue cSSValue = this.getProperty("font-size", true);
        if (cSSValue != null) {
            SVGLengthImpl sVGLengthImpl = new SVGLengthImpl(cSSValue.getCssText(), (SVGElement)this, 1);
            return sVGLengthImpl.getTransformedLength(affineTransform);
        }
        return 20.0f;
    }

    public String getTextAnchor() {
        CSSValue cSSValue = this.getProperty("text-anchor", true);
        if (cSSValue != null) {
            String string = cSSValue.getCssText();
            return string;
        }
        return null;
    }

    public SVGMarkerElementImpl getMarker(String string) {
        int n;
        String string2;
        CSSValue cSSValue = this.getProperty(string, true);
        if (cSSValue != null && (string2 = cSSValue.getCssText()).toLowerCase().indexOf("url") != -1 && (n = string2.indexOf(35)) != -1) {
            String string3 = string2.substring(n + 1, string2.length() - 1);
            Element element = this.getOwnerDoc().getElementById(string3);
            if (element instanceof SVGMarkerElementImpl) {
                return (SVGMarkerElementImpl)element;
            }
        }
        return null;
    }

    public Color getStopColor() {
        float f;
        Object object;
        Object object2;
        Color color = Color.black;
        CSSValue cSSValue = this.getProperty("stop-color", false);
        if (cSSValue == null) {
            cSSValue = this.getProperty("color", true);
        }
        if (cSSValue != null) {
            object2 = cSSValue.getCssText();
            if (((String)object2).equalsIgnoreCase("currentColor")) {
                cSSValue = this.getProperty("color", true);
            }
            if (cSSValue != null) {
                object2 = cSSValue.getCssText();
                if (cSSValue.getCssValueType() == 1) {
                    if (((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 25) {
                        object = ((CSSPrimitiveValue)cSSValue).getRGBColorValue();
                        f = object.getRed().getFloatValue(object.getRed().getPrimitiveType());
                        float f2 = object.getGreen().getFloatValue(object.getGreen().getPrimitiveType());
                        float f3 = object.getBlue().getFloatValue(object.getBlue().getPrimitiveType());
                        if (object.getRed().getPrimitiveType() == 2) {
                            f = f / 100.0f * 255.0f;
                        }
                        if (object.getGreen().getPrimitiveType() == 2) {
                            f2 = f2 / 100.0f * 255.0f;
                        }
                        if (object.getBlue().getPrimitiveType() == 2) {
                            f3 = f3 / 100.0f * 255.0f;
                        }
                        if (f > 255.0f) {
                            f = 255.0f;
                        }
                        if (f < 0.0f) {
                            f = 0.0f;
                        }
                        if (f2 > 255.0f) {
                            f2 = 255.0f;
                        }
                        if (f2 < 0.0f) {
                            f2 = 0.0f;
                        }
                        if (f3 > 255.0f) {
                            f3 = 255.0f;
                        }
                        if (f3 < 0.0f) {
                            f3 = 0.0f;
                        }
                        color = new Color((int)f, (int)f2, (int)f3);
                    } else {
                        color = SVGStylableImpl.getColor((String)object2);
                    }
                }
            }
        }
        if ((object2 = this.getProperty("stop-opacity", false)) != null) {
            object = object2.getCssText();
            f = 1.0f;
            try {
                f = Float.parseFloat((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("cannot decode stop-opacity: " + (String)object);
                f = 1.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(f * 255.0f));
        }
        return color;
    }

    public SVGClipPathElementImpl getClippingPath() {
        int n;
        String string;
        CSSValue cSSValue = this.getProperty("clip-path", false);
        if (cSSValue != null && (string = cSSValue.getCssText()).toLowerCase().indexOf("url") != -1 && (n = string.indexOf(35)) != -1) {
            String string2 = string.substring(n + 1, string.length() - 1);
            Element element = this.getOwnerDoc().getElementById(string2);
            if (element instanceof SVGClipPathElementImpl) {
                return (SVGClipPathElementImpl)element;
            }
        }
        return null;
    }

    public SVGFilterElementImpl getFilter() {
        int n;
        CSSValue cSSValue = this.getProperty("filter", false);
        if (cSSValue == null) {
            return null;
        }
        String string = cSSValue.getCssText();
        if (string.toLowerCase().indexOf("url") != -1 && (n = string.indexOf(35)) != -1) {
            String string2 = string.substring(n + 1, string.length() - 1);
            Element element = this.getOwnerDoc().getElementById(string2);
            if (element != null && element instanceof SVGFilterElementImpl) {
                return (SVGFilterElementImpl)element;
            }
        }
        return null;
    }

    public SVGColorProfileElementImpl getColorProfile() {
        Element element;
        CSSValue cSSValue = this.getProperty("color-profile", false);
        if (cSSValue == null) {
            return null;
        }
        String string = cSSValue.getCssText();
        if (string != null && (element = this.getOwnerDoc().getElementById(string)) != null && element instanceof SVGColorProfileElementImpl) {
            return (SVGColorProfileElementImpl)element;
        }
        return null;
    }

    public String getClipRule() {
        CSSValue cSSValue = this.getProperty("clip-rule", true);
        if (cSSValue != null) {
            return cSSValue.getCssText();
        }
        return "nonzero";
    }

    public String getFillRule() {
        CSSValue cSSValue = this.getProperty("fill-rule", true);
        if (cSSValue != null) {
            return cSSValue.getCssText();
        }
        return "nonzero";
    }

    public boolean getVisibility() {
        if (this.animatedProperties != null && this.animatedProperties.containsKey("visibility")) {
            String string = ((SVGAnimatedString)this.animatedProperties.get("visibility")).getAnimVal();
            return string.equals("visible");
        }
        CSSValue cSSValue = this.getProperty("visibility", true);
        if (cSSValue != null) {
            return cSSValue.getCssText().equalsIgnoreCase("visible");
        }
        return true;
    }

    public boolean getDisplay() {
        if (this.animatedProperties != null && this.animatedProperties.containsKey("display")) {
            String string = ((SVGAnimatedString)this.animatedProperties.get("display")).getAnimVal();
            return !string.equalsIgnoreCase("none");
        }
        CSSValue cSSValue = this.getProperty("display", false);
        if (cSSValue != null) {
            return !cSSValue.getCssText().equalsIgnoreCase("none");
        }
        return true;
    }

    public float getOpacity() {
        CSSValue cSSValue = this.getProperty("opacity", false);
        float f = 1.0f;
        if (cSSValue != null) {
            f = Float.parseFloat(cSSValue.getCssText());
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        return f;
    }

    public Cursor getCursor() {
        CSSValue cSSValue = this.getProperty("cursor", true);
        if (cSSValue != null) {
            String string = cSSValue.getCssText();
            if (string.toLowerCase().indexOf("url") != -1) {
                int n = string.indexOf(35);
                if (n != -1) {
                    String string2 = string.substring(n + 1, string.length() - 1);
                    Element element = this.getOwnerDoc().getElementById(string2);
                    if (element instanceof SVGCursorElementImpl) {
                        return ((SVGCursorElementImpl)element).getCursor();
                    }
                }
            } else {
                if (string.equals("auto")) {
                    return null;
                }
                if (string.equals("crosshair")) {
                    return crossHairCursor;
                }
                if (string.equals("default")) {
                    return defaultCursor;
                }
                if (string.equals("pointer")) {
                    return pointerCursor;
                }
                if (string.equals("move")) {
                    return moveCursor;
                }
                if (string.equals("e-resize")) {
                    return eResizeCursor;
                }
                if (string.equals("ne-resize")) {
                    return neResizeCursor;
                }
                if (string.equals("nw-resize")) {
                    return nwResizeCursor;
                }
                if (string.equals("n-resize")) {
                    return nResizeCursor;
                }
                if (string.equals("se-resize")) {
                    return seResizeCursor;
                }
                if (string.equals("sw-resize")) {
                    return swResizeCursor;
                }
                if (string.equals("s-resize")) {
                    return sResizeCursor;
                }
                if (string.equals("w-resize")) {
                    return wResizeCursor;
                }
                if (string.equals("text")) {
                    return textCursor;
                }
                if (string.equals("wait")) {
                    return waitCursor;
                }
                if (string.equals("help")) {
                    if (helpCursor == null) {
                        helpCursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("/images/helpCursor.gif")).getImage(), new Point(15, 15), "Help");
                    }
                    return helpCursor;
                }
            }
        }
        return null;
    }

    private static Color getColor(String string) {
        Color color = colorDecoder.getColor(string);
        if (color == null) {
            System.out.println("cannot decode colour: " + string);
            return Color.black;
        }
        return color;
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string;
        if (this.animatedProperties == null) {
            this.animatedProperties = new Hashtable();
        }
        if ((string = sVGAnimationElementImpl.getAttributeName()).equals("clip-path")) {
            CSSValue cSSValue = this.getProperty("clip-path", false);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey(string) ? (SVGAnimatedValue)this.animatedProperties.get(string) : (cSSValue != null ? new SVGAnimatedStringImpl(cSSValue.getCssText(), this) : new SVGAnimatedStringImpl("none", this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("clip-path", sVGAnimatedValue);
        } else if (string.equals("clip-rule")) {
            CSSValue cSSValue = this.getProperty("clip-rule", true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey(string) ? (SVGAnimatedValue)this.animatedProperties.get(string) : (cSSValue != null ? new SVGAnimatedStringImpl(cSSValue.getCssText(), this) : new SVGAnimatedStringImpl("evenodd", this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("clip-rule", sVGAnimatedValue);
        } else if (string.equals("color")) {
            CSSValue cSSValue = this.getProperty("color", true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey(string) ? (SVGAnimatedValue)this.animatedProperties.get(string) : (cSSValue != null ? new SVGAnimatedStringImpl(cSSValue.getCssText(), this) : new SVGAnimatedStringImpl("black", this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("color", sVGAnimatedValue);
        } else if (string.equals("fill")) {
            CSSValue cSSValue = this.getProperty("fill", true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey(string) ? (SVGAnimatedValue)this.animatedProperties.get(string) : (cSSValue != null ? new SVGAnimatedStringImpl(cSSValue.getCssText(), this) : new SVGAnimatedStringImpl("black", this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("fill", sVGAnimatedValue);
        } else if (string.equals("fill-opacity")) {
            CSSValue cSSValue = this.getProperty("fill-opacity", true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey(string) ? (SVGAnimatedValue)this.animatedProperties.get(string) : (cSSValue != null ? new SVGAnimatedNumberImpl(Float.parseFloat(cSSValue.getCssText()), this) : new SVGAnimatedNumberImpl(1.0f, this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("fill-opacity", sVGAnimatedValue);
        } else if (string.equals("fill-rule")) {
            CSSValue cSSValue = this.getProperty("fill-rule", true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey(string) ? (SVGAnimatedValue)this.animatedProperties.get(string) : (cSSValue != null ? new SVGAnimatedStringImpl(cSSValue.getCssText(), this) : new SVGAnimatedStringImpl("evenodd", this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("fill-rule", sVGAnimatedValue);
        } else if (string.equals("font-family")) {
            CSSValue cSSValue = this.getProperty("font-family", true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey(string) ? (SVGAnimatedValue)this.animatedProperties.get(string) : (cSSValue != null ? new SVGAnimatedStringImpl(cSSValue.getCssText(), this) : new SVGAnimatedStringImpl("Default", this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("font-family", sVGAnimatedValue);
        } else if (string.equals("font-size")) {
            CSSValue cSSValue = this.getProperty(string, true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey(string) ? (SVGAnimatedValue)this.animatedProperties.get(string) : (cSSValue != null ? new SVGAnimatedLengthImpl(new SVGLengthImpl(cSSValue.getCssText(), (SVGElement)this, 2), this) : new SVGAnimatedLengthImpl(new SVGLengthImpl(12.0f, (SVGElement)this, 2), this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("font-size", sVGAnimatedValue);
        } else if (string.equals("font-stretch") || string.equals("font-style") || string.equals("font-variant") || string.equals("font-weight")) {
            CSSValue cSSValue = this.getProperty(string, true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey(string) ? (SVGAnimatedValue)this.animatedProperties.get(string) : (cSSValue != null ? new SVGAnimatedStringImpl(cSSValue.getCssText(), this) : new SVGAnimatedStringImpl("normal", this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put(string, sVGAnimatedValue);
        } else if (string.equals("marker") || string.equals("marker-start") || string.equals("marker-mid") || string.equals("marker-end")) {
            CSSValue cSSValue = this.getProperty(string, true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey(string) ? (SVGAnimatedValue)this.animatedProperties.get(string) : (cSSValue != null ? new SVGAnimatedStringImpl(cSSValue.getCssText(), this) : new SVGAnimatedStringImpl("none", this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put(string, sVGAnimatedValue);
        } else if (string.equals("opacity")) {
            CSSValue cSSValue = this.getProperty("opacity", false);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey("opacity") ? (SVGAnimatedValue)this.animatedProperties.get("opacity") : (cSSValue != null ? new SVGAnimatedNumberImpl(Float.parseFloat(cSSValue.getCssText()), this) : new SVGAnimatedNumberImpl(1.0f, this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("opacity", sVGAnimatedValue);
        } else if (string.equals("stop-color")) {
            CSSValue cSSValue = this.getProperty("stop-color", false);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey("stop-color") ? (SVGAnimatedValue)this.animatedProperties.get("stop-color") : (cSSValue != null ? new SVGAnimatedStringImpl(cSSValue.getCssText(), this) : new SVGAnimatedStringImpl("black", this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("stop-color", sVGAnimatedValue);
        } else if (string.equals("stop-opacity")) {
            CSSValue cSSValue = this.getProperty("stop-opacity", false);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey("stop-opacity") ? (SVGAnimatedValue)this.animatedProperties.get("stop-opacity") : (cSSValue != null ? new SVGAnimatedNumberImpl(Float.parseFloat(cSSValue.getCssText()), this) : new SVGAnimatedNumberImpl(1.0f, this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("stop-opacity", sVGAnimatedValue);
        } else if (string.equals("stroke")) {
            CSSValue cSSValue = this.getProperty("stroke", true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey("stroke") ? (SVGAnimatedValue)this.animatedProperties.get("stroke") : (cSSValue != null ? new SVGAnimatedStringImpl(cSSValue.getCssText(), this) : new SVGAnimatedStringImpl("none", this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("stroke", sVGAnimatedValue);
        } else if (string.equals("stroke-dasharray")) {
            SVGAnimatedValue sVGAnimatedValue;
            CSSValue cSSValue = this.getProperty("stroke-dasharray", true);
            if (this.animatedProperties != null && this.animatedProperties.containsKey("stroke-dasharray")) {
                sVGAnimatedValue = (SVGAnimatedValue)this.animatedProperties.get("stroke-dasharray");
            } else {
                SVGLengthListImpl sVGLengthListImpl = new SVGLengthListImpl();
                if (cSSValue != null) {
                    String string2 = cSSValue.getCssText();
                    if (cSSValue.getCssValueType() == 2) {
                        CSSValueList cSSValueList = (CSSValueList)cSSValue;
                        int n = cSSValueList.getLength();
                        int n2 = 0;
                        while (n2 < n) {
                            CSSValue cSSValue2 = cSSValueList.item(n2);
                            SVGLengthImpl sVGLengthImpl = new SVGLengthImpl(cSSValue2.getCssText(), (SVGElement)this, 2);
                            sVGLengthListImpl.appendItem(sVGLengthImpl);
                            ++n2;
                        }
                    }
                }
                sVGAnimatedValue = new SVGAnimatedLengthListImpl(sVGLengthListImpl, this);
            }
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("stroke-dasharray", sVGAnimatedValue);
        } else if (string.equals("stroke-dashoffset")) {
            CSSValue cSSValue = this.getProperty("stroke-dashoffset", true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey("stroke-dashoffset") ? (SVGAnimatedValue)this.animatedProperties.get("stroke-dashoffset") : (cSSValue != null ? new SVGAnimatedLengthImpl(new SVGLengthImpl(cSSValue.getCssText(), (SVGElement)this, 2), this) : new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 2), this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("stroke-dashoffset", sVGAnimatedValue);
        } else if (string.equals("stroke-linecap")) {
            CSSValue cSSValue = this.getProperty("stroke-linecap", true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey("stroke-linecap") ? (SVGAnimatedValue)this.animatedProperties.get("stroke-linecap") : (cSSValue != null ? new SVGAnimatedStringImpl(cSSValue.getCssText(), this) : new SVGAnimatedStringImpl("none", this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("stroke-linecap", sVGAnimatedValue);
        } else if (string.equals("stroke-linejoin")) {
            CSSValue cSSValue = this.getProperty("stroke-linejoin", true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey("stroke-linejoin") ? (SVGAnimatedValue)this.animatedProperties.get("stroke-linejoin") : (cSSValue != null ? new SVGAnimatedStringImpl(cSSValue.getCssText(), this) : new SVGAnimatedStringImpl("none", this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("stroke-linejoin", sVGAnimatedValue);
        } else if (string.equals("stroke-miterlimit")) {
            CSSValue cSSValue = this.getProperty("stroke-miterlimit", true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey("stroke-miterlimit") ? (SVGAnimatedValue)this.animatedProperties.get("stroke-miterlimit") : (cSSValue != null ? new SVGAnimatedNumberImpl(Float.parseFloat(cSSValue.getCssText()), this) : new SVGAnimatedNumberImpl(4.0f, this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("stroke-miterlimit", sVGAnimatedValue);
        } else if (string.equals("stroke-opacity")) {
            CSSValue cSSValue = this.getProperty("stroke-opacity", true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey("stroke-opacity") ? (SVGAnimatedValue)this.animatedProperties.get("stroke-opacity") : (cSSValue != null ? new SVGAnimatedNumberImpl(Float.parseFloat(cSSValue.getCssText()), this) : new SVGAnimatedNumberImpl(1.0f, this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("stroke-opacity", sVGAnimatedValue);
        } else if (string.equals("stroke-width")) {
            CSSValue cSSValue = this.getProperty("stroke-width", true);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey("stroke-width") ? (SVGAnimatedValue)this.animatedProperties.get("stroke-width") : (cSSValue != null ? new SVGAnimatedLengthImpl(new SVGLengthImpl(cSSValue.getCssText(), (SVGElement)this, 2), this) : new SVGAnimatedLengthImpl(new SVGLengthImpl(1.0f, (SVGElement)this, 2), this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("stroke-width", sVGAnimatedValue);
        } else if (string.equals("visibility")) {
            CSSValue cSSValue = this.getProperty("visibility", false);
            SVGAnimatedValue sVGAnimatedValue = this.animatedProperties != null && this.animatedProperties.containsKey("visibility") ? (SVGAnimatedValue)this.animatedProperties.get("visibility") : (cSSValue != null ? new SVGAnimatedStringImpl(cSSValue.getCssText(), this) : new SVGAnimatedStringImpl("visible", this));
            sVGAnimatedValue.addAnimation(sVGAnimationElementImpl);
            this.animatedProperties.put("visibility", sVGAnimatedValue);
        }
    }

    static {
        pointerCursor = defaultCursor = new Cursor(0);
        moveCursor = new Cursor(13);
        eResizeCursor = new Cursor(11);
        neResizeCursor = new Cursor(7);
        nwResizeCursor = new Cursor(6);
        nResizeCursor = new Cursor(8);
        seResizeCursor = new Cursor(5);
        swResizeCursor = new Cursor(4);
        sResizeCursor = new Cursor(9);
        wResizeCursor = new Cursor(10);
        textCursor = new Cursor(2);
        waitCursor = new Cursor(3);
        helpCursor = null;
        colorDecoder = new SVGColorDecoder();
    }
}

