/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGStylableImpl;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGStyleElement;

public class SVGStyleElementImpl
extends SVGElementImpl
implements SVGStyleElement {
    Vector selectors;
    Vector styles;

    public SVGStyleElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "style");
        this.setupStyles();
    }

    public SVGStyleElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "style");
        this.setupStyles();
    }

    public SVGElementImpl cloneElement() {
        return new SVGStyleElementImpl(this.getOwnerDoc(), this);
    }

    public String getXMLspace() {
        return this.getAttribute("xml:space");
    }

    public void setXMLspace(String string) {
        if (string != null) {
            this.setAttribute("xml:space", string);
        } else {
            this.removeAttribute("xml:space");
        }
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public void setType(String string) {
        if (string != null) {
            this.setAttribute("type", string);
        } else {
            this.removeAttribute("type");
        }
    }

    public String getMedia() {
        return this.getAttribute("media");
    }

    public void setMedia(String string) {
        if (string != null) {
            this.setAttribute("media", string);
        } else {
            this.removeAttribute("media");
        }
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public void setTitle(String string) {
        if (string != null) {
            this.setAttribute("title", string);
        } else {
            this.removeAttribute("title");
        }
    }

    public String getStyleText() {
        int n;
        String string = "";
        if (this.hasChildNodes()) {
            NodeList nodeList = this.getChildNodes();
            n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 4 || node.getNodeType() == 3) {
                    string = string + node.getNodeValue();
                }
                ++n2;
            }
        }
        int n3 = string.indexOf("/*");
        n = string.indexOf("*/");
        while (n3 != -1 && n != -1) {
            string = string.substring(0, n3) + string.substring(n + 2);
            n3 = string.indexOf("/*");
            n = string.indexOf("*/");
        }
        return string;
    }

    private void setupStyles() {
        this.selectors = new Vector();
        this.styles = new Vector();
        String string = this.getStyleText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}");
        while (stringTokenizer.hasMoreTokens()) {
            CSSStyleDeclaration cSSStyleDeclaration;
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            CSSOMParser cSSOMParser = new CSSOMParser();
            try {
                cSSStyleDeclaration = cSSOMParser.parseStyleDeclaration(new InputSource((Reader)new StringReader("{" + string3 + "}")));
            }
            catch (IOException iOException) {
                cSSStyleDeclaration = null;
                System.out.println(iOException.getMessage());
            }
            if (cSSStyleDeclaration == null) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2.trim(), ",");
            while (stringTokenizer2.hasMoreTokens()) {
                String string4 = stringTokenizer2.nextToken();
                if (string4.indexOf("[") == 0) {
                    while (string4.indexOf("]") == -1 && stringTokenizer2.hasMoreTokens()) {
                        string4 = string4 + "," + stringTokenizer2.nextToken();
                    }
                }
                this.selectors.add(string4.trim());
                this.styles.add(cSSStyleDeclaration);
            }
        }
    }

    private boolean selectorMatchesAncestorElem(String string, SVGStylableImpl sVGStylableImpl) {
        if (string.equals("*")) {
            return true;
        }
        String string2 = sVGStylableImpl.getClassName().getAnimVal();
        String string3 = sVGStylableImpl.getTagName();
        String string4 = sVGStylableImpl.getId();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " +>");
        int n = stringTokenizer.countTokens();
        String string5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
        }
        if (string5 != null) {
            String string6;
            int n2;
            boolean bl = false;
            if (string5.startsWith(".")) {
                if (string2.indexOf(string5.substring(1)) != -1) {
                    bl = true;
                }
            } else if (string5.startsWith("*.")) {
                if (string2.indexOf(string5.substring(2)) != -1) {
                    bl = true;
                }
            } else if (string5.startsWith("#")) {
                if (string4.equals(string5.substring(1))) {
                    bl = true;
                }
            } else if (string5.startsWith("*#")) {
                if (string4.equals(string5.substring(2))) {
                    bl = true;
                }
            } else if (string5.indexOf(".") != -1) {
                n2 = string5.indexOf(".");
                string6 = string5.substring(0, n2);
                if (string3.equals(string6)) {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string5.substring(n2 + 1), ".");
                    while (stringTokenizer2.hasMoreTokens()) {
                        String string7 = stringTokenizer2.nextToken();
                        if (string2.indexOf(string7) == -1) continue;
                        bl = true;
                    }
                }
            } else if (string5.indexOf("#") != -1) {
                n2 = string5.indexOf("#");
                string6 = string5.substring(0, n2);
                String string8 = string5.substring(n2 + 1);
                if (string3.equals(string6) && string4.equals(string8)) {
                    bl = true;
                }
            } else if (string5.indexOf("[") != -1) {
                n2 = string5.indexOf(61);
                if (n2 != -1) {
                    string6 = string5.substring(1, n2);
                    int n3 = string5.indexOf(34);
                    int n4 = string5.lastIndexOf(34);
                    if (n3 != -1 && n4 != -1) {
                        String string9 = string5.substring(n3 + 1, n4);
                        if (sVGStylableImpl.getAttribute(string6).equals(string9)) {
                            bl = true;
                        }
                    }
                }
            } else if (string3.equals(string5)) {
                bl = true;
            }
            if (bl && n == 1) {
                return true;
            }
            if (bl && n > 1) {
                StringTokenizer stringTokenizer3 = new StringTokenizer(string);
                int n5 = stringTokenizer3.countTokens();
                String string10 = null;
                int n6 = 0;
                while (n6 < n5 - 1) {
                    string10 = stringTokenizer3.nextToken();
                    ++n6;
                }
                if (string10.equals(">")) {
                    int n7 = string.indexOf(string10);
                    String string11 = string.substring(0, n7 - 1);
                    Node node = sVGStylableImpl.getParentNode();
                    if (node != null && node instanceof SVGStylableImpl) {
                        return this.selectorMatchesElem(string11, (SVGStylableImpl)node);
                    }
                } else if (string10.equals("+")) {
                    int n8 = string.indexOf(string10);
                    String string12 = string.substring(0, n8 - 1);
                    Node node = sVGStylableImpl.getPreviousSibling();
                    while (node != null && !(node instanceof SVGElementImpl)) {
                        node = node.getPreviousSibling();
                    }
                    if (node != null && node instanceof SVGStylableImpl) {
                        return this.selectorMatchesElem(string12, (SVGStylableImpl)node);
                    }
                } else {
                    int n9 = string.indexOf(string5);
                    String string13 = string.substring(0, n9 - 1);
                    Node node = sVGStylableImpl.getParentNode();
                    if (node != null && node instanceof SVGStylableImpl) {
                        return this.selectorMatchesAncestorElem(string13, (SVGStylableImpl)node);
                    }
                }
            } else {
                Node node = sVGStylableImpl.getParentNode();
                if (node != null && node instanceof SVGStylableImpl) {
                    return this.selectorMatchesAncestorElem(string, (SVGStylableImpl)node);
                }
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean selectorMatchesElem(String string, SVGStylableImpl sVGStylableImpl) {
        Object object;
        String string2;
        int n;
        if (string.equals("*")) {
            return true;
        }
        String string3 = sVGStylableImpl.getClassName().getAnimVal();
        String string4 = sVGStylableImpl.getTagName();
        String string5 = sVGStylableImpl.getId();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " +>");
        int n2 = stringTokenizer.countTokens();
        String string6 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
        }
        if (string6 == null) return false;
        if (string6.startsWith(".")) {
            if (string3.indexOf(string6.substring(1)) == -1) {
                return false;
            }
        } else if (string6.startsWith("*.")) {
            if (string3.indexOf(string6.substring(2)) == -1) {
                return false;
            }
        } else if (string6.startsWith("#")) {
            if (!string5.equals(string6.substring(1))) {
                return false;
            }
        } else if (string6.startsWith("*#")) {
            if (!string5.equals(string6.substring(2))) {
                return false;
            }
        } else if (string6.indexOf(".") != -1) {
            n = string6.indexOf(".");
            string2 = string6.substring(0, n);
            if (!string4.equals(string2)) {
                return false;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string6.substring(n + 1), ".");
            while (stringTokenizer2.hasMoreTokens()) {
                String string7 = stringTokenizer2.nextToken();
                if (string3.indexOf(string7) != -1) continue;
                return false;
            }
        } else if (string6.indexOf("#") != -1) {
            n = string6.indexOf("#");
            string2 = string6.substring(0, n);
            String string8 = string6.substring(n + 1);
            if (!string4.equals(string2)) {
                return false;
            }
            if (!string5.equals(string8)) {
                return false;
            }
        } else if (string6.indexOf("[") != -1) {
            n = string6.indexOf(61);
            if (n == -1) return false;
            string2 = string6.substring(1, n);
            int n3 = string6.indexOf(34);
            int n4 = string6.lastIndexOf(34);
            if (n3 == -1 || n4 == -1) return false;
            String string9 = string6.substring(n3 + 1, n4);
            object = sVGStylableImpl.getAttributeNode(string2);
            if (object == null || !object.getValue().equals(string9)) {
                return false;
            }
        } else if (!string4.equals(string6)) {
            return false;
        }
        if (n2 == 1) {
            return true;
        }
        StringTokenizer stringTokenizer3 = new StringTokenizer(string);
        int n5 = stringTokenizer3.countTokens();
        String string10 = null;
        int n6 = 0;
        while (n6 < n5 - 1) {
            string10 = stringTokenizer3.nextToken();
            ++n6;
        }
        if (string10.equals(">")) {
            int n7 = string.indexOf(string10);
            object = string.substring(0, n7 - 1);
            Node node = sVGStylableImpl.getParentNode();
            if (node == null || !(node instanceof SVGStylableImpl)) return false;
            return this.selectorMatchesElem((String)object, (SVGStylableImpl)node);
        }
        if (string10.equals("+")) {
            int n8 = string.indexOf(string10);
            object = string.substring(0, n8 - 1);
            Node node = sVGStylableImpl.getPreviousSibling();
            while (node != null && !(node instanceof SVGElementImpl)) {
                node = node.getPreviousSibling();
            }
            if (node == null || !(node instanceof SVGStylableImpl)) return false;
            return this.selectorMatchesElem((String)object, (SVGStylableImpl)node);
        }
        int n9 = string.indexOf(string6);
        object = string.substring(0, n9 - 1);
        Node node = sVGStylableImpl.getParentNode();
        if (node == null || !(node instanceof SVGStylableImpl)) return false;
        return this.selectorMatchesAncestorElem((String)object, (SVGStylableImpl)node);
    }

    public CSSStyleDeclaration getStyle(SVGStylableImpl sVGStylableImpl) {
        Object object;
        Vector vector = new Vector();
        int n = this.selectors.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.selectors.elementAt(n2);
            if (this.selectorMatchesElem(string, sVGStylableImpl)) {
                vector.add(this.styles.elementAt(n2));
            }
            ++n2;
        }
        int n3 = vector.size();
        if (n3 == 0) {
            return null;
        }
        if (n3 == 1) {
            return (CSSStyleDeclaration)vector.elementAt(0);
        }
        String string = "";
        int n4 = n3 - 1;
        while (n4 >= 0) {
            object = (CSSStyleDeclaration)vector.elementAt(n4);
            String string2 = object.getCssText();
            string = string + string2.substring(1, string2.length() - 1) + ";";
            --n4;
        }
        object = new CSSOMParser();
        try {
            return object.parseStyleDeclaration(new InputSource((Reader)new StringReader("{" + string + "}")));
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

