/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import java.util.Vector;
import org.csiro.svg.dom.BasicShape;
import org.csiro.svg.dom.Drawable;
import org.csiro.svg.dom.SVGAnimatedEnumerationImpl;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedLengthListImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGClipPathElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGFontElementImpl;
import org.csiro.svg.dom.SVGGraphic;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGLengthListImpl;
import org.csiro.svg.dom.SVGMatrixImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGTexturePaint;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedLengthList;
import org.w3c.dom.svg.SVGAnimatedNumberList;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGTextElement;

public class SVGTextElementImpl
extends SVGGraphic
implements SVGTextElement,
Drawable,
BasicShape {
    public static final int ALIGN_START = 0;
    public static final int ALIGN_MIDDLE = 1;
    public static final int ALIGN_END = 2;
    public static final int ADJUST_SPACING = 1;
    public static final int ADJUST_GLYPHS = 2;
    protected SVGAnimatedLengthList x;
    protected SVGAnimatedLengthList y;
    protected SVGAnimatedLength textLength;
    protected SVGAnimatedEnumeration lengthAdjust;
    private static Vector lengthAdjustStrings;
    private static Vector lengthAdjustValues;
    private static final boolean is1_4OrGreater;
    boolean visible = true;
    boolean display = true;
    float opacity = 1.0f;
    Shape clipShape = null;
    Shape shape = null;
    BasicStroke stroke = null;
    Paint fillPaint = null;
    Paint linePaint = null;
    AffineTransform thisTransform = null;
    SVGFontElementImpl font = null;
    float fontSize = 10.0f;
    float xPos = 0.0f;
    float yPos = 0.0f;

    private static boolean isJDK1_4OrGreater() {
        return is1_4OrGreater;
    }

    public SVGTextElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "text");
        super.setAttribute("x", "0");
        super.setAttribute("y", "0");
    }

    public SVGTextElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "text");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGTextElementImpl sVGTextElementImpl = new SVGTextElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedLengthListImpl)this.getX()).getAnimations();
        Vector vector2 = ((SVGAnimatedLengthListImpl)this.getY()).getAnimations();
        Vector vector3 = ((SVGAnimatedLengthImpl)this.getTextLength()).getAnimations();
        Vector vector4 = ((SVGAnimatedEnumerationImpl)this.getLengthAdjust()).getAnimations();
        Vector vector5 = ((SVGAnimatedTransformListImpl)this.getTransform()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGTextElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGTextElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGTextElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector4 != null) {
            n = 0;
            while (n < vector4.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector4.elementAt(n);
                sVGTextElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector5 != null) {
            n = 0;
            while (n < vector5.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector5.elementAt(n);
                sVGTextElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGTextElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGTextElementImpl;
    }

    private void initLengthAdjustVectors() {
        if (lengthAdjustStrings == null) {
            lengthAdjustStrings = new Vector();
            lengthAdjustStrings.addElement("spacingAndGlyphs");
            lengthAdjustStrings.addElement("spacing");
        }
        if (lengthAdjustValues == null) {
            lengthAdjustValues = new Vector();
            lengthAdjustValues.addElement(new Short(2));
            lengthAdjustValues.addElement(new Short(1));
            lengthAdjustValues.addElement(new Short(0));
        }
    }

    public SVGAnimatedLengthList getX() {
        if (this.x == null) {
            SVGLengthListImpl sVGLengthListImpl = new SVGLengthListImpl();
            this.x = new SVGAnimatedLengthListImpl(sVGLengthListImpl, this);
            this.x.getBaseVal().initialize(new SVGLengthImpl(0.0f, (SVGElement)this, 0));
        }
        return this.x;
    }

    public SVGAnimatedLengthList getY() {
        if (this.y == null) {
            SVGLengthListImpl sVGLengthListImpl = new SVGLengthListImpl();
            this.y = new SVGAnimatedLengthListImpl(sVGLengthListImpl, this);
            this.y.getBaseVal().initialize(new SVGLengthImpl(0.0f, (SVGElement)this, 1));
        }
        return this.y;
    }

    public SVGAnimatedLengthList getDx() {
        return null;
    }

    public SVGAnimatedLengthList getDy() {
        return null;
    }

    public SVGAnimatedNumberList getRotate() {
        return null;
    }

    public SVGAnimatedLength getTextLength() {
        if (this.textLength == null) {
            this.textLength = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 0), this);
        }
        return this.textLength;
    }

    public SVGAnimatedEnumeration getLengthAdjust() {
        if (this.lengthAdjust == null) {
            if (lengthAdjustStrings == null) {
                this.initLengthAdjustVectors();
            }
            this.lengthAdjust = new SVGAnimatedEnumerationImpl(1, this, lengthAdjustStrings, lengthAdjustValues);
        }
        return this.lengthAdjust;
    }

    public int getNumberOfChars() {
        String string = this.getText();
        return string.length();
    }

    public float getComputedTextLength() {
        return 0.0f;
    }

    public float getSubStringLength(int n, int n2) throws DOMException {
        return 1.0f;
    }

    public SVGPoint getStartPositionOfChar(int n) throws DOMException {
        return null;
    }

    public SVGPoint getEndPositionOfChar(int n) throws DOMException {
        return null;
    }

    public SVGRect getExtentOfChar(int n) throws DOMException {
        return null;
    }

    public float getRotationOfChar(int n) throws DOMException {
        return 0.0f;
    }

    public int getCharNumAtPosition(SVGPoint sVGPoint) throws SVGException {
        return 0;
    }

    public void selectSubString(int n, int n2) throws DOMException {
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("x")) {
            return this.getX().getBaseVal().getItem(0).getValueAsString();
        }
        if (string.equalsIgnoreCase("y")) {
            return this.getY().getBaseVal().getItem(0).getValueAsString();
        }
        if (string.equalsIgnoreCase("textLength") && this.textLength != null) {
            return this.getTextLength().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("lengthAdjust")) {
            if (this.getLengthAdjust().getBaseVal() == 2) {
                return "spacingAndGlyphs";
            }
            return "spacing";
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("x")) {
            attr.setValue(this.getX().getBaseVal().getItem(0).getValueAsString());
        } else if (string.equalsIgnoreCase("y")) {
            attr.setValue(this.getY().getBaseVal().getItem(0).getValueAsString());
        } else if (string.equalsIgnoreCase("textLength") && this.textLength != null) {
            attr.setValue(this.getTextLength().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("lengthAdjust")) {
            if (this.getLengthAdjust().getBaseVal() == 2) {
                attr.setValue("spacingAndGlyphs");
            } else {
                attr.setValue("spacing");
            }
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("x")) {
            this.getX().getBaseVal().getItem(0).setValueAsString(string2);
        } else if (string.equalsIgnoreCase("y")) {
            this.getY().getBaseVal().getItem(0).setValueAsString(string2);
        } else if (string.equalsIgnoreCase("textLength")) {
            this.getTextLength().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("lengthAdjust")) {
            if (string2.equalsIgnoreCase("spacingAndGlyphs")) {
                this.getLengthAdjust().setBaseVal((short)2);
            } else if (string2.equalsIgnoreCase("spacing")) {
                this.getLengthAdjust().setBaseVal((short)1);
            } else {
                System.out.println("invalid lengthAdjust value: " + string2 + ". Setting to default 'spacing'.");
                this.getLengthAdjust().setBaseVal((short)1);
            }
        }
    }

    String getText() {
        String string = "";
        String string2 = this.getXMLspace();
        if (string2.length() == 0) {
            string2 = "default";
        }
        if (this.hasChildNodes()) {
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 3) {
                    String string3 = node.getNodeValue();
                    String string4 = "";
                    if (string2.equals("default")) {
                        int n3 = string3.indexOf(10);
                        while (n3 != -1) {
                            string3 = string3.substring(0, n3) + string3.substring(n3 + 1);
                            n3 = string3.indexOf(10);
                        }
                        int n4 = string3.indexOf(13);
                        while (n4 != -1) {
                            string3 = string3.substring(0, n4) + string3.substring(n4 + 1);
                            n4 = string3.indexOf(13);
                        }
                        string3 = string3.replace('\t', ' ');
                        StringTokenizer stringTokenizer = new StringTokenizer(string3);
                        while (stringTokenizer.hasMoreTokens()) {
                            string4 = string4 + stringTokenizer.nextToken() + " ";
                        }
                        string4 = string4.trim();
                    } else {
                        string3 = string3.replace('\n', ' ');
                        string3 = string3.replace('\r', ' ');
                        string4 = string3 = string3.replace('\t', ' ');
                    }
                    string = string + string4 + " ";
                }
                ++n2;
            }
        }
        if (string.length() > 0) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private GeneralPath layoutText(String string, Font font, int n, float f) {
        Shape shape;
        float f2;
        GlyphMetrics glyphMetrics;
        int n2;
        GlyphVector glyphVector = font.createGlyphVector(new FontRenderContext(null, true, true), new String(string));
        float f3 = this.getTextLength().getBaseVal().getValue();
        short s = this.getLengthAdjust().getBaseVal();
        GeneralPath generalPath = new GeneralPath();
        float f4 = (float)glyphVector.getVisualBounds().getWidth();
        if (glyphVector == null || glyphVector.getNumGlyphs() == 0 || f4 == 0.0f) {
            return generalPath;
        }
        float f5 = 1.0f;
        if (f3 != 0.0f) {
            f5 = f3 / f4;
        }
        float f6 = f;
        float f7 = 0.0f;
        if (s == 1 && glyphVector.getNumGlyphs() > 1 && f3 > 0.0f && f3 > f4) {
            n2 = glyphVector.getNumGlyphs() - 1;
            glyphMetrics = glyphVector.getGlyphMetrics(n2);
            f2 = glyphMetrics.getAdvance();
            shape = glyphVector.getGlyphOutline(n2);
            float f8 = (float)shape.getBounds2D().getWidth();
            float f9 = f2 - f8;
            f7 = f9 / (float)glyphVector.getNumGlyphs();
        }
        n2 = 0;
        while (n2 < glyphVector.getNumGlyphs()) {
            glyphMetrics = glyphVector.getGlyphMetrics(n2);
            f2 = glyphMetrics.getAdvance();
            shape = glyphVector.getGlyphOutline(n2);
            if (SVGTextElementImpl.isJDK1_4OrGreater()) {
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(-glyphVector.getGlyphPosition(n2).getX(), -glyphVector.getGlyphPosition(n2).getY());
                affineTransform.translate(0.0, 0.0);
                shape = affineTransform.createTransformedShape(shape);
            }
            if (s == 2) {
                AffineTransform affineTransform = AffineTransform.getScaleInstance(f5, 1.0);
                shape = affineTransform.createTransformedShape(shape);
                f2 *= f5;
            } else if (s == 1) {
                f2 *= f5;
                f2 += f7;
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(f6, 0.0);
            shape = affineTransform.createTransformedShape(shape);
            generalPath.append(shape, false);
            f6 += f2;
            ++n2;
        }
        return generalPath;
    }

    private Shape createShape(AffineTransform affineTransform) {
        String string;
        AffineTransform affineTransform2;
        try {
            affineTransform2 = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            affineTransform2 = null;
        }
        float f = ((SVGLengthImpl)this.getX().getAnimVal().getItem(0)).getTransformedLength(affineTransform2);
        float f2 = ((SVGLengthImpl)this.getY().getAnimVal().getItem(0)).getTransformedLength(affineTransform2);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(1);
        Font font = this.getFont(affineTransform2);
        String string2 = this.getText();
        if (string2.length() > 0 && font != null) {
            generalPath = this.layoutText(string2, font, 0, 0.0f);
            generalPath.transform(AffineTransform.getTranslateInstance(f, f2));
        }
        if ((string = this.getTextAnchor()) != null) {
            if (string.equals("middle")) {
                double d = generalPath.getBounds2D().getWidth();
                generalPath.transform(AffineTransform.getTranslateInstance(-d / 2.0, 0.0));
            } else if (string.equals("end")) {
                double d = generalPath.getBounds2D().getWidth();
                generalPath.transform(AffineTransform.getTranslateInstance(-d, 0.0));
            }
        }
        return generalPath;
    }

    public void draw(Graphics2D graphics2D, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        if (bl || this.shape == null && this.font == null) {
            this.refreshData();
            this.visible = this.getVisibility();
            this.display = this.getDisplay();
            this.opacity = this.getOpacity();
            object3 = this.getClippingPath();
            this.clipShape = null;
            if (object3 != null) {
                this.clipShape = ((SVGClipPathElementImpl)object3).getClippingShape(this);
            }
            this.thisTransform = ((SVGTransformListImpl)this.getTransform().getAnimVal()).getAffineTransform();
            this.font = this.getFontElement();
            if (this.font != null) {
                object2 = ((SVGMatrixImpl)this.getCTM()).getAffineTransform();
                try {
                    object = ((AffineTransform)object2).createInverse();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    object = null;
                }
                this.fontSize = this.getFontSize((AffineTransform)object);
                this.xPos = ((SVGLengthImpl)this.getX().getAnimVal().getItem(0)).getTransformedLength((AffineTransform)object);
                this.yPos = ((SVGLengthImpl)this.getY().getAnimVal().getItem(0)).getTransformedLength((AffineTransform)object);
            } else {
                this.shape = this.createShape(((SVGMatrixImpl)this.getCTM()).getAffineTransform());
            }
            this.stroke = this.getStroke();
            this.fillPaint = this.getFillPaint();
            this.linePaint = this.getLinePaint();
        } else {
            if (this.fillPaint != null && this.fillPaint instanceof SVGTexturePaint && ((SVGTexturePaint)this.fillPaint).getTextureType() == 2) {
                this.fillPaint = this.getFillPaint();
            }
            if (this.linePaint != null && this.linePaint instanceof SVGTexturePaint && ((SVGTexturePaint)this.linePaint).getTextureType() == 2) {
                this.linePaint = this.getLinePaint();
            }
        }
        if (this.visible && this.display && this.opacity > 0.0f) {
            object3 = graphics2D.getTransform();
            object2 = graphics2D.getClip();
            graphics2D.transform(this.thisTransform);
            if (this.clipShape != null) {
                graphics2D.clip(this.clipShape);
            }
            if (this.opacity < 1.0f) {
                Rectangle2D rectangle2D;
                Shape shape;
                object = this.getOwnerDoc().getRootElement();
                float f = object.getCurrentScale();
                SVGPoint sVGPoint = object.getCurrentTranslate();
                if (sVGPoint == null) {
                    sVGPoint = new SVGPointImpl();
                }
                AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
                if (this.font != null) {
                    shape = this.font.getBounds(this.getText(), this.xPos, this.yPos, this.fontSize);
                    Shape shape2 = affineTransform.createTransformedShape(shape);
                    rectangle2D = shape2.getBounds2D();
                } else {
                    shape = affineTransform.createTransformedShape(this.shape);
                    rectangle2D = shape.getBounds2D();
                }
                double d = rectangle2D.getWidth() / 5.0;
                double d2 = rectangle2D.getHeight() / 5.0;
                rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d2, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d2);
                int n = (int)(rectangle2D.getWidth() * (double)f);
                int n2 = (int)(rectangle2D.getHeight() * (double)f);
                if (n > 0 && n2 > 0) {
                    Object object4;
                    BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
                    Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D2.setRenderingHints(renderingHints);
                    if (f != 1.0f) {
                        graphics2D2.scale(f, f);
                    }
                    graphics2D2.translate(-rectangle2D.getX(), -rectangle2D.getY());
                    graphics2D2.transform(affineTransform);
                    if (this.font != null) {
                        double d3 = 0.0;
                        object4 = this.getTextAnchor();
                        if (object4 != null) {
                            if (((String)object4).equals("middle")) {
                                double d4 = rectangle2D.getWidth();
                                d3 = -d4 / 2.0;
                            } else if (((String)object4).equals("end")) {
                                double d5 = rectangle2D.getWidth();
                                d3 = -d5;
                            }
                        }
                        this.font.drawText(graphics2D2, this, this.getText(), (float)((double)this.xPos + d3), this.yPos, this.fontSize, bl);
                    } else {
                        graphics2D2.setStroke(this.stroke);
                        if (this.fillPaint != null) {
                            graphics2D2.setPaint(this.fillPaint);
                            graphics2D2.fill(this.shape);
                        }
                        if (this.linePaint != null) {
                            graphics2D2.setPaint(this.linePaint);
                            graphics2D2.draw(this.shape);
                        }
                    }
                    if (this.highlighted) {
                        graphics2D2.setPaint(Color.yellow);
                        SVGRect sVGRect = this.getBBox();
                        graphics2D2.draw(new Rectangle2D.Float(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight()));
                    }
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
                    graphics2D.setComposite(alphaComposite);
                    object4 = AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY());
                    ((AffineTransform)object4).scale(1.0f / f, 1.0f / f);
                    try {
                        ((AffineTransform)object4).preConcatenate(affineTransform.createInverse());
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    graphics2D.drawImage(bufferedImage, (AffineTransform)object4, null);
                    graphics2D.setComposite(composite);
                    bufferedImage.flush();
                }
            } else {
                if (this.font != null) {
                    double d = 0.0;
                    String string = this.getTextAnchor();
                    if (string != null) {
                        if (string.equals("middle")) {
                            double d6 = this.font.getBounds(this.getText(), this.xPos, this.yPos, this.fontSize).getWidth();
                            d = -d6 / 2.0;
                        } else if (string.equals("end")) {
                            double d7 = this.font.getBounds(this.getText(), this.xPos, this.yPos, this.fontSize).getWidth();
                            d = -d7;
                        }
                    }
                    this.font.drawText(graphics2D, this, this.getText(), (float)((double)this.xPos + d), this.yPos, this.fontSize, bl);
                } else {
                    graphics2D.setStroke(this.stroke);
                    if (this.fillPaint != null) {
                        graphics2D.setPaint(this.fillPaint);
                        graphics2D.fill(this.shape);
                    }
                    if (this.linePaint != null) {
                        graphics2D.setPaint(this.linePaint);
                        graphics2D.draw(this.shape);
                    }
                }
                if (this.highlighted) {
                    graphics2D.setPaint(Color.yellow);
                    SVGRect sVGRect = this.getBBox();
                    graphics2D.draw(new Rectangle2D.Float(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight()));
                }
            }
            graphics2D.setTransform((AffineTransform)object3);
            graphics2D.setClip((Shape)object2);
        }
    }

    public Shape getShape() {
        if (this.shape == null) {
            AffineTransform affineTransform = ((SVGMatrixImpl)this.getCTM()).getAffineTransform();
            return this.createShape(affineTransform);
        }
        return this.shape;
    }

    private Rectangle2D getBounds() {
        SVGFontElementImpl sVGFontElementImpl = this.getFontElement();
        if (sVGFontElementImpl != null) {
            AffineTransform affineTransform;
            AffineTransform affineTransform2 = ((SVGMatrixImpl)this.getCTM()).getAffineTransform();
            try {
                affineTransform = affineTransform2.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                affineTransform = null;
            }
            float f = this.getFontSize(affineTransform);
            float f2 = ((SVGLengthImpl)this.getX().getAnimVal().getItem(0)).getTransformedLength(affineTransform);
            float f3 = ((SVGLengthImpl)this.getY().getAnimVal().getItem(0)).getTransformedLength(affineTransform);
            Rectangle2D rectangle2D = sVGFontElementImpl.getBounds(this.getText(), f2, f3, f);
            Shape shape = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform().createTransformedShape(rectangle2D);
            return shape.getBounds2D();
        }
        Shape shape = this.getShape();
        Shape shape2 = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform().createTransformedShape(shape);
        return shape2.getBounds2D();
    }

    public SVGRect getBBox() {
        SVGFontElementImpl sVGFontElementImpl = this.getFontElement();
        if (sVGFontElementImpl != null) {
            AffineTransform affineTransform;
            AffineTransform affineTransform2 = ((SVGMatrixImpl)this.getCTM()).getAffineTransform();
            try {
                affineTransform = affineTransform2.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                affineTransform = null;
            }
            float f = this.getFontSize(affineTransform);
            float f2 = ((SVGLengthImpl)this.getX().getAnimVal().getItem(0)).getTransformedLength(affineTransform);
            float f3 = ((SVGLengthImpl)this.getY().getAnimVal().getItem(0)).getTransformedLength(affineTransform);
            Rectangle2D rectangle2D = sVGFontElementImpl.getBounds(this.getText(), f2, f3, f);
            return new SVGRectImpl(rectangle2D);
        }
        Shape shape = this.getShape();
        return new SVGRectImpl(shape.getBounds2D());
    }

    public boolean contains(double d, double d2) {
        Rectangle2D rectangle2D = this.getBounds();
        return rectangle2D.contains(d, d2);
    }

    public double boundingArea() {
        Rectangle2D rectangle2D = this.getBounds();
        return rectangle2D.getWidth() * rectangle2D.getHeight();
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("x")) {
            ((SVGAnimatedValue)((Object)this.getX())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("y")) {
            ((SVGAnimatedValue)((Object)this.getY())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("textLength")) {
            ((SVGAnimatedValue)((Object)this.getTextLength())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("lengthAdjust")) {
            ((SVGAnimatedValue)((Object)this.getLengthAdjust())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }

    static {
        String string = System.getProperty("java.version");
        is1_4OrGreater = "1.4".compareTo(string) < 0;
    }
}

