/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import org.csiro.svg.dom.SVGMatrixImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGTransform;

public class SVGTransformImpl
implements SVGTransform {
    protected short type;
    protected SVGMatrix matrix;
    protected float angle;
    protected SVGPoint rotateOrigin;

    public SVGTransformImpl() {
        this.type = 1;
        this.matrix = new SVGMatrixImpl();
        this.angle = 0.0f;
        this.rotateOrigin = new SVGPointImpl();
    }

    public SVGTransformImpl(SVGTransformImpl sVGTransformImpl) {
        this.type = sVGTransformImpl.getType();
        this.matrix = new SVGMatrixImpl((SVGMatrixImpl)sVGTransformImpl.getMatrix());
        this.angle = sVGTransformImpl.getAngle();
        this.rotateOrigin = new SVGPointImpl(sVGTransformImpl.getRotateOrigin());
    }

    public short getType() {
        return this.type;
    }

    public SVGMatrix getMatrix() {
        return this.matrix;
    }

    public float getAngle() {
        return this.angle;
    }

    public SVGPoint getRotateOrigin() {
        return this.rotateOrigin;
    }

    public void setMatrix(SVGMatrix sVGMatrix) {
        this.type = 1;
        this.matrix = sVGMatrix;
        this.angle = 0.0f;
        this.rotateOrigin.setX(0.0f);
        this.rotateOrigin.setY(0.0f);
    }

    public void setTranslate(float f, float f2) {
        this.type = (short)2;
        this.matrix = new SVGMatrixImpl();
        this.matrix = this.matrix.translate(f, f2);
        this.angle = 0.0f;
        this.rotateOrigin.setX(0.0f);
        this.rotateOrigin.setY(0.0f);
    }

    public void setScale(float f, float f2) {
        this.type = (short)3;
        this.matrix = new SVGMatrixImpl();
        this.matrix = this.matrix.scaleNonUniform(f, f2);
        this.angle = 0.0f;
        this.rotateOrigin.setX(0.0f);
        this.rotateOrigin.setY(0.0f);
    }

    public void setRotate(float f, float f2, float f3) {
        this.type = (short)4;
        this.matrix = new SVGMatrixImpl();
        this.matrix = this.matrix.translate(f2, f3);
        this.matrix = this.matrix.rotate(f);
        this.matrix = this.matrix.translate(-f2, -f3);
        this.angle = f;
        this.rotateOrigin.setX(f2);
        this.rotateOrigin.setY(f3);
    }

    public void setSkewX(float f) {
        this.type = (short)5;
        this.matrix = new SVGMatrixImpl();
        this.matrix = this.matrix.skewX(f);
        this.angle = f;
        this.rotateOrigin.setX(0.0f);
        this.rotateOrigin.setY(0.0f);
    }

    public void setSkewY(float f) {
        this.type = (short)6;
        this.matrix = new SVGMatrixImpl();
        this.matrix = this.matrix.skewY(f);
        this.angle = f;
        this.rotateOrigin.setX(0.0f);
        this.rotateOrigin.setY(0.0f);
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "matrix(" + this.getFloatString(this.matrix.getA()) + " " + this.getFloatString(this.matrix.getB()) + " " + this.getFloatString(this.matrix.getC()) + " " + this.getFloatString(this.matrix.getD()) + " " + this.getFloatString(this.matrix.getE()) + " " + this.getFloatString(this.matrix.getF()) + ")";
            }
            case 4: {
                if (this.rotateOrigin.getX() == 0.0f && this.rotateOrigin.getY() == 0.0f) {
                    return "rotate(" + this.getFloatString(this.angle) + ")";
                }
                return "rotate(" + this.getFloatString(this.angle) + " " + this.getFloatString(this.rotateOrigin.getX()) + " " + this.getFloatString(this.rotateOrigin.getY()) + ")";
            }
            case 3: {
                if (this.matrix.getA() == this.matrix.getD()) {
                    return "scale(" + this.getFloatString(this.matrix.getA()) + ")";
                }
                return "scale(" + this.getFloatString(this.matrix.getA()) + " " + this.getFloatString(this.matrix.getD()) + ")";
            }
            case 5: {
                return "skewX(" + this.getFloatString(this.angle) + ")";
            }
            case 6: {
                return "skewY(" + this.getFloatString(this.angle) + ")";
            }
            case 2: {
                return "translate(" + this.getFloatString(this.matrix.getE()) + " " + this.getFloatString(this.matrix.getF()) + ")";
            }
        }
        return "";
    }

    private String getFloatString(float f) {
        if ((float)((int)f) == f) {
            return "" + (int)f;
        }
        return "" + f;
    }
}

