/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;
import org.csiro.svg.dom.SVGExceptionImpl;
import org.csiro.svg.dom.SVGListImpl;
import org.csiro.svg.dom.SVGMatrixImpl;
import org.csiro.svg.dom.SVGTransformImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;

public class SVGTransformListImpl
extends SVGListImpl
implements SVGTransformList {
    public SVGTransform initialize(SVGTransform sVGTransform) throws DOMException, SVGException {
        return (SVGTransform)super.initialize(sVGTransform);
    }

    public SVGTransform getItem(int n) throws DOMException {
        return (SVGTransform)super.getItemAt(n);
    }

    public SVGTransform insertItemBefore(SVGTransform sVGTransform, int n) throws DOMException, SVGException {
        return (SVGTransform)super.insertItemBefore(sVGTransform, n);
    }

    public SVGTransform replaceItem(SVGTransform sVGTransform, int n) throws DOMException, SVGException {
        return (SVGTransform)super.replaceItem(sVGTransform, n);
    }

    public SVGTransform removeItem(int n) throws DOMException {
        return (SVGTransform)super.removeItemAt(n);
    }

    public SVGTransform appendItem(SVGTransform sVGTransform) throws DOMException, SVGException {
        return (SVGTransform)super.appendItem(sVGTransform);
    }

    public SVGTransform createSVGTransformFromMatrix(SVGMatrix sVGMatrix) {
        if (!(sVGMatrix instanceof SVGMatrixImpl)) {
            throw new SVGExceptionImpl(0, "Wrong item type for this list. Was expecting SVGMatrixImpl.");
        }
        SVGTransformImpl sVGTransformImpl = new SVGTransformImpl();
        sVGTransformImpl.setMatrix(sVGMatrix);
        return sVGTransformImpl;
    }

    public SVGTransform consolidate() {
        int n = this.getNumberOfItems();
        if (n == 0) {
            return null;
        }
        SVGTransform sVGTransform = this.getItem(0);
        SVGMatrix sVGMatrix = sVGTransform.getMatrix();
        int n2 = 1;
        while (n2 < n) {
            sVGTransform = this.getItem(n2);
            sVGMatrix = sVGMatrix.multiply(sVGTransform.getMatrix());
            ++n2;
        }
        SVGTransformImpl sVGTransformImpl = new SVGTransformImpl();
        sVGTransformImpl.setMatrix(sVGMatrix);
        this.initialize(sVGTransformImpl);
        return sVGTransformImpl;
    }

    static SVGTransformList createTransformList(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        SVGTransformListImpl sVGTransformListImpl = new SVGTransformListImpl();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "()", false);
        while (stringTokenizer.hasMoreTokens()) {
            float f;
            float f2;
            float f3;
            String string2 = stringTokenizer.nextToken().trim();
            if (!stringTokenizer.hasMoreTokens()) break;
            String string3 = stringTokenizer.nextToken().trim();
            if (string2.equals("matrix")) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ", ", false);
                int n = stringTokenizer2.countTokens();
                if (n == 6) {
                    f3 = Float.parseFloat(stringTokenizer2.nextToken());
                    f2 = Float.parseFloat(stringTokenizer2.nextToken());
                    f = Float.parseFloat(stringTokenizer2.nextToken());
                    float f4 = Float.parseFloat(stringTokenizer2.nextToken());
                    float f5 = Float.parseFloat(stringTokenizer2.nextToken());
                    float f6 = Float.parseFloat(stringTokenizer2.nextToken());
                    SVGTransformImpl sVGTransformImpl = new SVGTransformImpl();
                    SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl(f3, f2, f, f4, f5, f6);
                    sVGTransformImpl.setMatrix(sVGMatrixImpl);
                    sVGTransformListImpl.appendItem(sVGTransformImpl);
                    continue;
                }
                System.out.println("wrong number of args for matrix transform: matrix(" + string3 + ")");
                continue;
            }
            if (string2.equals("translate")) {
                StringTokenizer stringTokenizer3 = new StringTokenizer(string3, ", ", false);
                int n = stringTokenizer3.countTokens();
                f3 = 0.0f;
                f2 = 0.0f;
                if (n == 1) {
                    f3 = Float.parseFloat(stringTokenizer3.nextToken());
                } else if (n == 2) {
                    f3 = Float.parseFloat(stringTokenizer3.nextToken());
                    f2 = Float.parseFloat(stringTokenizer3.nextToken());
                } else {
                    System.out.println("wrong number of args for translate transform: translate(" + string3 + ")");
                    if (n > 2) {
                        f3 = Float.parseFloat(stringTokenizer3.nextToken());
                        f2 = Float.parseFloat(stringTokenizer3.nextToken());
                    }
                }
                SVGTransformImpl sVGTransformImpl = new SVGTransformImpl();
                sVGTransformImpl.setTranslate(f3, f2);
                sVGTransformListImpl.appendItem(sVGTransformImpl);
                continue;
            }
            if (string2.equals("scale")) {
                StringTokenizer stringTokenizer4 = new StringTokenizer(string3, ", ", false);
                int n = stringTokenizer4.countTokens();
                f3 = 0.0f;
                f2 = 0.0f;
                if (n == 1) {
                    f2 = f3 = Float.parseFloat(stringTokenizer4.nextToken());
                } else if (n == 2) {
                    f3 = Float.parseFloat(stringTokenizer4.nextToken());
                    f2 = Float.parseFloat(stringTokenizer4.nextToken());
                } else {
                    System.out.println("wrong number of args for scale transform: scale(" + string3 + ")");
                    if (n > 2) {
                        f3 = Float.parseFloat(stringTokenizer4.nextToken());
                        f2 = Float.parseFloat(stringTokenizer4.nextToken());
                    }
                }
                SVGTransformImpl sVGTransformImpl = new SVGTransformImpl();
                sVGTransformImpl.setScale(f3, f2);
                sVGTransformListImpl.appendItem(sVGTransformImpl);
                continue;
            }
            if (string2.equals("rotate")) {
                StringTokenizer stringTokenizer5 = new StringTokenizer(string3, ", ", false);
                int n = stringTokenizer5.countTokens();
                f3 = 0.0f;
                f2 = 0.0f;
                f = 0.0f;
                if (n == 1) {
                    f3 = Float.parseFloat(stringTokenizer5.nextToken());
                } else if (n == 3) {
                    f3 = Float.parseFloat(stringTokenizer5.nextToken());
                    f2 = Float.parseFloat(stringTokenizer5.nextToken());
                    f = Float.parseFloat(stringTokenizer5.nextToken());
                } else {
                    System.out.println("wrong number of args for rotate transform: rotate(" + string3 + ")");
                    if (n == 2) {
                        f3 = Float.parseFloat(stringTokenizer5.nextToken());
                    } else if (n > 3) {
                        f3 = Float.parseFloat(stringTokenizer5.nextToken());
                        f2 = Float.parseFloat(stringTokenizer5.nextToken());
                        f = Float.parseFloat(stringTokenizer5.nextToken());
                    }
                }
                SVGTransformImpl sVGTransformImpl = new SVGTransformImpl();
                sVGTransformImpl.setRotate(f3, f2, f);
                sVGTransformListImpl.appendItem(sVGTransformImpl);
                continue;
            }
            if (string2.equals("skewX")) {
                float f7 = Float.parseFloat(string3);
                SVGTransformImpl sVGTransformImpl = new SVGTransformImpl();
                sVGTransformImpl.setSkewX(f7);
                sVGTransformListImpl.appendItem(sVGTransformImpl);
                continue;
            }
            if (string2.equals("skewY")) {
                float f8 = Float.parseFloat(string3);
                SVGTransformImpl sVGTransformImpl = new SVGTransformImpl();
                sVGTransformImpl.setSkewY(f8);
                sVGTransformListImpl.appendItem(sVGTransformImpl);
                continue;
            }
            System.out.println("Invavid transform: " + string2 + "(" + string3 + ")");
        }
        return sVGTransformListImpl;
    }

    protected void checkItemType(Object object) throws SVGException {
        if (!(object instanceof SVGTransformImpl)) {
            throw new SVGExceptionImpl(0, "Wrong item type for this list. Was expecting SVGTransformImpl.");
        }
    }

    public String toString() {
        String string = "";
        long l = this.getNumberOfItems();
        int n = 0;
        while ((long)n < l) {
            string = string + this.getItem(n).toString();
            ++n;
        }
        return string;
    }

    public AffineTransform getAffineTransform() {
        int n = this.getNumberOfItems();
        if (n == 0) {
            return new AffineTransform();
        }
        SVGTransform sVGTransform = this.getItem(0);
        SVGMatrix sVGMatrix = sVGTransform.getMatrix();
        int n2 = 1;
        while (n2 < n) {
            sVGTransform = this.getItem(n2);
            sVGMatrix = sVGMatrix.multiply(sVGTransform.getMatrix());
            ++n2;
        }
        AffineTransform affineTransform = new AffineTransform(sVGMatrix.getA(), sVGMatrix.getB(), sVGMatrix.getC(), sVGMatrix.getD(), sVGMatrix.getE(), sVGMatrix.getF());
        return affineTransform;
    }
}

