/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.csiro.svg.dom.Drawable;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedPreserveAspectRatioImpl;
import org.csiro.svg.dom.SVGAnimatedStringImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGClipPathElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGGElementImpl;
import org.csiro.svg.dom.SVGGraphic;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGMatrixImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGSVGElementImpl;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGElementInstance;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGStylable;
import org.w3c.dom.svg.SVGSymbolElement;
import org.w3c.dom.svg.SVGUseElement;

public class SVGUseElementImpl
extends SVGGraphic
implements SVGUseElement,
Drawable {
    protected SVGAnimatedLength x;
    protected SVGAnimatedLength y;
    protected SVGAnimatedLength width;
    protected SVGAnimatedLength height;
    protected SVGAnimatedString href;
    boolean visible = true;
    boolean display = true;
    float opacity = 1.0f;
    Shape clipShape = null;
    SVGElementImpl clonedRef = null;
    String styleText = "";
    SVGClipPathElementImpl clipPath = null;

    public SVGUseElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "use");
        this.setAttribute("x", "0");
        this.setAttribute("y", "0");
        this.setAttribute("width", "100%");
        this.setAttribute("height", "100%");
        this.setAttribute("xlink:href", "");
    }

    public SVGUseElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "use");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGUseElementImpl sVGUseElementImpl = new SVGUseElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedLengthImpl)this.getX()).getAnimations();
        Vector vector2 = ((SVGAnimatedLengthImpl)this.getY()).getAnimations();
        Vector vector3 = ((SVGAnimatedLengthImpl)this.getWidth()).getAnimations();
        Vector vector4 = ((SVGAnimatedLengthImpl)this.getHeight()).getAnimations();
        Vector vector5 = ((SVGAnimatedStringImpl)this.getHref()).getAnimations();
        Vector vector6 = ((SVGAnimatedTransformListImpl)this.getTransform()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGUseElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGUseElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGUseElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector4 != null) {
            n = 0;
            while (n < vector4.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector4.elementAt(n);
                sVGUseElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector5 != null) {
            n = 0;
            while (n < vector5.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector5.elementAt(n);
                sVGUseElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector6 != null) {
            n = 0;
            while (n < vector6.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector6.elementAt(n);
                sVGUseElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGUseElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGUseElementImpl;
    }

    public SVGAnimatedLength getX() {
        if (this.x == null) {
            this.x = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 0), this);
        }
        return this.x;
    }

    public SVGAnimatedLength getY() {
        if (this.y == null) {
            this.y = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 1), this);
        }
        return this.y;
    }

    public SVGAnimatedLength getWidth() {
        if (this.width == null) {
            this.width = new SVGAnimatedLengthImpl(new SVGLengthImpl("100%", (SVGElement)this, 0), this);
        }
        return this.width;
    }

    public SVGAnimatedLength getHeight() {
        if (this.height == null) {
            this.height = new SVGAnimatedLengthImpl(new SVGLengthImpl("100%", (SVGElement)this, 1), this);
        }
        return this.height;
    }

    public SVGElementInstance getInstanceRoot() {
        return null;
    }

    public SVGElementInstance getAnimatedInstanceRoot() {
        return null;
    }

    public String getXlinkType() {
        return this.getAttribute("xlink:type");
    }

    public void setXlinkType(String string) throws DOMException {
        this.setAttribute("xlink:type", string);
    }

    public String getXlinkRole() {
        return this.getAttribute("xlink:role");
    }

    public void setXlinkRole(String string) throws DOMException {
        this.setAttribute("xlink:role", string);
    }

    public String getXlinkArcRole() {
        return this.getAttribute("xlink:arcrole");
    }

    public void setXlinkArcRole(String string) throws DOMException {
        this.setAttribute("xlink:arcrole", string);
    }

    public String getXlinkTitle() {
        return this.getAttribute("xlink:title");
    }

    public void setXlinkTitle(String string) throws DOMException {
        this.setAttribute("xlink:title", string);
    }

    public String getXlinkShow() {
        return this.getAttribute("xlink:show");
    }

    public void setXlinkShow(String string) throws DOMException {
        this.setAttribute("xlink:show", string);
    }

    public String getXlinkActuate() {
        return this.getAttribute("xlink:actuate");
    }

    public void setXlinkActuate(String string) throws DOMException {
        this.setAttribute("xlink:actuate", string);
    }

    public SVGAnimatedString getHref() {
        if (this.href == null) {
            this.href = new SVGAnimatedStringImpl("", this);
        }
        return this.href;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("x")) {
            return this.getX().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("y")) {
            return this.getY().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("width")) {
            return this.getWidth().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("height")) {
            return this.getHeight().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("xlink:href")) {
            return this.getHref().getBaseVal();
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("x")) {
            attr.setValue(this.getX().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("y")) {
            attr.setValue(this.getY().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("width")) {
            attr.setValue(this.getWidth().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("height")) {
            attr.setValue(this.getHeight().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("xlink:href")) {
            attr.setValue(this.getHref().getBaseVal());
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        String string = attr.getName();
        String string2 = attr.getValue();
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("x")) {
            this.getX().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("y")) {
            this.getY().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("width")) {
            this.getWidth().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("height")) {
            this.getHeight().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("xlink:href")) {
            this.getHref().setBaseVal(string2);
        }
    }

    public void draw(Graphics2D graphics2D, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        this.refreshData();
        this.visible = this.getVisibility();
        this.display = this.getDisplay();
        this.opacity = this.getOpacity();
        this.clipPath = this.getClippingPath();
        this.clipShape = null;
        if (this.clipPath != null) {
            this.clipShape = this.clipPath.getClippingShape(this);
        }
        this.clonedRef = null;
        String string = this.getHref().getAnimVal();
        if (string.length() > 0) {
            object3 = null;
            int n = string.indexOf(35);
            if (n != -1) {
                String string2 = string.substring(n + 1);
                string2 = string2.trim();
                object3 = this.getOwnerDoc().getElementById(string2);
                if (n > 0 && ((String)(object2 = this.getOwnerDoc().getURL().toLowerCase())).indexOf((String)(object = string.substring(0, n).toLowerCase())) < 0) {
                    object3 = null;
                    System.out.println("Use element error: External reference '" + string + "' not supported.");
                    return;
                }
            }
            if (object3 != null && (object3 instanceof Drawable || object3 instanceof SVGSymbolElement) && object3 instanceof SVGStylable) {
                this.clonedRef = ((SVGElementImpl)object3).cloneElement();
            } else {
                if (object3 == null) {
                    System.out.println("Use element error: Couldn't find element that matches reference '" + string + "'");
                    return;
                }
                System.out.println("Use element error: Found ref '" + string + "' but it wasn't a drawable object");
                return;
            }
        }
        if (this.visible && this.display && this.opacity > 0.0f && this.clonedRef != null) {
            object3 = graphics2D.getClip();
            if (this.clipShape != null) {
                graphics2D.clip(this.clipShape);
            }
            if (this.opacity < 1.0f) {
                SVGSVGElement sVGSVGElement = this.getOwnerDoc().getRootElement();
                float f = sVGSVGElement.getCurrentScale();
                object2 = sVGSVGElement.getCurrentTranslate();
                if (object2 == null) {
                    object2 = new SVGPointImpl();
                }
                object = this.getBBox();
                Rectangle2D.Double double_ = new Rectangle2D.Double(object.getX(), object.getY(), object.getWidth(), object.getHeight());
                AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
                Shape shape = affineTransform.createTransformedShape(double_);
                Rectangle2D rectangle2D = shape.getBounds2D();
                double d = rectangle2D.getWidth() / 5.0;
                double d2 = rectangle2D.getHeight() / 5.0;
                rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d2, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d2);
                int n = (int)(rectangle2D.getWidth() * (double)f);
                int n2 = (int)(rectangle2D.getHeight() * (double)f);
                if (n > 0 && n2 > 0) {
                    BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
                    Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D2.setRenderingHints(renderingHints);
                    if (f != 1.0f) {
                        graphics2D2.scale(f, f);
                    }
                    graphics2D2.translate(-rectangle2D.getX(), -rectangle2D.getY());
                    graphics2D2.transform(affineTransform);
                    this.drawShape(graphics2D2, bl);
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
                    graphics2D.setComposite(alphaComposite);
                    AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY());
                    affineTransform2.scale(1.0f / f, 1.0f / f);
                    try {
                        affineTransform2.preConcatenate(affineTransform.createInverse());
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    graphics2D.drawImage(bufferedImage, affineTransform2, null);
                    graphics2D.setComposite(composite);
                    bufferedImage.flush();
                }
            } else {
                this.drawShape(graphics2D, bl);
            }
            graphics2D.setClip((Shape)object3);
        }
    }

    private void drawShape(Graphics2D graphics2D, boolean bl) {
        SVGGElementImpl sVGGElementImpl = new SVGGElementImpl(this.getOwnerDoc());
        sVGGElementImpl.copyAttributes(this);
        sVGGElementImpl.animatedProperties = this.animatedProperties;
        sVGGElementImpl.removeAttribute("x");
        sVGGElementImpl.removeAttribute("y");
        sVGGElementImpl.removeAttribute("width");
        sVGGElementImpl.removeAttribute("height");
        sVGGElementImpl.removeAttribute("xlink:href");
        sVGGElementImpl.setAttribute("transform", ((SVGTransformListImpl)this.getTransform().getAnimVal()).toString() + "translate(" + this.getX().getAnimVal().getValue() + ", " + this.getY().getAnimVal().getValue() + ")");
        this.getParentNode().appendChild(sVGGElementImpl);
        if (this.clonedRef instanceof SVGSymbolElement) {
            SVGSVGElementImpl sVGSVGElementImpl = new SVGSVGElementImpl(this.getOwnerDoc());
            sVGGElementImpl.appendChild(sVGSVGElementImpl);
            ((SVGAnimatedLengthImpl)sVGSVGElementImpl.getWidth()).setBaseVal(this.getWidth().getBaseVal());
            ((SVGAnimatedLengthImpl)sVGSVGElementImpl.getHeight()).setBaseVal(this.getHeight().getBaseVal());
            Vector<Node> vector = new Vector<Node>();
            if (this.clonedRef.hasChildNodes()) {
                NodeList nodeList = this.clonedRef.getChildNodes();
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Node node = nodeList.item(n2);
                    if (node instanceof Drawable) {
                        vector.add(node);
                    }
                    ++n2;
                }
            }
            int n = 0;
            while (n < vector.size()) {
                Node node = (Node)vector.elementAt(n);
                this.clonedRef.removeChild(node);
                sVGSVGElementImpl.appendChild(node);
                ++n;
            }
            ((SVGAnimatedPreserveAspectRatioImpl)sVGSVGElementImpl.getPreserveAspectRatio()).setBaseVal(((SVGSymbolElement)((Object)this.clonedRef)).getPreserveAspectRatio().getBaseVal());
            if (((SVGSymbolElement)((Object)this.clonedRef)).getViewBox().getAnimVal().getWidth() > 0.0f) {
                sVGSVGElementImpl.setAttribute("viewBox", ((SVGRectImpl)((SVGSymbolElement)((Object)this.clonedRef)).getViewBox().getBaseVal()).toString());
            } else {
                sVGSVGElementImpl.setAttribute("viewBox", "0,0," + this.getWidth().getAnimVal().getValue() + "," + this.getHeight().getAnimVal().getValue());
            }
            sVGGElementImpl.draw(graphics2D, true);
        } else {
            sVGGElementImpl.appendChild(this.clonedRef);
            if (this.clonedRef instanceof SVGSVGElement) {
                ((SVGAnimatedLengthImpl)((SVGSVGElement)((Object)this.clonedRef)).getWidth()).setBaseVal(this.getWidth().getBaseVal());
                ((SVGAnimatedLengthImpl)((SVGSVGElement)((Object)this.clonedRef)).getHeight()).setBaseVal(this.getHeight().getBaseVal());
            }
            sVGGElementImpl.draw(graphics2D, true);
        }
        this.getParentNode().removeChild(sVGGElementImpl);
    }

    public SVGRect getBBox() {
        AffineTransform affineTransform;
        AffineTransform affineTransform2 = ((SVGMatrixImpl)this.getCTM()).getAffineTransform();
        try {
            affineTransform = affineTransform2.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            affineTransform = null;
        }
        float f = ((SVGLengthImpl)this.getX().getAnimVal()).getTransformedLength(affineTransform);
        float f2 = ((SVGLengthImpl)this.getY().getAnimVal()).getTransformedLength(affineTransform);
        float f3 = ((SVGLengthImpl)this.getWidth().getAnimVal()).getTransformedLength(affineTransform);
        float f4 = ((SVGLengthImpl)this.getHeight().getAnimVal()).getTransformedLength(affineTransform);
        SVGRectImpl sVGRectImpl = new SVGRectImpl(f, f2, f3, f4);
        return sVGRectImpl;
    }

    public boolean contains(double d, double d2) {
        SVGRect sVGRect = this.getBBox();
        Rectangle2D.Double double_ = new Rectangle2D.Double(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight());
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape = affineTransform.createTransformedShape(double_);
        return shape.contains(d, d2);
    }

    public double boundingArea() {
        SVGRect sVGRect = this.getBBox();
        Rectangle2D.Double double_ = new Rectangle2D.Double(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight());
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape = affineTransform.createTransformedShape(double_);
        Rectangle2D rectangle2D = shape.getBounds2D();
        return rectangle2D.getWidth() * rectangle2D.getHeight();
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("x")) {
            ((SVGAnimatedValue)((Object)this.getX())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("y")) {
            ((SVGAnimatedValue)((Object)this.getY())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("width")) {
            ((SVGAnimatedValue)((Object)this.getWidth())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("height")) {
            ((SVGAnimatedValue)((Object)this.getHeight())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

