/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.util.StringTokenizer;
import java.util.Vector;
import org.csiro.svg.dom.SVGAnimatedBooleanImpl;
import org.csiro.svg.dom.SVGAnimatedPreserveAspectRatioImpl;
import org.csiro.svg.dom.SVGAnimatedRectImpl;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGPreserveAspectRatioImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGStringListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGStringList;
import org.w3c.dom.svg.SVGViewElement;

public class SVGViewElementImpl
extends SVGElementImpl
implements SVGViewElement {
    protected SVGAnimatedRect viewBox;
    protected SVGAnimatedPreserveAspectRatio preserveAspectRatio;
    protected SVGAnimatedBoolean externalResourcesRequired;

    public SVGViewElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "view");
    }

    public SVGViewElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "view");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGViewElementImpl sVGViewElementImpl = new SVGViewElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedRectImpl)this.getViewBox()).getAnimations();
        Vector vector2 = ((SVGAnimatedPreserveAspectRatioImpl)this.getPreserveAspectRatio()).getAnimations();
        Vector vector3 = ((SVGAnimatedBooleanImpl)this.getExternalResourcesRequired()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGViewElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGViewElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGViewElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        return sVGViewElementImpl;
    }

    public short getZoomAndPan() {
        String string = this.getAttribute("zoomAndPan");
        if (string.equals("disable")) {
            return 1;
        }
        if (string.equals("magnify")) {
            return 2;
        }
        return 2;
    }

    public void setZoomAndPan(short s) {
        if (s == 1) {
            this.setAttribute("zoomAndPan", "disable");
        } else if (s == 2) {
            this.setAttribute("zoomAndPan", "magnify");
        } else {
            System.out.println("bad zoomAndPan value: " + s + ", setting to default value 'magnify'");
            this.setAttribute("zoomAndPan", "magnify");
        }
    }

    public SVGAnimatedRect getViewBox() {
        if (this.viewBox == null) {
            this.viewBox = new SVGAnimatedRectImpl(new SVGRectImpl(), this);
        }
        return this.viewBox;
    }

    public SVGAnimatedPreserveAspectRatio getPreserveAspectRatio() {
        if (this.preserveAspectRatio == null) {
            this.preserveAspectRatio = new SVGAnimatedPreserveAspectRatioImpl(new SVGPreserveAspectRatioImpl(), this);
        }
        return this.preserveAspectRatio;
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        if (this.externalResourcesRequired == null) {
            this.externalResourcesRequired = new SVGAnimatedBooleanImpl(false, this);
        }
        return this.externalResourcesRequired;
    }

    public SVGStringList getViewTarget() {
        SVGStringListImpl sVGStringListImpl = new SVGStringListImpl(this.getAttribute("viewTarget"));
        return sVGStringListImpl;
    }

    public void setViewTarget(SVGElement sVGElement) throws DOMException {
        this.setAttribute("viewTarget", sVGElement.getId());
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("viewBox")) {
            if (this.getViewBox().getBaseVal().getWidth() == 0.0f) {
                return "";
            }
            return ((SVGRectImpl)this.getViewBox().getBaseVal()).toString();
        }
        if (string.equalsIgnoreCase("preserveAspectRatio")) {
            return ((SVGPreserveAspectRatioImpl)this.getPreserveAspectRatio().getBaseVal()).toString();
        }
        if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                return "true";
            }
            return "false";
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("viewBox")) {
            if (this.getViewBox().getBaseVal().getWidth() == 0.0f) {
                attr.setValue("");
            } else {
                attr.setValue(((SVGRectImpl)this.getViewBox().getBaseVal()).toString());
            }
        } else if (string.equalsIgnoreCase("preserveAspectRatio")) {
            attr.setValue(((SVGPreserveAspectRatioImpl)this.getPreserveAspectRatio().getBaseVal()).toString());
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                attr.setValue("true");
            } else {
                attr.setValue("false");
            }
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("viewBox")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
            if (stringTokenizer.countTokens() == 4) {
                this.getViewBox().getBaseVal().setX(Float.parseFloat(stringTokenizer.nextToken()));
                this.getViewBox().getBaseVal().setY(Float.parseFloat(stringTokenizer.nextToken()));
                this.getViewBox().getBaseVal().setWidth(Float.parseFloat(stringTokenizer.nextToken()));
                this.getViewBox().getBaseVal().setHeight(Float.parseFloat(stringTokenizer.nextToken()));
            }
        } else if (string.equalsIgnoreCase("preserveAspectRatio")) {
            short s;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
            String string3 = null;
            String string4 = null;
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                string3 = stringTokenizer.nextToken();
                if (n > 1) {
                    string4 = stringTokenizer.nextToken();
                }
            }
            if (string3 != null) {
                s = SVGPreserveAspectRatioImpl.getAlignConst(string3);
                this.getPreserveAspectRatio().getBaseVal().setAlign(s);
            }
            if (string4 != null) {
                s = SVGPreserveAspectRatioImpl.getMeetOrSliceConst(string4);
                this.getPreserveAspectRatio().getBaseVal().setMeetOrSlice(s);
            }
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (string2.equalsIgnoreCase("true")) {
                this.getExternalResourcesRequired().setBaseVal(true);
            } else {
                this.getExternalResourcesRequired().setBaseVal(false);
            }
        }
    }
}

