/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGStylableImpl;
import org.csiro.svg.parser.SVGParseException;
import org.csiro.svg.parser.SVGParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGStylable;

public class CSStoPresentation {
    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("usage: java org.csiro.svg.parser.CSStoPresentation in.svg out.svg");
            System.exit(1);
        }
        try {
            SVGParser sVGParser = new SVGParser();
            SVGDocumentImpl sVGDocumentImpl = sVGParser.parseSVG(stringArray[0]);
            CSStoPresentation.convertStyle(sVGDocumentImpl);
            FileOutputStream fileOutputStream = new FileOutputStream(new File(stringArray[1]));
            OutputFormat outputFormat = new OutputFormat((Document)sVGDocumentImpl);
            outputFormat.setPreserveSpace(true);
            outputFormat.setDoctype(OutputFormat.whichDoctypePublic((Document)sVGDocumentImpl), OutputFormat.whichDoctypeSystem((Document)sVGDocumentImpl));
            outputFormat.setOmitXMLDeclaration(false);
            XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)fileOutputStream, outputFormat);
            xMLSerializer.serialize((Document)sVGDocumentImpl);
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
            System.exit(1);
        }
        catch (SVGParseException sVGParseException) {
            System.out.println("SVGParseException: " + sVGParseException.getMessage());
            System.exit(1);
        }
        System.out.println("finished writing svg file: " + stringArray[1]);
        System.exit(0);
    }

    public static void convertStyle(Node node) {
        int n;
        Object object;
        if (node instanceof SVGStylable && (object = ((SVGStylableImpl)node).getStyle()) != null) {
            n = 0;
            while (n < object.getLength()) {
                String string = object.item(n);
                String string2 = object.getPropertyValue(object.item(n));
                ((Element)node).setAttribute(string, string2);
                ++n;
            }
            ((Element)node).removeAttribute("style");
        }
        object = node.getChildNodes();
        n = 0;
        while (n < object.getLength()) {
            CSStoPresentation.convertStyle(object.item(n));
            ++n;
        }
    }
}

