/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.parser.XmlWriter;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGCircleElement;
import org.w3c.dom.svg.SVGRectElement;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGTextElement;

public class CreateSVG {
    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("usage: java org.csiro.svg.parser.CreateSVG out.svg");
            System.exit(1);
        }
        try {
            SVGDocumentImpl sVGDocumentImpl = new SVGDocumentImpl();
            SVGSVGElement sVGSVGElement = (SVGSVGElement)sVGDocumentImpl.createElement("svg");
            sVGDocumentImpl.appendChild(sVGSVGElement);
            sVGSVGElement.setAttribute("width", "600");
            sVGSVGElement.setAttribute("height", "600");
            SVGCircleElement sVGCircleElement = (SVGCircleElement)sVGDocumentImpl.createElement("circle");
            sVGCircleElement.getCx().getBaseVal().setValueAsString("100px");
            sVGCircleElement.setAttribute("cy", "100");
            sVGCircleElement.setAttribute("r", "50");
            sVGCircleElement.setAttribute("style", "fill:red; stroke:black; stroke-width:5");
            sVGSVGElement.appendChild(sVGCircleElement);
            SVGRectElement sVGRectElement = (SVGRectElement)sVGDocumentImpl.createElement("rect");
            sVGRectElement.setAttribute("x", "200px");
            sVGRectElement.setAttribute("y", "250px");
            sVGRectElement.setAttribute("width", "200");
            sVGRectElement.setAttribute("height", "150");
            sVGRectElement.setAttribute("style", "fill:none; stroke:blue; stroke-width:10");
            sVGSVGElement.appendChild(sVGRectElement);
            SVGTextElement sVGTextElement = (SVGTextElement)sVGDocumentImpl.createElement("text");
            sVGTextElement.setAttribute("x", "100");
            sVGTextElement.setAttribute("y", "300");
            Text text = sVGDocumentImpl.createTextNode("This is some text");
            sVGTextElement.appendChild(text);
            sVGSVGElement.appendChild(sVGTextElement);
            FileOutputStream fileOutputStream = new FileOutputStream(new File(stringArray[0]));
            XmlWriter xmlWriter = new XmlWriter(fileOutputStream);
            String string = "<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 20001102//EN\"\"http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtd\">";
            xmlWriter.print((Node)sVGDocumentImpl, string);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
            System.exit(1);
        }
        System.out.println("finished writing svg file: " + stringArray[0]);
        System.exit(0);
    }
}

