/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.parser;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGSVGElementImpl;
import org.csiro.svg.parser.SVGParseException;
import org.csiro.svg.parser.SVGParser;

public class ParseTest {
    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("usage: java org.csiro.svg.parser.ParseTest in.svg out.jpg");
            System.exit(1);
        }
        try {
            SVGParser sVGParser = new SVGParser();
            SVGDocumentImpl sVGDocumentImpl = sVGParser.parseSVG(stringArray[0]);
            System.out.println("parsed svg file: " + stringArray[0] + " successfully");
            SVGSVGElementImpl sVGSVGElementImpl = (SVGSVGElementImpl)sVGDocumentImpl.getRootElement();
            BufferedImage bufferedImage = new BufferedImage((int)sVGSVGElementImpl.getWidth().getBaseVal().getValue(), (int)sVGSVGElementImpl.getHeight().getBaseVal().getValue(), 5);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, (int)sVGSVGElementImpl.getWidth().getBaseVal().getValue(), (int)sVGSVGElementImpl.getHeight().getBaseVal().getValue());
            sVGDocumentImpl.draw(graphics2D);
            File file = new File(stringArray[1]);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            JPEGEncodeParam jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
            jPEGEncodeParam.setQuality(0.9f, true);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            fileOutputStream.close();
        }
        catch (SVGParseException sVGParseException) {
            System.out.println("SVGParseException: " + sVGParseException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
            System.exit(1);
        }
        System.out.println("finished writing new jpg file: " + stringArray[1]);
        System.exit(0);
    }
}

