/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.xerces.parsers.DOMParser;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.parser.SVGParseException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SVGParser
extends DOMParser
implements ErrorHandler,
EntityResolver {
    public SVGDocumentImpl parseSVG(String string) throws SVGParseException {
        Object object;
        Object object2;
        Object object3;
        boolean bl = false;
        if (string.startsWith("http:") || string.startsWith("ftp:") || string.startsWith("file:")) {
            try {
                object3 = new URL(string);
                object2 = ((URL)object3).openConnection();
                object = ((URLConnection)object2).getContentType();
                if (((String)object).indexOf("zip") != -1 || string.endsWith(".zip")) {
                    bl = true;
                }
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("bad url: " + string);
            }
            catch (IOException iOException) {
                System.out.println("IOException while getting SVG stream");
            }
        } else if (string.endsWith(".zip")) {
            bl = true;
        }
        try {
            this.setFeature("http://xml.org/sax/features/validation", true);
            this.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
            this.setErrorHandler(this);
            this.setEntityResolver(this);
            this.setFeature("http://xml.org/sax/features/namespaces", false);
            object3 = null;
            if (string.startsWith("http:") || string.startsWith("ftp:") || string.startsWith("file:")) {
                object2 = new URL(string);
                object = ((URL)object2).openConnection();
                if (bl) {
                    ZipInputStream zipInputStream = new ZipInputStream(((URLConnection)object).getInputStream());
                    ZipEntry zipEntry = zipInputStream.getNextEntry();
                    object3 = zipInputStream;
                } else {
                    object3 = ((URLConnection)object).getInputStream();
                }
            } else {
                object2 = new File(string);
                if (bl) {
                    object = new ZipInputStream(new FileInputStream((File)object2));
                    ZipEntry zipEntry = ((ZipInputStream)object).getNextEntry();
                    object3 = object;
                } else if (((File)object2).exists()) {
                    object3 = new FileInputStream((File)object2);
                } else {
                    System.out.println("\nFILE IO ERROR: Unable to find file '" + string + "'\n");
                    object2 = null;
                    return null;
                }
            }
            if (object3 != null) {
                this.parse(new InputSource((InputStream)object3));
                ((InputStream)object3).close();
            }
        }
        catch (SAXException sAXException) {
            System.out.println("SAXException in parsing XML: " + sAXException.getMessage());
            sAXException.printStackTrace();
            throw new SVGParseException("Fatal parsing error while trying to parse: " + string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("bad url: " + string);
            malformedURLException.printStackTrace();
            throw new SVGParseException("Cannot parse bad URL: " + string);
        }
        catch (IOException iOException) {
            System.out.println("IOException in parsing XML: " + iOException.getMessage());
            iOException.printStackTrace();
            throw new SVGParseException("Fatal IO error while trying to parse: " + string);
        }
        catch (Exception exception) {
            System.out.println("IOException in parsing XML: " + exception.getMessage());
            exception.printStackTrace();
            throw new SVGParseException("Fatal error while trying to parse: " + string);
        }
        System.out.println("xml parsing finished");
        object3 = this.getDocument();
        object2 = new SVGDocumentImpl((Document)object3);
        ((SVGDocumentImpl)object2).setURL(string);
        return object2;
    }

    public void warning(SAXParseException sAXParseException) {
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    public InputSource resolveEntity(String string, String string2) {
        if (string.indexOf("SVG 1.0") != -1) {
            return new InputSource(this.getClass().getResourceAsStream("/dtds/svg10.dtd"));
        }
        if (string.indexOf("20001102") != -1) {
            return new InputSource(this.getClass().getResourceAsStream("/dtds/svg-20001102.dtd"));
        }
        if (string.indexOf("20000802") != -1) {
            return new InputSource(this.getClass().getResourceAsStream("/dtds/svg-20000802.dtd"));
        }
        if (string.indexOf("20000629") != -1) {
            return new InputSource(this.getClass().getResourceAsStream("/dtds/svg-20000629.dtd"));
        }
        if (string.indexOf("20000303 Stylable") != -1) {
            return new InputSource(this.getClass().getResourceAsStream("/dtds/svg-20000303-stylable.dtd"));
        }
        if (string.indexOf("20000303 Shared") != -1) {
            return new InputSource(this.getClass().getResourceAsStream("/dtds/svg-20000303-shared.dtd"));
        }
        return null;
    }
}

