/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.parser;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlWriter {
    PrintWriter out;

    public XmlWriter(OutputStream outputStream) {
        this.out = new PrintWriter(outputStream);
    }

    public void print(Node node) {
        this.print(node, null, 0);
    }

    public void print(Node node, String string) {
        this.print(node, string, 0);
    }

    public void print(Node node, int n) {
        this.print(node, null, n);
    }

    public void print(Node node, String string, int n) {
        if (node == null) {
            return;
        }
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = string2 + " ";
            ++n2;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.out.println("<?xml version=\"1.0\" standalone=\"no\" ?>");
                if (string != null) {
                    this.out.println(string);
                }
                this.print((Node)((Document)node).getDocumentElement(), 0);
                this.out.flush();
                break;
            }
            case 1: {
                Object object;
                this.out.print(string2 + "<");
                this.out.print(node.getNodeName());
                Attr[] attrArray = this.sortAttributes(node.getAttributes());
                int n3 = 0;
                while (n3 < attrArray.length) {
                    object = attrArray[n3];
                    if (object.getNodeValue().length() > 0) {
                        this.out.print(' ');
                        this.out.print(object.getNodeName());
                        this.out.print("=\"");
                        this.out.print(this.normalize(object.getNodeValue()));
                        this.out.print('\"');
                    }
                    ++n3;
                }
                this.out.println('>');
                object = node.getChildNodes();
                if (object == null) break;
                int n4 = object.getLength();
                int n5 = 0;
                while (n5 < n4) {
                    this.print(object.item(n5), n + 2);
                    ++n5;
                }
                break;
            }
            case 5: {
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                this.out.print(string2 + "<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.println("]]>");
                break;
            }
            case 3: {
                if (node.getNodeValue().trim().length() <= 0) break;
                this.out.println(string2 + this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print(string2 + "<?");
                this.out.print(node.getNodeName());
                String string3 = node.getNodeValue();
                if (string3 != null && string3.length() > 0) {
                    this.out.print(' ');
                    this.out.print(string3);
                }
                this.out.println("?>");
            }
        }
        if (s == 1) {
            this.out.print(string2 + "</");
            this.out.print(node.getNodeName());
            this.out.println('>');
        }
        this.out.flush();
    }

    protected Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n];
        int n2 = 0;
        while (n2 < n) {
            attrArray[n2] = (Attr)namedNodeMap.item(n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            Object object;
            Object object2 = attrArray[n3].getNodeName();
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < n) {
                object = attrArray[n5].getNodeName();
                if (((String)object).compareTo((String)object2) < 0) {
                    object2 = object;
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 != n3) {
                object = attrArray[n3];
                attrArray[n3] = attrArray[n4];
                attrArray[n4] = object;
            }
            ++n3;
        }
        return attrArray;
    }

    protected String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

