/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.tools;

import java.io.ByteArrayOutputStream;
import java.util.TreeMap;

public class Base64Filter {
    private static Base64Filter s_instance = null;
    private static final char[] s_code = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private TreeMap m_encodeMappings;
    private TreeMap m_decodeMappings;

    private Base64Filter() {
        this.loadEncodeMappings();
        this.loadDecodeMappings();
    }

    public static Base64Filter instance() {
        if (s_instance == null) {
            s_instance = new Base64Filter();
        }
        return s_instance;
    }

    public byte[] decode(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        boolean bl = false;
        while (!bl) {
            int n2 = 3;
            if (n == string.length()) {
                bl = true;
                continue;
            }
            char c = string.charAt(n++);
            while (this.discardable(c)) {
                c = string.charAt(n++);
            }
            char c2 = string.charAt(n++);
            while (this.discardable(c2)) {
                c2 = string.charAt(n++);
            }
            char c3 = string.charAt(n++);
            while (this.discardable(c3)) {
                c3 = string.charAt(n++);
            }
            char c4 = string.charAt(n++);
            while (this.discardable(c4)) {
                c4 = string.charAt(n++);
            }
            byte by = (Byte)this.m_decodeMappings.get(new Character(c));
            byte by2 = (Byte)this.m_decodeMappings.get(new Character(c2));
            byte by3 = 0;
            byte by4 = 0;
            if (c3 == '=') {
                bl = true;
                n2 = 1;
            } else {
                by3 = (Byte)this.m_decodeMappings.get(new Character(c3));
                if (c4 == '=') {
                    bl = true;
                    n2 = 2;
                } else {
                    by4 = (Byte)this.m_decodeMappings.get(new Character(c4));
                }
            }
            byte by5 = (byte)(this.leftShift(by, 2) | this.rightShift(by2, 4));
            byteArrayOutputStream.write(by5);
            byte by6 = 0;
            byte by7 = 0;
            if (n2 <= 1) continue;
            by6 = (byte)(this.leftShift((byte)(by2 & 0xF), 4) | this.rightShift(by3, 2));
            byteArrayOutputStream.write(by6);
            if (n2 <= 2) continue;
            by7 = (byte)(this.leftShift((byte)(by3 & 3), 6) | by4);
            byteArrayOutputStream.write(by7);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length / 3;
        int n2 = byArray.length % 3;
        int n3 = 0;
        while (n3 <= n) {
            int n4 = n3 == n ? n2 : 3;
            byte by = 0;
            byte by2 = 0;
            byte by3 = 0;
            byte by4 = 0;
            byte by5 = 0;
            byte by6 = 0;
            byte by7 = 0;
            char c = '=';
            char c2 = '=';
            char c3 = '=';
            char c4 = '=';
            if (n4 > 0) {
                by = byArray[n3 * 3];
                if (n4 > 1) {
                    by2 = byArray[n3 * 3 + 1];
                    if (n4 > 2) {
                        by3 = byArray[n3 * 3 + 2];
                    }
                }
            }
            if (n4 > 0) {
                by4 = this.rightShift(by, 2);
                by5 = (byte)(this.leftShift((byte)(by & 3), 4) | this.rightShift(by2, 4));
                c = ((Character)this.m_encodeMappings.get(new Byte(by4))).charValue();
                c2 = ((Character)this.m_encodeMappings.get(new Byte(by5))).charValue();
                if (n4 > 1) {
                    by6 = (byte)(this.leftShift((byte)(by2 & 0xF), 2) | this.rightShift(by3, 6));
                    c3 = ((Character)this.m_encodeMappings.get(new Byte(by6))).charValue();
                    if (n4 > 2) {
                        by7 = (byte)(by3 & 0x3F);
                        c4 = ((Character)this.m_encodeMappings.get(new Byte(by7))).charValue();
                    }
                }
            }
            if (n4 > 0) {
                stringBuffer.append(c);
                stringBuffer.append(c2);
                stringBuffer.append(c3);
                stringBuffer.append(c4);
                if (stringBuffer.length() % 73 == 72) {
                    stringBuffer.append("\n");
                }
            }
            ++n3;
        }
        return stringBuffer.toString().getBytes();
    }

    private void loadEncodeMappings() {
        this.m_encodeMappings = new TreeMap();
        int n = 0;
        while (n < 64) {
            this.m_encodeMappings.put(new Byte((byte)n), new Character(s_code[n]));
            ++n;
        }
    }

    private void loadDecodeMappings() {
        this.m_decodeMappings = new TreeMap();
        int n = 0;
        while (n < 64) {
            this.m_decodeMappings.put(new Character(s_code[n]), new Byte((byte)n));
            ++n;
        }
    }

    private boolean discardable(char c) {
        if (c == '=') {
            return false;
        }
        return !this.m_decodeMappings.containsKey(new Character(c));
    }

    private byte rightShift(byte by, int n) {
        return (byte)(by >>> n & (1 << 8 - n) - 1);
    }

    private byte leftShift(byte by, int n) {
        return (byte)((by & (1 << 8 - n) - 1) << n);
    }
}

