/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.tools;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGSVGElementImpl;
import org.csiro.svg.parser.SVGParseException;
import org.csiro.svg.parser.SVGParser;
import org.csiro.svg.viewer.Canvas;

public class SvgToJpegConverter {
    public static void convert(String string, String string2) {
        String[] stringArray = new String[]{string, string2};
        SvgToJpegConverter.convert(stringArray);
    }

    public static void convert(String string, String string2, int n, int n2) {
        String[] stringArray = new String[]{string, string2, Integer.toString(n), Integer.toString(n2)};
        SvgToJpegConverter.convert(stringArray);
    }

    public static void convert(String string, String string2, int n, int n2, double d, double d2, double d3, double d4) {
        String[] stringArray = new String[]{string, string2, Integer.toString(n), Integer.toString(n2), Double.toString(d), Double.toString(d2), Double.toString(d3), Double.toString(d4)};
        SvgToJpegConverter.convert(stringArray);
    }

    private static void convert(String[] stringArray) {
        try {
            SVGParser sVGParser = new SVGParser();
            SVGDocumentImpl sVGDocumentImpl = sVGParser.parseSVG(stringArray[0]);
            SVGSVGElementImpl sVGSVGElementImpl = (SVGSVGElementImpl)sVGDocumentImpl.getRootElement();
            Canvas canvas = new Canvas();
            if (stringArray.length == 2) {
                canvas.setSize((int)sVGSVGElementImpl.getWidth().getBaseVal().getValue(), (int)sVGSVGElementImpl.getHeight().getBaseVal().getValue());
            } else {
                canvas.setSize(Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
            }
            canvas.setBackground(Color.white);
            canvas.setSVGDocument(sVGDocumentImpl);
            if (stringArray.length == 8) {
                canvas.setView(Double.parseDouble(stringArray[4]), Double.parseDouble(stringArray[5]), Double.parseDouble(stringArray[6]), Double.parseDouble(stringArray[7]));
            } else if (stringArray.length == 4) {
                canvas.setView(0.0, 0.0, sVGSVGElementImpl.getWidth().getBaseVal().getValue(), sVGSVGElementImpl.getHeight().getBaseVal().getValue());
            } else {
                canvas.zoomAll();
            }
            BufferedImage bufferedImage = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 5);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            canvas.doPaint(graphics2D);
            File file = new File(stringArray[1]);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            JPEGEncodeParam jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
            jPEGEncodeParam.setQuality(0.9f, true);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            System.out.println("created jpeg file: " + stringArray[1]);
        }
        catch (IOException iOException) {
            System.out.println("Failed to write JPEG file. Got execption: " + iOException.getMessage());
        }
        catch (SVGParseException sVGParseException) {
            System.out.println("Parse exception while parsing SVG file: " + sVGParseException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2 && stringArray.length != 4 && stringArray.length != 8) {
            System.out.println("usage: java org.csiro.svg.tools.SvgToJpegConverter infile.svg outfile.jpg [width height [viewX viewY viewWidth viewHeight]]");
            System.exit(1);
        }
        SvgToJpegConverter.convert(stringArray);
        System.exit(0);
    }
}

