/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JComponent;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGSVGElementImpl;
import org.csiro.svg.dom.events.UIEventImpl;
import org.csiro.svg.viewer.WorldMouseEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class Canvas
extends JComponent
implements Printable,
Pageable,
AbstractView {
    Rectangle2D.Double theView = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    Rectangle theCanvas = new Rectangle(0, 0, 0, 0);
    private double screenToWorldX;
    private double screenToWorldY;
    private double worldToScreenX;
    private double worldToScreenY;
    private boolean useDoubleBuffer = true;
    private boolean doAntiAliasing = true;
    protected SVGDocumentImpl svgDoc = null;
    boolean flipped = false;
    private transient Image offscreen = null;

    public void setSVGDocument(SVGDocumentImpl sVGDocumentImpl) {
        UIEventImpl uIEventImpl;
        SVGSVGElement sVGSVGElement;
        if (this.svgDoc != null) {
            sVGSVGElement = this.svgDoc.getRootElement();
            uIEventImpl = (UIEventImpl)this.svgDoc.createEvent("UIEvent");
            uIEventImpl.initUIEvent("onunload", false, false, this, 0);
            uIEventImpl.setTarget(sVGSVGElement);
            sVGSVGElement.dispatchEvent(uIEventImpl);
        }
        this.svgDoc = null;
        System.gc();
        this.svgDoc = sVGDocumentImpl;
        if (this.svgDoc != null) {
            this.svgDoc.setDefaultView(this);
            sVGSVGElement = this.svgDoc.getRootElement();
            uIEventImpl = (UIEventImpl)this.svgDoc.createEvent("UIEvent");
            uIEventImpl.initUIEvent("onload", false, false, this, 0);
            uIEventImpl.setTarget(sVGSVGElement);
            sVGSVGElement.dispatchEvent(uIEventImpl);
            if (this.svgDoc.getRootElement() != null) {
                DocumentEventListener documentEventListener = new DocumentEventListener();
                this.svgDoc.getRootElement().addEventListener("onfocusin", documentEventListener, false);
                this.svgDoc.getRootElement().addEventListener("onfocusout", documentEventListener, false);
                this.svgDoc.getRootElement().addEventListener("onchange", documentEventListener, false);
                this.svgDoc.getRootElement().addEventListener("onclick", documentEventListener, false);
                this.svgDoc.getRootElement().addEventListener("ondblclick", documentEventListener, false);
                this.svgDoc.getRootElement().addEventListener("onmousemove", documentEventListener, false);
                this.svgDoc.getRootElement().addEventListener("onmousedown", documentEventListener, false);
                this.svgDoc.getRootElement().addEventListener("onmouseup", documentEventListener, false);
                this.svgDoc.getRootElement().addEventListener("onunload", documentEventListener, false);
                this.svgDoc.getRootElement().addEventListener("onload", documentEventListener, false);
            }
        }
        this.zoomAll();
        this.draw();
    }

    public SVGDocumentImpl getSVGDocument() {
        return this.svgDoc;
    }

    public void draw() {
        this.repaint();
    }

    public void invalidate() {
        super.invalidate();
        this.offscreen = null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public boolean getFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean bl) {
        this.flipped = bl;
    }

    public void setDoubleBuffer(boolean bl) {
        this.useDoubleBuffer = bl;
    }

    public boolean getDoubleBuffer() {
        return this.useDoubleBuffer;
    }

    public void setAntiAliasing(boolean bl) {
        this.doAntiAliasing = bl;
    }

    public boolean getAntiAliasing() {
        return this.doAntiAliasing;
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        if (this.theCanvas.width == rectangle.width && this.theCanvas.height == rectangle.height) {
            return;
        }
        this.theCanvas.width = rectangle.width;
        this.theCanvas.height = rectangle.height;
        this.checkView();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.theCanvas.width == n3 && this.theCanvas.height == n4) {
            return;
        }
        double d = (double)n3 / (double)this.theCanvas.width;
        double d2 = (double)n4 / (double)this.theCanvas.height;
        this.theCanvas.width = n3;
        this.theCanvas.height = n4;
        this.theView.width *= d;
        this.theView.height *= d2;
        this.checkView();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        double d = (double)n / (double)this.theCanvas.width;
        double d2 = (double)n2 / (double)this.theCanvas.height;
        this.theCanvas.width = n;
        this.theCanvas.height = n2;
        this.theView.width *= d;
        this.theView.height *= d2;
        this.checkView();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        double d = (double)dimension.width / (double)this.theCanvas.width;
        double d2 = (double)dimension.height / (double)this.theCanvas.height;
        this.theCanvas.width = dimension.width;
        this.theCanvas.height = dimension.height;
        this.theView.width *= d;
        this.theView.height *= d2;
        this.checkView();
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(175, 175);
    }

    public Image getBackgroundImage() {
        return this.offscreen;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        if (n != 0 || n2 != 0) {
            if (this.useDoubleBuffer) {
                if (this.offscreen == null) {
                    this.offscreen = this.createImage(rectangle.width, rectangle.height);
                }
                if (this.offscreen != null) {
                    Graphics graphics2 = this.offscreen.getGraphics();
                    graphics2.setClip(0, 0, rectangle.width, rectangle.height);
                    this.doPaint(graphics2);
                    graphics.drawImage(this.offscreen, 0, 0, null);
                    graphics2.dispose();
                }
            } else {
                Image image = this.createImage((int)((double)rectangle.width * 2.5), (int)((double)rectangle.height * 2.5));
                if (image != null) {
                    Graphics2D graphics2D = (Graphics2D)image.getGraphics();
                    graphics2D.setClip(0, 0, (int)((double)rectangle.width * 2.5), (int)((double)rectangle.height * 2.5));
                    graphics2D.scale(2.5, 2.5);
                    this.doPaint(graphics2D);
                    graphics.drawImage(image, 0, 0, n, n2, null);
                    graphics2D.dispose();
                }
            }
        }
    }

    public void doPaint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = this.getBounds();
        Rectangle2D.Double double_ = this.getView();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        AffineTransform affineTransform = new AffineTransform();
        if (this.flipped) {
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -1.0f * (float)rectangle.height);
        }
        graphics2D.transform(affineTransform);
        if (this.svgDoc != null) {
            SVGSVGElementImpl sVGSVGElementImpl = (SVGSVGElementImpl)this.svgDoc.getRootElement();
            if (sVGSVGElementImpl != null) {
                sVGSVGElementImpl.setCurrentScale((float)((double)rectangle.width / double_.width));
                SVGPointImpl sVGPointImpl = new SVGPointImpl();
                sVGPointImpl.setX((float)(-1.0 * double_.x));
                sVGPointImpl.setY((float)(-1.0 * double_.y));
                sVGSVGElementImpl.setCurrentTranslate(sVGPointImpl);
            }
            this.svgDoc.draw(graphics2D);
        }
    }

    public void drawXORRectangle(Rectangle rectangle) {
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(this.getBackground());
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (rectangle.width < 0) {
            rectangle2.x = rectangle.x + rectangle.width;
            rectangle2.width = -1 * rectangle.width;
        }
        if (rectangle.height < 0) {
            rectangle2.y = rectangle.y + rectangle.height;
            rectangle2.height = -1 * rectangle.height;
        }
        graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics.dispose();
        graphics = null;
    }

    public void print() {
        System.out.println("In Print");
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPageable(this);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double d = pageFormat.getImageableWidth() / (double)this.getWidth();
        double d2 = pageFormat.getImageableHeight() / (double)this.getHeight();
        double d3 = Math.min(d, d2);
        graphics2D.scale(d3, d3);
        System.out.println(pageFormat.getImageableWidth() + " " + pageFormat.getImageableHeight());
        System.out.println(pageFormat.getWidth() + " " + pageFormat.getHeight());
        System.out.println(this.getWidth() + " " + this.getHeight());
        System.out.println("printing " + n);
        this.setDoubleBuffer(false);
        Color color = this.getBackground();
        this.setBackground(Color.white);
        this.printAll(graphics2D);
        this.setBackground(color);
        this.setDoubleBuffer(true);
        return 0;
    }

    public int getNumberOfPages() {
        return 1;
    }

    public PageFormat getPageFormat(int n) {
        return new PageFormat();
    }

    public Printable getPrintable(int n) {
        return this;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        double d = this.getWorldXCoord(mouseEvent.getX());
        double d2 = this.flipped ? this.getWorldYCoord(this.theCanvas.height - mouseEvent.getY()) : this.getWorldYCoord(mouseEvent.getY());
        super.processMouseEvent(new WorldMouseEvent(mouseEvent, d, d2));
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        double d = this.getWorldXCoord(mouseEvent.getX());
        double d2 = this.flipped ? this.getWorldYCoord(this.theCanvas.height - mouseEvent.getY()) : this.getWorldYCoord(mouseEvent.getY());
        super.processMouseMotionEvent(new WorldMouseEvent(mouseEvent, d, d2));
    }

    private void checkView() {
        if (this.theView.width < 0.0) {
            this.theView.x += this.theView.width;
            this.theView.width *= -1.0;
        }
        if (this.theView.height < 0.0) {
            this.theView.y += this.theView.height;
            this.theView.height *= -1.0;
        }
        double d = this.theView.x;
        double d2 = this.theView.y;
        double d3 = this.theView.width;
        double d4 = (double)this.theCanvas.width / d3;
        double d5 = this.theView.height;
        double d6 = (double)this.theCanvas.height / d5;
        if (d4 > d6) {
            this.theView.y = d2;
            this.theView.height = d5;
            this.theView.width = (double)this.theCanvas.width * (this.theView.height / (double)this.theCanvas.height);
            this.theView.x = d - (this.theView.width - d3) * 0.5;
        } else {
            this.theView.x = d;
            this.theView.width = d3;
            this.theView.height = (double)this.theCanvas.height * (this.theView.width / (double)this.theCanvas.width);
            this.theView.y = d2 - (this.theView.height - d5) * 0.5;
        }
        this.calculateView();
    }

    private void calculateView() {
        this.screenToWorldX = this.theView.width / (double)this.theCanvas.width;
        this.screenToWorldY = this.theView.height / (double)this.theCanvas.height;
        this.worldToScreenX = (double)this.theCanvas.width / this.theView.width;
        this.worldToScreenY = (double)this.theCanvas.height / this.theView.height;
    }

    public void setView(Rectangle2D.Double double_) {
        if (this.theView.equals(double_)) {
            return;
        }
        this.theView = new Rectangle2D.Double(double_.x, double_.y, double_.width, double_.height);
        this.checkView();
        this.draw();
    }

    public void setView(double d, double d2, double d3, double d4) {
        if (this.theView.x == d && this.theView.y == d2 && this.theView.width == d3 && this.theView.height == d4) {
            return;
        }
        this.theView.x = d;
        this.theView.y = d2;
        this.theView.width = d3;
        this.theView.height = d4;
        this.checkView();
        this.draw();
    }

    public Rectangle2D.Double getView() {
        return new Rectangle2D.Double(this.theView.x, this.theView.y, this.theView.width, this.theView.height);
    }

    public double getWorldXCoord(int n) {
        return (double)n * this.screenToWorldX + this.theView.x;
    }

    public double getWorldYCoord(int n) {
        return (double)n * this.screenToWorldY + this.theView.y;
    }

    public int getScreenXCoord(double d) {
        return (int)((d - this.theView.x) * this.worldToScreenX);
    }

    public int getScreenYCoord(double d) {
        return (int)((d - this.theView.y) * this.worldToScreenY);
    }

    public void panRelative(double d, double d2) {
        this.theView.x += d;
        this.theView.y += d2;
        this.calculateView();
    }

    public void panAbsolute(double d, double d2) {
        this.theView.x = d;
        this.theView.y = d2;
        this.calculateView();
    }

    public void center(double d, double d2) {
        this.theView.x = d - this.theView.width / 2.0;
        this.theView.y = d2 - this.theView.height / 2.0;
        this.calculateView();
    }

    public void fitToWindow() {
        this.zoomAll();
    }

    public void zoomAll() {
        if (this.svgDoc != null && this.svgDoc.getRootElement() != null) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.theCanvas.width, this.theCanvas.height);
            this.setView(double_);
        }
    }

    public void zoom(double d) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double d2 = this.theView.x + this.theView.width / 2.0;
        double d3 = this.theView.y + this.theView.height / 2.0;
        double_.width = this.theView.width * d;
        double_.height = this.theView.height * d;
        double_.x = d2 - double_.width / 2.0;
        double_.y = d3 - double_.height / 2.0;
        this.setView(double_);
    }

    public DocumentView getDocument() {
        return this.svgDoc;
    }

    class DocumentEventListener
    implements EventListener {
        DocumentEventListener() {
        }

        public void handleEvent(Event event) {
            Canvas.this.draw();
        }
    }
}

