/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.viewer;

import java.awt.event.MouseEvent;
import java.util.Vector;
import org.csiro.svg.dom.Drawable;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGStylableImpl;
import org.csiro.svg.viewer.Canvas;
import org.csiro.svg.viewer.MouseHandler;
import org.csiro.svg.viewer.Viewer;
import org.csiro.svg.viewer.WorldMouseEvent;

public class CursorMouseHandler
extends MouseHandler {
    private Viewer viewer;
    private boolean usingCustom = false;

    public CursorMouseHandler(Canvas canvas, Viewer viewer) {
        super(canvas);
        this.viewer = viewer;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Vector vector;
        int n;
        if (this.getCanvas().getSVGDocument() != null && (n = (vector = this.getCanvas().getSVGDocument().getElementsThatContain(((WorldMouseEvent)mouseEvent).getWorldX(), ((WorldMouseEvent)mouseEvent).getWorldY())).size()) > 0) {
            Vector<SVGElementImpl> vector2 = new Vector<SVGElementImpl>();
            int n2 = 0;
            while (n2 < n) {
                SVGElementImpl sVGElementImpl = (SVGElementImpl)vector.elementAt(n2);
                if (sVGElementImpl instanceof SVGStylableImpl && sVGElementImpl instanceof Drawable && ((SVGStylableImpl)sVGElementImpl).getCursor() != null) {
                    vector2.add(sVGElementImpl);
                }
                ++n2;
            }
            int n3 = vector2.size();
            SVGStylableImpl sVGStylableImpl = null;
            if (n3 == 1) {
                sVGStylableImpl = (SVGStylableImpl)vector2.elementAt(0);
            } else if (n3 > 1) {
                sVGStylableImpl = (SVGStylableImpl)vector2.elementAt(0);
                double d = ((Drawable)((Object)sVGStylableImpl)).boundingArea();
                int n4 = 1;
                while (n4 < n3) {
                    SVGStylableImpl sVGStylableImpl2 = (SVGStylableImpl)vector2.elementAt(n4);
                    double d2 = ((Drawable)((Object)sVGStylableImpl2)).boundingArea();
                    if (d2 < d) {
                        sVGStylableImpl = sVGStylableImpl2;
                        d = d2;
                    }
                    ++n4;
                }
            }
            if (sVGStylableImpl != null) {
                this.canvas.setCursor(sVGStylableImpl.getCursor());
                this.usingCustom = true;
                return;
            }
        }
        if (this.usingCustom) {
            this.canvas.setCursor(this.viewer.currentCursor);
            this.usingCustom = false;
        }
    }
}

