/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.viewer;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.csiro.svg.dom.SVGAElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.viewer.Canvas;
import org.csiro.svg.viewer.MouseHandler;
import org.csiro.svg.viewer.Viewer;
import org.csiro.svg.viewer.WorldMouseEvent;
import org.w3c.dom.NodeList;

public class LinkToMouseHandler
extends MouseHandler {
    private Viewer viewer;
    private boolean usingHand = false;

    public LinkToMouseHandler(Canvas canvas, Viewer viewer) {
        super(canvas);
        this.viewer = viewer;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        SVGDocumentImpl sVGDocumentImpl = this.canvas.getSVGDocument();
        if (sVGDocumentImpl == null) {
            return;
        }
        if (sVGDocumentImpl.getRootElement() == null) {
            return;
        }
        NodeList nodeList = sVGDocumentImpl.getRootElement().getElementsByTagName("a");
        int n = nodeList.getLength();
        if (n > 0) {
            Vector<SVGAElementImpl> vector = new Vector<SVGAElementImpl>();
            int n2 = 0;
            while (n2 < n) {
                SVGAElementImpl sVGAElementImpl = (SVGAElementImpl)nodeList.item(n2);
                if (sVGAElementImpl.getHref() != null && sVGAElementImpl.contains(((WorldMouseEvent)mouseEvent).getWorldX(), ((WorldMouseEvent)mouseEvent).getWorldY())) {
                    vector.addElement(sVGAElementImpl);
                }
                ++n2;
            }
            int n3 = vector.size();
            if (n3 > 0) {
                SVGAElementImpl sVGAElementImpl = null;
                if (n3 == 1) {
                    sVGAElementImpl = (SVGAElementImpl)vector.elementAt(0);
                } else if (n3 > 1) {
                    sVGAElementImpl = (SVGAElementImpl)vector.elementAt(0);
                    double d = sVGAElementImpl.boundingArea();
                    int n4 = 1;
                    while (n4 < n3) {
                        SVGAElementImpl sVGAElementImpl2 = (SVGAElementImpl)vector.elementAt(n4);
                        double d2 = sVGAElementImpl2.boundingArea();
                        if (d2 < d) {
                            sVGAElementImpl = sVGAElementImpl2;
                            d = d2;
                        }
                        ++n4;
                    }
                }
                if (sVGAElementImpl != null) {
                    this.canvas.setCursor(new Cursor(12));
                    this.usingHand = true;
                    this.viewer.showStatus(sVGAElementImpl.getHref().getAnimVal());
                    return;
                }
            }
        }
        if (this.usingHand) {
            this.canvas.setCursor(this.viewer.currentCursor);
            this.usingHand = false;
            this.viewer.showStatus("");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        SVGDocumentImpl sVGDocumentImpl = this.canvas.getSVGDocument();
        if (sVGDocumentImpl == null) {
            return;
        }
        if (sVGDocumentImpl.getRootElement() == null) {
            return;
        }
        NodeList nodeList = sVGDocumentImpl.getRootElement().getElementsByTagName("a");
        int n = nodeList.getLength();
        if (n > 0) {
            Vector<SVGAElementImpl> vector = new Vector<SVGAElementImpl>();
            int n2 = 0;
            while (n2 < n) {
                SVGAElementImpl sVGAElementImpl = (SVGAElementImpl)nodeList.item(n2);
                if (sVGAElementImpl.getHref() != null && sVGAElementImpl.contains(((WorldMouseEvent)mouseEvent).getWorldX(), ((WorldMouseEvent)mouseEvent).getWorldY())) {
                    vector.addElement(sVGAElementImpl);
                }
                ++n2;
            }
            int n3 = vector.size();
            if (n3 > 0) {
                SVGAElementImpl sVGAElementImpl = null;
                if (n3 == 1) {
                    sVGAElementImpl = (SVGAElementImpl)vector.elementAt(0);
                } else if (n3 > 1) {
                    sVGAElementImpl = (SVGAElementImpl)vector.elementAt(0);
                    double d = sVGAElementImpl.boundingArea();
                    int n4 = 1;
                    while (n4 < n3) {
                        SVGAElementImpl sVGAElementImpl2 = (SVGAElementImpl)vector.elementAt(n4);
                        double d2 = sVGAElementImpl2.boundingArea();
                        if (d2 < d) {
                            sVGAElementImpl = sVGAElementImpl2;
                            d = d2;
                        }
                        ++n4;
                    }
                }
                if (sVGAElementImpl != null) {
                    String string = sVGAElementImpl.getHref().getAnimVal();
                    if (string.indexOf(58) == -1 && string.indexOf("#") != 0) {
                        int n5 = this.viewer.currentPath.lastIndexOf(47);
                        if (n5 == -1) {
                            n5 = this.viewer.currentPath.lastIndexOf(92);
                        }
                        string = this.viewer.currentPath.substring(0, n5 + 1) + string;
                    }
                    if (string.indexOf(".svg") != -1 || string.indexOf("#") == 0) {
                        this.viewer.loadNewDocument(string);
                    } else if (!this.viewer.invokedStandalone) {
                        try {
                            URL uRL = new URL(string);
                            this.viewer.getAppletContext().showDocument(uRL);
                        }
                        catch (MalformedURLException malformedURLException) {
                            JOptionPane.showMessageDialog(this.viewer, "Cannot load malformed URL: " + string, "Link Error", 1);
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.viewer, "Cannot load URL: " + string + "\nwhile running as a stand alone application.", "Link Error", 1);
                    }
                }
            }
        }
    }
}

