/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.viewer;

import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

public class ScriptController {
    Scriptable scope;
    Context cx;
    Hashtable objectTable;
    boolean isGlobalScope = false;

    public Context getContext() {
        return this.cx;
    }

    public void setContext(Context context) {
        this.cx = context;
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public void setScope(Scriptable scriptable) {
        this.scope = scriptable;
    }

    public void addObject(String string, Object object) {
        if (this.objectTable == null) {
            this.objectTable = new Hashtable();
        }
        this.objectTable.put(string, object);
    }

    public void removeObject(String string) {
        if (this.objectTable == null) {
            return;
        }
        if (this.objectTable.containsKey(string)) {
            this.objectTable.remove(string);
        }
    }

    public void exposeObjectsToScriptEngine() {
        if (this.objectTable == null) {
            return;
        }
        Enumeration enumeration = this.objectTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.exposeObjectToScriptEngine(string, this.objectTable.get(string));
        }
    }

    public void exposeObjectToScriptEngine(String string, Object object) {
        System.out.println("ScriptController about to expose '" + string + "' to ScriptController engine as " + object.toString());
        this.getContext();
        Scriptable scriptable = Context.toObject((Object)object, (Scriptable)this.getScope());
        this.getScope().put(string, this.getScope(), (Object)scriptable);
    }

    public void setGlobalScope(boolean bl) {
        if (this.isGlobalScope) {
            return;
        }
        this.isGlobalScope = bl;
        if (this.getGlobalScope()) {
            this.setContext(Context.enter());
            this.setScope((Scriptable)new ImporterTopLevel(this.getContext()));
            this.exposeObjectsToScriptEngine();
        }
    }

    public boolean getGlobalScope() {
        return this.isGlobalScope;
    }

    public Object execute(String string) {
        if (!this.getGlobalScope()) {
            this.setContext(Context.enter());
            this.setScope((Scriptable)new ImporterTopLevel(this.getContext()));
            this.exposeObjectsToScriptEngine();
        }
        Object object = null;
        try {
            object = this.getContext().evaluateString(this.getScope(), string, "<cmd>", 1, null);
            this.getContext();
            object = Context.toString((Object)object);
        }
        catch (JavaScriptException javaScriptException) {
            System.err.println("Exception caught: " + javaScriptException.getMessage());
        }
        if (!this.getGlobalScope()) {
            Context.exit();
            this.setContext(null);
            this.setScope(null);
        }
        return object;
    }

    protected void finalize() throws Throwable {
        if (this.getGlobalScope()) {
            Context.exit();
        }
        super.finalize();
    }
}

