/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.csiro.svg.viewer.ScriptController;

public class ScriptFrame
extends JFrame {
    boolean dirty;
    String scriptfile = "";
    JPanel contentPane = new JPanel();
    BorderLayout borderLayout = new BorderLayout();
    JSplitPane textSplitPane = new JSplitPane();
    JToolBar scriptToolBar = new JToolBar();
    JButton executeButton = new JButton();
    JButton saveButton = new JButton();
    JScrollPane inputTextScrollPanel = new JScrollPane();
    JTextArea inputTextArea = new JTextArea();
    JScrollPane outputTextScrollPanel = new JScrollPane();
    JTextArea outputTextArea = new JTextArea();
    ScriptController scriptController = null;
    JButton openButton = new JButton();
    protected String currentPath = null;

    public void loadDocument(String string) {
        try {
            File file = new File(string);
            int n = (int)file.length();
            int n2 = 0;
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[n];
            while (fileReader.ready()) {
                n2 += fileReader.read(cArray, n2, n - n2);
            }
            fileReader.close();
            this.inputTextArea.setText(new String(cArray, 0, n2));
            this.setScriptfile(string);
            this.dirty = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean saveFile() {
        if (this.getScriptfile() == null) {
            return this.saveAsFile();
        }
        try {
            File file = new File(this.getScriptfile());
            FileWriter fileWriter = new FileWriter(file);
            String string = this.inputTextArea.getText();
            fileWriter.write(string);
            fileWriter.close();
            this.dirty = false;
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    boolean saveAsFile() {
        return false;
    }

    boolean okToAbandon() {
        if (!this.dirty) {
            return true;
        }
        int n = JOptionPane.showConfirmDialog(this, "Save changes?", "Text Edit", 1);
        switch (n) {
            case 0: {
                return this.saveFile();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public String getScriptfile() {
        return this.scriptfile;
    }

    public void setScriptfile(String string) {
        this.scriptfile = string;
    }

    public ScriptFrame(ScriptController scriptController) {
        this.scriptController = scriptController;
        this.myinit();
    }

    public ScriptFrame() {
        this.myinit();
    }

    private void myinit() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setScriptController(ScriptController scriptController) {
        this.scriptController = scriptController;
    }

    public ScriptController getScriptController() {
        return this.scriptController;
    }

    private void jbInit() throws Exception {
        this.contentPane.setLayout(this.borderLayout);
        this.textSplitPane.setOrientation(0);
        this.textSplitPane.setBottomComponent(this.outputTextScrollPanel);
        this.textSplitPane.setContinuousLayout(true);
        this.textSplitPane.setLeftComponent(null);
        this.textSplitPane.setOneTouchExpandable(true);
        this.textSplitPane.setRightComponent(null);
        this.textSplitPane.setTopComponent(this.inputTextScrollPanel);
        this.executeButton.setToolTipText("Execute the input text");
        this.executeButton.setActionCommand("execute");
        this.executeButton.setText("Execute");
        this.executeButton.addActionListener(new ExecuteActionListener());
        this.openButton.setToolTipText("Open a script file");
        this.openButton.setActionCommand("open");
        this.openButton.setText("Open");
        this.openButton.addActionListener(new OpenActionListener());
        this.saveButton.setToolTipText("Save changes to the script file");
        this.saveButton.setActionCommand("save");
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new SaveActionListener());
        this.inputTextScrollPanel.setVerticalScrollBarPolicy(22);
        this.inputTextScrollPanel.setAutoscrolls(true);
        this.outputTextScrollPanel.setAutoscrolls(true);
        this.outputTextScrollPanel.setVerticalScrollBarPolicy(22);
        this.outputTextArea.setEditable(false);
        this.getContentPane().add((Component)this.contentPane, "Center");
        this.contentPane.add((Component)this.scriptToolBar, "North");
        this.contentPane.add((Component)this.textSplitPane, "Center");
        this.textSplitPane.add((Component)this.inputTextScrollPanel, "top");
        this.textSplitPane.add((Component)this.outputTextScrollPanel, "bottom");
        this.outputTextScrollPanel.getViewport().add((Component)this.outputTextArea, null);
        this.inputTextScrollPanel.getViewport().add((Component)this.inputTextArea, null);
        this.scriptToolBar.add((Component)this.openButton, null);
        this.scriptToolBar.add((Component)this.executeButton, null);
        this.scriptToolBar.add((Component)this.saveButton, null);
        ((Component)this).setBounds(0, 0, 600, 700);
        this.textSplitPane.setDividerLocation(300);
    }

    public static void main(String[] stringArray) {
        ScriptController scriptController = new ScriptController();
        scriptController.addObject("controller", scriptController);
        ScriptFrame scriptFrame = new ScriptFrame();
        scriptController.addObject("frame", scriptFrame);
        scriptController.setGlobalScope(false);
        scriptFrame.setScriptController(scriptController);
        scriptFrame.show();
        scriptFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    void executeButton_actionPerformed(ActionEvent actionEvent) {
    }

    class OpenActionListener
    implements ActionListener {
        OpenActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("OpenActionListener about to enter open file dialogue...");
            Object[] objectArray = new Object[]{"Open", "Cancel", "Browse for File"};
            JOptionPane jOptionPane = new JOptionPane("Enter the filename or URL to open\n(or browse for a file)", 3, 2, null, objectArray, objectArray[0]);
            jOptionPane.setWantsInput(true);
            if (ScriptFrame.this.getScriptfile() != null) {
                jOptionPane.setInitialSelectionValue(ScriptFrame.this.getScriptfile());
            }
            jOptionPane.selectInitialValue();
            JDialog jDialog = jOptionPane.createDialog(null, "hello");
            jDialog.show();
            String string = (String)jOptionPane.getValue();
            if (string == null) {
                return;
            }
            if (string == JOptionPane.UNINITIALIZED_VALUE || objectArray[0].equals(string)) {
                String string2 = (String)jOptionPane.getInputValue();
                ScriptFrame.this.loadDocument(string2);
            } else {
                if (objectArray[1].equals(string)) {
                    return;
                }
                JFileChooser jFileChooser = ScriptFrame.this.currentPath == null ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(ScriptFrame.this.currentPath);
                int n = jFileChooser.showOpenDialog(ScriptFrame.this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    ScriptFrame.this.currentPath = file.getPath();
                    System.out.println(file.getAbsolutePath());
                    ScriptFrame.this.loadDocument(file.getAbsolutePath());
                }
            }
        }
    }

    class SaveActionListener
    implements ActionListener {
        SaveActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScriptFrame.this.saveFile();
        }
    }

    class ExecuteActionListener
    implements ActionListener {
        ExecuteActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("ExecuteActionListener About to execute script: " + ScriptFrame.this.inputTextArea.getText());
            ScriptFrame.this.executeButton_actionPerformed(actionEvent);
            Object object = null;
            object = ScriptFrame.this.scriptController.execute(ScriptFrame.this.inputTextArea.getText());
            if (object != null) {
                ScriptFrame.this.outputTextArea.selectAll();
                ScriptFrame.this.outputTextArea.setText(null);
                ScriptFrame.this.outputTextArea.setText(object.toString());
            }
        }
    }
}

