/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.viewer;

import java.util.StringTokenizer;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGStylableImpl;
import org.csiro.svg.dom.SVGViewElementImpl;
import org.csiro.svg.parser.SVGParseException;
import org.csiro.svg.parser.SVGParser;
import org.csiro.svg.viewer.SvgListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimationElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGGElement;
import org.w3c.dom.svg.SVGSVGElement;

public class SvgLoader
extends Thread {
    String svgUrl;
    String fragment;
    SvgListener listener;
    boolean running = false;

    public SvgLoader(String string, SvgListener svgListener) {
        this.svgUrl = string;
        this.fragment = null;
        this.listener = svgListener;
    }

    public SvgLoader(String string, String string2, SvgListener svgListener) {
        this.svgUrl = string;
        this.fragment = string2;
        this.listener = svgListener;
    }

    public void run() {
        block25: {
            this.running = true;
            SVGParser sVGParser = new SVGParser();
            try {
                SVGDocumentImpl sVGDocumentImpl = sVGParser.parseSVG(this.svgUrl);
                if (!this.running) break block25;
                if (this.fragment != null) {
                    if (this.fragment.indexOf("svgView") == -1) {
                        SVGElement sVGElement;
                        String string = this.fragment;
                        if (this.fragment.indexOf("xpointer") != -1) {
                            int n = this.fragment.indexOf("'");
                            int n2 = this.fragment.lastIndexOf("'");
                            string = this.fragment.substring(n + 1, n2);
                        }
                        if ((sVGElement = (SVGElement)sVGDocumentImpl.getElementById(string)) != null) {
                            if (sVGElement instanceof SVGViewElementImpl) {
                                SVGViewElementImpl sVGViewElementImpl = (SVGViewElementImpl)sVGElement;
                                Node node = sVGViewElementImpl.getParentNode();
                                while (!(node instanceof SVGSVGElement)) {
                                    node = node.getParentNode();
                                }
                                SVGSVGElement sVGSVGElement = (SVGSVGElement)node;
                                sVGDocumentImpl.setRootElement(sVGSVGElement);
                                if (sVGViewElementImpl.getViewBox().getBaseVal().getWidth() > 0.0f) {
                                    sVGSVGElement.setAttribute("viewBox", ((SVGRectImpl)sVGViewElementImpl.getViewBox().getBaseVal()).toString());
                                }
                                if (sVGViewElementImpl.getAttribute("zoomAndPan").length() > 0) {
                                    sVGSVGElement.setAttribute("zoomAndPan", sVGViewElementImpl.getAttribute("zoomAndPan"));
                                }
                                if (sVGViewElementImpl.getAttribute("preserveAspectRatio").length() > 0) {
                                    sVGSVGElement.setAttribute("preserveAspectRatio", sVGViewElementImpl.getAttribute("preserveAspectRatio"));
                                }
                                if (sVGViewElementImpl.getAttribute("viewTarget").length() > 0) {
                                    StringTokenizer stringTokenizer = new StringTokenizer(sVGViewElementImpl.getAttribute("viewTarget"));
                                    while (stringTokenizer.hasMoreTokens()) {
                                        String string2 = stringTokenizer.nextToken();
                                        Element element = sVGDocumentImpl.getElementById(string2);
                                        if (!(element instanceof SVGStylableImpl)) continue;
                                        ((SVGStylableImpl)element).setHighlighted(true);
                                    }
                                }
                            } else if (sVGElement instanceof SVGAnimationElement) {
                                SVGAnimationElement sVGAnimationElement = (SVGAnimationElement)sVGElement;
                                sVGAnimationElement.setAttribute("begin", "0");
                            } else {
                                Node node = sVGElement.getParentNode();
                                while (!(node instanceof SVGSVGElement)) {
                                    node = node.getParentNode();
                                }
                                SVGSVGElement sVGSVGElement = (SVGSVGElement)node;
                                sVGDocumentImpl.setRootElement(sVGSVGElement);
                            }
                        }
                    } else {
                        int n = this.fragment.indexOf("(");
                        int n3 = this.fragment.lastIndexOf(")");
                        String string = this.fragment.substring(n + 1, n3);
                        SVGSVGElement sVGSVGElement = sVGDocumentImpl.getRootElement();
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                        while (stringTokenizer.hasMoreTokens()) {
                            Object object;
                            Object object2;
                            String string3 = stringTokenizer.nextToken();
                            n = string3.indexOf("(");
                            n3 = string3.lastIndexOf(")");
                            String string4 = string3.substring(0, n);
                            String string5 = string3.substring(n + 1, n3);
                            if (string4.equals("viewBox") || string4.equals("preserveAspectRatio") || string4.equals("zoomAndPan")) {
                                sVGSVGElement.setAttribute(string4, string5);
                                continue;
                            }
                            if (string4.equals("transform")) {
                                object2 = (SVGGElement)sVGDocumentImpl.createElement("g");
                                object2.setAttribute(string4, string5);
                                object = sVGSVGElement.getChildNodes();
                                int n4 = 0;
                                while (n4 < object.getLength()) {
                                    Node node = object.item(n4);
                                    sVGSVGElement.removeChild(node);
                                    object2.appendChild(node);
                                    ++n4;
                                }
                                sVGSVGElement.appendChild((Node)object2);
                                continue;
                            }
                            if (!string4.equals("viewTarget")) continue;
                            object2 = new StringTokenizer(string5, ",");
                            while (((StringTokenizer)object2).hasMoreTokens()) {
                                object = ((StringTokenizer)object2).nextToken();
                                Element element = sVGDocumentImpl.getElementById((String)object);
                                if (!(element instanceof SVGStylableImpl)) continue;
                                ((SVGStylableImpl)element).setHighlighted(true);
                            }
                        }
                    }
                }
                String string = this.svgUrl;
                if (this.fragment != null) {
                    string = string + "#" + this.fragment;
                }
                this.listener.newSvgDoc(sVGDocumentImpl, string);
            }
            catch (SVGParseException sVGParseException) {
                System.out.println("SVGParseException: " + sVGParseException.getMessage());
                if (!this.running) break block25;
                String string = this.svgUrl;
                if (this.fragment != null) {
                    string = string + "#" + this.fragment;
                }
                this.listener.newSvgDoc(null, string);
            }
        }
    }

    public void stopLoading() {
        this.running = false;
    }
}

