/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.viewer;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGSVGElementImpl;
import org.csiro.svg.parser.XmlWriter;
import org.csiro.svg.viewer.Canvas;
import org.csiro.svg.viewer.CursorMouseHandler;
import org.csiro.svg.viewer.JpgFileFilter;
import org.csiro.svg.viewer.LinkToMouseHandler;
import org.csiro.svg.viewer.MouseHandler;
import org.csiro.svg.viewer.PanMouseHandler;
import org.csiro.svg.viewer.ScriptController;
import org.csiro.svg.viewer.ScriptFrame;
import org.csiro.svg.viewer.ScriptMouseHandler;
import org.csiro.svg.viewer.StatusBar;
import org.csiro.svg.viewer.SvgFileFilter;
import org.csiro.svg.viewer.SvgListener;
import org.csiro.svg.viewer.SvgLoader;
import org.csiro.svg.viewer.ZoomInMouseHandler;
import org.csiro.svg.viewer.ZoomOutMouseHandler;
import org.csiro.svg.viewer.ZoomRectMouseHandler;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Node;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class Viewer
extends JApplet
implements SvgListener,
AbstractView {
    public boolean invokedStandalone = false;
    public Canvas canvas;
    protected JPanel contentPanel = new JPanel();
    protected JPanel toolbar = new JPanel();
    protected JPanel documentbar = new JPanel();
    protected JPanel topbar = new JPanel();
    protected JPopupMenu popupMenu = new JPopupMenu();
    protected ScriptFrame scriptFrame = null;
    protected ScriptController scriptController = null;
    protected String currentPath = null;
    protected Vector docHistory = new Vector();
    protected int docIndex = 0;
    protected JFrame frame = null;
    protected int width;
    protected int height;
    protected String title = "CSIRO SVG Viewer (20020312)";
    public String svgfile = null;
    protected PanMouseHandler panMouseHandler;
    protected ZoomInMouseHandler zoomInMouseHandler;
    protected ZoomOutMouseHandler zoomOutMouseHandler;
    protected ZoomRectMouseHandler zoomRectMouseHandler;
    protected LinkToMouseHandler linkToMouseHandler;
    protected MouseHandler currentMouseHandler;
    protected PopupMenuHandler popupMenuHandler;
    protected ScriptMouseHandler scriptMouseHandler;
    protected JToggleButton linkButton;
    protected JToggleButton panButton;
    protected JToggleButton zoomInButton;
    protected JToggleButton zoomOutButton;
    protected JToggleButton zoomRectButton;
    protected ButtonGroup buttonGroup = new ButtonGroup();
    protected JMenuItem linkMenuItem;
    protected JMenuItem panMenuItem;
    protected JMenuItem zoomInMenuItem;
    protected JMenuItem zoomOutMenuItem;
    protected JMenuItem zoomRectMenuItem;
    protected JButton backButton;
    protected JButton forwardButton;
    protected JButton reloadButton;
    protected JButton viewSrcButton;
    protected JButton viewDomButton;
    protected JButton origViewButton;
    protected JButton printButton;
    protected JButton aboutButton;
    protected JButton goButton;
    protected JButton loadButton;
    protected JTextField documentUrlField;
    Cursor linkCursor;
    Cursor panCursor;
    Cursor zoomInCursor;
    Cursor zoomOutCursor;
    Cursor zoomRectCursor;
    Cursor currentCursor;
    protected StatusBar statusBar;
    protected JFrame viewSourceFrame = null;
    protected JTextArea viewSourceArea = null;
    boolean showToolbar = true;
    protected boolean showMenu = true;
    protected Dimension buttonDimension = new Dimension(32, 32);
    protected Insets zeroInsets = new Insets(0, 0, 0, 0);
    protected boolean showScriptController = false;

    public void setFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public boolean getShowToolbar() {
        return this.showToolbar;
    }

    public void setShowToolbar(boolean bl) {
        if (bl && !this.showToolbar) {
            this.contentPanel.add((Component)this.toolbar, "North");
            this.contentPanel.revalidate();
            if (this.canvas != null) {
                this.canvas.draw();
            }
        } else if (!bl && this.showToolbar) {
            this.contentPanel.remove(this.toolbar);
            this.contentPanel.revalidate();
            if (this.canvas != null) {
                this.canvas.draw();
            }
        }
        this.showToolbar = bl;
    }

    public boolean getShowMenu() {
        return this.showMenu;
    }

    public void setShowMenu(boolean bl) {
        this.showMenu = bl;
    }

    protected URL getImage(String string) {
        return this.getClass().getResource(string);
    }

    protected AbstractButton makeToolbarButton(String string, String string2, boolean bl) {
        ImageIcon imageIcon = new ImageIcon(this.getImage(string2));
        AbstractButton abstractButton = bl ? (imageIcon.getIconWidth() < 1 || imageIcon.getIconHeight() < 1 ? new JToggleButton(string) : new JToggleButton(imageIcon)) : (imageIcon.getIconWidth() < 1 || imageIcon.getIconHeight() < 1 ? new JButton(string) : new JButton(imageIcon));
        abstractButton.setMinimumSize(this.buttonDimension);
        abstractButton.setMaximumSize(this.buttonDimension);
        abstractButton.setPreferredSize(this.buttonDimension);
        abstractButton.setMargin(this.zeroInsets);
        abstractButton.setToolTipText(string);
        this.toolbar.add(abstractButton);
        return abstractButton;
    }

    protected JMenuItem makeMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = bl ? new JCheckBoxMenuItem(string, false) : new JMenuItem(string);
        this.popupMenu.add(jMenuItem);
        return jMenuItem;
    }

    protected void initParams() {
        if (!this.invokedStandalone) {
            if (this.getParameter("svgfile") != null) {
                this.currentPath = this.svgfile = this.getParameter("svgfile");
                System.out.println("setting svgfile to " + this.svgfile);
            }
            if (this.getParameter("showtoolbar") != null) {
                this.showToolbar = Boolean.valueOf(this.getParameter("showtoolbar"));
                System.out.println("setting showtoolbar to " + this.showToolbar);
            }
            if (this.getParameter("showmenu") != null) {
                this.showMenu = Boolean.valueOf(this.getParameter("showmenu"));
                System.out.println("setting showMenu to " + this.showMenu);
            }
            if (this.getParameter("bgcolor") != null) {
                try {
                    Color color = Color.decode(this.getParameter("bgcolor"));
                    this.canvas.setBackground(color);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public void start() {
        System.out.println("In start");
        this.canvas.fitToWindow();
        this.canvas.draw();
    }

    public boolean getShowScriptController() {
        return this.showScriptController;
    }

    public void setShowScriptController(boolean bl) {
        this.showScriptController = bl;
    }

    public void showStatus(String string) {
        if (this.statusBar != null) {
            this.statusBar.showStatus(string);
        } else {
            super.showStatus(string);
        }
    }

    public void init() {
        ActionListener actionListener;
        JMenuItem jMenuItem;
        this.contentPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.toolbar.setBorder(null);
        this.toolbar.setLayout(new BoxLayout(this.toolbar, 0));
        this.documentbar.setBorder(null);
        this.documentbar.setLayout(new BoxLayout(this.documentbar, 0));
        this.topbar.setBorder(BorderFactory.createEtchedBorder());
        this.topbar.setLayout(new BoxLayout(this.topbar, 1));
        this.backButton = (JButton)this.makeToolbarButton("Back", "/images/back.gif", false);
        JMenuItem jMenuItem2 = this.makeMenuItem("Back", false);
        BackListener backListener = new BackListener();
        this.backButton.addActionListener(backListener);
        jMenuItem2.addActionListener(backListener);
        this.backButton.setEnabled(false);
        this.forwardButton = (JButton)this.makeToolbarButton("Forward", "/images/forward.gif", false);
        JMenuItem jMenuItem3 = this.makeMenuItem("Forward", false);
        ForwardListener forwardListener = new ForwardListener();
        this.forwardButton.addActionListener(forwardListener);
        jMenuItem3.addActionListener(forwardListener);
        this.forwardButton.setEnabled(false);
        this.reloadButton = (JButton)this.makeToolbarButton("Reload", "/images/refresh.gif", false);
        JMenuItem jMenuItem4 = this.makeMenuItem("Reload", false);
        RefreshListener refreshListener = new RefreshListener();
        this.reloadButton.addActionListener(refreshListener);
        jMenuItem4.addActionListener(refreshListener);
        this.viewSrcButton = (JButton)this.makeToolbarButton("View Source", "/images/source.gif", false);
        JMenuItem jMenuItem5 = this.makeMenuItem("View Source", false);
        ViewSourceListener viewSourceListener = new ViewSourceListener();
        this.viewSrcButton.addActionListener(viewSourceListener);
        jMenuItem5.addActionListener(viewSourceListener);
        this.origViewButton = (JButton)this.makeToolbarButton("Original View", "/images/zoom-all.gif", false);
        JMenuItem jMenuItem6 = this.makeMenuItem("Original View", false);
        FitToWindowListener fitToWindowListener = new FitToWindowListener();
        this.origViewButton.addActionListener(fitToWindowListener);
        jMenuItem6.addActionListener(fitToWindowListener);
        this.toolbar.add(Box.createHorizontalStrut(10));
        this.popupMenu.addSeparator();
        this.linkButton = (JToggleButton)this.makeToolbarButton("Link To", "/images/link.gif", true);
        this.linkMenuItem = this.makeMenuItem("Link To", true);
        LinkToListener linkToListener = new LinkToListener();
        this.linkButton.addActionListener(linkToListener);
        this.linkMenuItem.addActionListener(linkToListener);
        this.buttonGroup.add(this.linkButton);
        this.panButton = (JToggleButton)this.makeToolbarButton("Pan", "/images/pan.gif", true);
        this.panMenuItem = this.makeMenuItem("Pan", true);
        PanListener panListener = new PanListener();
        this.panButton.addActionListener(panListener);
        this.panMenuItem.addActionListener(panListener);
        this.buttonGroup.add(this.panButton);
        this.zoomInButton = (JToggleButton)this.makeToolbarButton("Zoom In", "/images/zoom-in.gif", true);
        this.zoomInMenuItem = this.makeMenuItem("Zoom In", true);
        ZoomInListener zoomInListener = new ZoomInListener();
        this.zoomInButton.addActionListener(zoomInListener);
        this.zoomInMenuItem.addActionListener(zoomInListener);
        this.buttonGroup.add(this.zoomInButton);
        this.zoomOutButton = (JToggleButton)this.makeToolbarButton("Zoom Out", "/images/zoom-out.gif", true);
        this.zoomOutMenuItem = this.makeMenuItem("Zoom Out", true);
        ZoomOutListener zoomOutListener = new ZoomOutListener();
        this.zoomOutButton.addActionListener(zoomOutListener);
        this.zoomOutMenuItem.addActionListener(zoomOutListener);
        this.buttonGroup.add(this.zoomOutButton);
        this.zoomRectButton = (JToggleButton)this.makeToolbarButton("Zoom to Rectangle", "/images/zoom-rect.gif", true);
        this.zoomRectMenuItem = this.makeMenuItem("Zoom Rectangle", true);
        ZoomRectListener zoomRectListener = new ZoomRectListener();
        this.zoomRectButton.addActionListener(zoomRectListener);
        this.zoomRectMenuItem.addActionListener(zoomRectListener);
        this.buttonGroup.add(this.zoomRectButton);
        this.toolbar.add(Box.createHorizontalStrut(10));
        this.popupMenu.addSeparator();
        this.printButton = (JButton)this.makeToolbarButton("Print", "/images/print.gif", false);
        JMenuItem jMenuItem7 = this.makeMenuItem("Print...", false);
        PrintListener printListener = new PrintListener();
        this.printButton.addActionListener(printListener);
        jMenuItem7.addActionListener(printListener);
        if (this.invokedStandalone) {
            jMenuItem = this.makeMenuItem("Save as JPEG...", false);
            actionListener = new SaveAsJPEGListener();
            jMenuItem.addActionListener(actionListener);
        }
        this.aboutButton = (JButton)this.makeToolbarButton("About", "/images/about.gif", false);
        jMenuItem = this.makeMenuItem("About", false);
        this.toolbar.add(Box.createHorizontalGlue());
        this.documentUrlField = new JTextField(10);
        this.documentbar.add(this.documentUrlField);
        this.goButton = new JButton("Go");
        actionListener = new OpenUrlListener();
        this.goButton.addActionListener(actionListener);
        this.documentUrlField.addActionListener(actionListener);
        this.documentbar.add(this.goButton);
        if (this.invokedStandalone) {
            this.loadButton = new JButton("Browse");
            BrowseFileListener browseFileListener = new BrowseFileListener();
            this.loadButton.addActionListener(browseFileListener);
            this.documentbar.add(this.loadButton);
        }
        this.documentbar.add(Box.createHorizontalGlue());
        this.canvas = new Canvas();
        this.canvas.setBackground(Color.white);
        this.contentPanel.add((Component)this.canvas, "Center");
        if (this.showScriptController) {
            this.scriptController = new ScriptController();
            this.scriptController.setGlobalScope(false);
            this.scriptController.addObject("viewer", this);
            this.scriptFrame = new ScriptFrame(this.scriptController);
            this.scriptFrame.show();
        }
        this.initParams();
        if (this.svgfile != null) {
            this.loadNewDocument(this.svgfile);
        }
        this.zoomInMouseHandler = new ZoomInMouseHandler(this.canvas);
        this.zoomOutMouseHandler = new ZoomOutMouseHandler(this.canvas);
        this.zoomRectMouseHandler = new ZoomRectMouseHandler(this.canvas);
        this.panMouseHandler = new PanMouseHandler(this.canvas);
        this.linkToMouseHandler = new LinkToMouseHandler(this.canvas, this);
        this.canvas.addMouseMotionListener(new CursorMouseHandler(this.canvas, this));
        this.popupMenuHandler = new PopupMenuHandler(this.canvas);
        this.canvas.addMouseListener(this.popupMenuHandler);
        this.canvas.addMouseMotionListener(this.popupMenuHandler);
        this.scriptMouseHandler = new ScriptMouseHandler(this.canvas);
        this.linkCursor = new Cursor(0);
        this.panCursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getImage("/images/panCursor.gif")).getImage(), new Point(16, 16), "Pan");
        this.zoomInCursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getImage("/images/zoomInCursor.gif")).getImage(), new Point(14, 14), "Zoom In");
        this.zoomOutCursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getImage("/images/zoomOutCursor.gif")).getImage(), new Point(14, 14), "Zoom Out");
        this.zoomRectCursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getImage("/images/zoomRectCursor.gif")).getImage(), new Point(14, 14), "Zoom Out");
        this.currentCursor = this.linkCursor;
        if (this.showToolbar) {
            this.topbar.add(this.toolbar);
            this.topbar.add(Box.createVerticalStrut(4));
            this.topbar.add(this.documentbar);
            this.contentPanel.add((Component)this.topbar, "North");
        }
        if (this.invokedStandalone) {
            this.statusBar = new StatusBar();
            this.contentPanel.add((Component)this.statusBar, "South");
        }
    }

    public void documentBack() {
        if (this.docHistory.size() - this.docIndex > 1) {
            ++this.docIndex;
            this.loadDocument((String)this.docHistory.elementAt(this.docHistory.size() - 1 - this.docIndex));
            this.forwardButton.setEnabled(true);
        }
        if (this.docHistory.size() - this.docIndex == 1) {
            this.backButton.setEnabled(false);
        }
    }

    public void documentForward() {
        if (this.docIndex >= 1) {
            --this.docIndex;
            this.loadDocument((String)this.docHistory.elementAt(this.docHistory.size() - 1 - this.docIndex));
            this.backButton.setEnabled(true);
        }
        if (this.docIndex == 0) {
            this.forwardButton.setEnabled(false);
        }
    }

    public void loadNewDocument(String string) {
        int n = 0;
        while (n < this.docIndex) {
            this.docHistory.remove(this.docHistory.size() - 1);
            ++n;
        }
        this.docIndex = 0;
        this.docHistory.add(string);
        if (this.docHistory.size() > 1) {
            this.backButton.setEnabled(true);
        }
        this.forwardButton.setEnabled(false);
        this.loadDocument(string);
    }

    public void loadDocument(String string) {
        int n;
        this.svgfile = this.svgfile != null && string.indexOf("#") == 0 ? (this.svgfile.indexOf("#") == -1 ? this.svgfile + string : this.svgfile.substring(0, this.svgfile.indexOf("#")) + string) : string;
        this.documentUrlField.setText(this.svgfile);
        this.currentPath = "";
        if (this.svgfile.indexOf(47) != -1 || this.svgfile.indexOf(92) != -1) {
            n = this.svgfile.lastIndexOf(47);
            if (n == -1) {
                n = this.svgfile.lastIndexOf(92);
            }
            this.currentPath = this.svgfile.substring(0, n + 1);
        }
        if ((n = this.svgfile.indexOf("#")) != -1) {
            String string2 = this.svgfile.substring(0, n);
            String string3 = this.svgfile.substring(n + 1);
            SvgLoader svgLoader = new SvgLoader(string2, string3, this);
            svgLoader.start();
        } else {
            SvgLoader svgLoader = new SvgLoader(this.svgfile, this);
            svgLoader.start();
        }
    }

    public void saveDocument(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            XmlWriter xmlWriter = new XmlWriter(fileOutputStream);
            xmlWriter.print((Node)this.canvas.getSVGDocument(), "<!DOCTYPE svg SYSTEM \"svg-20000802.dtd\">");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Caught exception while saving document " + iOException.getLocalizedMessage());
        }
    }

    public Context getContext() {
        return this.scriptController.getContext();
    }

    public void setContext(Context context) {
        this.scriptController.setContext(context);
    }

    public Scriptable getScope() {
        return this.scriptController.getScope();
    }

    public void setScope(Scriptable scriptable) {
        this.scriptController.setScope(scriptable);
    }

    public void newSvgDoc(SVGDocumentImpl sVGDocumentImpl, String string) {
        if (sVGDocumentImpl != null) {
            SVGSVGElementImpl sVGSVGElementImpl;
            System.out.println("finished reading svg doc: " + string);
            this.linkButton.setSelected(true);
            this.canvas.setCursor(this.linkCursor);
            this.currentCursor = this.linkCursor;
            this.canvas.removeMouseListener(this.currentMouseHandler);
            this.canvas.removeMouseMotionListener(this.currentMouseHandler);
            this.canvas.removeMouseListener(this.scriptMouseHandler);
            this.canvas.removeMouseMotionListener(this.scriptMouseHandler);
            this.currentMouseHandler = this.linkToMouseHandler;
            this.canvas.addMouseListener(this.currentMouseHandler);
            this.canvas.addMouseMotionListener(this.currentMouseHandler);
            this.canvas.addMouseListener(this.scriptMouseHandler);
            this.canvas.addMouseMotionListener(this.scriptMouseHandler);
            if (this.scriptController == null || sVGDocumentImpl != null) {
                // empty if block
            }
            this.canvas.setSVGDocument(sVGDocumentImpl);
            String string2 = this.title;
            if (sVGDocumentImpl.getTitle() != null && sVGDocumentImpl.getTitle().trim().length() > 0) {
                string2 = string2 + " : " + sVGDocumentImpl.getTitle().trim();
            }
            if (this.frame != null) {
                this.frame.setTitle(string2);
            }
            if ((sVGSVGElementImpl = (SVGSVGElementImpl)sVGDocumentImpl.getRootElement()) != null) {
                String string3 = sVGSVGElementImpl.getAttribute("zoomAndPan");
                if (string3.equals("disable")) {
                    this.panButton.setEnabled(false);
                    this.zoomInButton.setEnabled(false);
                    this.zoomOutButton.setEnabled(false);
                    this.zoomRectButton.setEnabled(false);
                    this.panMenuItem.setEnabled(false);
                    this.zoomInMenuItem.setEnabled(false);
                    this.zoomOutMenuItem.setEnabled(false);
                    this.zoomRectMenuItem.setEnabled(false);
                } else {
                    this.panButton.setEnabled(true);
                    this.zoomInButton.setEnabled(true);
                    this.zoomOutButton.setEnabled(true);
                    this.zoomRectButton.setEnabled(true);
                    this.panMenuItem.setEnabled(true);
                    this.zoomInMenuItem.setEnabled(true);
                    this.zoomOutMenuItem.setEnabled(true);
                    this.zoomRectMenuItem.setEnabled(true);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "Could not load SVG :\n" + string, "Load Error", 1);
        }
    }

    public static void main1(String[] stringArray) {
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = string + stringArray[n];
            ++n;
        }
        boolean bl = true;
        boolean bl2 = true;
        Object var5_5 = null;
        Viewer viewer = new Viewer();
        viewer.invokedStandalone = true;
        if (var5_5 != null) {
            viewer.svgfile = var5_5;
        }
        viewer.setShowToolbar(bl);
        viewer.setShowMenu(bl2);
        JFrame jFrame = new JFrame(viewer.title);
        ((Component)jFrame).setBounds(20, 20, 750, 750);
        jFrame.getContentPane().add((Component)viewer, "Center");
        viewer.frame = jFrame;
        viewer.init();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.show();
        viewer.scriptFrame.loadDocument(string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 4) {
            System.out.println("Usage: java org.csiro.svgv.display.Viewer [-/+toolbar] [-/+menu] [svg-url]");
            System.exit(1);
        }
        boolean bl = true;
        boolean bl2 = true;
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("+toolbar")) {
                bl = false;
            } else if (stringArray[n].equals("+menu")) {
                bl2 = false;
            } else {
                string = stringArray[n];
            }
            ++n;
        }
        Viewer viewer = new Viewer();
        viewer.invokedStandalone = true;
        if (string != null) {
            viewer.svgfile = string;
        }
        viewer.setShowToolbar(bl);
        viewer.setShowMenu(bl2);
        JFrame jFrame = new JFrame(viewer.title);
        ((Component)jFrame).setBounds(20, 20, 750, 750);
        jFrame.getContentPane().add((Component)viewer, "Center");
        viewer.frame = jFrame;
        viewer.init();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.show();
        viewer.canvas.fitToWindow();
        viewer.canvas.draw();
    }

    public void saveAsJPEG(String string) {
        BufferedImage bufferedImage = new BufferedImage(this.canvas.getWidth(), this.canvas.getHeight(), 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.canvas.doPaint(graphics2D);
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            JPEGEncodeParam jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
            jPEGEncodeParam.setQuality(0.9f, true);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
        }
        catch (IOException iOException) {
            System.out.println("Failed to write JPEG file. Got execption: " + iOException.getMessage());
        }
    }

    public DocumentView getDocument() {
        return this.canvas.getSVGDocument();
    }

    public class PopupMenuHandler
    extends MouseHandler {
        public PopupMenuHandler(Canvas canvas) {
            super(canvas);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isMetaDown() && Viewer.this.showMenu) {
                MenuElement[] menuElementArray = Viewer.this.popupMenu.getSubElements();
                int n = 0;
                while (n < menuElementArray.length) {
                    JMenuItem jMenuItem = (JMenuItem)menuElementArray[n];
                    if (jMenuItem instanceof JCheckBoxMenuItem) {
                        if (Viewer.this.currentMouseHandler == Viewer.this.zoomInMouseHandler && jMenuItem.getText().equals("Zoom In")) {
                            ((JCheckBoxMenuItem)jMenuItem).setState(true);
                        } else if (Viewer.this.currentMouseHandler == Viewer.this.zoomOutMouseHandler && jMenuItem.getText().equals("Zoom Out")) {
                            ((JCheckBoxMenuItem)jMenuItem).setState(true);
                        } else if (Viewer.this.currentMouseHandler == Viewer.this.zoomRectMouseHandler && jMenuItem.getText().equals("Zoom Rectangle")) {
                            ((JCheckBoxMenuItem)jMenuItem).setState(true);
                        } else if (Viewer.this.currentMouseHandler == Viewer.this.panMouseHandler && jMenuItem.getText().equals("Pan")) {
                            ((JCheckBoxMenuItem)jMenuItem).setState(true);
                        } else if (Viewer.this.currentMouseHandler == Viewer.this.linkToMouseHandler && jMenuItem.getText().equals("Link To")) {
                            ((JCheckBoxMenuItem)jMenuItem).setState(true);
                        } else {
                            ((JCheckBoxMenuItem)jMenuItem).setState(false);
                        }
                    }
                    ++n;
                }
                Viewer.this.popupMenu.show(this.canvas, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public class PrintListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.canvas.print();
        }
    }

    public class PanListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.panButton.setSelected(true);
            Viewer.this.canvas.setCursor(Viewer.this.panCursor);
            Viewer.this.currentCursor = Viewer.this.panCursor;
            Viewer.this.canvas.removeMouseListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.removeMouseMotionListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.removeMouseListener(Viewer.this.scriptMouseHandler);
            Viewer.this.canvas.removeMouseMotionListener(Viewer.this.scriptMouseHandler);
            Viewer.this.currentMouseHandler = Viewer.this.panMouseHandler;
            Viewer.this.canvas.addMouseListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.addMouseMotionListener(Viewer.this.currentMouseHandler);
        }
    }

    public class ZoomRectListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.zoomRectButton.setSelected(true);
            Viewer.this.canvas.setCursor(Viewer.this.zoomRectCursor);
            Viewer.this.currentCursor = Viewer.this.zoomRectCursor;
            Viewer.this.canvas.removeMouseListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.removeMouseMotionListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.removeMouseListener(Viewer.this.scriptMouseHandler);
            Viewer.this.canvas.removeMouseMotionListener(Viewer.this.scriptMouseHandler);
            Viewer.this.currentMouseHandler = Viewer.this.zoomRectMouseHandler;
            Viewer.this.canvas.addMouseListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.addMouseMotionListener(Viewer.this.currentMouseHandler);
        }
    }

    public class ZoomOutListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.zoomOutButton.setSelected(true);
            Viewer.this.canvas.setCursor(Viewer.this.zoomOutCursor);
            Viewer.this.currentCursor = Viewer.this.zoomOutCursor;
            Viewer.this.canvas.removeMouseListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.removeMouseMotionListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.removeMouseListener(Viewer.this.scriptMouseHandler);
            Viewer.this.canvas.removeMouseMotionListener(Viewer.this.scriptMouseHandler);
            Viewer.this.currentMouseHandler = Viewer.this.zoomOutMouseHandler;
            Viewer.this.canvas.addMouseListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.addMouseMotionListener(Viewer.this.currentMouseHandler);
        }
    }

    public class ZoomInListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.zoomInButton.setSelected(true);
            Viewer.this.canvas.setCursor(Viewer.this.zoomInCursor);
            Viewer.this.currentCursor = Viewer.this.zoomInCursor;
            Viewer.this.canvas.removeMouseListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.removeMouseMotionListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.removeMouseListener(Viewer.this.scriptMouseHandler);
            Viewer.this.canvas.removeMouseMotionListener(Viewer.this.scriptMouseHandler);
            Viewer.this.currentMouseHandler = Viewer.this.zoomInMouseHandler;
            Viewer.this.canvas.addMouseListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.addMouseMotionListener(Viewer.this.currentMouseHandler);
        }
    }

    public class LinkToListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.linkButton.setSelected(true);
            Viewer.this.canvas.setCursor(Viewer.this.linkCursor);
            Viewer.this.currentCursor = Viewer.this.linkCursor;
            Viewer.this.canvas.removeMouseListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.removeMouseMotionListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.removeMouseListener(Viewer.this.scriptMouseHandler);
            Viewer.this.canvas.removeMouseMotionListener(Viewer.this.scriptMouseHandler);
            Viewer.this.currentMouseHandler = Viewer.this.linkToMouseHandler;
            Viewer.this.canvas.addMouseListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.addMouseMotionListener(Viewer.this.currentMouseHandler);
            Viewer.this.canvas.addMouseListener(Viewer.this.scriptMouseHandler);
            Viewer.this.canvas.addMouseMotionListener(Viewer.this.scriptMouseHandler);
        }
    }

    public class SaveAsJPEGListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = Viewer.this.currentPath == null ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(Viewer.this.currentPath);
            jFileChooser.setFileFilter(new JpgFileFilter());
            int n = jFileChooser.showSaveDialog(Viewer.this.canvas);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                Viewer.this.currentPath = file.getPath();
                Viewer.this.saveAsJPEG(file.getAbsolutePath());
            }
        }
    }

    public class ViewSourceListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            if (Viewer.this.viewSourceFrame == null) {
                Viewer.this.viewSourceFrame = new JFrame();
                Viewer.this.viewSourceArea = new JTextArea(20, 60);
                Viewer.this.viewSourceArea.setFont(new Font("Courier", 0, 12));
                object5 = new JScrollPane(Viewer.this.viewSourceArea);
                ((Component)Viewer.this.viewSourceFrame).setBounds(40, 40, 600, 400);
                Viewer.this.viewSourceFrame.getContentPane().add((Component)object5, "Center");
                JPanel jPanel = new JPanel();
                JButton jButton = new JButton("Save As...");
                object4 = new SaveSourceListener();
                jButton.addActionListener((ActionListener)object4);
                jPanel.add(jButton);
                Viewer.this.viewSourceFrame.getContentPane().add((Component)jPanel, "South");
            }
            object5 = Viewer.this.svgfile;
            int n = Viewer.this.svgfile.indexOf("#");
            if (n != -1) {
                object5 = Viewer.this.svgfile.substring(0, n);
            }
            Viewer.this.viewSourceFrame.setTitle("Source of " + (String)object5);
            boolean bl = false;
            object4 = null;
            if (((String)object5).startsWith("http:") || ((String)object5).startsWith("ftp:") || ((String)object5).startsWith("file:")) {
                try {
                    object3 = new URL((String)object5);
                    object2 = ((URL)object3).openConnection();
                    object = ((URLConnection)object2).getContentType();
                    if (((String)object).indexOf("zip") != -1 || ((String)object5).endsWith(".zip")) {
                        bl = true;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    System.out.println("bad url: " + (String)object5);
                }
                catch (IOException iOException) {
                    System.out.println("IOException while getting SVG stream");
                }
            } else if (((String)object5).endsWith(".zip")) {
                bl = true;
            }
            try {
                ZipConstants zipConstants;
                object3 = null;
                if (((String)object5).startsWith("http:") || ((String)object5).startsWith("ftp:") || ((String)object5).startsWith("file:")) {
                    object2 = new URL((String)object5);
                    object = ((URL)object2).openConnection();
                    if (bl) {
                        zipConstants = new ZipInputStream(((URLConnection)object).getInputStream());
                        ZipEntry zipEntry = zipConstants.getNextEntry();
                        object3 = zipConstants;
                    } else {
                        object3 = ((URLConnection)object).getInputStream();
                    }
                } else {
                    object2 = new File((String)object5);
                    if (bl) {
                        object = new ZipInputStream(new FileInputStream((File)object2));
                        zipConstants = ((ZipInputStream)object).getNextEntry();
                        object3 = object;
                    } else {
                        object3 = new FileInputStream((File)object2);
                    }
                }
                if (object3 != null) {
                    object4 = object3;
                }
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("bad url: " + Viewer.this.svgfile);
                malformedURLException.printStackTrace();
            }
            catch (IOException iOException) {
                System.out.println("IOException in parsing XML: " + iOException.getMessage());
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                System.out.println("IOException in parsing XML: " + exception.getMessage());
                exception.printStackTrace();
            }
            if (object4 != null) {
                object3 = new StringBuffer();
                object2 = new byte[1024];
                try {
                    int n2 = ((InputStream)object4).read((byte[])object2, 0, 1024);
                    while (n2 != -1) {
                        ((StringBuffer)object3).append(new String((byte[])object2, 0, n2));
                        n2 = ((InputStream)object4).read((byte[])object2, 0, 1024);
                    }
                }
                catch (Exception exception) {
                    System.out.println("IOException in parsing XML: " + exception.getMessage());
                    exception.printStackTrace();
                }
                Viewer.this.viewSourceArea.setText(((StringBuffer)object3).toString());
                Viewer.this.viewSourceArea.setCaretPosition(0);
            }
            Viewer.this.viewSourceFrame.show();
        }
    }

    public class ForwardListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.documentForward();
        }
    }

    public class BackListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.documentBack();
        }
    }

    public class FitToWindowListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.canvas.zoomAll();
            Viewer.this.canvas.draw();
        }
    }

    public class SaveDOMListener
    implements ActionListener {
        public Viewer viewer = null;

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[]{"Save", "Cancel", "Browse for File"};
            JOptionPane jOptionPane = new JOptionPane("Enter the filename save\n(or browse for a file)", 3, 2, null, objectArray, objectArray[0]);
            jOptionPane.setWantsInput(true);
            if (Viewer.this.svgfile != null) {
                jOptionPane.setInitialSelectionValue(Viewer.this.svgfile);
            }
            jOptionPane.selectInitialValue();
            JDialog jDialog = jOptionPane.createDialog(this.viewer, Viewer.this.title);
            jDialog.show();
            String string = (String)jOptionPane.getValue();
            if (string == null) {
                return;
            }
            if (string == JOptionPane.UNINITIALIZED_VALUE || objectArray[0].equals(string)) {
                String string2 = (String)jOptionPane.getInputValue();
                Viewer.this.saveDocument(string2);
            } else {
                if (objectArray[1].equals(string)) {
                    return;
                }
                JFileChooser jFileChooser = Viewer.this.currentPath == null ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(Viewer.this.currentPath);
                jFileChooser.setFileFilter(new SvgFileFilter());
                int n = jFileChooser.showOpenDialog(Viewer.this.canvas);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    Viewer.this.currentPath = file.getPath();
                    System.out.println(file.getAbsolutePath());
                    Viewer.this.saveDocument(file.getAbsolutePath());
                }
            }
        }
    }

    public class SaveSourceListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object[] objectArray = new Object[]{"Save", "Cancel", "Browse for File"};
            JOptionPane jOptionPane = new JOptionPane("Enter the filename save\n(or browse for a file)", 3, 2, null, objectArray, objectArray[0]);
            jOptionPane.setWantsInput(true);
            if (Viewer.this.svgfile != null) {
                object = Viewer.this.svgfile;
                int n = Viewer.this.svgfile.indexOf("#");
                if (n != -1) {
                    object = Viewer.this.svgfile.substring(0, n);
                }
                jOptionPane.setInitialSelectionValue(object);
            }
            jOptionPane.selectInitialValue();
            object = jOptionPane.createDialog(null, Viewer.this.title);
            ((Dialog)object).show();
            String string = (String)jOptionPane.getValue();
            if (string == null) {
                return;
            }
            if (string == JOptionPane.UNINITIALIZED_VALUE || objectArray[0].equals(string)) {
                String string2 = (String)jOptionPane.getInputValue();
                if (Viewer.this.viewSourceArea != null) {
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(new File(string2));
                        String string3 = Viewer.this.viewSourceArea.getText();
                        fileOutputStream.write(string3.getBytes());
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(null, "Could not save file:\n" + string2, "Save Error", 1);
                    }
                }
            } else {
                if (objectArray[1].equals(string)) {
                    return;
                }
                JFileChooser jFileChooser = Viewer.this.currentPath == null ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(Viewer.this.currentPath);
                jFileChooser.setFileFilter(new SvgFileFilter());
                int n = jFileChooser.showOpenDialog(Viewer.this.canvas);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    Viewer.this.currentPath = file.getPath();
                    System.out.println(file.getAbsolutePath());
                    if (Viewer.this.viewSourceArea != null) {
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            String string4 = Viewer.this.viewSourceArea.getText();
                            fileOutputStream.write(string4.getBytes());
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(null, "Could not save file:\n" + file.getAbsolutePath(), "Save Error", 1);
                        }
                    }
                }
            }
        }
    }

    public class RefreshListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Viewer.this.loadDocument(Viewer.this.svgfile);
        }
    }

    public class OpenUrlListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = Viewer.this.documentUrlField.getText();
            if (string == null || string.equals("")) {
                return;
            }
            Viewer.this.loadNewDocument(string);
        }
    }

    public class BrowseFileListener
    implements ActionListener {
        public Viewer viewer = null;

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = Viewer.this.currentPath == null ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(Viewer.this.currentPath);
            jFileChooser.setFileFilter(new SvgFileFilter());
            int n = jFileChooser.showOpenDialog(Viewer.this.canvas);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                Viewer.this.currentPath = file.getPath();
                System.out.println(file.getAbsolutePath());
                Viewer.this.loadNewDocument(file.getAbsolutePath());
            }
        }
    }
}

