/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.viewer;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import org.csiro.svg.viewer.Canvas;
import org.csiro.svg.viewer.MouseHandler;

public class ZoomRectMouseHandler
extends MouseHandler {
    Rectangle canvasDimensions;
    int pressedX;
    int pressedY;
    Rectangle previous = null;

    public ZoomRectMouseHandler(Canvas canvas) {
        super(canvas);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown()) {
            this.pressedX = mouseEvent.getX();
            this.pressedY = mouseEvent.getY();
            this.canvasDimensions = this.getCanvas().getBounds();
            this.previous = new Rectangle(this.pressedX, this.pressedY, this.canvasDimensions.width / 10, this.canvasDimensions.height / 10);
            this.getCanvas().drawXORRectangle(this.previous);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown()) {
            Rectangle rectangle = new Rectangle(this.previous);
            if (rectangle.width < 0) {
                rectangle.x += rectangle.width;
                rectangle.width = -1 * rectangle.width;
            }
            if (rectangle.height < 0) {
                rectangle.y += rectangle.height;
                rectangle.height = -1 * rectangle.height;
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            Canvas canvas = this.getCanvas();
            double_.x = canvas.getWorldXCoord(rectangle.x);
            double_.width = canvas.getWorldXCoord(rectangle.x + rectangle.width) - double_.x;
            if (canvas.getFlipped()) {
                double_.y = canvas.getWorldYCoord(this.canvasDimensions.height - rectangle.y);
                double_.height = canvas.getWorldYCoord(this.canvasDimensions.height - rectangle.y - rectangle.height) - double_.y;
            } else {
                double_.y = canvas.getWorldYCoord(rectangle.y + rectangle.height);
                double_.height = canvas.getWorldYCoord(rectangle.y) - double_.y;
            }
            canvas.setView(double_);
            canvas.draw();
            this.previous = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown() && this.previous != null) {
            this.getCanvas().drawXORRectangle(this.previous);
            int n = mouseEvent.getX() - this.pressedX;
            int n2 = mouseEvent.getY() - this.pressedY;
            if (n > 0) {
                this.previous.x = this.pressedX;
                if (n < this.canvasDimensions.width / 10) {
                    n = this.canvasDimensions.width / 10;
                }
            } else if (-1 * n < this.canvasDimensions.width / 10) {
                n = this.canvasDimensions.width / -10;
            }
            if (n2 > 0) {
                if (n2 < this.canvasDimensions.height / 10) {
                    n2 = this.canvasDimensions.height / 10;
                }
            } else if (-1 * n2 < this.canvasDimensions.height / 10) {
                n2 = this.canvasDimensions.height / -10;
            }
            this.previous.width = n;
            this.previous.height = n2;
            this.getCanvas().drawXORRectangle(this.previous);
        }
    }
}

