/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.apps.rasterizer.SVGConverterException;
import org.apache.batik.apps.rasterizer.SVGConverterSource;

public class SVGConverterURLSource
implements SVGConverterSource {
    protected static final String SVG_EXTENSION = ".svg";
    public static final String ERROR_INVALID_URL = "SVGConverterURLSource.error.invalid.url";
    URL url;
    String name;

    public SVGConverterURLSource(String string) throws SVGConverterException {
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SVGConverterException(ERROR_INVALID_URL, new Object[]{string});
        }
        String string2 = this.url.getFile();
        if (string2 == null || !string2.toLowerCase().endsWith(SVG_EXTENSION)) {
            throw new SVGConverterException(ERROR_INVALID_URL, new Object[]{string});
        }
        int n = string2.lastIndexOf("/");
        if (n != -1) {
            string2 = string2.substring(n + 1);
        }
        this.name = string2;
        String string3 = this.url.getRef();
        if (string3 != null && !"".equals(string3)) {
            this.name = this.name + "" + string3.hashCode();
        }
    }

    public String toString() {
        return this.url.toString();
    }

    public String getURI() {
        return this.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SVGConverterURLSource)) {
            return false;
        }
        return this.url.equals(((SVGConverterURLSource)object).url);
    }

    public InputStream openStream() throws IOException {
        return this.url.openStream();
    }

    public boolean isSameAs(String string) {
        return this.toString().equals(string);
    }

    public boolean isReadable() {
        return true;
    }

    public String getName() {
        return this.name;
    }
}

