/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.apache.batik.util.gui.ExtendedGridBagConstraints;
import org.apache.batik.util.gui.resource.ResourceManager;

public class JPEGOptionPanel
extends JPanel {
    public static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.GUI";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.GUI", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected JSlider quality;

    public JPEGOptionPanel() {
        super(new GridBagLayout());
        ExtendedGridBagConstraints extendedGridBagConstraints = new ExtendedGridBagConstraints();
        extendedGridBagConstraints.insets = new Insets(5, 5, 5, 5);
        extendedGridBagConstraints.weightx = 0.0;
        extendedGridBagConstraints.weighty = 0.0;
        extendedGridBagConstraints.fill = 0;
        extendedGridBagConstraints.setGridBounds(0, 0, 1, 1);
        this.add((Component)new JLabel(resources.getString("JPEGOptionPanel.label")), extendedGridBagConstraints);
        this.quality = new JSlider();
        this.quality.setMinimum(0);
        this.quality.setMaximum(100);
        this.quality.setMajorTickSpacing(10);
        this.quality.setMinorTickSpacing(5);
        this.quality.setPaintTicks(true);
        this.quality.setPaintLabels(true);
        this.quality.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        int n = 0;
        while (n < 100) {
            hashtable.put(new Integer(n), new JLabel("0." + n / 10));
            n += 10;
        }
        hashtable.put(new Integer(100), new JLabel("1"));
        this.quality.setLabelTable(hashtable);
        Dimension dimension = this.quality.getPreferredSize();
        this.quality.setPreferredSize(new Dimension(350, dimension.height));
        extendedGridBagConstraints.weightx = 1.0;
        extendedGridBagConstraints.fill = 2;
        extendedGridBagConstraints.setGridBounds(1, 0, 1, 1);
        this.add((Component)this.quality, extendedGridBagConstraints);
    }

    public float getQuality() {
        return (float)this.quality.getValue() / 100.0f;
    }

    public static void main(String[] stringArray) {
        System.out.println(JPEGOptionPanel.showDialog(null));
    }

    public static float showDialog(Component component) {
        Dialog dialog = new Dialog(component);
        dialog.pack();
        dialog.show();
        return dialog.getQuality();
    }

    public static class Dialog
    extends JDialog {
        protected JButton ok;
        protected JPEGOptionPanel panel;

        public Dialog(Component component) {
            super(JOptionPane.getFrameForComponent(component), resources.getString("JPEGOptionPanel.dialog.title"));
            this.setModal(true);
            this.panel = new JPEGOptionPanel();
            this.getContentPane().add((Component)this.panel, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "South");
        }

        public float getQuality() {
            return this.panel.getQuality();
        }

        protected JPanel createButtonPanel() {
            JPanel jPanel = new JPanel(new FlowLayout());
            this.ok = new JButton(resources.getString("OKButton.text"));
            this.ok.addActionListener(new OKButtonAction());
            jPanel.add(this.ok);
            return jPanel;
        }

        protected class OKButtonAction
        extends AbstractAction {
            protected OKButtonAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Dialog.this.dispose();
            }
        }
    }
}

