/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.util.PreferenceManager;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLPreferenceManager
extends PreferenceManager {
    protected String xmlParserClassName;

    public XMLPreferenceManager(String string) {
        this(string, null, XMLResourceDescriptor.getXMLParserClassName());
    }

    public XMLPreferenceManager(String string, Map map) {
        this(string, map, XMLResourceDescriptor.getXMLParserClassName());
    }

    public XMLPreferenceManager(String string, String string2) {
        this(string, null, string2);
    }

    public XMLPreferenceManager(String string, Map map, String string2) {
        super(string, map);
        this.internal = new XMLProperties();
        this.xmlParserClassName = string2;
    }

    protected class XMLProperties
    extends Properties {
        protected XMLProperties() {
        }

        public synchronized void load(InputStream inputStream) throws IOException {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "8859_1"));
            SAXDocumentFactory sAXDocumentFactory = new SAXDocumentFactory(GenericDOMImplementation.getDOMImplementation(), XMLPreferenceManager.this.xmlParserClassName);
            Document document = sAXDocumentFactory.createDocument("http://xml.apache.org/batik/preferences", "preferences", null, bufferedReader);
            Element element = document.getDocumentElement();
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && node.getNodeName().equals("property")) {
                    String string = ((Element)node).getAttributeNS(null, "name");
                    StringBuffer stringBuffer = new StringBuffer();
                    Node node2 = node.getFirstChild();
                    while (node2 != null) {
                        if (node2.getNodeType() != 3) break;
                        stringBuffer.append(node2.getNodeValue());
                        node2 = node2.getNextSibling();
                    }
                    String string2 = stringBuffer.toString();
                    ((Hashtable)this).put(string, string2);
                }
                node = node.getNextSibling();
            }
        }

        public synchronized void store(OutputStream outputStream, String string) throws IOException {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
            HashMap hashMap = new HashMap();
            this.enumerate(hashMap);
            bufferedWriter.write("<preferences xmlns=\"http://xml.apache.org/batik/preferences\">\n");
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = (String)hashMap.get(string2);
                bufferedWriter.write("<property name=\"" + string2 + "\">");
                bufferedWriter.write(DOMUtilities.contentToString(string3));
                bufferedWriter.write("</property>\n");
            }
            bufferedWriter.write("</preferences>\n");
            bufferedWriter.flush();
        }

        private synchronized void enumerate(Map map) {
            Object k;
            Iterator iterator;
            if (this.defaults != null) {
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    k = iterator.next();
                    map.put(k, ((Hashtable)this.defaults).get(k));
                }
            }
            iterator = ((Hashtable)this).keySet().iterator();
            while (iterator.hasNext()) {
                k = iterator.next();
                map.put(k, ((Hashtable)this).get(k));
            }
        }
    }
}

