/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.ColorMatrixRable;
import org.apache.batik.ext.awt.image.renderable.ColorMatrixRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeColorMatrixElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    public String getLocalName() {
        return "feColorMatrix";
    }

    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        ColorMatrixRable colorMatrixRable;
        Filter filter2 = AbstractSVGFilterPrimitiveElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = filter2.getBounds2D();
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        int n = SVGFeColorMatrixElementBridge.convertType(element);
        switch (n) {
            case 2: {
                float f = SVGFeColorMatrixElementBridge.convertValuesToHueRotate(element);
                colorMatrixRable = ColorMatrixRable8Bit.buildHueRotate(f);
                break;
            }
            case 3: {
                colorMatrixRable = ColorMatrixRable8Bit.buildLuminanceToAlpha();
                break;
            }
            case 0: {
                float[][] fArray = SVGFeColorMatrixElementBridge.convertValuesToMatrix(element);
                colorMatrixRable = ColorMatrixRable8Bit.buildMatrix(fArray);
                break;
            }
            case 1: {
                float f = SVGFeColorMatrixElementBridge.convertValuesToSaturate(element);
                colorMatrixRable = ColorMatrixRable8Bit.buildSaturate(f);
                break;
            }
            default: {
                throw new Error();
            }
        }
        colorMatrixRable.setSource(filter2);
        AbstractSVGFilterPrimitiveElementBridge.handleColorInterpolationFilters(colorMatrixRable, element);
        PadRable8Bit padRable8Bit = new PadRable8Bit(colorMatrixRable, rectangle2D3, PadMode.ZERO_PAD);
        AbstractSVGFilterPrimitiveElementBridge.updateFilterMap(element, padRable8Bit, map);
        return padRable8Bit;
    }

    protected static float[][] convertValuesToMatrix(Element element) {
        String string = element.getAttributeNS(null, "values");
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"values"});
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        float[][] fArray = new float[4][5];
        int n = 0;
        try {
            while (n < 20 && stringTokenizer.hasMoreTokens()) {
                fArray[n / 5][n % 5] = SVGUtilities.convertSVGNumber(stringTokenizer.nextToken());
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"values", string, numberFormatException});
        }
        if (n != 20 || stringTokenizer.hasMoreTokens()) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"values", string});
        }
        int n2 = 0;
        while (n2 < 4) {
            float[] fArray2 = fArray[n2];
            fArray2[4] = fArray2[4] * 255.0f;
            ++n2;
        }
        return fArray;
    }

    protected static float convertValuesToSaturate(Element element) {
        String string = element.getAttributeNS(null, "values");
        int n = string.length();
        if (string.length() == 0) {
            return 0.0f;
        }
        try {
            return SVGUtilities.convertSVGNumber(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"values", string});
        }
    }

    protected static float convertValuesToHueRotate(Element element) {
        String string = element.getAttributeNS(null, "values");
        int n = string.length();
        if (string.length() == 0) {
            return 1.0f;
        }
        try {
            return (float)((double)SVGUtilities.convertSVGNumber(string) * Math.PI) / 180.0f;
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"values", string});
        }
    }

    protected static int convertType(Element element) {
        String string = element.getAttributeNS(null, "type");
        int n = string.length();
        if (string.length() == 0) {
            return 0;
        }
        if ("hueRotate".equals(string)) {
            return 2;
        }
        if ("luminanceToAlpha".equals(string)) {
            return 3;
        }
        if ("matrix".equals(string)) {
            return 0;
        }
        if ("saturate".equals(string)) {
            return 1;
        }
        throw new BridgeException(element, "attribute.malformed", new Object[]{"type", string});
    }
}

