/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathParser;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGPathElementBridge
extends SVGDecoratedShapeElementBridge {
    public String getLocalName() {
        return "path";
    }

    public Bridge getInstance() {
        return new SVGPathElementBridge();
    }

    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        block5: {
            String string = element.getAttributeNS(null, "d");
            if (string.length() != 0) {
                AWTPathProducer aWTPathProducer = new AWTPathProducer();
                aWTPathProducer.setWindingRule(CSSUtilities.convertFillRule(element));
                try {
                    try {
                        PathParser pathParser = new PathParser();
                        pathParser.setPathHandler(aWTPathProducer);
                        pathParser.parse(string);
                    }
                    catch (ParseException parseException) {
                        BridgeException bridgeException = new BridgeException(element, "attribute.malformed", new Object[]{"d"});
                        bridgeException.setGraphicsNode(shapeNode);
                        throw bridgeException;
                    }
                    Object var9_8 = null;
                    shapeNode.setShape(aWTPathProducer.getShape());
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    shapeNode.setShape(aWTPathProducer.getShape());
                    throw throwable;
                }
            }
            throw new BridgeException(element, "attribute.missing", new Object[]{"d"});
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("d")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }
}

