/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class StrokeDasharrayManager
extends AbstractValueManager {
    public boolean isInheritedProperty() {
        return true;
    }

    public String getPropertyName() {
        return "stroke-dasharray";
    }

    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 35: {
                if (lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
            }
        }
        ListValue listValue = new ListValue(' ');
        do {
            FloatValue floatValue;
            switch (lexicalUnit.getLexicalUnitType()) {
                case 13: {
                    floatValue = new FloatValue(1, lexicalUnit.getIntegerValue());
                    break;
                }
                case 14: {
                    floatValue = new FloatValue(1, lexicalUnit.getFloatValue());
                    break;
                }
                default: {
                    throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                }
            }
            listValue.append(floatValue);
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
            if (lexicalUnit == null || lexicalUnit.getLexicalUnitType() != 0) continue;
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
        } while (lexicalUnit != null);
        return listValue;
    }

    public Value createStringValue(short s, String string, CSSEngine cSSEngine) throws DOMException {
        if (s != 21) {
            throw this.createInvalidStringTypeDOMException(s);
        }
        if (string.equalsIgnoreCase("none")) {
            return ValueConstants.NONE_VALUE;
        }
        throw this.createInvalidIdentifierDOMException(string);
    }
}

