/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import org.apache.batik.gvt.font.UnicodeRange;

public class Kern {
    private int[] firstGlyphCodes;
    private int[] secondGlyphCodes;
    private UnicodeRange[] firstUnicodeRanges;
    private UnicodeRange[] secondUnicodeRanges;
    private float kerningAdjust;

    public Kern(int[] nArray, int[] nArray2, UnicodeRange[] unicodeRangeArray, UnicodeRange[] unicodeRangeArray2, float f) {
        this.firstGlyphCodes = nArray;
        this.secondGlyphCodes = nArray2;
        this.firstUnicodeRanges = unicodeRangeArray;
        this.secondUnicodeRanges = unicodeRangeArray2;
        this.kerningAdjust = f;
    }

    public boolean matchesFirstGlyph(int n, String string) {
        int n2 = 0;
        while (n2 < this.firstGlyphCodes.length) {
            if (this.firstGlyphCodes[n2] == n) {
                return true;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.firstUnicodeRanges.length) {
            if (this.firstUnicodeRanges[n3].contains(string)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean matchesSecondGlyph(int n, String string) {
        int n2 = 0;
        while (n2 < this.secondGlyphCodes.length) {
            if (this.secondGlyphCodes[n2] == n) {
                return true;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.secondUnicodeRanges.length) {
            if (this.secondUnicodeRanges[n3].contains(string)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public float getAdjustValue() {
        return this.kerningAdjust;
    }
}

