/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.DOMGroupManager;
import org.apache.batik.svggen.ErrorConstants;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.SVGBufferedImageOp;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphicContext;
import org.apache.batik.svggen.SVGGraphicContextConverter;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.svggen.SVGSyntax;
import org.apache.batik.svggen.StyleHandler;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DOMTreeManager
implements SVGSyntax,
ErrorConstants {
    int maxGCOverrides;
    private Vector groupManagers = new Vector();
    private List genericDefSet = new LinkedList();
    SVGGraphicContext defaultGC;
    private Element topLevelGroup;
    SVGGraphicContextConverter gcConverter;
    private SVGGeneratorContext generatorContext;
    private SVGBufferedImageOp filterConverter;
    private List otherDefs;

    public DOMTreeManager(GraphicContext graphicContext, SVGGeneratorContext sVGGeneratorContext, int n) {
        if (graphicContext == null) {
            throw new SVGGraphics2DRuntimeException("gc should not be null");
        }
        if (n <= 0) {
            throw new SVGGraphics2DRuntimeException("maxGcOverrides should be greater than zero");
        }
        if (sVGGeneratorContext == null) {
            throw new SVGGraphics2DRuntimeException("generatorContext should not be null");
        }
        this.generatorContext = sVGGeneratorContext;
        this.maxGCOverrides = n;
        this.recycleTopLevelGroup();
        this.defaultGC = this.gcConverter.toSVG(graphicContext);
    }

    public void addGroupManager(DOMGroupManager dOMGroupManager) {
        if (dOMGroupManager != null) {
            this.groupManagers.addElement(dOMGroupManager);
        }
    }

    public void removeGroupManager(DOMGroupManager dOMGroupManager) {
        if (dOMGroupManager != null) {
            this.groupManagers.removeElement(dOMGroupManager);
        }
    }

    public void appendGroup(Element element, DOMGroupManager dOMGroupManager) {
        this.topLevelGroup.appendChild(element);
        int n = this.groupManagers.size();
        int n2 = 0;
        while (n2 < n) {
            DOMGroupManager dOMGroupManager2 = (DOMGroupManager)this.groupManagers.elementAt(n2);
            if (dOMGroupManager2 != dOMGroupManager) {
                dOMGroupManager2.recycleCurrentGroup();
            }
            ++n2;
        }
    }

    private void recycleTopLevelGroup() {
        this.recycleTopLevelGroup(true);
    }

    private void recycleTopLevelGroup(boolean bl) {
        int n = this.groupManagers.size();
        int n2 = 0;
        while (n2 < n) {
            DOMGroupManager dOMGroupManager = (DOMGroupManager)this.groupManagers.elementAt(n2);
            dOMGroupManager.recycleCurrentGroup();
            ++n2;
        }
        this.topLevelGroup = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "g");
        if (bl) {
            this.filterConverter = new SVGBufferedImageOp(this.generatorContext);
            this.gcConverter = new SVGGraphicContextConverter(this.generatorContext);
        }
    }

    public void setTopLevelGroup(Element element) {
        if (element == null) {
            throw new SVGGraphics2DRuntimeException("topLevelGroup should not be null");
        }
        if (!"g".equalsIgnoreCase(element.getTagName())) {
            throw new SVGGraphics2DRuntimeException("topLevelGroup should be a group <g>");
        }
        this.recycleTopLevelGroup(false);
        this.topLevelGroup = element;
    }

    public Element getRoot() {
        Element element = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "svg");
        if (this.gcConverter.getCompositeConverter().getAlphaCompositeConverter().requiresBackgroundAccess()) {
            element.setAttributeNS(null, "enable-background", "new");
        }
        if (this.generatorContext.generatorComment != null) {
            Comment comment = this.generatorContext.domFactory.createComment(this.generatorContext.generatorComment);
            element.appendChild(comment);
        }
        this.applyDefaultRenderingStyle(element);
        element.appendChild(this.getGenericDefinitions());
        element.appendChild(this.getTopLevelGroup());
        return element;
    }

    public void applyDefaultRenderingStyle(Element element) {
        Map map = this.defaultGC.getGroupContext();
        this.generatorContext.styleHandler.setStyle(element, map, this.generatorContext);
    }

    public Element getGenericDefinitions() {
        Element element = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "defs");
        Iterator iterator = this.genericDefSet.iterator();
        while (iterator.hasNext()) {
            element.appendChild((Element)iterator.next());
        }
        element.setAttributeNS(null, "id", "genericDefs");
        return element;
    }

    public ExtensionHandler getExtensionHandler() {
        return this.generatorContext.getExtensionHandler();
    }

    void setExtensionHandler(ExtensionHandler extensionHandler) {
        this.generatorContext.setExtensionHandler(extensionHandler);
    }

    public List getDefinitionSet() {
        List list = this.gcConverter.getDefinitionSet();
        list.removeAll(this.genericDefSet);
        list.addAll(this.filterConverter.getDefinitionSet());
        if (this.otherDefs != null) {
            list.addAll(this.otherDefs);
            this.otherDefs = null;
        }
        this.filterConverter = new SVGBufferedImageOp(this.generatorContext);
        this.gcConverter = new SVGGraphicContextConverter(this.generatorContext);
        return list;
    }

    public void addOtherDef(Element element) {
        if (this.otherDefs == null) {
            this.otherDefs = new LinkedList();
        }
        this.otherDefs.add(element);
    }

    public Element getTopLevelGroup() {
        boolean bl = true;
        return this.getTopLevelGroup(bl);
    }

    public Element getTopLevelGroup(boolean bl) {
        List list;
        Element element = this.topLevelGroup;
        if (bl && (list = this.getDefinitionSet()).size() > 0) {
            Element element2 = null;
            NodeList nodeList = element.getElementsByTagName("defs");
            if (nodeList.getLength() > 0) {
                element2 = (Element)nodeList.item(0);
            }
            if (element2 == null) {
                element2 = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "defs");
                element2.setAttributeNS(null, "id", this.generatorContext.idGenerator.generateID("defs"));
                element.insertBefore(element2, element.getFirstChild());
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                element2.appendChild((Element)iterator.next());
            }
        }
        this.recycleTopLevelGroup(false);
        return element;
    }

    public SVGBufferedImageOp getFilterConverter() {
        return this.filterConverter;
    }

    public SVGGraphicContextConverter getGraphicContextConverter() {
        return this.gcConverter;
    }

    SVGGeneratorContext getGeneratorContext() {
        return this.generatorContext;
    }

    Document getDOMFactory() {
        return this.generatorContext.domFactory;
    }

    StyleHandler getStyleHandler() {
        return this.generatorContext.styleHandler;
    }
}

