/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */


package butterfly.actions;

import java.util.Hashtable;
import java.util.Vector;

import butterfly.actions.interfaces.IActionContext;
import butterfly.actions.interfaces.IButterflyAction;

/**
 * @author Administrator
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class ActionContext implements IActionContext {
	private Hashtable actions_;
	
	public ActionContext(){
		actions_ = new Hashtable(3);
		buildActionTable();
	}
	/**
	 * @see butterfly.actions.interfaces.IActionContext#getAllowedActions(Object)
	 */
	public IButterflyAction[] getAllowedActions(Object obj) {
		//asdf
		return getActionsForClass(obj.getClass());
	}
	
	private IButterflyAction[] getActionsForClass(Class c){
		Vector acts = (Vector)actions_.get(c);
		if(acts != null){
			return ((IButterflyAction[])acts.toArray(new IButterflyAction[0]));
		}
		if(c.equals(Object.class)){
			return new IButterflyAction[0];
		}
		return getActionsForClass(c.getSuperclass());
	}
	
	protected void buildActionTable(){
		
	}
	
	public void addActionToContext(Class context,IButterflyAction act){
		Vector acts = (Vector)actions_.get(context);
		if(acts == null){
			acts = new Vector();
			actions_.put(context,acts);
		}
		acts.add(act);		
	}
	
	public void removeActionFromContext(Class context, IButterflyAction act){
		Vector acts = (Vector)actions_.get(context);
		acts.remove(act);
	}

}
