/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.actions;

import java.util.Hashtable;

import org.apache.avalon.framework.component.ComponentManager;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.actions.interfaces.IButterflyAction;
import butterfly.components.interfaces.IComponent;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.statemachine.interfaces.IStateAction;
/**
 * Insert the type's description here.
 * Creation date: (8/17/2002 5:41:35 PM)
 * @author: 
 */
public abstract class ButterflyAction extends javax.swing.AbstractAction implements IComponent,IComponentRequester,IActionRequester,org.apache.avalon.framework.component.Composable ,IStateAction,IButterflyAction{
	private IComponentLookup lookup_;
	private IActionLookup actionLookup_;
	private ComponentManager componentManager_;
	private Hashtable stateEventData_;
/**
 * IButterflyAction constructor comment.
 */
public ButterflyAction() {
	super();
}
/**
 * IButterflyAction constructor comment.
 * @param name java.lang.String
 */
public ButterflyAction(String name) {
	super(name);
}
/**
 * IButterflyAction constructor comment.
 * @param name java.lang.String
 * @param icon javax.swing.Icon
 */
public ButterflyAction(String name, javax.swing.Icon icon) {
	super(name, icon);
}
	/**
	 * Invoked when an action occurs.
	 */
public abstract void actionPerformed(java.awt.event.ActionEvent e);
/**
 * compose method comment.
 */
public void compose(org.apache.avalon.framework.component.ComponentManager arg1) throws org.apache.avalon.framework.component.ComponentException {
	setComponentManager(arg1);	
}
/**
 * Insert the method's description here.
 * Creation date: (8/17/2002 5:45:06 PM)
 * @param newLookup butterfly.components.interfaces.IComponentLookup
 */
public IActionLookup getActionLookup() {
	return actionLookup_;
}
/**
 * Insert the method's description here.
 * Creation date: (8/19/2002 6:21:16 PM)
 * @return org.apache.avalon.framework.component.ComponentManager
 */
public org.apache.avalon.framework.component.ComponentManager getComponentManager() {
	return componentManager_;
}
/**
 * Insert the method's description here.
 * Creation date: (8/17/2002 5:45:06 PM)
 * @return butterfly.components.interfaces.IComponentLookup
 */
public butterfly.components.interfaces.IComponentLookup getLookup() {
	return lookup_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/16/2002 11:38:12 AM)
 * @return java.util.Hashtable
 */
public java.util.Hashtable getStateEventData() {
	return stateEventData_;
}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 6:37:54 PM)
 */
public void requestActions() {}
/**
 * Insert the method's description here.
 * Creation date: (9/16/2002 6:37:54 PM)
 */
public void requestComponents() {}
/**
 * Insert the method's description here.
 * Creation date: (8/17/2002 5:45:06 PM)
 * @param newLookup butterfly.components.interfaces.IComponentLookup
 */
public void setActionLookup(IActionLookup newLookup) {
	actionLookup_ = newLookup;
}
/**
 * Insert the method's description here.
 * Creation date: (8/17/2002 5:45:06 PM)
 * @param newLookup butterfly.components.interfaces.IComponentLookup
 */
public void setComponentLookup(IComponentLookup lookup) {
	lookup_ = lookup;
}
/**
 * Insert the method's description here.
 * Creation date: (8/19/2002 6:21:16 PM)
 * @param newComponentManager org.apache.avalon.framework.component.ComponentManager
 */
public void setComponentManager(org.apache.avalon.framework.component.ComponentManager newComponentManager) {
	componentManager_ = newComponentManager;
}
/**
 * Insert the method's description here.
 * Creation date: (11/16/2002 11:38:12 AM)
 * @param newStateEventData java.util.Hashtable
 */
public void setStateEventData(java.util.Hashtable newStateEventData) {
	stateEventData_ = newStateEventData;
}
}
